/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.maven.lifecycle.internal.builder.multithreaded;

import io.quarkus.launcher.shaded.org.apache.maven.execution.MavenSession;
import io.quarkus.launcher.shaded.org.apache.maven.lifecycle.internal.BuildThreadFactory;
import io.quarkus.launcher.shaded.org.apache.maven.lifecycle.internal.LifecycleModuleBuilder;
import io.quarkus.launcher.shaded.org.apache.maven.lifecycle.internal.ProjectBuildList;
import io.quarkus.launcher.shaded.org.apache.maven.lifecycle.internal.ProjectSegment;
import io.quarkus.launcher.shaded.org.apache.maven.lifecycle.internal.ReactorBuildStatus;
import io.quarkus.launcher.shaded.org.apache.maven.lifecycle.internal.ReactorContext;
import io.quarkus.launcher.shaded.org.apache.maven.lifecycle.internal.TaskSegment;
import io.quarkus.launcher.shaded.org.apache.maven.lifecycle.internal.builder.Builder;
import io.quarkus.launcher.shaded.org.apache.maven.lifecycle.internal.builder.multithreaded.ConcurrencyDependencyGraph;
import io.quarkus.launcher.shaded.org.apache.maven.lifecycle.internal.builder.multithreaded.ThreadOutputMuxer;
import io.quarkus.launcher.shaded.org.apache.maven.project.MavenProject;
import io.quarkus.launcher.shaded.org.codehaus.plexus.component.annotations.Component;
import io.quarkus.launcher.shaded.org.codehaus.plexus.component.annotations.Requirement;
import io.quarkus.launcher.shaded.org.codehaus.plexus.logging.Logger;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

@Component(role=Builder.class, hint="io.quarkus.launcher.shaded.multithreaded")
public class MultiThreadedBuilder
implements Builder {
    @Requirement
    private Logger logger;
    @Requirement
    private LifecycleModuleBuilder lifecycleModuleBuilder;

    @Override
    public void build(MavenSession session, ReactorContext reactorContext, ProjectBuildList projectBuilds, List<TaskSegment> taskSegments, ReactorBuildStatus reactorBuildStatus) throws ExecutionException, InterruptedException {
        int nThreads = Math.min(session.getRequest().getDegreeOfConcurrency(), session.getProjects().size());
        boolean parallel = nThreads >= 2;
        session.setParallel(parallel);
        for (ProjectSegment segment : projectBuilds) {
            segment.getSession().setParallel(parallel);
        }
        ExecutorService executor = Executors.newFixedThreadPool(nThreads, new BuildThreadFactory());
        ExecutorCompletionService<ProjectSegment> service = new ExecutorCompletionService<ProjectSegment>(executor);
        ThreadOutputMuxer muxer = null;
        for (TaskSegment taskSegment : taskSegments) {
            ProjectBuildList segmentProjectBuilds = projectBuilds.getByTaskSegment(taskSegment);
            Map<MavenProject, ProjectSegment> projectBuildMap = projectBuilds.selectSegment(taskSegment);
            try {
                ConcurrencyDependencyGraph analyzer = new ConcurrencyDependencyGraph(segmentProjectBuilds, session.getProjectDependencyGraph());
                this.multiThreadedProjectTaskSegmentBuild(analyzer, reactorContext, session, service, taskSegment, projectBuildMap, muxer);
                if (!reactorContext.getReactorBuildStatus().isHalted()) continue;
            }
            catch (Exception e) {
                session.getResult().addException(e);
            }
            break;
        }
        executor.shutdown();
        executor.awaitTermination(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
    }

    private void multiThreadedProjectTaskSegmentBuild(ConcurrencyDependencyGraph analyzer, ReactorContext reactorContext, MavenSession rootSession, CompletionService<ProjectSegment> service, TaskSegment taskSegment, Map<MavenProject, ProjectSegment> projectBuildList, ThreadOutputMuxer muxer) {
        for (MavenProject mavenProject : analyzer.getRootSchedulableBuilds()) {
            ProjectSegment projectSegment = projectBuildList.get(mavenProject);
            this.logger.debug("io.quarkus.launcher.shaded.Scheduling: " + projectSegment.getProject());
            Callable<ProjectSegment> cb = this.createBuildCallable(rootSession, projectSegment, reactorContext, taskSegment, muxer);
            service.submit(cb);
        }
        for (int i = 0; i < analyzer.getNumberOfBuilds(); ++i) {
            try {
                ProjectSegment projectBuild = service.take().get();
                if (reactorContext.getReactorBuildStatus().isHalted()) break;
                if (analyzer.getNumberOfBuilds() <= 1) continue;
                List<MavenProject> newItemsThatCanBeBuilt = analyzer.markAsFinished(projectBuild.getProject());
                for (MavenProject mavenProject : newItemsThatCanBeBuilt) {
                    ProjectSegment scheduledDependent = projectBuildList.get(mavenProject);
                    this.logger.debug("io.quarkus.launcher.shaded.Scheduling: " + scheduledDependent);
                    Callable<ProjectSegment> cb = this.createBuildCallable(rootSession, scheduledDependent, reactorContext, taskSegment, muxer);
                    service.submit(cb);
                }
                continue;
            }
            catch (InterruptedException e) {
                rootSession.getResult().addException(e);
                break;
            }
            catch (ExecutionException e) {
                rootSession.getResult().addException(e);
                break;
            }
        }
    }

    private Callable<ProjectSegment> createBuildCallable(final MavenSession rootSession, final ProjectSegment projectBuild, final ReactorContext reactorContext, final TaskSegment taskSegment, ThreadOutputMuxer muxer) {
        return new Callable<ProjectSegment>(){

            @Override
            public ProjectSegment call() {
                MultiThreadedBuilder.this.lifecycleModuleBuilder.buildProject(projectBuild.getSession(), rootSession, reactorContext, projectBuild.getProject(), taskSegment);
                return projectBuild;
            }
        };
    }
}

