/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.maven.lifecycle.mapping;

import io.quarkus.launcher.shaded.org.apache.maven.lifecycle.mapping.Lifecycle;
import io.quarkus.launcher.shaded.org.apache.maven.lifecycle.mapping.LifecycleMapping;
import io.quarkus.launcher.shaded.org.apache.maven.lifecycle.mapping.LifecyclePhase;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DefaultLifecycleMapping
implements LifecycleMapping {
    private List<Lifecycle> lifecycles;
    private Map<String, Lifecycle> lifecycleMap;
    private Map<String, LifecyclePhase> phases;

    private void initLifecycleMap() {
        block4: {
            if (this.lifecycleMap != null) break block4;
            this.lifecycleMap = new HashMap<String, Lifecycle>();
            if (this.lifecycles != null) {
                for (Lifecycle lifecycle : this.lifecycles) {
                    this.lifecycleMap.put(lifecycle.getId(), lifecycle);
                }
            } else {
                String[] lifecycleIds;
                for (String lifecycleId : lifecycleIds = new String[]{"io.quarkus.launcher.shaded.default", "io.quarkus.launcher.shaded.clean", "io.quarkus.launcher.shaded.site"}) {
                    Map<String, LifecyclePhase> phases = this.getLifecyclePhases(lifecycleId);
                    if (phases == null) continue;
                    Lifecycle lifecycle = new Lifecycle();
                    lifecycle.setId(lifecycleId);
                    lifecycle.setLifecyclePhases(phases);
                    this.lifecycleMap.put(lifecycleId, lifecycle);
                }
            }
        }
    }

    @Override
    public Map<String, Lifecycle> getLifecycles() {
        this.initLifecycleMap();
        return this.lifecycleMap;
    }

    @Override
    public List<String> getOptionalMojos(String lifecycle) {
        return null;
    }

    private Map<String, LifecyclePhase> getLifecyclePhases(String lifecycle) {
        this.initLifecycleMap();
        Lifecycle lifecycleMapping = this.lifecycleMap.get(lifecycle);
        if (lifecycleMapping != null) {
            return lifecycleMapping.getLifecyclePhases();
        }
        if ("io.quarkus.launcher.shaded.default".equals(lifecycle)) {
            return this.phases;
        }
        return null;
    }

    @Override
    @Deprecated
    public Map<String, String> getPhases(String lifecycle) {
        return LifecyclePhase.toLegacyMap(this.getLifecyclePhases(lifecycle));
    }
}

