/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.maven.model;

import io.quarkus.launcher.shaded.org.apache.maven.model.ActivationFile;
import io.quarkus.launcher.shaded.org.apache.maven.model.ActivationOS;
import io.quarkus.launcher.shaded.org.apache.maven.model.ActivationProperty;
import io.quarkus.launcher.shaded.org.apache.maven.model.InputLocation;
import io.quarkus.launcher.shaded.org.apache.maven.model.InputLocationTracker;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;

public class Activation
implements Serializable,
Cloneable,
InputLocationTracker {
    private boolean activeByDefault = false;
    private String jdk;
    private ActivationOS os;
    private ActivationProperty property;
    private ActivationFile file;
    private Map<Object, InputLocation> locations;
    private InputLocation location;
    private InputLocation activeByDefaultLocation;
    private InputLocation jdkLocation;
    private InputLocation osLocation;
    private InputLocation propertyLocation;
    private InputLocation fileLocation;

    public Activation clone() {
        try {
            Activation copy = (Activation)super.clone();
            if (this.os != null) {
                copy.os = this.os.clone();
            }
            if (this.property != null) {
                copy.property = this.property.clone();
            }
            if (this.file != null) {
                copy.file = this.file.clone();
            }
            if (copy.locations != null) {
                copy.locations = new LinkedHashMap<Object, InputLocation>(copy.locations);
            }
            return copy;
        }
        catch (Exception ex) {
            throw (RuntimeException)new UnsupportedOperationException(this.getClass().getName() + "io.quarkus.launcher.shaded. does not support clone()").initCause(ex);
        }
    }

    public ActivationFile getFile() {
        return this.file;
    }

    public String getJdk() {
        return this.jdk;
    }

    @Override
    public InputLocation getLocation(Object key) {
        if (key instanceof String) {
            switch ((String)key) {
                case "io.quarkus.launcher.shaded.": {
                    return this.location;
                }
                case "io.quarkus.launcher.shaded.activeByDefault": {
                    return this.activeByDefaultLocation;
                }
                case "io.quarkus.launcher.shaded.jdk": {
                    return this.jdkLocation;
                }
                case "io.quarkus.launcher.shaded.os": {
                    return this.osLocation;
                }
                case "io.quarkus.launcher.shaded.property": {
                    return this.propertyLocation;
                }
                case "io.quarkus.launcher.shaded.file": {
                    return this.fileLocation;
                }
            }
            return this.getOtherLocation(key);
        }
        return this.getOtherLocation(key);
    }

    public ActivationOS getOs() {
        return this.os;
    }

    @Override
    public void setLocation(Object key, InputLocation location) {
        if (key instanceof String) {
            switch ((String)key) {
                case "io.quarkus.launcher.shaded.": {
                    this.location = location;
                    return;
                }
                case "io.quarkus.launcher.shaded.activeByDefault": {
                    this.activeByDefaultLocation = location;
                    return;
                }
                case "io.quarkus.launcher.shaded.jdk": {
                    this.jdkLocation = location;
                    return;
                }
                case "io.quarkus.launcher.shaded.os": {
                    this.osLocation = location;
                    return;
                }
                case "io.quarkus.launcher.shaded.property": {
                    this.propertyLocation = location;
                    return;
                }
                case "io.quarkus.launcher.shaded.file": {
                    this.fileLocation = location;
                    return;
                }
            }
            this.setOtherLocation(key, location);
            return;
        }
        this.setOtherLocation(key, location);
    }

    public void setOtherLocation(Object key, InputLocation location) {
        if (location != null) {
            if (this.locations == null) {
                this.locations = new LinkedHashMap<Object, InputLocation>();
            }
            this.locations.put(key, location);
        }
    }

    private InputLocation getOtherLocation(Object key) {
        return this.locations != null ? this.locations.get(key) : null;
    }

    public ActivationProperty getProperty() {
        return this.property;
    }

    public boolean isActiveByDefault() {
        return this.activeByDefault;
    }

    public void setActiveByDefault(boolean activeByDefault) {
        this.activeByDefault = activeByDefault;
    }

    public void setFile(ActivationFile file) {
        this.file = file;
    }

    public void setJdk(String jdk) {
        this.jdk = jdk;
    }

    public void setOs(ActivationOS os) {
        this.os = os;
    }

    public void setProperty(ActivationProperty property) {
        this.property = property;
    }
}

