/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.maven.model;

import io.quarkus.launcher.shaded.org.apache.maven.model.InputLocation;
import io.quarkus.launcher.shaded.org.apache.maven.model.InputLocationTracker;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;

public class Notifier
implements Serializable,
Cloneable,
InputLocationTracker {
    private String type = "io.quarkus.launcher.shaded.mail";
    private boolean sendOnError = true;
    private boolean sendOnFailure = true;
    private boolean sendOnSuccess = true;
    private boolean sendOnWarning = true;
    private String address;
    private Properties configuration;
    private Map<Object, InputLocation> locations;
    private InputLocation location;
    private InputLocation typeLocation;
    private InputLocation sendOnErrorLocation;
    private InputLocation sendOnFailureLocation;
    private InputLocation sendOnSuccessLocation;
    private InputLocation sendOnWarningLocation;
    private InputLocation addressLocation;
    private InputLocation configurationLocation;

    public void addConfiguration(String key, String value) {
        this.getConfiguration().put(key, value);
    }

    public Notifier clone() {
        try {
            Notifier copy = (Notifier)super.clone();
            if (this.configuration != null) {
                copy.configuration = (Properties)this.configuration.clone();
            }
            if (copy.locations != null) {
                copy.locations = new LinkedHashMap<Object, InputLocation>(copy.locations);
            }
            return copy;
        }
        catch (Exception ex) {
            throw (RuntimeException)new UnsupportedOperationException(this.getClass().getName() + "io.quarkus.launcher.shaded. does not support clone()").initCause(ex);
        }
    }

    public String getAddress() {
        return this.address;
    }

    public Properties getConfiguration() {
        if (this.configuration == null) {
            this.configuration = new Properties();
        }
        return this.configuration;
    }

    @Override
    public InputLocation getLocation(Object key) {
        if (key instanceof String) {
            switch ((String)key) {
                case "io.quarkus.launcher.shaded.": {
                    return this.location;
                }
                case "io.quarkus.launcher.shaded.type": {
                    return this.typeLocation;
                }
                case "io.quarkus.launcher.shaded.sendOnError": {
                    return this.sendOnErrorLocation;
                }
                case "io.quarkus.launcher.shaded.sendOnFailure": {
                    return this.sendOnFailureLocation;
                }
                case "io.quarkus.launcher.shaded.sendOnSuccess": {
                    return this.sendOnSuccessLocation;
                }
                case "io.quarkus.launcher.shaded.sendOnWarning": {
                    return this.sendOnWarningLocation;
                }
                case "io.quarkus.launcher.shaded.address": {
                    return this.addressLocation;
                }
                case "io.quarkus.launcher.shaded.configuration": {
                    return this.configurationLocation;
                }
            }
            return this.getOtherLocation(key);
        }
        return this.getOtherLocation(key);
    }

    @Override
    public void setLocation(Object key, InputLocation location) {
        if (key instanceof String) {
            switch ((String)key) {
                case "io.quarkus.launcher.shaded.": {
                    this.location = location;
                    return;
                }
                case "io.quarkus.launcher.shaded.type": {
                    this.typeLocation = location;
                    return;
                }
                case "io.quarkus.launcher.shaded.sendOnError": {
                    this.sendOnErrorLocation = location;
                    return;
                }
                case "io.quarkus.launcher.shaded.sendOnFailure": {
                    this.sendOnFailureLocation = location;
                    return;
                }
                case "io.quarkus.launcher.shaded.sendOnSuccess": {
                    this.sendOnSuccessLocation = location;
                    return;
                }
                case "io.quarkus.launcher.shaded.sendOnWarning": {
                    this.sendOnWarningLocation = location;
                    return;
                }
                case "io.quarkus.launcher.shaded.address": {
                    this.addressLocation = location;
                    return;
                }
                case "io.quarkus.launcher.shaded.configuration": {
                    this.configurationLocation = location;
                    return;
                }
            }
            this.setOtherLocation(key, location);
            return;
        }
        this.setOtherLocation(key, location);
    }

    public void setOtherLocation(Object key, InputLocation location) {
        if (location != null) {
            if (this.locations == null) {
                this.locations = new LinkedHashMap<Object, InputLocation>();
            }
            this.locations.put(key, location);
        }
    }

    private InputLocation getOtherLocation(Object key) {
        return this.locations != null ? this.locations.get(key) : null;
    }

    public String getType() {
        return this.type;
    }

    public boolean isSendOnError() {
        return this.sendOnError;
    }

    public boolean isSendOnFailure() {
        return this.sendOnFailure;
    }

    public boolean isSendOnSuccess() {
        return this.sendOnSuccess;
    }

    public boolean isSendOnWarning() {
        return this.sendOnWarning;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setConfiguration(Properties configuration) {
        this.configuration = configuration;
    }

    public void setSendOnError(boolean sendOnError) {
        this.sendOnError = sendOnError;
    }

    public void setSendOnFailure(boolean sendOnFailure) {
        this.sendOnFailure = sendOnFailure;
    }

    public void setSendOnSuccess(boolean sendOnSuccess) {
        this.sendOnSuccess = sendOnSuccess;
    }

    public void setSendOnWarning(boolean sendOnWarning) {
        this.sendOnWarning = sendOnWarning;
    }

    public void setType(String type) {
        this.type = type;
    }
}

