/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.maven.model;

import io.quarkus.launcher.shaded.org.apache.maven.model.InputLocation;
import io.quarkus.launcher.shaded.org.apache.maven.model.InputLocationTracker;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;

public class RepositoryBase
implements Serializable,
Cloneable,
InputLocationTracker {
    private String id;
    private String name;
    private String url;
    private String layout = "io.quarkus.launcher.shaded.default";
    private Map<Object, InputLocation> locations;
    private InputLocation location;
    private InputLocation idLocation;
    private InputLocation nameLocation;
    private InputLocation urlLocation;
    private InputLocation layoutLocation;

    public RepositoryBase clone() {
        try {
            RepositoryBase copy = (RepositoryBase)super.clone();
            if (copy.locations != null) {
                copy.locations = new LinkedHashMap<Object, InputLocation>(copy.locations);
            }
            return copy;
        }
        catch (Exception ex) {
            throw (RuntimeException)new UnsupportedOperationException(this.getClass().getName() + "io.quarkus.launcher.shaded. does not support clone()").initCause(ex);
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RepositoryBase)) {
            return false;
        }
        RepositoryBase that = (RepositoryBase)other;
        boolean result = true;
        result = result && (this.getId() == null ? that.getId() == null : this.getId().equals(that.getId()));
        return result;
    }

    public String getId() {
        return this.id;
    }

    public String getLayout() {
        return this.layout;
    }

    @Override
    public InputLocation getLocation(Object key) {
        if (key instanceof String) {
            switch ((String)key) {
                case "io.quarkus.launcher.shaded.": {
                    return this.location;
                }
                case "io.quarkus.launcher.shaded.id": {
                    return this.idLocation;
                }
                case "io.quarkus.launcher.shaded.name": {
                    return this.nameLocation;
                }
                case "io.quarkus.launcher.shaded.url": {
                    return this.urlLocation;
                }
                case "io.quarkus.launcher.shaded.layout": {
                    return this.layoutLocation;
                }
            }
            return this.getOtherLocation(key);
        }
        return this.getOtherLocation(key);
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void setLocation(Object key, InputLocation location) {
        if (key instanceof String) {
            switch ((String)key) {
                case "io.quarkus.launcher.shaded.": {
                    this.location = location;
                    return;
                }
                case "io.quarkus.launcher.shaded.id": {
                    this.idLocation = location;
                    return;
                }
                case "io.quarkus.launcher.shaded.name": {
                    this.nameLocation = location;
                    return;
                }
                case "io.quarkus.launcher.shaded.url": {
                    this.urlLocation = location;
                    return;
                }
                case "io.quarkus.launcher.shaded.layout": {
                    this.layoutLocation = location;
                    return;
                }
            }
            this.setOtherLocation(key, location);
            return;
        }
        this.setOtherLocation(key, location);
    }

    public void setOtherLocation(Object key, InputLocation location) {
        if (location != null) {
            if (this.locations == null) {
                this.locations = new LinkedHashMap<Object, InputLocation>();
            }
            this.locations.put(key, location);
        }
    }

    private InputLocation getOtherLocation(Object key) {
        return this.locations != null ? this.locations.get(key) : null;
    }

    public String getUrl() {
        return this.url;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + (this.id != null ? this.id.hashCode() : 0);
        return result;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setLayout(String layout) {
        this.layout = layout;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("io.quarkus.launcher.shaded.id = '");
        buf.append(this.getId());
        buf.append("io.quarkus.launcher.shaded.'");
        return buf.toString();
    }
}

