/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.maven.model.building;

import io.quarkus.launcher.shaded.javax.inject.Inject;
import io.quarkus.launcher.shaded.javax.inject.Named;
import io.quarkus.launcher.shaded.javax.inject.Singleton;
import io.quarkus.launcher.shaded.org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import io.quarkus.launcher.shaded.org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import io.quarkus.launcher.shaded.org.apache.maven.artifact.versioning.VersionRange;
import io.quarkus.launcher.shaded.org.apache.maven.model.Activation;
import io.quarkus.launcher.shaded.org.apache.maven.model.Build;
import io.quarkus.launcher.shaded.org.apache.maven.model.Dependency;
import io.quarkus.launcher.shaded.org.apache.maven.model.DependencyManagement;
import io.quarkus.launcher.shaded.org.apache.maven.model.InputLocation;
import io.quarkus.launcher.shaded.org.apache.maven.model.InputSource;
import io.quarkus.launcher.shaded.org.apache.maven.model.Model;
import io.quarkus.launcher.shaded.org.apache.maven.model.ModelBase;
import io.quarkus.launcher.shaded.org.apache.maven.model.Parent;
import io.quarkus.launcher.shaded.org.apache.maven.model.Plugin;
import io.quarkus.launcher.shaded.org.apache.maven.model.PluginManagement;
import io.quarkus.launcher.shaded.org.apache.maven.model.Profile;
import io.quarkus.launcher.shaded.org.apache.maven.model.Repository;
import io.quarkus.launcher.shaded.org.apache.maven.model.building.DefaultModelBuildingEvent;
import io.quarkus.launcher.shaded.org.apache.maven.model.building.DefaultModelBuildingRequest;
import io.quarkus.launcher.shaded.org.apache.maven.model.building.DefaultModelBuildingResult;
import io.quarkus.launcher.shaded.org.apache.maven.model.building.DefaultModelProblemCollector;
import io.quarkus.launcher.shaded.org.apache.maven.model.building.FileModelSource;
import io.quarkus.launcher.shaded.org.apache.maven.model.building.FilterModelBuildingRequest;
import io.quarkus.launcher.shaded.org.apache.maven.model.building.ModelBuilder;
import io.quarkus.launcher.shaded.org.apache.maven.model.building.ModelBuildingEventCatapult;
import io.quarkus.launcher.shaded.org.apache.maven.model.building.ModelBuildingException;
import io.quarkus.launcher.shaded.org.apache.maven.model.building.ModelBuildingListener;
import io.quarkus.launcher.shaded.org.apache.maven.model.building.ModelBuildingRequest;
import io.quarkus.launcher.shaded.org.apache.maven.model.building.ModelBuildingResult;
import io.quarkus.launcher.shaded.org.apache.maven.model.building.ModelCache;
import io.quarkus.launcher.shaded.org.apache.maven.model.building.ModelCacheTag;
import io.quarkus.launcher.shaded.org.apache.maven.model.building.ModelData;
import io.quarkus.launcher.shaded.org.apache.maven.model.building.ModelProblem;
import io.quarkus.launcher.shaded.org.apache.maven.model.building.ModelProblemCollector;
import io.quarkus.launcher.shaded.org.apache.maven.model.building.ModelProblemCollectorExt;
import io.quarkus.launcher.shaded.org.apache.maven.model.building.ModelProblemCollectorRequest;
import io.quarkus.launcher.shaded.org.apache.maven.model.building.ModelProblemUtils;
import io.quarkus.launcher.shaded.org.apache.maven.model.building.ModelProcessor;
import io.quarkus.launcher.shaded.org.apache.maven.model.building.ModelSource;
import io.quarkus.launcher.shaded.org.apache.maven.model.building.ModelSource2;
import io.quarkus.launcher.shaded.org.apache.maven.model.building.Result;
import io.quarkus.launcher.shaded.org.apache.maven.model.composition.DependencyManagementImporter;
import io.quarkus.launcher.shaded.org.apache.maven.model.inheritance.InheritanceAssembler;
import io.quarkus.launcher.shaded.org.apache.maven.model.interpolation.ModelInterpolator;
import io.quarkus.launcher.shaded.org.apache.maven.model.io.ModelParseException;
import io.quarkus.launcher.shaded.org.apache.maven.model.management.DependencyManagementInjector;
import io.quarkus.launcher.shaded.org.apache.maven.model.management.PluginManagementInjector;
import io.quarkus.launcher.shaded.org.apache.maven.model.normalization.ModelNormalizer;
import io.quarkus.launcher.shaded.org.apache.maven.model.path.ModelPathTranslator;
import io.quarkus.launcher.shaded.org.apache.maven.model.path.ModelUrlNormalizer;
import io.quarkus.launcher.shaded.org.apache.maven.model.plugin.LifecycleBindingsInjector;
import io.quarkus.launcher.shaded.org.apache.maven.model.plugin.PluginConfigurationExpander;
import io.quarkus.launcher.shaded.org.apache.maven.model.plugin.ReportConfigurationExpander;
import io.quarkus.launcher.shaded.org.apache.maven.model.plugin.ReportingConverter;
import io.quarkus.launcher.shaded.org.apache.maven.model.profile.DefaultProfileActivationContext;
import io.quarkus.launcher.shaded.org.apache.maven.model.profile.ProfileInjector;
import io.quarkus.launcher.shaded.org.apache.maven.model.profile.ProfileSelector;
import io.quarkus.launcher.shaded.org.apache.maven.model.resolution.InvalidRepositoryException;
import io.quarkus.launcher.shaded.org.apache.maven.model.resolution.ModelResolver;
import io.quarkus.launcher.shaded.org.apache.maven.model.resolution.UnresolvableModelException;
import io.quarkus.launcher.shaded.org.apache.maven.model.resolution.WorkspaceModelResolver;
import io.quarkus.launcher.shaded.org.apache.maven.model.superpom.SuperPomProvider;
import io.quarkus.launcher.shaded.org.apache.maven.model.validation.ModelValidator;
import io.quarkus.launcher.shaded.org.codehaus.plexus.interpolation.MapBasedValueSource;
import io.quarkus.launcher.shaded.org.codehaus.plexus.interpolation.StringSearchInterpolator;
import io.quarkus.launcher.shaded.org.eclipse.sisu.Nullable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;

@Named
@Singleton
public class DefaultModelBuilder
implements ModelBuilder {
    @Inject
    private ModelProcessor modelProcessor;
    @Inject
    private ModelValidator modelValidator;
    @Inject
    private ModelNormalizer modelNormalizer;
    @Inject
    private ModelInterpolator modelInterpolator;
    @Inject
    private ModelPathTranslator modelPathTranslator;
    @Inject
    private ModelUrlNormalizer modelUrlNormalizer;
    @Inject
    private SuperPomProvider superPomProvider;
    @Inject
    private InheritanceAssembler inheritanceAssembler;
    @Inject
    private ProfileSelector profileSelector;
    @Inject
    private ProfileInjector profileInjector;
    @Inject
    private PluginManagementInjector pluginManagementInjector;
    @Inject
    private DependencyManagementInjector dependencyManagementInjector;
    @Inject
    private DependencyManagementImporter dependencyManagementImporter;
    @Inject
    @Nullable
    private LifecycleBindingsInjector lifecycleBindingsInjector;
    @Inject
    private PluginConfigurationExpander pluginConfigurationExpander;
    @Inject
    private ReportConfigurationExpander reportConfigurationExpander;
    @Inject
    private ReportingConverter reportingConverter;

    public DefaultModelBuilder setModelProcessor(ModelProcessor modelProcessor) {
        this.modelProcessor = modelProcessor;
        return this;
    }

    public DefaultModelBuilder setModelValidator(ModelValidator modelValidator) {
        this.modelValidator = modelValidator;
        return this;
    }

    public DefaultModelBuilder setModelNormalizer(ModelNormalizer modelNormalizer) {
        this.modelNormalizer = modelNormalizer;
        return this;
    }

    public DefaultModelBuilder setModelInterpolator(ModelInterpolator modelInterpolator) {
        this.modelInterpolator = modelInterpolator;
        return this;
    }

    public DefaultModelBuilder setModelPathTranslator(ModelPathTranslator modelPathTranslator) {
        this.modelPathTranslator = modelPathTranslator;
        return this;
    }

    public DefaultModelBuilder setModelUrlNormalizer(ModelUrlNormalizer modelUrlNormalizer) {
        this.modelUrlNormalizer = modelUrlNormalizer;
        return this;
    }

    public DefaultModelBuilder setSuperPomProvider(SuperPomProvider superPomProvider) {
        this.superPomProvider = superPomProvider;
        return this;
    }

    public DefaultModelBuilder setProfileSelector(ProfileSelector profileSelector) {
        this.profileSelector = profileSelector;
        return this;
    }

    public DefaultModelBuilder setProfileInjector(ProfileInjector profileInjector) {
        this.profileInjector = profileInjector;
        return this;
    }

    public DefaultModelBuilder setInheritanceAssembler(InheritanceAssembler inheritanceAssembler) {
        this.inheritanceAssembler = inheritanceAssembler;
        return this;
    }

    public DefaultModelBuilder setDependencyManagementImporter(DependencyManagementImporter depMgmtImporter) {
        this.dependencyManagementImporter = depMgmtImporter;
        return this;
    }

    public DefaultModelBuilder setDependencyManagementInjector(DependencyManagementInjector depMgmtInjector) {
        this.dependencyManagementInjector = depMgmtInjector;
        return this;
    }

    public DefaultModelBuilder setLifecycleBindingsInjector(LifecycleBindingsInjector lifecycleBindingsInjector) {
        this.lifecycleBindingsInjector = lifecycleBindingsInjector;
        return this;
    }

    public DefaultModelBuilder setPluginConfigurationExpander(PluginConfigurationExpander pluginConfigurationExpander) {
        this.pluginConfigurationExpander = pluginConfigurationExpander;
        return this;
    }

    public DefaultModelBuilder setPluginManagementInjector(PluginManagementInjector pluginManagementInjector) {
        this.pluginManagementInjector = pluginManagementInjector;
        return this;
    }

    public DefaultModelBuilder setReportConfigurationExpander(ReportConfigurationExpander reportConfigurationExpander) {
        this.reportConfigurationExpander = reportConfigurationExpander;
        return this;
    }

    public DefaultModelBuilder setReportingConverter(ReportingConverter reportingConverter) {
        this.reportingConverter = reportingConverter;
        return this;
    }

    @Override
    public ModelBuildingResult build(ModelBuildingRequest request) throws ModelBuildingException {
        ModelData parentData;
        Model inputModel;
        DefaultModelBuildingResult result = new DefaultModelBuildingResult();
        DefaultModelProblemCollector problems = new DefaultModelProblemCollector(result);
        DefaultProfileActivationContext profileActivationContext = this.getProfileActivationContext(request);
        problems.setSource("io.quarkus.launcher.shaded.(external profiles)");
        List<Profile> activeExternalProfiles = this.profileSelector.getActiveProfiles(request.getProfiles(), profileActivationContext, problems);
        result.setActiveExternalProfiles(activeExternalProfiles);
        if (!activeExternalProfiles.isEmpty()) {
            Properties profileProps = new Properties();
            for (Profile profile : activeExternalProfiles) {
                profileProps.putAll((Map<?, ?>)profile.getProperties());
            }
            profileProps.putAll(profileActivationContext.getUserProperties());
            profileActivationContext.setUserProperties(profileProps);
        }
        if ((inputModel = request.getRawModel()) == null) {
            inputModel = this.readModel(request.getModelSource(), request.getPomFile(), request, problems);
        }
        problems.setRootModel(inputModel);
        ModelData resultData = new ModelData(request.getModelSource(), inputModel);
        ModelData superData = new ModelData(null, this.getSuperModel());
        LinkedHashSet<String> parentIds = new LinkedHashSet<String>();
        ArrayList<ModelData> lineage = new ArrayList<ModelData>();
        ModelData currentData = resultData;
        while (currentData != null) {
            lineage.add(currentData);
            Model rawModel = currentData.getModel();
            currentData.setRawModel(rawModel);
            Model tmpModel = rawModel.clone();
            currentData.setModel(tmpModel);
            problems.setSource(tmpModel);
            this.modelNormalizer.mergeDuplicates(tmpModel, request, problems);
            profileActivationContext.setProjectProperties(tmpModel.getProperties());
            List<Profile> activePomProfiles = this.profileSelector.getActiveProfiles(rawModel.getProfiles(), profileActivationContext, problems);
            currentData.setActiveProfiles(activePomProfiles);
            Map<String, Activation> interpolatedActivations = this.getProfileActivations(rawModel, false);
            this.injectProfileActivations(tmpModel, interpolatedActivations);
            for (Profile activeProfile : activePomProfiles) {
                this.profileInjector.injectProfile(tmpModel, activeProfile, request, problems);
            }
            if (currentData == resultData) {
                for (Profile activeProfile : activeExternalProfiles) {
                    this.profileInjector.injectProfile(tmpModel, activeProfile, request, problems);
                }
            }
            if (currentData == superData) break;
            this.configureResolver(request.getModelResolver(), tmpModel, problems);
            ModelData parentData2 = this.readParent(tmpModel, currentData.getSource(), request, problems);
            if (parentData2 == null) {
                currentData = superData;
                continue;
            }
            if (currentData == resultData) {
                currentData.setGroupId(currentData.getRawModel().getGroupId() == null ? parentData2.getGroupId() : currentData.getRawModel().getGroupId());
                currentData.setVersion(currentData.getRawModel().getVersion() == null ? parentData2.getVersion() : currentData.getRawModel().getVersion());
                currentData.setArtifactId(currentData.getRawModel().getArtifactId());
                parentIds.add(currentData.getId());
                currentData.setGroupId(null);
                currentData.setArtifactId(null);
                currentData.setVersion(null);
                currentData = parentData2;
                continue;
            }
            if (!parentIds.add(parentData2.getId())) {
                String message = "io.quarkus.launcher.shaded.The parents form a cycle: ";
                for (String modelId : parentIds) {
                    message = message + modelId + "io.quarkus.launcher.shaded. -> ";
                }
                message = message + parentData2.getId();
                problems.add(new ModelProblemCollectorRequest(ModelProblem.Severity.FATAL, ModelProblem.Version.BASE).setMessage(message));
                throw problems.newModelBuildingException();
            }
            currentData = parentData2;
        }
        problems.setSource(inputModel);
        this.checkPluginVersions(lineage, request, problems);
        this.assembleInheritance(lineage, request, problems);
        Model resultModel = resultData.getModel();
        problems.setSource(resultModel);
        problems.setRootModel(resultModel);
        resultModel = this.interpolateModel(resultModel, request, problems);
        resultData.setModel(resultModel);
        if (resultModel.getParent() != null && ((parentData = (ModelData)lineage.get(1)).getVersion() == null || parentData.getVersion().contains("io.quarkus.launcher.shaded.${"))) {
            Model interpolatedParent = this.interpolateModel(parentData.getModel(), request, problems);
            parentData.setVersion(interpolatedParent.getVersion());
        }
        this.modelUrlNormalizer.normalize(resultModel, request);
        this.configureResolver(request.getModelResolver(), resultModel, problems, true);
        resultData.setGroupId(resultModel.getGroupId());
        resultData.setArtifactId(resultModel.getArtifactId());
        resultData.setVersion(resultModel.getVersion());
        result.setEffectiveModel(resultModel);
        for (ModelData currentData2 : lineage) {
            String modelId = currentData2 != superData ? currentData2.getId() : "io.quarkus.launcher.shaded.";
            result.addModelId(modelId);
            result.setActivePomProfiles(modelId, currentData2.getActiveProfiles());
            result.setRawModel(modelId, currentData2.getRawModel());
        }
        if (!request.isTwoPhaseBuilding()) {
            this.build(request, result);
        }
        return result;
    }

    @Override
    public ModelBuildingResult build(ModelBuildingRequest request, ModelBuildingResult result) throws ModelBuildingException {
        return this.build(request, result, new LinkedHashSet<String>());
    }

    private ModelBuildingResult build(ModelBuildingRequest request, ModelBuildingResult result, Collection<String> imports) throws ModelBuildingException {
        Model resultModel = result.getEffectiveModel();
        DefaultModelProblemCollector problems = new DefaultModelProblemCollector(result);
        problems.setSource(resultModel);
        problems.setRootModel(resultModel);
        this.modelPathTranslator.alignToBaseDirectory(resultModel, resultModel.getProjectDirectory(), request);
        this.pluginManagementInjector.injectManagement(resultModel, request, problems);
        this.fireEvent(resultModel, request, problems, ModelBuildingEventCatapult.BUILD_EXTENSIONS_ASSEMBLED);
        if (request.isProcessPlugins()) {
            if (this.lifecycleBindingsInjector == null) {
                throw new IllegalStateException("io.quarkus.launcher.shaded.lifecycle bindings injector is missing");
            }
            this.lifecycleBindingsInjector.injectLifecycleBindings(resultModel, request, problems);
        }
        this.importDependencyManagement(resultModel, request, problems, imports);
        this.dependencyManagementInjector.injectManagement(resultModel, request, problems);
        this.modelNormalizer.injectDefaultValues(resultModel, request, problems);
        if (request.isProcessPlugins()) {
            this.reportConfigurationExpander.expandPluginConfiguration(resultModel, request, problems);
            this.reportingConverter.convertReporting(resultModel, request, problems);
            this.pluginConfigurationExpander.expandPluginConfiguration(resultModel, request, problems);
        }
        this.modelValidator.validateEffectiveModel(resultModel, request, problems);
        if (this.hasModelErrors(problems)) {
            throw problems.newModelBuildingException();
        }
        return result;
    }

    @Override
    public Result<? extends Model> buildRawModel(File pomFile, int validationLevel, boolean locationTracking) {
        DefaultModelBuildingRequest request = new DefaultModelBuildingRequest().setValidationLevel(validationLevel).setLocationTracking(locationTracking);
        DefaultModelProblemCollector collector = new DefaultModelProblemCollector(new DefaultModelBuildingResult());
        try {
            return Result.newResult(this.readModel(null, pomFile, request, collector), collector.getProblems());
        }
        catch (ModelBuildingException e) {
            return Result.error(collector.getProblems());
        }
    }

    private Model readModel(ModelSource modelSource, File pomFile, ModelBuildingRequest request, DefaultModelProblemCollector problems) throws ModelBuildingException {
        Model model;
        if (modelSource == null) {
            if (pomFile != null) {
                modelSource = new FileModelSource(pomFile);
            } else {
                throw new NullPointerException("io.quarkus.launcher.shaded.neither pomFile nor modelSource can be null");
            }
        }
        problems.setSource(modelSource.getLocation());
        try {
            boolean strict = request.getValidationLevel() >= 20;
            InputSource source = request.isLocationTracking() ? new InputSource() : null;
            HashMap<String, Object> options = new HashMap<String, Object>();
            options.put("io.quarkus.launcher.shaded.org.apache.maven.model.io.isStrict", strict);
            options.put("io.quarkus.launcher.shaded.org.apache.maven.model.io.inputSource", source);
            options.put("io.quarkus.launcher.shaded.org.apache.maven.model.building.source", modelSource);
            try {
                model = this.modelProcessor.read(modelSource.getInputStream(), options);
            }
            catch (ModelParseException e) {
                if (!strict) {
                    throw e;
                }
                options.put("io.quarkus.launcher.shaded.org.apache.maven.model.io.isStrict", Boolean.FALSE);
                try {
                    model = this.modelProcessor.read(modelSource.getInputStream(), options);
                }
                catch (ModelParseException ne) {
                    throw e;
                }
                if (pomFile != null) {
                    problems.add(new ModelProblemCollectorRequest(ModelProblem.Severity.ERROR, ModelProblem.Version.V20).setMessage("io.quarkus.launcher.shaded.Malformed POM " + modelSource.getLocation() + "io.quarkus.launcher.shaded.: " + e.getMessage()).setException(e));
                }
                problems.add(new ModelProblemCollectorRequest(ModelProblem.Severity.WARNING, ModelProblem.Version.V20).setMessage("io.quarkus.launcher.shaded.Malformed POM " + modelSource.getLocation() + "io.quarkus.launcher.shaded.: " + e.getMessage()).setException(e));
            }
            if (source != null) {
                source.setModelId(ModelProblemUtils.toId(model));
                source.setLocation(modelSource.getLocation());
            }
        }
        catch (ModelParseException e) {
            problems.add(new ModelProblemCollectorRequest(ModelProblem.Severity.FATAL, ModelProblem.Version.BASE).setMessage("io.quarkus.launcher.shaded.Non-parseable POM " + modelSource.getLocation() + "io.quarkus.launcher.shaded.: " + e.getMessage()).setException(e));
            throw problems.newModelBuildingException();
        }
        catch (IOException e) {
            String msg = e.getMessage();
            if (msg == null || msg.length() <= 0) {
                msg = e.getClass().getName().endsWith("io.quarkus.launcher.shaded.MalformedInputException") ? "io.quarkus.launcher.shaded.Some input bytes do not match the file encoding." : e.getClass().getSimpleName();
            }
            problems.add(new ModelProblemCollectorRequest(ModelProblem.Severity.FATAL, ModelProblem.Version.BASE).setMessage("io.quarkus.launcher.shaded.Non-readable POM " + modelSource.getLocation() + "io.quarkus.launcher.shaded.: " + msg).setException(e));
            throw problems.newModelBuildingException();
        }
        model.setPomFile(pomFile);
        problems.setSource(model);
        this.modelValidator.validateRawModel(model, request, problems);
        if (this.hasFatalErrors(problems)) {
            throw problems.newModelBuildingException();
        }
        return model;
    }

    private DefaultProfileActivationContext getProfileActivationContext(ModelBuildingRequest request) {
        DefaultProfileActivationContext context = new DefaultProfileActivationContext();
        context.setActiveProfileIds(request.getActiveProfileIds());
        context.setInactiveProfileIds(request.getInactiveProfileIds());
        context.setSystemProperties(request.getSystemProperties());
        context.setUserProperties(request.getUserProperties());
        context.setProjectDirectory(request.getPomFile() != null ? request.getPomFile().getParentFile() : null);
        return context;
    }

    private void configureResolver(ModelResolver modelResolver, Model model, DefaultModelProblemCollector problems) {
        this.configureResolver(modelResolver, model, problems, false);
    }

    private void configureResolver(ModelResolver modelResolver, Model model, DefaultModelProblemCollector problems, boolean replaceRepositories) {
        if (modelResolver == null) {
            return;
        }
        problems.setSource(model);
        List<Repository> repositories = model.getRepositories();
        for (Repository repository : repositories) {
            try {
                modelResolver.addRepository(repository, replaceRepositories);
            }
            catch (InvalidRepositoryException e) {
                problems.add(new ModelProblemCollectorRequest(ModelProblem.Severity.ERROR, ModelProblem.Version.BASE).setMessage("io.quarkus.launcher.shaded.Invalid repository " + repository.getId() + "io.quarkus.launcher.shaded.: " + e.getMessage()).setLocation(repository.getLocation("io.quarkus.launcher.shaded.")).setException(e));
            }
        }
    }

    private void checkPluginVersions(List<ModelData> lineage, ModelBuildingRequest request, ModelProblemCollector problems) {
        if (request.getValidationLevel() < 20) {
            return;
        }
        HashMap<String, Plugin> plugins = new HashMap<String, Plugin>();
        HashMap<String, String> versions = new HashMap<String, String>();
        HashMap<String, String> managedVersions = new HashMap<String, String>();
        for (int i = lineage.size() - 1; i >= 0; --i) {
            Model model = lineage.get(i).getModel();
            Build build = model.getBuild();
            if (build == null) continue;
            for (Plugin plugin : build.getPlugins()) {
                String key = plugin.getKey();
                if (versions.get(key) != null) continue;
                versions.put(key, plugin.getVersion());
                plugins.put(key, plugin);
            }
            PluginManagement mgmt = build.getPluginManagement();
            if (mgmt == null) continue;
            for (Plugin plugin : mgmt.getPlugins()) {
                String key = plugin.getKey();
                if (managedVersions.get(key) != null) continue;
                managedVersions.put(key, plugin.getVersion());
            }
        }
        for (String key : versions.keySet()) {
            if (versions.get(key) != null || managedVersions.get(key) != null) continue;
            InputLocation location = ((Plugin)plugins.get(key)).getLocation("io.quarkus.launcher.shaded.");
            problems.add(new ModelProblemCollectorRequest(ModelProblem.Severity.WARNING, ModelProblem.Version.V20).setMessage("io.quarkus.launcher.shaded.'build.plugins.plugin.version' for " + key + "io.quarkus.launcher.shaded. is missing.").setLocation(location));
        }
    }

    private void assembleInheritance(List<ModelData> lineage, ModelBuildingRequest request, ModelProblemCollector problems) {
        for (int i = lineage.size() - 2; i >= 0; --i) {
            Model parent = lineage.get(i + 1).getModel();
            Model child = lineage.get(i).getModel();
            this.inheritanceAssembler.assembleModelInheritance(child, parent, request, problems);
        }
    }

    private Map<String, Activation> getProfileActivations(Model model, boolean clone) {
        HashMap<String, Activation> activations = new HashMap<String, Activation>();
        for (Profile profile : model.getProfiles()) {
            Activation activation = profile.getActivation();
            if (activation == null) continue;
            if (clone) {
                activation = activation.clone();
            }
            activations.put(profile.getId(), activation);
        }
        return activations;
    }

    private void injectProfileActivations(Model model, Map<String, Activation> activations) {
        for (Profile profile : model.getProfiles()) {
            Activation activation = profile.getActivation();
            if (activation == null) continue;
            profile.setActivation(activations.get(profile.getId()));
        }
    }

    private Model interpolateModel(Model model, ModelBuildingRequest request, ModelProblemCollector problems) {
        Map<String, Activation> originalActivations = this.getProfileActivations(model, true);
        Model interpolatedModel = this.modelInterpolator.interpolateModel(model, model.getProjectDirectory(), request, problems);
        if (interpolatedModel.getParent() != null) {
            StringSearchInterpolator ssi = new StringSearchInterpolator();
            ssi.addValueSource(new MapBasedValueSource(request.getUserProperties()));
            ssi.addValueSource(new MapBasedValueSource(model.getProperties()));
            ssi.addValueSource(new MapBasedValueSource(request.getSystemProperties()));
            try {
                String interpolated = ssi.interpolate(interpolatedModel.getParent().getVersion());
                interpolatedModel.getParent().setVersion(interpolated);
            }
            catch (Exception e) {
                ModelProblemCollectorRequest mpcr = new ModelProblemCollectorRequest(ModelProblem.Severity.ERROR, ModelProblem.Version.BASE).setMessage("io.quarkus.launcher.shaded.Failed to interpolate field: " + interpolatedModel.getParent().getVersion() + "io.quarkus.launcher.shaded. on class: ").setException(e);
                problems.add(mpcr);
            }
        }
        interpolatedModel.setPomFile(model.getPomFile());
        this.injectProfileActivations(model, originalActivations);
        return interpolatedModel;
    }

    private ModelData readParent(Model childModel, ModelSource childSource, ModelBuildingRequest request, DefaultModelProblemCollector problems) throws ModelBuildingException {
        ModelData parentData;
        Parent parent = childModel.getParent();
        if (parent != null) {
            String groupId = parent.getGroupId();
            String artifactId = parent.getArtifactId();
            String version = parent.getVersion();
            parentData = this.getCache(request.getModelCache(), groupId, artifactId, version, ModelCacheTag.RAW);
            if (parentData == null) {
                parentData = this.readParentLocally(childModel, childSource, request, problems);
                if (parentData == null) {
                    parentData = this.readParentExternally(childModel, request, problems);
                }
                this.putCache(request.getModelCache(), groupId, artifactId, version, ModelCacheTag.RAW, parentData);
            } else {
                File pomFile = parentData.getModel().getPomFile();
                if (pomFile != null) {
                    FileModelSource pomSource = new FileModelSource(pomFile);
                    ModelSource expectedParentSource = this.getParentPomFile(childModel, childSource);
                    if (expectedParentSource == null || expectedParentSource instanceof ModelSource2 && !pomSource.equals(expectedParentSource)) {
                        parentData = this.readParentExternally(childModel, request, problems);
                    }
                }
            }
            Model parentModel = parentData.getModel();
            if (!"io.quarkus.launcher.shaded.pom".equals(parentModel.getPackaging())) {
                problems.add(new ModelProblemCollectorRequest(ModelProblem.Severity.ERROR, ModelProblem.Version.BASE).setMessage("io.quarkus.launcher.shaded.Invalid packaging for parent POM " + ModelProblemUtils.toSourceHint(parentModel) + "io.quarkus.launcher.shaded., must be \"pom\" but is \"" + parentModel.getPackaging() + "io.quarkus.launcher.shaded.\"").setLocation(parentModel.getLocation("io.quarkus.launcher.shaded.packaging")));
            }
        } else {
            parentData = null;
        }
        return parentData;
    }

    private ModelData readParentLocally(Model childModel, ModelSource childSource, ModelBuildingRequest request, DefaultModelProblemCollector problems) throws ModelBuildingException {
        Model candidateModel;
        ModelSource candidateSource;
        Parent parent = childModel.getParent();
        WorkspaceModelResolver resolver = request.getWorkspaceModelResolver();
        if (resolver == null) {
            candidateSource = this.getParentPomFile(childModel, childSource);
            if (candidateSource == null) {
                return null;
            }
            File pomFile = null;
            if (candidateSource instanceof FileModelSource) {
                pomFile = ((FileModelSource)candidateSource).getPomFile();
            }
            candidateModel = this.readModel(candidateSource, pomFile, request, problems);
        } else {
            try {
                candidateModel = resolver.resolveRawModel(parent.getGroupId(), parent.getArtifactId(), parent.getVersion());
            }
            catch (UnresolvableModelException e) {
                problems.add(new ModelProblemCollectorRequest(ModelProblem.Severity.FATAL, ModelProblem.Version.BASE).setMessage(e.getMessage().toString()).setLocation(parent.getLocation("io.quarkus.launcher.shaded.")).setException(e));
                throw problems.newModelBuildingException();
            }
            if (candidateModel == null) {
                return null;
            }
            candidateSource = new FileModelSource(candidateModel.getPomFile());
        }
        String groupId = candidateModel.getGroupId();
        if (groupId == null && candidateModel.getParent() != null) {
            groupId = candidateModel.getParent().getGroupId();
        }
        String artifactId = candidateModel.getArtifactId();
        String version = candidateModel.getVersion();
        if (version == null && candidateModel.getParent() != null) {
            version = candidateModel.getParent().getVersion();
        }
        if (groupId == null || !groupId.equals(parent.getGroupId()) || artifactId == null || !artifactId.equals(parent.getArtifactId())) {
            StringBuilder buffer = new StringBuilder(256);
            buffer.append("io.quarkus.launcher.shaded.'parent.relativePath'");
            if (childModel != problems.getRootModel()) {
                buffer.append("io.quarkus.launcher.shaded. of POM ").append(ModelProblemUtils.toSourceHint(childModel));
            }
            buffer.append("io.quarkus.launcher.shaded. points at ").append(groupId).append(':').append(artifactId);
            buffer.append("io.quarkus.launcher.shaded. instead of ").append(parent.getGroupId()).append(':');
            buffer.append(parent.getArtifactId()).append("io.quarkus.launcher.shaded., please verify your project structure");
            problems.setSource(childModel);
            problems.add(new ModelProblemCollectorRequest(ModelProblem.Severity.WARNING, ModelProblem.Version.BASE).setMessage(buffer.toString()).setLocation(parent.getLocation("io.quarkus.launcher.shaded.")));
            return null;
        }
        if (version != null && parent.getVersion() != null && !version.equals(parent.getVersion())) {
            try {
                VersionRange parentRange = VersionRange.createFromVersionSpec(parent.getVersion());
                if (!parentRange.hasRestrictions()) {
                    return null;
                }
                if (!parentRange.containsVersion(new DefaultArtifactVersion(version))) {
                    return null;
                }
                if (childModel.getVersion() == null) {
                    problems.add(new ModelProblemCollectorRequest(ModelProblem.Severity.FATAL, ModelProblem.Version.V31).setMessage("io.quarkus.launcher.shaded.Version must be a constant").setLocation(childModel.getLocation("io.quarkus.launcher.shaded.")));
                } else if (childModel.getVersion().contains("io.quarkus.launcher.shaded.${")) {
                    problems.add(new ModelProblemCollectorRequest(ModelProblem.Severity.FATAL, ModelProblem.Version.V31).setMessage("io.quarkus.launcher.shaded.Version must be a constant").setLocation(childModel.getLocation("io.quarkus.launcher.shaded.version")));
                }
            }
            catch (InvalidVersionSpecificationException e) {
                return null;
            }
        }
        ModelData parentData = new ModelData(candidateSource, candidateModel, groupId, artifactId, version);
        return parentData;
    }

    private ModelSource getParentPomFile(Model childModel, ModelSource source) {
        if (!(source instanceof ModelSource2)) {
            return null;
        }
        String parentPath = childModel.getParent().getRelativePath();
        if (parentPath == null || parentPath.length() <= 0) {
            return null;
        }
        return ((ModelSource2)source).getRelatedSource(parentPath);
    }

    private ModelData readParentExternally(Model childModel, ModelBuildingRequest request, DefaultModelProblemCollector problems) throws ModelBuildingException {
        ModelSource modelSource;
        problems.setSource(childModel);
        Parent parent = childModel.getParent().clone();
        String groupId = parent.getGroupId();
        String artifactId = parent.getArtifactId();
        String version = parent.getVersion();
        ModelResolver modelResolver = request.getModelResolver();
        Objects.requireNonNull(modelResolver, String.format("io.quarkus.launcher.shaded.request.modelResolver cannot be null (parent POM %s and POM %s)", ModelProblemUtils.toId(groupId, artifactId, version), ModelProblemUtils.toSourceHint(childModel)));
        try {
            modelSource = modelResolver.resolveModel(parent);
        }
        catch (UnresolvableModelException e) {
            StringBuilder buffer = new StringBuilder(256);
            buffer.append("io.quarkus.launcher.shaded.Non-resolvable parent POM");
            if (!this.containsCoordinates(e.getMessage(), groupId, artifactId, version)) {
                buffer.append(' ').append(ModelProblemUtils.toId(groupId, artifactId, version));
            }
            if (childModel != problems.getRootModel()) {
                buffer.append("io.quarkus.launcher.shaded. for ").append(ModelProblemUtils.toId(childModel));
            }
            buffer.append("io.quarkus.launcher.shaded.: ").append(e.getMessage());
            if (childModel.getProjectDirectory() != null) {
                if (parent.getRelativePath() == null || parent.getRelativePath().length() <= 0) {
                    buffer.append("io.quarkus.launcher.shaded. and 'parent.relativePath' points at no local POM");
                } else {
                    buffer.append("io.quarkus.launcher.shaded. and 'parent.relativePath' points at wrong local POM");
                }
            }
            problems.add(new ModelProblemCollectorRequest(ModelProblem.Severity.FATAL, ModelProblem.Version.BASE).setMessage(buffer.toString()).setLocation(parent.getLocation("io.quarkus.launcher.shaded.")).setException(e));
            throw problems.newModelBuildingException();
        }
        ModelBuildingRequest lenientRequest = request;
        if (request.getValidationLevel() > 20) {
            lenientRequest = new FilterModelBuildingRequest(request){

                @Override
                public int getValidationLevel() {
                    return 20;
                }
            };
        }
        Model parentModel = this.readModel(modelSource, null, lenientRequest, problems);
        if (!parent.getVersion().equals(version)) {
            if (childModel.getVersion() == null) {
                problems.add(new ModelProblemCollectorRequest(ModelProblem.Severity.FATAL, ModelProblem.Version.V31).setMessage("io.quarkus.launcher.shaded.Version must be a constant").setLocation(childModel.getLocation("io.quarkus.launcher.shaded.")));
            } else if (childModel.getVersion().contains("io.quarkus.launcher.shaded.${")) {
                problems.add(new ModelProblemCollectorRequest(ModelProblem.Severity.FATAL, ModelProblem.Version.V31).setMessage("io.quarkus.launcher.shaded.Version must be a constant").setLocation(childModel.getLocation("io.quarkus.launcher.shaded.version")));
            }
        }
        ModelData parentData = new ModelData(modelSource, parentModel, parent.getGroupId(), parent.getArtifactId(), parent.getVersion());
        return parentData;
    }

    private Model getSuperModel() {
        return this.superPomProvider.getSuperModel("io.quarkus.launcher.shaded.4.0.0").clone();
    }

    private void importDependencyManagement(Model model, ModelBuildingRequest request, DefaultModelProblemCollector problems, Collection<String> importIds) {
        DependencyManagement depMgmt = model.getDependencyManagement();
        if (depMgmt == null) {
            return;
        }
        String importing = model.getGroupId() + ':' + model.getArtifactId() + ':' + model.getVersion();
        importIds.add(importing);
        WorkspaceModelResolver workspaceResolver = request.getWorkspaceModelResolver();
        ModelResolver modelResolver = request.getModelResolver();
        ModelBuildingRequest importRequest = null;
        ArrayList<DependencyManagement> importMgmts = null;
        Iterator<Dependency> it = depMgmt.getDependencies().iterator();
        while (it.hasNext()) {
            Dependency dependency = it.next();
            if (!"io.quarkus.launcher.shaded.pom".equals(dependency.getType()) || !"io.quarkus.launcher.shaded.import".equals(dependency.getScope())) continue;
            it.remove();
            String groupId = dependency.getGroupId();
            String artifactId = dependency.getArtifactId();
            String version = dependency.getVersion();
            if (groupId == null || groupId.length() <= 0) {
                problems.add(new ModelProblemCollectorRequest(ModelProblem.Severity.ERROR, ModelProblem.Version.BASE).setMessage("io.quarkus.launcher.shaded.'dependencyManagement.dependencies.dependency.groupId' for " + dependency.getManagementKey() + "io.quarkus.launcher.shaded. is missing.").setLocation(dependency.getLocation("io.quarkus.launcher.shaded.")));
                continue;
            }
            if (artifactId == null || artifactId.length() <= 0) {
                problems.add(new ModelProblemCollectorRequest(ModelProblem.Severity.ERROR, ModelProblem.Version.BASE).setMessage("io.quarkus.launcher.shaded.'dependencyManagement.dependencies.dependency.artifactId' for " + dependency.getManagementKey() + "io.quarkus.launcher.shaded. is missing.").setLocation(dependency.getLocation("io.quarkus.launcher.shaded.")));
                continue;
            }
            if (version == null || version.length() <= 0) {
                problems.add(new ModelProblemCollectorRequest(ModelProblem.Severity.ERROR, ModelProblem.Version.BASE).setMessage("io.quarkus.launcher.shaded.'dependencyManagement.dependencies.dependency.version' for " + dependency.getManagementKey() + "io.quarkus.launcher.shaded. is missing.").setLocation(dependency.getLocation("io.quarkus.launcher.shaded.")));
                continue;
            }
            String imported = groupId + ':' + artifactId + ':' + version;
            if (importIds.contains(imported)) {
                String message = "io.quarkus.launcher.shaded.The dependencies of type=pom and with scope=import form a cycle: ";
                for (String modelId : importIds) {
                    message = message + modelId + "io.quarkus.launcher.shaded. -> ";
                }
                message = message + imported;
                problems.add(new ModelProblemCollectorRequest(ModelProblem.Severity.ERROR, ModelProblem.Version.BASE).setMessage(message));
                continue;
            }
            DependencyManagement importMgmt = this.getCache(request.getModelCache(), groupId, artifactId, version, ModelCacheTag.IMPORT);
            if (importMgmt == null) {
                if (workspaceResolver == null && modelResolver == null) {
                    throw new NullPointerException(String.format("io.quarkus.launcher.shaded.request.workspaceModelResolver and request.modelResolver cannot be null (parent POM %s and POM %s)", ModelProblemUtils.toId(groupId, artifactId, version), ModelProblemUtils.toSourceHint(model)));
                }
                ModelBase importModel = null;
                if (workspaceResolver != null) {
                    try {
                        importModel = workspaceResolver.resolveEffectiveModel(groupId, artifactId, version);
                    }
                    catch (UnresolvableModelException e) {
                        problems.add(new ModelProblemCollectorRequest(ModelProblem.Severity.FATAL, ModelProblem.Version.BASE).setMessage(e.getMessage().toString()).setException(e));
                        continue;
                    }
                }
                if (importModel == null) {
                    ModelBuildingResult importResult;
                    ModelSource importSource;
                    try {
                        importSource = modelResolver.resolveModel(groupId, artifactId, version);
                    }
                    catch (UnresolvableModelException e) {
                        StringBuilder buffer = new StringBuilder(256);
                        buffer.append("io.quarkus.launcher.shaded.Non-resolvable import POM");
                        if (!this.containsCoordinates(e.getMessage(), groupId, artifactId, version)) {
                            buffer.append(' ').append(ModelProblemUtils.toId(groupId, artifactId, version));
                        }
                        buffer.append("io.quarkus.launcher.shaded.: ").append(e.getMessage());
                        problems.add(new ModelProblemCollectorRequest(ModelProblem.Severity.ERROR, ModelProblem.Version.BASE).setMessage(buffer.toString()).setLocation(dependency.getLocation("io.quarkus.launcher.shaded.")).setException(e));
                        continue;
                    }
                    if (importRequest == null) {
                        importRequest = new DefaultModelBuildingRequest();
                        importRequest.setValidationLevel(0);
                        importRequest.setModelCache(request.getModelCache());
                        importRequest.setSystemProperties(request.getSystemProperties());
                        importRequest.setUserProperties(request.getUserProperties());
                        importRequest.setLocationTracking(request.isLocationTracking());
                    }
                    importRequest.setModelSource(importSource);
                    importRequest.setModelResolver(modelResolver.newCopy());
                    try {
                        importResult = this.build(importRequest);
                    }
                    catch (ModelBuildingException e) {
                        problems.addAll(e.getProblems());
                        continue;
                    }
                    problems.addAll(importResult.getProblems());
                    importModel = importResult.getEffectiveModel();
                }
                if ((importMgmt = importModel.getDependencyManagement()) == null) {
                    importMgmt = new DependencyManagement();
                }
                this.putCache(request.getModelCache(), groupId, artifactId, version, ModelCacheTag.IMPORT, importMgmt);
            }
            if (importMgmts == null) {
                importMgmts = new ArrayList<DependencyManagement>();
            }
            importMgmts.add(importMgmt);
        }
        importIds.remove(importing);
        this.dependencyManagementImporter.importManagement(model, importMgmts, request, problems);
    }

    private <T> void putCache(ModelCache modelCache, String groupId, String artifactId, String version, ModelCacheTag<T> tag, T data) {
        if (modelCache != null) {
            modelCache.put(groupId, artifactId, version, tag.getName(), tag.intoCache(data));
        }
    }

    private <T> T getCache(ModelCache modelCache, String groupId, String artifactId, String version, ModelCacheTag<T> tag) {
        Object data;
        if (modelCache != null && (data = modelCache.get(groupId, artifactId, version, tag.getName())) != null) {
            return tag.fromCache(tag.getType().cast(data));
        }
        return null;
    }

    private void fireEvent(Model model, ModelBuildingRequest request, ModelProblemCollector problems, ModelBuildingEventCatapult catapult) throws ModelBuildingException {
        ModelBuildingListener listener = request.getModelBuildingListener();
        if (listener != null) {
            DefaultModelBuildingEvent event = new DefaultModelBuildingEvent(model, request, problems);
            catapult.fire(listener, event);
        }
    }

    private boolean containsCoordinates(String message, String groupId, String artifactId, String version) {
        return !(message == null || groupId != null && !message.contains(groupId) || artifactId != null && !message.contains(artifactId) || version != null && !message.contains(version));
    }

    protected boolean hasModelErrors(ModelProblemCollectorExt problems) {
        if (problems instanceof DefaultModelProblemCollector) {
            return ((DefaultModelProblemCollector)problems).hasErrors();
        }
        throw new IllegalStateException();
    }

    protected boolean hasFatalErrors(ModelProblemCollectorExt problems) {
        if (problems instanceof DefaultModelProblemCollector) {
            return ((DefaultModelProblemCollector)problems).hasFatalErrors();
        }
        throw new IllegalStateException();
    }
}

