/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.maven.model.building;

import io.quarkus.launcher.shaded.org.apache.maven.model.Model;
import io.quarkus.launcher.shaded.org.apache.maven.model.building.ModelProblem;
import java.io.File;

public class ModelProblemUtils {
    static String toSourceHint(Model model) {
        if (model == null) {
            return "io.quarkus.launcher.shaded.";
        }
        StringBuilder buffer = new StringBuilder(128);
        buffer.append(ModelProblemUtils.toId(model));
        File pomFile = model.getPomFile();
        if (pomFile != null) {
            buffer.append("io.quarkus.launcher.shaded. (").append(pomFile).append(')');
        }
        return buffer.toString();
    }

    static String toPath(Model model) {
        File pomFile;
        String path = "io.quarkus.launcher.shaded.";
        if (model != null && (pomFile = model.getPomFile()) != null) {
            path = pomFile.getAbsolutePath();
        }
        return path;
    }

    static String toId(Model model) {
        if (model == null) {
            return "io.quarkus.launcher.shaded.";
        }
        String groupId = model.getGroupId();
        if (groupId == null && model.getParent() != null) {
            groupId = model.getParent().getGroupId();
        }
        String artifactId = model.getArtifactId();
        String version = model.getVersion();
        if (version == null && model.getParent() != null) {
            version = model.getParent().getVersion();
        }
        if (version == null) {
            version = "io.quarkus.launcher.shaded.[unknown-version]";
        }
        return ModelProblemUtils.toId(groupId, artifactId, version);
    }

    static String toId(String groupId, String artifactId, String version) {
        StringBuilder buffer = new StringBuilder(128);
        buffer.append(groupId != null && groupId.length() > 0 ? groupId : "io.quarkus.launcher.shaded.[unknown-group-id]");
        buffer.append(':');
        buffer.append(artifactId != null && artifactId.length() > 0 ? artifactId : "io.quarkus.launcher.shaded.[unknown-artifact-id]");
        buffer.append(':');
        buffer.append(version != null && version.length() > 0 ? version : "io.quarkus.launcher.shaded.[unknown-version]");
        return buffer.toString();
    }

    public static String formatLocation(ModelProblem problem, String projectId) {
        StringBuilder buffer = new StringBuilder(256);
        if (!problem.getModelId().equals(projectId)) {
            buffer.append(problem.getModelId());
            if (problem.getSource().length() > 0) {
                if (buffer.length() > 0) {
                    buffer.append("io.quarkus.launcher.shaded., ");
                }
                buffer.append(problem.getSource());
            }
        }
        if (problem.getLineNumber() > 0) {
            if (buffer.length() > 0) {
                buffer.append("io.quarkus.launcher.shaded., ");
            }
            buffer.append("io.quarkus.launcher.shaded.line ").append(problem.getLineNumber());
        }
        if (problem.getColumnNumber() > 0) {
            if (buffer.length() > 0) {
                buffer.append("io.quarkus.launcher.shaded., ");
            }
            buffer.append("io.quarkus.launcher.shaded.column ").append(problem.getColumnNumber());
        }
        return buffer.toString();
    }
}

