/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.maven.model.interpolation;

import io.quarkus.launcher.shaded.javax.inject.Inject;
import io.quarkus.launcher.shaded.org.apache.maven.model.Model;
import io.quarkus.launcher.shaded.org.apache.maven.model.building.ModelBuildingRequest;
import io.quarkus.launcher.shaded.org.apache.maven.model.building.ModelProblemCollector;
import io.quarkus.launcher.shaded.org.apache.maven.model.interpolation.BuildTimestampValueSource;
import io.quarkus.launcher.shaded.org.apache.maven.model.interpolation.ModelInterpolator;
import io.quarkus.launcher.shaded.org.apache.maven.model.interpolation.PathTranslatingPostProcessor;
import io.quarkus.launcher.shaded.org.apache.maven.model.interpolation.ProblemDetectingValueSource;
import io.quarkus.launcher.shaded.org.apache.maven.model.interpolation.UrlNormalizingPostProcessor;
import io.quarkus.launcher.shaded.org.apache.maven.model.path.PathTranslator;
import io.quarkus.launcher.shaded.org.apache.maven.model.path.UrlNormalizer;
import io.quarkus.launcher.shaded.org.codehaus.plexus.interpolation.AbstractValueSource;
import io.quarkus.launcher.shaded.org.codehaus.plexus.interpolation.InterpolationPostProcessor;
import io.quarkus.launcher.shaded.org.codehaus.plexus.interpolation.MapBasedValueSource;
import io.quarkus.launcher.shaded.org.codehaus.plexus.interpolation.ObjectBasedValueSource;
import io.quarkus.launcher.shaded.org.codehaus.plexus.interpolation.PrefixAwareRecursionInterceptor;
import io.quarkus.launcher.shaded.org.codehaus.plexus.interpolation.PrefixedObjectValueSource;
import io.quarkus.launcher.shaded.org.codehaus.plexus.interpolation.PrefixedValueSourceWrapper;
import io.quarkus.launcher.shaded.org.codehaus.plexus.interpolation.RecursionInterceptor;
import io.quarkus.launcher.shaded.org.codehaus.plexus.interpolation.ValueSource;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;

public abstract class AbstractStringBasedModelInterpolator
implements ModelInterpolator {
    public static final String SHA1_PROPERTY = "io.quarkus.launcher.shaded.sha1";
    public static final String CHANGELIST_PROPERTY = "io.quarkus.launcher.shaded.changelist";
    public static final String REVISION_PROPERTY = "io.quarkus.launcher.shaded.revision";
    private static final List<String> PROJECT_PREFIXES = Arrays.asList("io.quarkus.launcher.shaded.pom.", "io.quarkus.launcher.shaded.project.");
    private static final Collection<String> TRANSLATED_PATH_EXPRESSIONS;
    @Inject
    private PathTranslator pathTranslator;
    @Inject
    private UrlNormalizer urlNormalizer;

    public AbstractStringBasedModelInterpolator setPathTranslator(PathTranslator pathTranslator) {
        this.pathTranslator = pathTranslator;
        return this;
    }

    public AbstractStringBasedModelInterpolator setUrlNormalizer(UrlNormalizer urlNormalizer) {
        this.urlNormalizer = urlNormalizer;
        return this;
    }

    protected List<ValueSource> createValueSources(Model model, final File projectDir, final ModelBuildingRequest config, ModelProblemCollector problems) {
        Properties modelProperties = model.getProperties();
        ValueSource modelValueSource1 = new PrefixedObjectValueSource(PROJECT_PREFIXES, model, false);
        if (config.getValidationLevel() >= 20) {
            modelValueSource1 = new ProblemDetectingValueSource(modelValueSource1, "io.quarkus.launcher.shaded.pom.", "io.quarkus.launcher.shaded.project.", problems);
        }
        ValueSource modelValueSource2 = new ObjectBasedValueSource(model);
        if (config.getValidationLevel() >= 20) {
            modelValueSource2 = new ProblemDetectingValueSource(modelValueSource2, "io.quarkus.launcher.shaded.", "io.quarkus.launcher.shaded.project.", problems);
        }
        ArrayList<ValueSource> valueSources = new ArrayList<ValueSource>(9);
        if (projectDir != null) {
            PrefixedValueSourceWrapper basedirValueSource = new PrefixedValueSourceWrapper((ValueSource)new AbstractValueSource(false){

                @Override
                public Object getValue(String expression) {
                    if ("io.quarkus.launcher.shaded.basedir".equals(expression)) {
                        return projectDir.getAbsolutePath();
                    }
                    return null;
                }
            }, PROJECT_PREFIXES, true);
            valueSources.add(basedirValueSource);
            PrefixedValueSourceWrapper baseUriValueSource = new PrefixedValueSourceWrapper((ValueSource)new AbstractValueSource(false){

                @Override
                public Object getValue(String expression) {
                    if ("io.quarkus.launcher.shaded.baseUri".equals(expression)) {
                        return projectDir.getAbsoluteFile().toPath().toUri().toASCIIString();
                    }
                    return null;
                }
            }, PROJECT_PREFIXES, false);
            valueSources.add(baseUriValueSource);
            valueSources.add(new BuildTimestampValueSource(config.getBuildStartTime(), modelProperties));
        }
        valueSources.add(modelValueSource1);
        valueSources.add(new MapBasedValueSource(config.getUserProperties()));
        if (config.getSystemProperties().containsKey(REVISION_PROPERTY)) {
            modelProperties.put(REVISION_PROPERTY, config.getSystemProperties().get(REVISION_PROPERTY));
        }
        if (config.getSystemProperties().containsKey(CHANGELIST_PROPERTY)) {
            modelProperties.put(CHANGELIST_PROPERTY, config.getSystemProperties().get(CHANGELIST_PROPERTY));
        }
        if (config.getSystemProperties().containsKey(SHA1_PROPERTY)) {
            modelProperties.put(SHA1_PROPERTY, config.getSystemProperties().get(SHA1_PROPERTY));
        }
        valueSources.add(new MapBasedValueSource(modelProperties));
        valueSources.add(new MapBasedValueSource(config.getSystemProperties()));
        valueSources.add(new AbstractValueSource(false){

            @Override
            public Object getValue(String expression) {
                return config.getSystemProperties().getProperty("io.quarkus.launcher.shaded.env." + expression);
            }
        });
        valueSources.add(modelValueSource2);
        return valueSources;
    }

    protected List<? extends InterpolationPostProcessor> createPostProcessors(Model model, File projectDir, ModelBuildingRequest config) {
        ArrayList<InterpolationPostProcessor> processors = new ArrayList<InterpolationPostProcessor>(2);
        if (projectDir != null) {
            processors.add(new PathTranslatingPostProcessor(PROJECT_PREFIXES, TRANSLATED_PATH_EXPRESSIONS, projectDir, this.pathTranslator));
        }
        processors.add(new UrlNormalizingPostProcessor(this.urlNormalizer));
        return processors;
    }

    protected RecursionInterceptor createRecursionInterceptor() {
        return new PrefixAwareRecursionInterceptor(PROJECT_PREFIXES);
    }

    static {
        HashSet<String> translatedPrefixes = new HashSet<String>();
        translatedPrefixes.add("io.quarkus.launcher.shaded.build.directory");
        translatedPrefixes.add("io.quarkus.launcher.shaded.build.outputDirectory");
        translatedPrefixes.add("io.quarkus.launcher.shaded.build.testOutputDirectory");
        translatedPrefixes.add("io.quarkus.launcher.shaded.build.sourceDirectory");
        translatedPrefixes.add("io.quarkus.launcher.shaded.build.testSourceDirectory");
        translatedPrefixes.add("io.quarkus.launcher.shaded.build.scriptSourceDirectory");
        translatedPrefixes.add("io.quarkus.launcher.shaded.reporting.outputDirectory");
        TRANSLATED_PATH_EXPRESSIONS = translatedPrefixes;
    }
}

