/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.maven.model.interpolation;

import io.quarkus.launcher.shaded.org.apache.maven.model.building.ModelProblem;
import io.quarkus.launcher.shaded.org.apache.maven.model.building.ModelProblemCollector;
import io.quarkus.launcher.shaded.org.apache.maven.model.building.ModelProblemCollectorRequest;
import io.quarkus.launcher.shaded.org.codehaus.plexus.interpolation.ValueSource;
import java.util.List;

class ProblemDetectingValueSource
implements ValueSource {
    private final ValueSource valueSource;
    private final String bannedPrefix;
    private final String newPrefix;
    private final ModelProblemCollector problems;

    ProblemDetectingValueSource(ValueSource valueSource, String bannedPrefix, String newPrefix, ModelProblemCollector problems) {
        this.valueSource = valueSource;
        this.bannedPrefix = bannedPrefix;
        this.newPrefix = newPrefix;
        this.problems = problems;
    }

    @Override
    public Object getValue(String expression) {
        Object value = this.valueSource.getValue(expression);
        if (value != null && expression.startsWith(this.bannedPrefix)) {
            String msg = "io.quarkus.launcher.shaded.The expression ${" + expression + "io.quarkus.launcher.shaded.} is deprecated.";
            if (this.newPrefix != null && this.newPrefix.length() > 0) {
                msg = msg + "io.quarkus.launcher.shaded. Please use ${" + this.newPrefix + expression.substring(this.bannedPrefix.length()) + "io.quarkus.launcher.shaded.} instead.";
            }
            this.problems.add(new ModelProblemCollectorRequest(ModelProblem.Severity.WARNING, ModelProblem.Version.V20).setMessage(msg));
        }
        return value;
    }

    @Override
    public List getFeedback() {
        return this.valueSource.getFeedback();
    }

    @Override
    public void clearFeedback() {
        this.valueSource.clearFeedback();
    }
}

