/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.maven.model.interpolation;

import io.quarkus.launcher.shaded.org.apache.maven.model.path.UrlNormalizer;
import io.quarkus.launcher.shaded.org.codehaus.plexus.interpolation.InterpolationPostProcessor;
import java.util.HashSet;
import java.util.Set;

class UrlNormalizingPostProcessor
implements InterpolationPostProcessor {
    private static final Set<String> URL_EXPRESSIONS;
    private UrlNormalizer normalizer;

    UrlNormalizingPostProcessor(UrlNormalizer normalizer) {
        this.normalizer = normalizer;
    }

    @Override
    public Object execute(String expression, Object value) {
        if (value != null && URL_EXPRESSIONS.contains(expression)) {
            return this.normalizer.normalize(value.toString());
        }
        return null;
    }

    static {
        HashSet<String> expressions = new HashSet<String>();
        expressions.add("io.quarkus.launcher.shaded.project.url");
        expressions.add("io.quarkus.launcher.shaded.project.scm.url");
        expressions.add("io.quarkus.launcher.shaded.project.scm.connection");
        expressions.add("io.quarkus.launcher.shaded.project.scm.developerConnection");
        expressions.add("io.quarkus.launcher.shaded.project.distributionManagement.site.url");
        URL_EXPRESSIONS = expressions;
    }
}

