/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.maven.model.io.xpp3;

import io.quarkus.launcher.shaded.org.apache.maven.model.Activation;
import io.quarkus.launcher.shaded.org.apache.maven.model.ActivationFile;
import io.quarkus.launcher.shaded.org.apache.maven.model.ActivationOS;
import io.quarkus.launcher.shaded.org.apache.maven.model.ActivationProperty;
import io.quarkus.launcher.shaded.org.apache.maven.model.Build;
import io.quarkus.launcher.shaded.org.apache.maven.model.BuildBase;
import io.quarkus.launcher.shaded.org.apache.maven.model.CiManagement;
import io.quarkus.launcher.shaded.org.apache.maven.model.ConfigurationContainer;
import io.quarkus.launcher.shaded.org.apache.maven.model.Contributor;
import io.quarkus.launcher.shaded.org.apache.maven.model.Dependency;
import io.quarkus.launcher.shaded.org.apache.maven.model.DependencyManagement;
import io.quarkus.launcher.shaded.org.apache.maven.model.DeploymentRepository;
import io.quarkus.launcher.shaded.org.apache.maven.model.Developer;
import io.quarkus.launcher.shaded.org.apache.maven.model.DistributionManagement;
import io.quarkus.launcher.shaded.org.apache.maven.model.Exclusion;
import io.quarkus.launcher.shaded.org.apache.maven.model.Extension;
import io.quarkus.launcher.shaded.org.apache.maven.model.FileSet;
import io.quarkus.launcher.shaded.org.apache.maven.model.InputLocation;
import io.quarkus.launcher.shaded.org.apache.maven.model.InputLocationTracker;
import io.quarkus.launcher.shaded.org.apache.maven.model.IssueManagement;
import io.quarkus.launcher.shaded.org.apache.maven.model.License;
import io.quarkus.launcher.shaded.org.apache.maven.model.MailingList;
import io.quarkus.launcher.shaded.org.apache.maven.model.Model;
import io.quarkus.launcher.shaded.org.apache.maven.model.ModelBase;
import io.quarkus.launcher.shaded.org.apache.maven.model.Notifier;
import io.quarkus.launcher.shaded.org.apache.maven.model.Organization;
import io.quarkus.launcher.shaded.org.apache.maven.model.Parent;
import io.quarkus.launcher.shaded.org.apache.maven.model.PatternSet;
import io.quarkus.launcher.shaded.org.apache.maven.model.Plugin;
import io.quarkus.launcher.shaded.org.apache.maven.model.PluginConfiguration;
import io.quarkus.launcher.shaded.org.apache.maven.model.PluginContainer;
import io.quarkus.launcher.shaded.org.apache.maven.model.PluginExecution;
import io.quarkus.launcher.shaded.org.apache.maven.model.PluginManagement;
import io.quarkus.launcher.shaded.org.apache.maven.model.Prerequisites;
import io.quarkus.launcher.shaded.org.apache.maven.model.Profile;
import io.quarkus.launcher.shaded.org.apache.maven.model.Relocation;
import io.quarkus.launcher.shaded.org.apache.maven.model.ReportPlugin;
import io.quarkus.launcher.shaded.org.apache.maven.model.ReportSet;
import io.quarkus.launcher.shaded.org.apache.maven.model.Reporting;
import io.quarkus.launcher.shaded.org.apache.maven.model.Repository;
import io.quarkus.launcher.shaded.org.apache.maven.model.RepositoryBase;
import io.quarkus.launcher.shaded.org.apache.maven.model.RepositoryPolicy;
import io.quarkus.launcher.shaded.org.apache.maven.model.Resource;
import io.quarkus.launcher.shaded.org.apache.maven.model.Scm;
import io.quarkus.launcher.shaded.org.apache.maven.model.Site;
import io.quarkus.launcher.shaded.org.codehaus.plexus.util.xml.Xpp3Dom;
import io.quarkus.launcher.shaded.org.codehaus.plexus.util.xml.pull.MXSerializer;
import io.quarkus.launcher.shaded.org.codehaus.plexus.util.xml.pull.XmlSerializer;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;

public class MavenXpp3WriterEx {
    private static final String NAMESPACE = null;
    private String fileComment = null;
    protected InputLocation.StringFormatter stringFormatter;

    public void setFileComment(String fileComment) {
        this.fileComment = fileComment;
    }

    public void setStringFormatter(InputLocation.StringFormatter stringFormatter) {
        this.stringFormatter = stringFormatter;
    }

    protected String toString(InputLocation location) {
        if (this.stringFormatter != null) {
            return this.stringFormatter.toString(location);
        }
        return ' ' + location.getSource().toString() + ':' + location.getLineNumber() + ' ';
    }

    public void write(Writer writer, Model model) throws IOException {
        MXSerializer serializer = new MXSerializer();
        serializer.setProperty("io/quarkus/launcher/shaded/http://xmlpull.org/v1/doc/properties.html#serializer-indentation", "io.quarkus.launcher.shaded.  ");
        serializer.setProperty("io/quarkus/launcher/shaded/http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", "io.quarkus.launcher.shaded.\n");
        serializer.setOutput(writer);
        serializer.startDocument(model.getModelEncoding(), null);
        this.writeModel(model, "io.quarkus.launcher.shaded.project", serializer);
        serializer.endDocument();
    }

    public void write(OutputStream stream, Model model) throws IOException {
        MXSerializer serializer = new MXSerializer();
        serializer.setProperty("io/quarkus/launcher/shaded/http://xmlpull.org/v1/doc/properties.html#serializer-indentation", "io.quarkus.launcher.shaded.  ");
        serializer.setProperty("io/quarkus/launcher/shaded/http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", "io.quarkus.launcher.shaded.\n");
        serializer.setOutput(stream, model.getModelEncoding());
        serializer.startDocument(model.getModelEncoding(), null);
        this.writeModel(model, "io.quarkus.launcher.shaded.project", serializer);
        serializer.endDocument();
    }

    protected void writeXpp3DomToSerializer(Xpp3Dom dom, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, dom.getName());
        String[] attributeNames = dom.getAttributeNames();
        for (String attributeName : attributeNames) {
            serializer.attribute(NAMESPACE, attributeName, dom.getAttribute(attributeName));
        }
        for (Xpp3Dom aChild : dom.getChildren()) {
            this.writeXpp3DomToSerializer(aChild, serializer);
        }
        String value = dom.getValue();
        if (value != null) {
            serializer.text(value);
        }
        serializer.endTag(NAMESPACE, dom.getName());
        if (dom.getInputLocation() != null && dom.getChildCount() == 0) {
            serializer.comment(this.toString((InputLocation)dom.getInputLocation()));
        }
    }

    private void writeActivation(Activation activation, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (activation.isActiveByDefault()) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.activeByDefault").text(String.valueOf(activation.isActiveByDefault())).endTag(NAMESPACE, "io.quarkus.launcher.shaded.activeByDefault");
            this.writeLocationTracking(activation, "io.quarkus.launcher.shaded.activeByDefault", serializer);
        }
        if (activation.getJdk() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.jdk").text(activation.getJdk()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.jdk");
            this.writeLocationTracking(activation, "io.quarkus.launcher.shaded.jdk", serializer);
        }
        if (activation.getOs() != null) {
            this.writeActivationOS(activation.getOs(), "io.quarkus.launcher.shaded.os", serializer);
        }
        if (activation.getProperty() != null) {
            this.writeActivationProperty(activation.getProperty(), "io.quarkus.launcher.shaded.property", serializer);
        }
        if (activation.getFile() != null) {
            this.writeActivationFile(activation.getFile(), "io.quarkus.launcher.shaded.file", serializer);
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeActivationFile(ActivationFile activationFile, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (activationFile.getMissing() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.missing").text(activationFile.getMissing()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.missing");
            this.writeLocationTracking(activationFile, "io.quarkus.launcher.shaded.missing", serializer);
        }
        if (activationFile.getExists() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.exists").text(activationFile.getExists()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.exists");
            this.writeLocationTracking(activationFile, "io.quarkus.launcher.shaded.exists", serializer);
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeActivationOS(ActivationOS activationOS, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (activationOS.getName() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.name").text(activationOS.getName()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.name");
            this.writeLocationTracking(activationOS, "io.quarkus.launcher.shaded.name", serializer);
        }
        if (activationOS.getFamily() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.family").text(activationOS.getFamily()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.family");
            this.writeLocationTracking(activationOS, "io.quarkus.launcher.shaded.family", serializer);
        }
        if (activationOS.getArch() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.arch").text(activationOS.getArch()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.arch");
            this.writeLocationTracking(activationOS, "io.quarkus.launcher.shaded.arch", serializer);
        }
        if (activationOS.getVersion() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.version").text(activationOS.getVersion()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.version");
            this.writeLocationTracking(activationOS, "io.quarkus.launcher.shaded.version", serializer);
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeActivationProperty(ActivationProperty activationProperty, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (activationProperty.getName() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.name").text(activationProperty.getName()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.name");
            this.writeLocationTracking(activationProperty, "io.quarkus.launcher.shaded.name", serializer);
        }
        if (activationProperty.getValue() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.value").text(activationProperty.getValue()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.value");
            this.writeLocationTracking(activationProperty, "io.quarkus.launcher.shaded.value", serializer);
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    /*
     * WARNING - void declaration
     */
    private void writeBuild(Build build, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (build.getSourceDirectory() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.sourceDirectory").text(build.getSourceDirectory()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.sourceDirectory");
            this.writeLocationTracking(build, "io.quarkus.launcher.shaded.sourceDirectory", serializer);
        }
        if (build.getScriptSourceDirectory() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.scriptSourceDirectory").text(build.getScriptSourceDirectory()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.scriptSourceDirectory");
            this.writeLocationTracking(build, "io.quarkus.launcher.shaded.scriptSourceDirectory", serializer);
        }
        if (build.getTestSourceDirectory() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.testSourceDirectory").text(build.getTestSourceDirectory()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.testSourceDirectory");
            this.writeLocationTracking(build, "io.quarkus.launcher.shaded.testSourceDirectory", serializer);
        }
        if (build.getOutputDirectory() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.outputDirectory").text(build.getOutputDirectory()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.outputDirectory");
            this.writeLocationTracking(build, "io.quarkus.launcher.shaded.outputDirectory", serializer);
        }
        if (build.getTestOutputDirectory() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.testOutputDirectory").text(build.getTestOutputDirectory()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.testOutputDirectory");
            this.writeLocationTracking(build, "io.quarkus.launcher.shaded.testOutputDirectory", serializer);
        }
        if (build.getExtensions() != null && build.getExtensions().size() > 0) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.extensions");
            for (Extension extension : build.getExtensions()) {
                this.writeExtension(extension, "io.quarkus.launcher.shaded.extension", serializer);
            }
            serializer.endTag(NAMESPACE, "io.quarkus.launcher.shaded.extensions");
        }
        if (build.getDefaultGoal() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.defaultGoal").text(build.getDefaultGoal()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.defaultGoal");
            this.writeLocationTracking(build, "io.quarkus.launcher.shaded.defaultGoal", serializer);
        }
        if (build.getResources() != null && build.getResources().size() > 0) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.resources");
            for (Resource resource : build.getResources()) {
                this.writeResource(resource, "io.quarkus.launcher.shaded.resource", serializer);
            }
            serializer.endTag(NAMESPACE, "io.quarkus.launcher.shaded.resources");
        }
        if (build.getTestResources() != null && build.getTestResources().size() > 0) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.testResources");
            for (Resource resource : build.getTestResources()) {
                this.writeResource(resource, "io.quarkus.launcher.shaded.testResource", serializer);
            }
            serializer.endTag(NAMESPACE, "io.quarkus.launcher.shaded.testResources");
        }
        if (build.getDirectory() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.directory").text(build.getDirectory()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.directory");
            this.writeLocationTracking(build, "io.quarkus.launcher.shaded.directory", serializer);
        }
        if (build.getFinalName() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.finalName").text(build.getFinalName()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.finalName");
            this.writeLocationTracking(build, "io.quarkus.launcher.shaded.finalName", serializer);
        }
        if (build.getFilters() != null && build.getFilters().size() > 0) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.filters");
            InputLocation location = build.getLocation("io.quarkus.launcher.shaded.filters");
            boolean bl = false;
            for (String filter : build.getFilters()) {
                void var5_11;
                serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.filter").text(filter).endTag(NAMESPACE, "io.quarkus.launcher.shaded.filter");
                this.writeLocationTracking(location, (int)(++var5_11), serializer);
            }
            serializer.endTag(NAMESPACE, "io.quarkus.launcher.shaded.filters");
        }
        if (build.getPluginManagement() != null) {
            this.writePluginManagement(build.getPluginManagement(), "io.quarkus.launcher.shaded.pluginManagement", serializer);
        }
        if (build.getPlugins() != null && build.getPlugins().size() > 0) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.plugins");
            for (Plugin plugin : build.getPlugins()) {
                this.writePlugin(plugin, "io.quarkus.launcher.shaded.plugin", serializer);
            }
            serializer.endTag(NAMESPACE, "io.quarkus.launcher.shaded.plugins");
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeBuildBase(BuildBase buildBase, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (buildBase.getDefaultGoal() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.defaultGoal").text(buildBase.getDefaultGoal()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.defaultGoal");
            this.writeLocationTracking(buildBase, "io.quarkus.launcher.shaded.defaultGoal", serializer);
        }
        if (buildBase.getResources() != null && buildBase.getResources().size() > 0) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.resources");
            for (Resource o : buildBase.getResources()) {
                this.writeResource(o, "io.quarkus.launcher.shaded.resource", serializer);
            }
            serializer.endTag(NAMESPACE, "io.quarkus.launcher.shaded.resources");
        }
        if (buildBase.getTestResources() != null && buildBase.getTestResources().size() > 0) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.testResources");
            for (Resource o : buildBase.getTestResources()) {
                this.writeResource(o, "io.quarkus.launcher.shaded.testResource", serializer);
            }
            serializer.endTag(NAMESPACE, "io.quarkus.launcher.shaded.testResources");
        }
        if (buildBase.getDirectory() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.directory").text(buildBase.getDirectory()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.directory");
            this.writeLocationTracking(buildBase, "io.quarkus.launcher.shaded.directory", serializer);
        }
        if (buildBase.getFinalName() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.finalName").text(buildBase.getFinalName()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.finalName");
            this.writeLocationTracking(buildBase, "io.quarkus.launcher.shaded.finalName", serializer);
        }
        if (buildBase.getFilters() != null && buildBase.getFilters().size() > 0) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.filters");
            InputLocation location = buildBase.getLocation("io.quarkus.launcher.shaded.filters");
            int n = 0;
            for (String filter : buildBase.getFilters()) {
                serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.filter").text(filter).endTag(NAMESPACE, "io.quarkus.launcher.shaded.filter");
                this.writeLocationTracking(location, n++, serializer);
            }
            serializer.endTag(NAMESPACE, "io.quarkus.launcher.shaded.filters");
        }
        if (buildBase.getPluginManagement() != null) {
            this.writePluginManagement(buildBase.getPluginManagement(), "io.quarkus.launcher.shaded.pluginManagement", serializer);
        }
        if (buildBase.getPlugins() != null && buildBase.getPlugins().size() > 0) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.plugins");
            for (Plugin o : buildBase.getPlugins()) {
                this.writePlugin(o, "io.quarkus.launcher.shaded.plugin", serializer);
            }
            serializer.endTag(NAMESPACE, "io.quarkus.launcher.shaded.plugins");
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeCiManagement(CiManagement ciManagement, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (ciManagement.getSystem() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.system").text(ciManagement.getSystem()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.system");
            this.writeLocationTracking(ciManagement, "io.quarkus.launcher.shaded.system", serializer);
        }
        if (ciManagement.getUrl() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.url").text(ciManagement.getUrl()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.url");
            this.writeLocationTracking(ciManagement, "io.quarkus.launcher.shaded.url", serializer);
        }
        if (ciManagement.getNotifiers() != null && ciManagement.getNotifiers().size() > 0) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.notifiers");
            for (Notifier o : ciManagement.getNotifiers()) {
                this.writeNotifier(o, "io.quarkus.launcher.shaded.notifier", serializer);
            }
            serializer.endTag(NAMESPACE, "io.quarkus.launcher.shaded.notifiers");
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeConfigurationContainer(ConfigurationContainer configurationContainer, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (configurationContainer.getInherited() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.inherited").text(configurationContainer.getInherited()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.inherited");
            this.writeLocationTracking(configurationContainer, "io.quarkus.launcher.shaded.inherited", serializer);
        }
        if (configurationContainer.getConfiguration() != null) {
            this.writeXpp3DomToSerializer((Xpp3Dom)configurationContainer.getConfiguration(), serializer);
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeContributor(Contributor contributor, String tagName, XmlSerializer serializer) throws IOException {
        InputLocation location;
        serializer.startTag(NAMESPACE, tagName);
        if (contributor.getName() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.name").text(contributor.getName()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.name");
            this.writeLocationTracking(contributor, "io.quarkus.launcher.shaded.name", serializer);
        }
        if (contributor.getEmail() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.email").text(contributor.getEmail()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.email");
            this.writeLocationTracking(contributor, "io.quarkus.launcher.shaded.email", serializer);
        }
        if (contributor.getUrl() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.url").text(contributor.getUrl()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.url");
            this.writeLocationTracking(contributor, "io.quarkus.launcher.shaded.url", serializer);
        }
        if (contributor.getOrganization() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.organization").text(contributor.getOrganization()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.organization");
            this.writeLocationTracking(contributor, "io.quarkus.launcher.shaded.organization", serializer);
        }
        if (contributor.getOrganizationUrl() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.organizationUrl").text(contributor.getOrganizationUrl()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.organizationUrl");
            this.writeLocationTracking(contributor, "io.quarkus.launcher.shaded.organizationUrl", serializer);
        }
        if (contributor.getRoles() != null && contributor.getRoles().size() > 0) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.roles");
            location = contributor.getLocation("io.quarkus.launcher.shaded.roles");
            int n = 0;
            for (String role : contributor.getRoles()) {
                serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.role").text(role).endTag(NAMESPACE, "io.quarkus.launcher.shaded.role");
                this.writeLocationTracking(location, n++, serializer);
            }
            serializer.endTag(NAMESPACE, "io.quarkus.launcher.shaded.roles");
        }
        if (contributor.getTimezone() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.timezone").text(contributor.getTimezone()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.timezone");
            this.writeLocationTracking(contributor, "io.quarkus.launcher.shaded.timezone", serializer);
        }
        if (contributor.getProperties() != null && contributor.getProperties().size() > 0) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.properties");
            location = contributor.getLocation("io.quarkus.launcher.shaded.properties");
            for (String string : contributor.getProperties().keySet()) {
                String value = (String)contributor.getProperties().get(string);
                serializer.startTag(NAMESPACE, string).text(value).endTag(NAMESPACE, string);
                this.writeLocationTracking(location, string, serializer);
            }
            serializer.endTag(NAMESPACE, "io.quarkus.launcher.shaded.properties");
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeDependency(Dependency dependency, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (dependency.getGroupId() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.groupId").text(dependency.getGroupId()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.groupId");
            this.writeLocationTracking(dependency, "io.quarkus.launcher.shaded.groupId", serializer);
        }
        if (dependency.getArtifactId() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.artifactId").text(dependency.getArtifactId()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.artifactId");
            this.writeLocationTracking(dependency, "io.quarkus.launcher.shaded.artifactId", serializer);
        }
        if (dependency.getVersion() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.version").text(dependency.getVersion()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.version");
            this.writeLocationTracking(dependency, "io.quarkus.launcher.shaded.version", serializer);
        }
        if (dependency.getType() != null && !dependency.getType().equals("io.quarkus.launcher.shaded.jar")) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.type").text(dependency.getType()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.type");
            this.writeLocationTracking(dependency, "io.quarkus.launcher.shaded.type", serializer);
        }
        if (dependency.getClassifier() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.classifier").text(dependency.getClassifier()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.classifier");
            this.writeLocationTracking(dependency, "io.quarkus.launcher.shaded.classifier", serializer);
        }
        if (dependency.getScope() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.scope").text(dependency.getScope()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.scope");
            this.writeLocationTracking(dependency, "io.quarkus.launcher.shaded.scope", serializer);
        }
        if (dependency.getSystemPath() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.systemPath").text(dependency.getSystemPath()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.systemPath");
            this.writeLocationTracking(dependency, "io.quarkus.launcher.shaded.systemPath", serializer);
        }
        if (dependency.getExclusions() != null && dependency.getExclusions().size() > 0) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.exclusions");
            for (Exclusion o : dependency.getExclusions()) {
                this.writeExclusion(o, "io.quarkus.launcher.shaded.exclusion", serializer);
            }
            serializer.endTag(NAMESPACE, "io.quarkus.launcher.shaded.exclusions");
        }
        if (dependency.getOptional() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.optional").text(dependency.getOptional()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.optional");
            this.writeLocationTracking(dependency, "io.quarkus.launcher.shaded.optional", serializer);
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeDependencyManagement(DependencyManagement dependencyManagement, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (dependencyManagement.getDependencies() != null && dependencyManagement.getDependencies().size() > 0) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.dependencies");
            for (Dependency o : dependencyManagement.getDependencies()) {
                this.writeDependency(o, "io.quarkus.launcher.shaded.dependency", serializer);
            }
            serializer.endTag(NAMESPACE, "io.quarkus.launcher.shaded.dependencies");
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeDeploymentRepository(DeploymentRepository deploymentRepository, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (!deploymentRepository.isUniqueVersion()) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.uniqueVersion").text(String.valueOf(deploymentRepository.isUniqueVersion())).endTag(NAMESPACE, "io.quarkus.launcher.shaded.uniqueVersion");
            this.writeLocationTracking(deploymentRepository, "io.quarkus.launcher.shaded.uniqueVersion", serializer);
        }
        if (deploymentRepository.getReleases() != null) {
            this.writeRepositoryPolicy(deploymentRepository.getReleases(), "io.quarkus.launcher.shaded.releases", serializer);
        }
        if (deploymentRepository.getSnapshots() != null) {
            this.writeRepositoryPolicy(deploymentRepository.getSnapshots(), "io.quarkus.launcher.shaded.snapshots", serializer);
        }
        if (deploymentRepository.getId() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.id").text(deploymentRepository.getId()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.id");
            this.writeLocationTracking(deploymentRepository, "io.quarkus.launcher.shaded.id", serializer);
        }
        if (deploymentRepository.getName() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.name").text(deploymentRepository.getName()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.name");
            this.writeLocationTracking(deploymentRepository, "io.quarkus.launcher.shaded.name", serializer);
        }
        if (deploymentRepository.getUrl() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.url").text(deploymentRepository.getUrl()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.url");
            this.writeLocationTracking(deploymentRepository, "io.quarkus.launcher.shaded.url", serializer);
        }
        if (deploymentRepository.getLayout() != null && !deploymentRepository.getLayout().equals("io.quarkus.launcher.shaded.default")) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.layout").text(deploymentRepository.getLayout()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.layout");
            this.writeLocationTracking(deploymentRepository, "io.quarkus.launcher.shaded.layout", serializer);
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeDeveloper(Developer developer, String tagName, XmlSerializer serializer) throws IOException {
        InputLocation location;
        serializer.startTag(NAMESPACE, tagName);
        if (developer.getId() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.id").text(developer.getId()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.id");
            this.writeLocationTracking(developer, "io.quarkus.launcher.shaded.id", serializer);
        }
        if (developer.getName() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.name").text(developer.getName()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.name");
            this.writeLocationTracking(developer, "io.quarkus.launcher.shaded.name", serializer);
        }
        if (developer.getEmail() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.email").text(developer.getEmail()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.email");
            this.writeLocationTracking(developer, "io.quarkus.launcher.shaded.email", serializer);
        }
        if (developer.getUrl() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.url").text(developer.getUrl()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.url");
            this.writeLocationTracking(developer, "io.quarkus.launcher.shaded.url", serializer);
        }
        if (developer.getOrganization() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.organization").text(developer.getOrganization()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.organization");
            this.writeLocationTracking(developer, "io.quarkus.launcher.shaded.organization", serializer);
        }
        if (developer.getOrganizationUrl() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.organizationUrl").text(developer.getOrganizationUrl()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.organizationUrl");
            this.writeLocationTracking(developer, "io.quarkus.launcher.shaded.organizationUrl", serializer);
        }
        if (developer.getRoles() != null && developer.getRoles().size() > 0) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.roles");
            location = developer.getLocation("io.quarkus.launcher.shaded.roles");
            int n = 0;
            for (String role : developer.getRoles()) {
                serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.role").text(role).endTag(NAMESPACE, "io.quarkus.launcher.shaded.role");
                this.writeLocationTracking(location, n++, serializer);
            }
            serializer.endTag(NAMESPACE, "io.quarkus.launcher.shaded.roles");
        }
        if (developer.getTimezone() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.timezone").text(developer.getTimezone()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.timezone");
            this.writeLocationTracking(developer, "io.quarkus.launcher.shaded.timezone", serializer);
        }
        if (developer.getProperties() != null && developer.getProperties().size() > 0) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.properties");
            location = developer.getLocation("io.quarkus.launcher.shaded.properties");
            for (String string : developer.getProperties().keySet()) {
                String value = (String)developer.getProperties().get(string);
                serializer.startTag(NAMESPACE, string).text(value).endTag(NAMESPACE, string);
                this.writeLocationTracking(location, string, serializer);
            }
            serializer.endTag(NAMESPACE, "io.quarkus.launcher.shaded.properties");
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeDistributionManagement(DistributionManagement distributionManagement, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (distributionManagement.getRepository() != null) {
            this.writeDeploymentRepository(distributionManagement.getRepository(), "io.quarkus.launcher.shaded.repository", serializer);
        }
        if (distributionManagement.getSnapshotRepository() != null) {
            this.writeDeploymentRepository(distributionManagement.getSnapshotRepository(), "io.quarkus.launcher.shaded.snapshotRepository", serializer);
        }
        if (distributionManagement.getSite() != null) {
            this.writeSite(distributionManagement.getSite(), "io.quarkus.launcher.shaded.site", serializer);
        }
        if (distributionManagement.getDownloadUrl() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.downloadUrl").text(distributionManagement.getDownloadUrl()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.downloadUrl");
            this.writeLocationTracking(distributionManagement, "io.quarkus.launcher.shaded.downloadUrl", serializer);
        }
        if (distributionManagement.getRelocation() != null) {
            this.writeRelocation(distributionManagement.getRelocation(), "io.quarkus.launcher.shaded.relocation", serializer);
        }
        if (distributionManagement.getStatus() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.status").text(distributionManagement.getStatus()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.status");
            this.writeLocationTracking(distributionManagement, "io.quarkus.launcher.shaded.status", serializer);
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeExclusion(Exclusion exclusion, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (exclusion.getArtifactId() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.artifactId").text(exclusion.getArtifactId()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.artifactId");
            this.writeLocationTracking(exclusion, "io.quarkus.launcher.shaded.artifactId", serializer);
        }
        if (exclusion.getGroupId() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.groupId").text(exclusion.getGroupId()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.groupId");
            this.writeLocationTracking(exclusion, "io.quarkus.launcher.shaded.groupId", serializer);
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeExtension(Extension extension, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (extension.getGroupId() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.groupId").text(extension.getGroupId()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.groupId");
            this.writeLocationTracking(extension, "io.quarkus.launcher.shaded.groupId", serializer);
        }
        if (extension.getArtifactId() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.artifactId").text(extension.getArtifactId()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.artifactId");
            this.writeLocationTracking(extension, "io.quarkus.launcher.shaded.artifactId", serializer);
        }
        if (extension.getVersion() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.version").text(extension.getVersion()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.version");
            this.writeLocationTracking(extension, "io.quarkus.launcher.shaded.version", serializer);
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeFileSet(FileSet fileSet, String tagName, XmlSerializer serializer) throws IOException {
        int n;
        InputLocation location;
        serializer.startTag(NAMESPACE, tagName);
        if (fileSet.getDirectory() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.directory").text(fileSet.getDirectory()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.directory");
            this.writeLocationTracking(fileSet, "io.quarkus.launcher.shaded.directory", serializer);
        }
        if (fileSet.getIncludes() != null && fileSet.getIncludes().size() > 0) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.includes");
            location = fileSet.getLocation("io.quarkus.launcher.shaded.includes");
            n = 0;
            for (String include : fileSet.getIncludes()) {
                serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.include").text(include).endTag(NAMESPACE, "io.quarkus.launcher.shaded.include");
                this.writeLocationTracking(location, n++, serializer);
            }
            serializer.endTag(NAMESPACE, "io.quarkus.launcher.shaded.includes");
        }
        if (fileSet.getExcludes() != null && fileSet.getExcludes().size() > 0) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.excludes");
            location = fileSet.getLocation("io.quarkus.launcher.shaded.excludes");
            n = 0;
            for (String exclude : fileSet.getExcludes()) {
                serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.exclude").text(exclude).endTag(NAMESPACE, "io.quarkus.launcher.shaded.exclude");
                this.writeLocationTracking(location, n++, serializer);
            }
            serializer.endTag(NAMESPACE, "io.quarkus.launcher.shaded.excludes");
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeIssueManagement(IssueManagement issueManagement, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (issueManagement.getSystem() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.system").text(issueManagement.getSystem()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.system");
            this.writeLocationTracking(issueManagement, "io.quarkus.launcher.shaded.system", serializer);
        }
        if (issueManagement.getUrl() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.url").text(issueManagement.getUrl()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.url");
            this.writeLocationTracking(issueManagement, "io.quarkus.launcher.shaded.url", serializer);
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeLicense(License license, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (license.getName() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.name").text(license.getName()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.name");
            this.writeLocationTracking(license, "io.quarkus.launcher.shaded.name", serializer);
        }
        if (license.getUrl() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.url").text(license.getUrl()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.url");
            this.writeLocationTracking(license, "io.quarkus.launcher.shaded.url", serializer);
        }
        if (license.getDistribution() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.distribution").text(license.getDistribution()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.distribution");
            this.writeLocationTracking(license, "io.quarkus.launcher.shaded.distribution", serializer);
        }
        if (license.getComments() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.comments").text(license.getComments()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.comments");
            this.writeLocationTracking(license, "io.quarkus.launcher.shaded.comments", serializer);
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeLocationTracking(InputLocationTracker locationTracker, Object key, XmlSerializer serializer) throws IOException {
        InputLocation location;
        InputLocation inputLocation = location = locationTracker == null ? null : locationTracker.getLocation(key);
        if (location != null) {
            serializer.comment(this.toString(location));
        }
    }

    private void writeMailingList(MailingList mailingList, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (mailingList.getName() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.name").text(mailingList.getName()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.name");
            this.writeLocationTracking(mailingList, "io.quarkus.launcher.shaded.name", serializer);
        }
        if (mailingList.getSubscribe() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.subscribe").text(mailingList.getSubscribe()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.subscribe");
            this.writeLocationTracking(mailingList, "io.quarkus.launcher.shaded.subscribe", serializer);
        }
        if (mailingList.getUnsubscribe() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.unsubscribe").text(mailingList.getUnsubscribe()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.unsubscribe");
            this.writeLocationTracking(mailingList, "io.quarkus.launcher.shaded.unsubscribe", serializer);
        }
        if (mailingList.getPost() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.post").text(mailingList.getPost()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.post");
            this.writeLocationTracking(mailingList, "io.quarkus.launcher.shaded.post", serializer);
        }
        if (mailingList.getArchive() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.archive").text(mailingList.getArchive()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.archive");
            this.writeLocationTracking(mailingList, "io.quarkus.launcher.shaded.archive", serializer);
        }
        if (mailingList.getOtherArchives() != null && mailingList.getOtherArchives().size() > 0) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.otherArchives");
            InputLocation location = mailingList.getLocation("io.quarkus.launcher.shaded.otherArchives");
            int n = 0;
            for (String otherArchive : mailingList.getOtherArchives()) {
                serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.otherArchive").text(otherArchive).endTag(NAMESPACE, "io.quarkus.launcher.shaded.otherArchive");
                this.writeLocationTracking(location, n++, serializer);
            }
            serializer.endTag(NAMESPACE, "io.quarkus.launcher.shaded.otherArchives");
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    /*
     * WARNING - void declaration
     */
    private void writeModel(Model model, String tagName, XmlSerializer serializer) throws IOException {
        InputLocation location;
        if (this.fileComment != null) {
            serializer.comment(this.fileComment);
        }
        serializer.setPrefix("io.quarkus.launcher.shaded.", "io/quarkus/launcher/shaded/http://maven.apache.org/POM/4.0.0");
        serializer.setPrefix("io.quarkus.launcher.shaded.xsi", "io/quarkus/launcher/shaded/http://www.w3.org/2001/XMLSchema-instance");
        serializer.startTag(NAMESPACE, tagName);
        serializer.attribute("io.quarkus.launcher.shaded.", "io.quarkus.launcher.shaded.xsi:schemaLocation", "io/quarkus/launcher/shaded/http://maven.apache.org/POM/4.0.0 https://maven.apache.org/xsd/maven-4.0.0.xsd");
        if (model.getChildProjectUrlInheritAppendPath() != null) {
            serializer.attribute(NAMESPACE, "io.quarkus.launcher.shaded.child.project.url.inherit.append.path", model.getChildProjectUrlInheritAppendPath());
        }
        if (model.getModelVersion() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.modelVersion").text(model.getModelVersion()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.modelVersion");
            this.writeLocationTracking(model, "io.quarkus.launcher.shaded.modelVersion", serializer);
        }
        if (model.getParent() != null) {
            this.writeParent(model.getParent(), "io.quarkus.launcher.shaded.parent", serializer);
        }
        if (model.getGroupId() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.groupId").text(model.getGroupId()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.groupId");
            this.writeLocationTracking(model, "io.quarkus.launcher.shaded.groupId", serializer);
        }
        if (model.getArtifactId() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.artifactId").text(model.getArtifactId()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.artifactId");
            this.writeLocationTracking(model, "io.quarkus.launcher.shaded.artifactId", serializer);
        }
        if (model.getVersion() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.version").text(model.getVersion()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.version");
            this.writeLocationTracking(model, "io.quarkus.launcher.shaded.version", serializer);
        }
        if (model.getPackaging() != null && !model.getPackaging().equals("io.quarkus.launcher.shaded.jar")) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.packaging").text(model.getPackaging()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.packaging");
            this.writeLocationTracking(model, "io.quarkus.launcher.shaded.packaging", serializer);
        }
        if (model.getName() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.name").text(model.getName()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.name");
            this.writeLocationTracking(model, "io.quarkus.launcher.shaded.name", serializer);
        }
        if (model.getDescription() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.description").text(model.getDescription()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.description");
            this.writeLocationTracking(model, "io.quarkus.launcher.shaded.description", serializer);
        }
        if (model.getUrl() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.url").text(model.getUrl()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.url");
            this.writeLocationTracking(model, "io.quarkus.launcher.shaded.url", serializer);
        }
        if (model.getInceptionYear() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.inceptionYear").text(model.getInceptionYear()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.inceptionYear");
            this.writeLocationTracking(model, "io.quarkus.launcher.shaded.inceptionYear", serializer);
        }
        if (model.getOrganization() != null) {
            this.writeOrganization(model.getOrganization(), "io.quarkus.launcher.shaded.organization", serializer);
        }
        if (model.getLicenses() != null && model.getLicenses().size() > 0) {
            serializer.startTag(NAMESPACE, "licenses");
            for (License license : model.getLicenses()) {
                this.writeLicense(license, "io.quarkus.launcher.shaded.license", serializer);
            }
            serializer.endTag(NAMESPACE, "licenses");
        }
        if (model.getDevelopers() != null && model.getDevelopers().size() > 0) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.developers");
            for (Developer developer : model.getDevelopers()) {
                this.writeDeveloper(developer, "io.quarkus.launcher.shaded.developer", serializer);
            }
            serializer.endTag(NAMESPACE, "io.quarkus.launcher.shaded.developers");
        }
        if (model.getContributors() != null && model.getContributors().size() > 0) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.contributors");
            for (Contributor contributor : model.getContributors()) {
                this.writeContributor(contributor, "io.quarkus.launcher.shaded.contributor", serializer);
            }
            serializer.endTag(NAMESPACE, "io.quarkus.launcher.shaded.contributors");
        }
        if (model.getMailingLists() != null && model.getMailingLists().size() > 0) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.mailingLists");
            for (MailingList mailingList : model.getMailingLists()) {
                this.writeMailingList(mailingList, "io.quarkus.launcher.shaded.mailingList", serializer);
            }
            serializer.endTag(NAMESPACE, "io.quarkus.launcher.shaded.mailingLists");
        }
        if (model.getPrerequisites() != null) {
            this.writePrerequisites(model.getPrerequisites(), "io.quarkus.launcher.shaded.prerequisites", serializer);
        }
        if (model.getModules() != null && model.getModules().size() > 0) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.modules");
            location = model.getLocation("io.quarkus.launcher.shaded.modules");
            boolean bl = false;
            for (String module : model.getModules()) {
                void var5_13;
                serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.module").text(module).endTag(NAMESPACE, "io.quarkus.launcher.shaded.module");
                this.writeLocationTracking(location, (int)(++var5_13), serializer);
            }
            serializer.endTag(NAMESPACE, "io.quarkus.launcher.shaded.modules");
        }
        if (model.getScm() != null) {
            this.writeScm(model.getScm(), "io.quarkus.launcher.shaded.scm", serializer);
        }
        if (model.getIssueManagement() != null) {
            this.writeIssueManagement(model.getIssueManagement(), "io.quarkus.launcher.shaded.issueManagement", serializer);
        }
        if (model.getCiManagement() != null) {
            this.writeCiManagement(model.getCiManagement(), "io.quarkus.launcher.shaded.ciManagement", serializer);
        }
        if (model.getDistributionManagement() != null) {
            this.writeDistributionManagement(model.getDistributionManagement(), "io.quarkus.launcher.shaded.distributionManagement", serializer);
        }
        if (model.getProperties() != null && model.getProperties().size() > 0) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.properties");
            location = model.getLocation("io.quarkus.launcher.shaded.properties");
            for (String string : model.getProperties().keySet()) {
                String value = (String)model.getProperties().get(string);
                serializer.startTag(NAMESPACE, string).text(value).endTag(NAMESPACE, string);
                this.writeLocationTracking(location, string, serializer);
            }
            serializer.endTag(NAMESPACE, "io.quarkus.launcher.shaded.properties");
        }
        if (model.getDependencyManagement() != null) {
            this.writeDependencyManagement(model.getDependencyManagement(), "io.quarkus.launcher.shaded.dependencyManagement", serializer);
        }
        if (model.getDependencies() != null && model.getDependencies().size() > 0) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.dependencies");
            for (Dependency dependency : model.getDependencies()) {
                this.writeDependency(dependency, "io.quarkus.launcher.shaded.dependency", serializer);
            }
            serializer.endTag(NAMESPACE, "io.quarkus.launcher.shaded.dependencies");
        }
        if (model.getRepositories() != null && model.getRepositories().size() > 0) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.repositories");
            for (Repository repository : model.getRepositories()) {
                this.writeRepository(repository, "io.quarkus.launcher.shaded.repository", serializer);
            }
            serializer.endTag(NAMESPACE, "io.quarkus.launcher.shaded.repositories");
        }
        if (model.getPluginRepositories() != null && model.getPluginRepositories().size() > 0) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.pluginRepositories");
            for (Repository repository : model.getPluginRepositories()) {
                this.writeRepository(repository, "io.quarkus.launcher.shaded.pluginRepository", serializer);
            }
            serializer.endTag(NAMESPACE, "io.quarkus.launcher.shaded.pluginRepositories");
        }
        if (model.getBuild() != null) {
            this.writeBuild(model.getBuild(), "io.quarkus.launcher.shaded.build", serializer);
        }
        if (model.getReports() != null) {
            this.writeXpp3DomToSerializer((Xpp3Dom)model.getReports(), serializer);
        }
        if (model.getReporting() != null) {
            this.writeReporting(model.getReporting(), "io.quarkus.launcher.shaded.reporting", serializer);
        }
        if (model.getProfiles() != null && model.getProfiles().size() > 0) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.profiles");
            for (Profile profile : model.getProfiles()) {
                this.writeProfile(profile, "io.quarkus.launcher.shaded.profile", serializer);
            }
            serializer.endTag(NAMESPACE, "io.quarkus.launcher.shaded.profiles");
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeModelBase(ModelBase modelBase, String tagName, XmlSerializer serializer) throws IOException {
        InputLocation location;
        serializer.startTag(NAMESPACE, tagName);
        if (modelBase.getModules() != null && modelBase.getModules().size() > 0) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.modules");
            location = modelBase.getLocation("io.quarkus.launcher.shaded.modules");
            int n = 0;
            for (String module : modelBase.getModules()) {
                serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.module").text(module).endTag(NAMESPACE, "io.quarkus.launcher.shaded.module");
                this.writeLocationTracking(location, n++, serializer);
            }
            serializer.endTag(NAMESPACE, "io.quarkus.launcher.shaded.modules");
        }
        if (modelBase.getDistributionManagement() != null) {
            this.writeDistributionManagement(modelBase.getDistributionManagement(), "io.quarkus.launcher.shaded.distributionManagement", serializer);
        }
        if (modelBase.getProperties() != null && modelBase.getProperties().size() > 0) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.properties");
            location = modelBase.getLocation("io.quarkus.launcher.shaded.properties");
            for (String string : modelBase.getProperties().keySet()) {
                String value = (String)modelBase.getProperties().get(string);
                serializer.startTag(NAMESPACE, string).text(value).endTag(NAMESPACE, string);
                this.writeLocationTracking(location, string, serializer);
            }
            serializer.endTag(NAMESPACE, "io.quarkus.launcher.shaded.properties");
        }
        if (modelBase.getDependencyManagement() != null) {
            this.writeDependencyManagement(modelBase.getDependencyManagement(), "io.quarkus.launcher.shaded.dependencyManagement", serializer);
        }
        if (modelBase.getDependencies() != null && modelBase.getDependencies().size() > 0) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.dependencies");
            for (Dependency o : modelBase.getDependencies()) {
                this.writeDependency(o, "io.quarkus.launcher.shaded.dependency", serializer);
            }
            serializer.endTag(NAMESPACE, "io.quarkus.launcher.shaded.dependencies");
        }
        if (modelBase.getRepositories() != null && modelBase.getRepositories().size() > 0) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.repositories");
            for (Repository o : modelBase.getRepositories()) {
                this.writeRepository(o, "io.quarkus.launcher.shaded.repository", serializer);
            }
            serializer.endTag(NAMESPACE, "io.quarkus.launcher.shaded.repositories");
        }
        if (modelBase.getPluginRepositories() != null && modelBase.getPluginRepositories().size() > 0) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.pluginRepositories");
            for (Repository o : modelBase.getPluginRepositories()) {
                this.writeRepository(o, "io.quarkus.launcher.shaded.pluginRepository", serializer);
            }
            serializer.endTag(NAMESPACE, "io.quarkus.launcher.shaded.pluginRepositories");
        }
        if (modelBase.getReports() != null) {
            this.writeXpp3DomToSerializer((Xpp3Dom)modelBase.getReports(), serializer);
        }
        if (modelBase.getReporting() != null) {
            this.writeReporting(modelBase.getReporting(), "io.quarkus.launcher.shaded.reporting", serializer);
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeNotifier(Notifier notifier, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (notifier.getType() != null && !notifier.getType().equals("io.quarkus.launcher.shaded.mail")) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.type").text(notifier.getType()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.type");
            this.writeLocationTracking(notifier, "io.quarkus.launcher.shaded.type", serializer);
        }
        if (!notifier.isSendOnError()) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.sendOnError").text(String.valueOf(notifier.isSendOnError())).endTag(NAMESPACE, "io.quarkus.launcher.shaded.sendOnError");
            this.writeLocationTracking(notifier, "io.quarkus.launcher.shaded.sendOnError", serializer);
        }
        if (!notifier.isSendOnFailure()) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.sendOnFailure").text(String.valueOf(notifier.isSendOnFailure())).endTag(NAMESPACE, "io.quarkus.launcher.shaded.sendOnFailure");
            this.writeLocationTracking(notifier, "io.quarkus.launcher.shaded.sendOnFailure", serializer);
        }
        if (!notifier.isSendOnSuccess()) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.sendOnSuccess").text(String.valueOf(notifier.isSendOnSuccess())).endTag(NAMESPACE, "io.quarkus.launcher.shaded.sendOnSuccess");
            this.writeLocationTracking(notifier, "io.quarkus.launcher.shaded.sendOnSuccess", serializer);
        }
        if (!notifier.isSendOnWarning()) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.sendOnWarning").text(String.valueOf(notifier.isSendOnWarning())).endTag(NAMESPACE, "io.quarkus.launcher.shaded.sendOnWarning");
            this.writeLocationTracking(notifier, "io.quarkus.launcher.shaded.sendOnWarning", serializer);
        }
        if (notifier.getAddress() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.address").text(notifier.getAddress()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.address");
            this.writeLocationTracking(notifier, "io.quarkus.launcher.shaded.address", serializer);
        }
        if (notifier.getConfiguration() != null && notifier.getConfiguration().size() > 0) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.configuration");
            InputLocation location = notifier.getLocation("io.quarkus.launcher.shaded.configuration");
            for (String string : notifier.getConfiguration().keySet()) {
                String value = (String)notifier.getConfiguration().get(string);
                serializer.startTag(NAMESPACE, string).text(value).endTag(NAMESPACE, string);
                this.writeLocationTracking(location, string, serializer);
            }
            serializer.endTag(NAMESPACE, "io.quarkus.launcher.shaded.configuration");
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeOrganization(Organization organization, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (organization.getName() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.name").text(organization.getName()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.name");
            this.writeLocationTracking(organization, "io.quarkus.launcher.shaded.name", serializer);
        }
        if (organization.getUrl() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.url").text(organization.getUrl()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.url");
            this.writeLocationTracking(organization, "io.quarkus.launcher.shaded.url", serializer);
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeParent(Parent parent, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (parent.getGroupId() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.groupId").text(parent.getGroupId()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.groupId");
            this.writeLocationTracking(parent, "io.quarkus.launcher.shaded.groupId", serializer);
        }
        if (parent.getArtifactId() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.artifactId").text(parent.getArtifactId()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.artifactId");
            this.writeLocationTracking(parent, "io.quarkus.launcher.shaded.artifactId", serializer);
        }
        if (parent.getVersion() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.version").text(parent.getVersion()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.version");
            this.writeLocationTracking(parent, "io.quarkus.launcher.shaded.version", serializer);
        }
        if (parent.getRelativePath() != null && !parent.getRelativePath().equals("io/quarkus/launcher/shaded/../pom.xml")) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.relativePath").text(parent.getRelativePath()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.relativePath");
            this.writeLocationTracking(parent, "io.quarkus.launcher.shaded.relativePath", serializer);
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writePatternSet(PatternSet patternSet, String tagName, XmlSerializer serializer) throws IOException {
        int n;
        InputLocation location;
        serializer.startTag(NAMESPACE, tagName);
        if (patternSet.getIncludes() != null && patternSet.getIncludes().size() > 0) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.includes");
            location = patternSet.getLocation("io.quarkus.launcher.shaded.includes");
            n = 0;
            for (String include : patternSet.getIncludes()) {
                serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.include").text(include).endTag(NAMESPACE, "io.quarkus.launcher.shaded.include");
                this.writeLocationTracking(location, n++, serializer);
            }
            serializer.endTag(NAMESPACE, "io.quarkus.launcher.shaded.includes");
        }
        if (patternSet.getExcludes() != null && patternSet.getExcludes().size() > 0) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.excludes");
            location = patternSet.getLocation("io.quarkus.launcher.shaded.excludes");
            n = 0;
            for (String exclude : patternSet.getExcludes()) {
                serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.exclude").text(exclude).endTag(NAMESPACE, "io.quarkus.launcher.shaded.exclude");
                this.writeLocationTracking(location, n++, serializer);
            }
            serializer.endTag(NAMESPACE, "io.quarkus.launcher.shaded.excludes");
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writePlugin(Plugin plugin, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (plugin.getGroupId() != null && !plugin.getGroupId().equals("io.quarkus.launcher.shaded.org.apache.maven.plugins")) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.groupId").text(plugin.getGroupId()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.groupId");
            this.writeLocationTracking(plugin, "io.quarkus.launcher.shaded.groupId", serializer);
        }
        if (plugin.getArtifactId() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.artifactId").text(plugin.getArtifactId()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.artifactId");
            this.writeLocationTracking(plugin, "io.quarkus.launcher.shaded.artifactId", serializer);
        }
        if (plugin.getVersion() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.version").text(plugin.getVersion()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.version");
            this.writeLocationTracking(plugin, "io.quarkus.launcher.shaded.version", serializer);
        }
        if (plugin.getExtensions() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.extensions").text(plugin.getExtensions()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.extensions");
            this.writeLocationTracking(plugin, "io.quarkus.launcher.shaded.extensions", serializer);
        }
        if (plugin.getExecutions() != null && plugin.getExecutions().size() > 0) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.executions");
            for (PluginExecution pluginExecution : plugin.getExecutions()) {
                this.writePluginExecution(pluginExecution, "io.quarkus.launcher.shaded.execution", serializer);
            }
            serializer.endTag(NAMESPACE, "io.quarkus.launcher.shaded.executions");
        }
        if (plugin.getDependencies() != null && plugin.getDependencies().size() > 0) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.dependencies");
            for (Dependency dependency : plugin.getDependencies()) {
                this.writeDependency(dependency, "io.quarkus.launcher.shaded.dependency", serializer);
            }
            serializer.endTag(NAMESPACE, "io.quarkus.launcher.shaded.dependencies");
        }
        if (plugin.getGoals() != null) {
            this.writeXpp3DomToSerializer((Xpp3Dom)plugin.getGoals(), serializer);
        }
        if (plugin.getInherited() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.inherited").text(plugin.getInherited()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.inherited");
            this.writeLocationTracking(plugin, "io.quarkus.launcher.shaded.inherited", serializer);
        }
        if (plugin.getConfiguration() != null) {
            this.writeXpp3DomToSerializer((Xpp3Dom)plugin.getConfiguration(), serializer);
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writePluginConfiguration(PluginConfiguration pluginConfiguration, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (pluginConfiguration.getPluginManagement() != null) {
            this.writePluginManagement(pluginConfiguration.getPluginManagement(), "io.quarkus.launcher.shaded.pluginManagement", serializer);
        }
        if (pluginConfiguration.getPlugins() != null && pluginConfiguration.getPlugins().size() > 0) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.plugins");
            for (Plugin o : pluginConfiguration.getPlugins()) {
                this.writePlugin(o, "io.quarkus.launcher.shaded.plugin", serializer);
            }
            serializer.endTag(NAMESPACE, "io.quarkus.launcher.shaded.plugins");
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writePluginContainer(PluginContainer pluginContainer, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (pluginContainer.getPlugins() != null && pluginContainer.getPlugins().size() > 0) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.plugins");
            for (Plugin o : pluginContainer.getPlugins()) {
                this.writePlugin(o, "io.quarkus.launcher.shaded.plugin", serializer);
            }
            serializer.endTag(NAMESPACE, "io.quarkus.launcher.shaded.plugins");
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writePluginExecution(PluginExecution pluginExecution, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (pluginExecution.getId() != null && !pluginExecution.getId().equals("io.quarkus.launcher.shaded.default")) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.id").text(pluginExecution.getId()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.id");
            this.writeLocationTracking(pluginExecution, "io.quarkus.launcher.shaded.id", serializer);
        }
        if (pluginExecution.getPhase() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.phase").text(pluginExecution.getPhase()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.phase");
            this.writeLocationTracking(pluginExecution, "io.quarkus.launcher.shaded.phase", serializer);
        }
        if (pluginExecution.getGoals() != null && pluginExecution.getGoals().size() > 0) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.goals");
            InputLocation location = pluginExecution.getLocation("io.quarkus.launcher.shaded.goals");
            int n = 0;
            for (String goal : pluginExecution.getGoals()) {
                serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.goal").text(goal).endTag(NAMESPACE, "io.quarkus.launcher.shaded.goal");
                this.writeLocationTracking(location, n++, serializer);
            }
            serializer.endTag(NAMESPACE, "io.quarkus.launcher.shaded.goals");
        }
        if (pluginExecution.getInherited() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.inherited").text(pluginExecution.getInherited()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.inherited");
            this.writeLocationTracking(pluginExecution, "io.quarkus.launcher.shaded.inherited", serializer);
        }
        if (pluginExecution.getConfiguration() != null) {
            this.writeXpp3DomToSerializer((Xpp3Dom)pluginExecution.getConfiguration(), serializer);
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writePluginManagement(PluginManagement pluginManagement, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (pluginManagement.getPlugins() != null && pluginManagement.getPlugins().size() > 0) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.plugins");
            for (Plugin o : pluginManagement.getPlugins()) {
                this.writePlugin(o, "io.quarkus.launcher.shaded.plugin", serializer);
            }
            serializer.endTag(NAMESPACE, "io.quarkus.launcher.shaded.plugins");
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writePrerequisites(Prerequisites prerequisites, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (prerequisites.getMaven() != null && !prerequisites.getMaven().equals("io.quarkus.launcher.shaded.2.0")) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.maven").text(prerequisites.getMaven()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.maven");
            this.writeLocationTracking(prerequisites, "io.quarkus.launcher.shaded.maven", serializer);
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeProfile(Profile profile, String tagName, XmlSerializer serializer) throws IOException {
        InputLocation location;
        serializer.startTag(NAMESPACE, tagName);
        if (profile.getId() != null && !profile.getId().equals("io.quarkus.launcher.shaded.default")) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.id").text(profile.getId()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.id");
            this.writeLocationTracking(profile, "io.quarkus.launcher.shaded.id", serializer);
        }
        if (profile.getActivation() != null) {
            this.writeActivation(profile.getActivation(), "io.quarkus.launcher.shaded.activation", serializer);
        }
        if (profile.getBuild() != null) {
            this.writeBuildBase(profile.getBuild(), "io.quarkus.launcher.shaded.build", serializer);
        }
        if (profile.getModules() != null && profile.getModules().size() > 0) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.modules");
            location = profile.getLocation("io.quarkus.launcher.shaded.modules");
            int n = 0;
            for (String module : profile.getModules()) {
                serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.module").text(module).endTag(NAMESPACE, "io.quarkus.launcher.shaded.module");
                this.writeLocationTracking(location, n++, serializer);
            }
            serializer.endTag(NAMESPACE, "io.quarkus.launcher.shaded.modules");
        }
        if (profile.getDistributionManagement() != null) {
            this.writeDistributionManagement(profile.getDistributionManagement(), "io.quarkus.launcher.shaded.distributionManagement", serializer);
        }
        if (profile.getProperties() != null && profile.getProperties().size() > 0) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.properties");
            location = profile.getLocation("io.quarkus.launcher.shaded.properties");
            for (String string : profile.getProperties().keySet()) {
                String value = (String)profile.getProperties().get(string);
                serializer.startTag(NAMESPACE, string).text(value).endTag(NAMESPACE, string);
                this.writeLocationTracking(location, string, serializer);
            }
            serializer.endTag(NAMESPACE, "io.quarkus.launcher.shaded.properties");
        }
        if (profile.getDependencyManagement() != null) {
            this.writeDependencyManagement(profile.getDependencyManagement(), "io.quarkus.launcher.shaded.dependencyManagement", serializer);
        }
        if (profile.getDependencies() != null && profile.getDependencies().size() > 0) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.dependencies");
            for (Dependency o : profile.getDependencies()) {
                this.writeDependency(o, "io.quarkus.launcher.shaded.dependency", serializer);
            }
            serializer.endTag(NAMESPACE, "io.quarkus.launcher.shaded.dependencies");
        }
        if (profile.getRepositories() != null && profile.getRepositories().size() > 0) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.repositories");
            for (Repository o : profile.getRepositories()) {
                this.writeRepository(o, "io.quarkus.launcher.shaded.repository", serializer);
            }
            serializer.endTag(NAMESPACE, "io.quarkus.launcher.shaded.repositories");
        }
        if (profile.getPluginRepositories() != null && profile.getPluginRepositories().size() > 0) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.pluginRepositories");
            for (Repository o : profile.getPluginRepositories()) {
                this.writeRepository(o, "io.quarkus.launcher.shaded.pluginRepository", serializer);
            }
            serializer.endTag(NAMESPACE, "io.quarkus.launcher.shaded.pluginRepositories");
        }
        if (profile.getReports() != null) {
            this.writeXpp3DomToSerializer((Xpp3Dom)profile.getReports(), serializer);
        }
        if (profile.getReporting() != null) {
            this.writeReporting(profile.getReporting(), "io.quarkus.launcher.shaded.reporting", serializer);
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeRelocation(Relocation relocation, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (relocation.getGroupId() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.groupId").text(relocation.getGroupId()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.groupId");
            this.writeLocationTracking(relocation, "io.quarkus.launcher.shaded.groupId", serializer);
        }
        if (relocation.getArtifactId() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.artifactId").text(relocation.getArtifactId()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.artifactId");
            this.writeLocationTracking(relocation, "io.quarkus.launcher.shaded.artifactId", serializer);
        }
        if (relocation.getVersion() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.version").text(relocation.getVersion()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.version");
            this.writeLocationTracking(relocation, "io.quarkus.launcher.shaded.version", serializer);
        }
        if (relocation.getMessage() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.message").text(relocation.getMessage()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.message");
            this.writeLocationTracking(relocation, "io.quarkus.launcher.shaded.message", serializer);
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeReportPlugin(ReportPlugin reportPlugin, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (reportPlugin.getGroupId() != null && !reportPlugin.getGroupId().equals("io.quarkus.launcher.shaded.org.apache.maven.plugins")) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.groupId").text(reportPlugin.getGroupId()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.groupId");
            this.writeLocationTracking(reportPlugin, "io.quarkus.launcher.shaded.groupId", serializer);
        }
        if (reportPlugin.getArtifactId() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.artifactId").text(reportPlugin.getArtifactId()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.artifactId");
            this.writeLocationTracking(reportPlugin, "io.quarkus.launcher.shaded.artifactId", serializer);
        }
        if (reportPlugin.getVersion() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.version").text(reportPlugin.getVersion()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.version");
            this.writeLocationTracking(reportPlugin, "io.quarkus.launcher.shaded.version", serializer);
        }
        if (reportPlugin.getReportSets() != null && reportPlugin.getReportSets().size() > 0) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.reportSets");
            for (ReportSet o : reportPlugin.getReportSets()) {
                this.writeReportSet(o, "io.quarkus.launcher.shaded.reportSet", serializer);
            }
            serializer.endTag(NAMESPACE, "io.quarkus.launcher.shaded.reportSets");
        }
        if (reportPlugin.getInherited() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.inherited").text(reportPlugin.getInherited()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.inherited");
            this.writeLocationTracking(reportPlugin, "io.quarkus.launcher.shaded.inherited", serializer);
        }
        if (reportPlugin.getConfiguration() != null) {
            this.writeXpp3DomToSerializer((Xpp3Dom)reportPlugin.getConfiguration(), serializer);
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeReportSet(ReportSet reportSet, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (reportSet.getId() != null && !reportSet.getId().equals("io.quarkus.launcher.shaded.default")) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.id").text(reportSet.getId()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.id");
            this.writeLocationTracking(reportSet, "io.quarkus.launcher.shaded.id", serializer);
        }
        if (reportSet.getReports() != null && reportSet.getReports().size() > 0) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.reports");
            InputLocation location = reportSet.getLocation("io.quarkus.launcher.shaded.reports");
            int n = 0;
            for (String report : reportSet.getReports()) {
                serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.report").text(report).endTag(NAMESPACE, "io.quarkus.launcher.shaded.report");
                this.writeLocationTracking(location, n++, serializer);
            }
            serializer.endTag(NAMESPACE, "io.quarkus.launcher.shaded.reports");
        }
        if (reportSet.getInherited() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.inherited").text(reportSet.getInherited()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.inherited");
            this.writeLocationTracking(reportSet, "io.quarkus.launcher.shaded.inherited", serializer);
        }
        if (reportSet.getConfiguration() != null) {
            this.writeXpp3DomToSerializer((Xpp3Dom)reportSet.getConfiguration(), serializer);
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeReporting(Reporting reporting, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (reporting.getExcludeDefaults() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.excludeDefaults").text(reporting.getExcludeDefaults()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.excludeDefaults");
            this.writeLocationTracking(reporting, "io.quarkus.launcher.shaded.excludeDefaults", serializer);
        }
        if (reporting.getOutputDirectory() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.outputDirectory").text(reporting.getOutputDirectory()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.outputDirectory");
            this.writeLocationTracking(reporting, "io.quarkus.launcher.shaded.outputDirectory", serializer);
        }
        if (reporting.getPlugins() != null && reporting.getPlugins().size() > 0) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.plugins");
            for (ReportPlugin o : reporting.getPlugins()) {
                this.writeReportPlugin(o, "io.quarkus.launcher.shaded.plugin", serializer);
            }
            serializer.endTag(NAMESPACE, "io.quarkus.launcher.shaded.plugins");
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeRepository(Repository repository, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (repository.getReleases() != null) {
            this.writeRepositoryPolicy(repository.getReleases(), "io.quarkus.launcher.shaded.releases", serializer);
        }
        if (repository.getSnapshots() != null) {
            this.writeRepositoryPolicy(repository.getSnapshots(), "io.quarkus.launcher.shaded.snapshots", serializer);
        }
        if (repository.getId() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.id").text(repository.getId()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.id");
            this.writeLocationTracking(repository, "io.quarkus.launcher.shaded.id", serializer);
        }
        if (repository.getName() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.name").text(repository.getName()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.name");
            this.writeLocationTracking(repository, "io.quarkus.launcher.shaded.name", serializer);
        }
        if (repository.getUrl() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.url").text(repository.getUrl()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.url");
            this.writeLocationTracking(repository, "io.quarkus.launcher.shaded.url", serializer);
        }
        if (repository.getLayout() != null && !repository.getLayout().equals("io.quarkus.launcher.shaded.default")) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.layout").text(repository.getLayout()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.layout");
            this.writeLocationTracking(repository, "io.quarkus.launcher.shaded.layout", serializer);
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeRepositoryBase(RepositoryBase repositoryBase, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (repositoryBase.getId() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.id").text(repositoryBase.getId()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.id");
            this.writeLocationTracking(repositoryBase, "io.quarkus.launcher.shaded.id", serializer);
        }
        if (repositoryBase.getName() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.name").text(repositoryBase.getName()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.name");
            this.writeLocationTracking(repositoryBase, "io.quarkus.launcher.shaded.name", serializer);
        }
        if (repositoryBase.getUrl() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.url").text(repositoryBase.getUrl()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.url");
            this.writeLocationTracking(repositoryBase, "io.quarkus.launcher.shaded.url", serializer);
        }
        if (repositoryBase.getLayout() != null && !repositoryBase.getLayout().equals("io.quarkus.launcher.shaded.default")) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.layout").text(repositoryBase.getLayout()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.layout");
            this.writeLocationTracking(repositoryBase, "io.quarkus.launcher.shaded.layout", serializer);
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeRepositoryPolicy(RepositoryPolicy repositoryPolicy, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (repositoryPolicy.getEnabled() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.enabled").text(repositoryPolicy.getEnabled()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.enabled");
            this.writeLocationTracking(repositoryPolicy, "io.quarkus.launcher.shaded.enabled", serializer);
        }
        if (repositoryPolicy.getUpdatePolicy() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.updatePolicy").text(repositoryPolicy.getUpdatePolicy()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.updatePolicy");
            this.writeLocationTracking(repositoryPolicy, "io.quarkus.launcher.shaded.updatePolicy", serializer);
        }
        if (repositoryPolicy.getChecksumPolicy() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.checksumPolicy").text(repositoryPolicy.getChecksumPolicy()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.checksumPolicy");
            this.writeLocationTracking(repositoryPolicy, "io.quarkus.launcher.shaded.checksumPolicy", serializer);
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeResource(Resource resource, String tagName, XmlSerializer serializer) throws IOException {
        int n;
        InputLocation location;
        serializer.startTag(NAMESPACE, tagName);
        if (resource.getTargetPath() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.targetPath").text(resource.getTargetPath()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.targetPath");
            this.writeLocationTracking(resource, "io.quarkus.launcher.shaded.targetPath", serializer);
        }
        if (resource.getFiltering() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.filtering").text(resource.getFiltering()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.filtering");
            this.writeLocationTracking(resource, "io.quarkus.launcher.shaded.filtering", serializer);
        }
        if (resource.getDirectory() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.directory").text(resource.getDirectory()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.directory");
            this.writeLocationTracking(resource, "io.quarkus.launcher.shaded.directory", serializer);
        }
        if (resource.getIncludes() != null && resource.getIncludes().size() > 0) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.includes");
            location = resource.getLocation("io.quarkus.launcher.shaded.includes");
            n = 0;
            for (String include : resource.getIncludes()) {
                serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.include").text(include).endTag(NAMESPACE, "io.quarkus.launcher.shaded.include");
                this.writeLocationTracking(location, n++, serializer);
            }
            serializer.endTag(NAMESPACE, "io.quarkus.launcher.shaded.includes");
        }
        if (resource.getExcludes() != null && resource.getExcludes().size() > 0) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.excludes");
            location = resource.getLocation("io.quarkus.launcher.shaded.excludes");
            n = 0;
            for (String exclude : resource.getExcludes()) {
                serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.exclude").text(exclude).endTag(NAMESPACE, "io.quarkus.launcher.shaded.exclude");
                this.writeLocationTracking(location, n++, serializer);
            }
            serializer.endTag(NAMESPACE, "io.quarkus.launcher.shaded.excludes");
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeScm(Scm scm, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (scm.getChildScmConnectionInheritAppendPath() != null) {
            serializer.attribute(NAMESPACE, "io.quarkus.launcher.shaded.child.scm.connection.inherit.append.path", scm.getChildScmConnectionInheritAppendPath());
        }
        if (scm.getChildScmDeveloperConnectionInheritAppendPath() != null) {
            serializer.attribute(NAMESPACE, "io.quarkus.launcher.shaded.child.scm.developerConnection.inherit.append.path", scm.getChildScmDeveloperConnectionInheritAppendPath());
        }
        if (scm.getChildScmUrlInheritAppendPath() != null) {
            serializer.attribute(NAMESPACE, "io.quarkus.launcher.shaded.child.scm.url.inherit.append.path", scm.getChildScmUrlInheritAppendPath());
        }
        if (scm.getConnection() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.connection").text(scm.getConnection()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.connection");
            this.writeLocationTracking(scm, "io.quarkus.launcher.shaded.connection", serializer);
        }
        if (scm.getDeveloperConnection() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.developerConnection").text(scm.getDeveloperConnection()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.developerConnection");
            this.writeLocationTracking(scm, "io.quarkus.launcher.shaded.developerConnection", serializer);
        }
        if (scm.getTag() != null && !scm.getTag().equals("io.quarkus.launcher.shaded.HEAD")) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.tag").text(scm.getTag()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.tag");
            this.writeLocationTracking(scm, "io.quarkus.launcher.shaded.tag", serializer);
        }
        if (scm.getUrl() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.url").text(scm.getUrl()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.url");
            this.writeLocationTracking(scm, "io.quarkus.launcher.shaded.url", serializer);
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeSite(Site site, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (site.getChildSiteUrlInheritAppendPath() != null) {
            serializer.attribute(NAMESPACE, "io.quarkus.launcher.shaded.child.site.url.inherit.append.path", site.getChildSiteUrlInheritAppendPath());
        }
        if (site.getId() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.id").text(site.getId()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.id");
            this.writeLocationTracking(site, "io.quarkus.launcher.shaded.id", serializer);
        }
        if (site.getName() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.name").text(site.getName()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.name");
            this.writeLocationTracking(site, "io.quarkus.launcher.shaded.name", serializer);
        }
        if (site.getUrl() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.url").text(site.getUrl()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.url");
            this.writeLocationTracking(site, "io.quarkus.launcher.shaded.url", serializer);
        }
        serializer.endTag(NAMESPACE, tagName);
    }
}

