/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.maven.model.normalization;

import io.quarkus.launcher.shaded.javax.inject.Named;
import io.quarkus.launcher.shaded.javax.inject.Singleton;
import io.quarkus.launcher.shaded.org.apache.maven.model.Build;
import io.quarkus.launcher.shaded.org.apache.maven.model.Dependency;
import io.quarkus.launcher.shaded.org.apache.maven.model.Model;
import io.quarkus.launcher.shaded.org.apache.maven.model.Plugin;
import io.quarkus.launcher.shaded.org.apache.maven.model.building.ModelBuildingRequest;
import io.quarkus.launcher.shaded.org.apache.maven.model.building.ModelProblemCollector;
import io.quarkus.launcher.shaded.org.apache.maven.model.merge.MavenModelMerger;
import io.quarkus.launcher.shaded.org.apache.maven.model.normalization.ModelNormalizer;
import io.quarkus.launcher.shaded.org.codehaus.plexus.util.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;

@Named
@Singleton
public class DefaultModelNormalizer
implements ModelNormalizer {
    private DuplicateMerger merger = new DuplicateMerger();

    @Override
    public void mergeDuplicates(Model model, ModelBuildingRequest request, ModelProblemCollector problems) {
        LinkedHashMap<String, Cloneable> normalized;
        Build build = model.getBuild();
        if (build != null) {
            List<Plugin> plugins = build.getPlugins();
            normalized = new LinkedHashMap<String, Cloneable>(plugins.size() * 2);
            for (Plugin plugin : plugins) {
                String key = plugin.getKey();
                Plugin first = (Plugin)normalized.get(key);
                if (first != null) {
                    this.merger.mergePlugin(plugin, first);
                }
                normalized.put(key, plugin);
            }
            if (plugins.size() != normalized.size()) {
                build.setPlugins(new ArrayList<Plugin>(normalized.values()));
            }
        }
        List<Dependency> dependencies = model.getDependencies();
        normalized = new LinkedHashMap(dependencies.size() * 2);
        for (Dependency dependency : dependencies) {
            normalized.put(dependency.getManagementKey(), dependency);
        }
        if (dependencies.size() != normalized.size()) {
            model.setDependencies(new ArrayList<Dependency>(normalized.values()));
        }
    }

    @Override
    public void injectDefaultValues(Model model, ModelBuildingRequest request, ModelProblemCollector problems) {
        this.injectDependencyDefaults(model.getDependencies());
        Build build = model.getBuild();
        if (build != null) {
            for (Plugin plugin : build.getPlugins()) {
                this.injectDependencyDefaults(plugin.getDependencies());
            }
        }
    }

    private void injectDependencyDefaults(List<Dependency> dependencies) {
        for (Dependency dependency : dependencies) {
            if (!StringUtils.isEmpty(dependency.getScope())) continue;
            dependency.setScope("io.quarkus.launcher.shaded.compile");
        }
    }

    protected static class DuplicateMerger
    extends MavenModelMerger {
        protected DuplicateMerger() {
        }

        public void mergePlugin(Plugin target, Plugin source) {
            super.mergePlugin(target, source, false, Collections.emptyMap());
        }
    }
}

