/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.maven.model.path;

import io.quarkus.launcher.shaded.javax.inject.Inject;
import io.quarkus.launcher.shaded.javax.inject.Named;
import io.quarkus.launcher.shaded.javax.inject.Singleton;
import io.quarkus.launcher.shaded.org.apache.maven.model.DistributionManagement;
import io.quarkus.launcher.shaded.org.apache.maven.model.Model;
import io.quarkus.launcher.shaded.org.apache.maven.model.Scm;
import io.quarkus.launcher.shaded.org.apache.maven.model.Site;
import io.quarkus.launcher.shaded.org.apache.maven.model.building.ModelBuildingRequest;
import io.quarkus.launcher.shaded.org.apache.maven.model.path.ModelUrlNormalizer;
import io.quarkus.launcher.shaded.org.apache.maven.model.path.UrlNormalizer;

@Named
@Singleton
public class DefaultModelUrlNormalizer
implements ModelUrlNormalizer {
    @Inject
    private UrlNormalizer urlNormalizer;

    public DefaultModelUrlNormalizer setUrlNormalizer(UrlNormalizer urlNormalizer) {
        this.urlNormalizer = urlNormalizer;
        return this;
    }

    @Override
    public void normalize(Model model, ModelBuildingRequest request) {
        Site site;
        DistributionManagement dist;
        if (model == null) {
            return;
        }
        model.setUrl(this.normalize(model.getUrl()));
        Scm scm = model.getScm();
        if (scm != null) {
            scm.setUrl(this.normalize(scm.getUrl()));
            scm.setConnection(this.normalize(scm.getConnection()));
            scm.setDeveloperConnection(this.normalize(scm.getDeveloperConnection()));
        }
        if ((dist = model.getDistributionManagement()) != null && (site = dist.getSite()) != null) {
            site.setUrl(this.normalize(site.getUrl()));
        }
    }

    private String normalize(String url) {
        return this.urlNormalizer.normalize(url);
    }
}

