/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.maven.model.plugin;

import io.quarkus.launcher.shaded.javax.inject.Named;
import io.quarkus.launcher.shaded.javax.inject.Singleton;
import io.quarkus.launcher.shaded.org.apache.maven.model.Build;
import io.quarkus.launcher.shaded.org.apache.maven.model.InputLocation;
import io.quarkus.launcher.shaded.org.apache.maven.model.InputSource;
import io.quarkus.launcher.shaded.org.apache.maven.model.Model;
import io.quarkus.launcher.shaded.org.apache.maven.model.Plugin;
import io.quarkus.launcher.shaded.org.apache.maven.model.PluginManagement;
import io.quarkus.launcher.shaded.org.apache.maven.model.ReportPlugin;
import io.quarkus.launcher.shaded.org.apache.maven.model.ReportSet;
import io.quarkus.launcher.shaded.org.apache.maven.model.Reporting;
import io.quarkus.launcher.shaded.org.apache.maven.model.building.ModelBuildingRequest;
import io.quarkus.launcher.shaded.org.apache.maven.model.building.ModelProblem;
import io.quarkus.launcher.shaded.org.apache.maven.model.building.ModelProblemCollector;
import io.quarkus.launcher.shaded.org.apache.maven.model.building.ModelProblemCollectorRequest;
import io.quarkus.launcher.shaded.org.apache.maven.model.plugin.ReportingConverter;
import io.quarkus.launcher.shaded.org.codehaus.plexus.util.StringUtils;
import io.quarkus.launcher.shaded.org.codehaus.plexus.util.xml.Xpp3Dom;

@Named
@Singleton
public class DefaultReportingConverter
implements ReportingConverter {
    private final InputLocation location;

    public DefaultReportingConverter() {
        String modelId = "io.quarkus.launcher.shaded.org.apache.maven:maven-model-builder:" + this.getClass().getPackage().getImplementationVersion() + "io.quarkus.launcher.shaded.:reporting-converter";
        InputSource inputSource = new InputSource();
        inputSource.setModelId(modelId);
        this.location = new InputLocation(-1, -1, inputSource);
        this.location.setLocation(0, this.location);
    }

    @Override
    public void convertReporting(Model model, ModelBuildingRequest request, ModelProblemCollector problems) {
        Xpp3Dom reportPlugins;
        Xpp3Dom configuration;
        Plugin sitePlugin;
        Reporting reporting = model.getReporting();
        if (reporting == null) {
            return;
        }
        Build build = model.getBuild();
        if (build == null) {
            build = new Build();
            model.setBuild(build);
            model.setLocation("io.quarkus.launcher.shaded.build", this.location);
        }
        if ((sitePlugin = this.findSitePlugin(build)) == null) {
            sitePlugin = new Plugin();
            sitePlugin.setArtifactId("io.quarkus.launcher.shaded.maven-site-plugin");
            sitePlugin.setLocation("io.quarkus.launcher.shaded.artifactId", this.location);
            PluginManagement pluginManagement = build.getPluginManagement();
            if (pluginManagement == null) {
                pluginManagement = new PluginManagement();
                build.setPluginManagement(pluginManagement);
            }
            pluginManagement.addPlugin(sitePlugin);
        }
        if ((configuration = (Xpp3Dom)sitePlugin.getConfiguration()) == null) {
            configuration = new Xpp3Dom("io.quarkus.launcher.shaded.configuration", this.location);
            sitePlugin.setConfiguration(configuration);
        }
        if ((reportPlugins = configuration.getChild("io.quarkus.launcher.shaded.reportPlugins")) != null) {
            problems.add(new ModelProblemCollectorRequest(ModelProblem.Severity.WARNING, ModelProblem.Version.BASE).setMessage("io.quarkus.launcher.shaded.Reporting configuration should be done in <reporting> section, not in maven-site-plugin <configuration> as reportPlugins parameter.").setLocation(sitePlugin.getLocation("io.quarkus.launcher.shaded.configuration")));
            return;
        }
        if (configuration.getChild("io.quarkus.launcher.shaded.outputDirectory") == null) {
            this.addDom(configuration, "io.quarkus.launcher.shaded.outputDirectory", reporting.getOutputDirectory(), reporting.getLocation("io.quarkus.launcher.shaded.outputDirectory"));
        }
        reportPlugins = new Xpp3Dom("io.quarkus.launcher.shaded.reportPlugins", this.location);
        configuration.addChild(reportPlugins);
        boolean hasMavenProjectInfoReportsPlugin = false;
        for (ReportPlugin plugin : reporting.getPlugins()) {
            Xpp3Dom reportPlugin = this.convert(plugin);
            reportPlugins.addChild(reportPlugin);
            if (reporting.isExcludeDefaults() || hasMavenProjectInfoReportsPlugin || !"io.quarkus.launcher.shaded.org.apache.maven.plugins".equals(plugin.getGroupId()) || !"io.quarkus.launcher.shaded.maven-project-info-reports-plugin".equals(plugin.getArtifactId())) continue;
            hasMavenProjectInfoReportsPlugin = true;
        }
        if (!reporting.isExcludeDefaults() && !hasMavenProjectInfoReportsPlugin) {
            Xpp3Dom dom = new Xpp3Dom("io.quarkus.launcher.shaded.reportPlugin", this.location);
            this.addDom(dom, "io.quarkus.launcher.shaded.groupId", "io.quarkus.launcher.shaded.org.apache.maven.plugins");
            this.addDom(dom, "io.quarkus.launcher.shaded.artifactId", "io.quarkus.launcher.shaded.maven-project-info-reports-plugin");
            reportPlugins.addChild(dom);
        }
    }

    private Plugin findSitePlugin(Build build) {
        for (Plugin plugin : build.getPlugins()) {
            if (!this.isSitePlugin(plugin)) continue;
            return plugin;
        }
        PluginManagement pluginManagement = build.getPluginManagement();
        if (pluginManagement != null) {
            for (Plugin plugin : pluginManagement.getPlugins()) {
                if (!this.isSitePlugin(plugin)) continue;
                return plugin;
            }
        }
        return null;
    }

    private boolean isSitePlugin(Plugin plugin) {
        return "io.quarkus.launcher.shaded.maven-site-plugin".equals(plugin.getArtifactId()) && "io.quarkus.launcher.shaded.org.apache.maven.plugins".equals(plugin.getGroupId());
    }

    private Xpp3Dom convert(ReportPlugin plugin) {
        Xpp3Dom dom = new Xpp3Dom("io.quarkus.launcher.shaded.reportPlugin", plugin.getLocation("io.quarkus.launcher.shaded."));
        this.addDom(dom, "io.quarkus.launcher.shaded.groupId", plugin.getGroupId(), plugin.getLocation("io.quarkus.launcher.shaded.groupId"));
        this.addDom(dom, "io.quarkus.launcher.shaded.artifactId", plugin.getArtifactId(), plugin.getLocation("io.quarkus.launcher.shaded.artifactId"));
        this.addDom(dom, "io.quarkus.launcher.shaded.version", plugin.getVersion(), plugin.getLocation("io.quarkus.launcher.shaded.version"));
        Xpp3Dom configuration = (Xpp3Dom)plugin.getConfiguration();
        if (configuration != null) {
            configuration = new Xpp3Dom(configuration);
            dom.addChild(configuration);
        }
        if (!plugin.getReportSets().isEmpty()) {
            Xpp3Dom reportSets = new Xpp3Dom("io.quarkus.launcher.shaded.reportSets", plugin.getLocation("io.quarkus.launcher.shaded.reportSets"));
            for (ReportSet reportSet : plugin.getReportSets()) {
                Xpp3Dom rs = this.convert(reportSet);
                reportSets.addChild(rs);
            }
            dom.addChild(reportSets);
        }
        return dom;
    }

    private Xpp3Dom convert(ReportSet reportSet) {
        Xpp3Dom dom = new Xpp3Dom("io.quarkus.launcher.shaded.reportSet", reportSet.getLocation("io.quarkus.launcher.shaded."));
        InputLocation idLocation = reportSet.getLocation("io.quarkus.launcher.shaded.id");
        this.addDom(dom, "io.quarkus.launcher.shaded.id", reportSet.getId(), idLocation == null ? this.location : idLocation);
        Xpp3Dom configuration = (Xpp3Dom)reportSet.getConfiguration();
        if (configuration != null) {
            configuration = new Xpp3Dom(configuration);
            dom.addChild(configuration);
        }
        if (!reportSet.getReports().isEmpty()) {
            InputLocation location = reportSet.getLocation("io.quarkus.launcher.shaded.reports");
            Xpp3Dom reports = new Xpp3Dom("io.quarkus.launcher.shaded.reports", location);
            int n = 0;
            for (String report : reportSet.getReports()) {
                this.addDom(reports, "io.quarkus.launcher.shaded.report", report, location == null ? null : location.getLocation(n++));
            }
            dom.addChild(reports);
        }
        return dom;
    }

    private void addDom(Xpp3Dom parent, String childName, String childValue) {
        this.addDom(parent, childName, childValue, this.location);
    }

    private void addDom(Xpp3Dom parent, String childName, String childValue, InputLocation location) {
        if (StringUtils.isNotEmpty(childValue)) {
            parent.addChild(this.newDom(childName, childValue, location));
        }
    }

    private Xpp3Dom newDom(String name, String value, InputLocation location) {
        Xpp3Dom dom = new Xpp3Dom(name, location);
        dom.setValue(value);
        return dom;
    }
}

