/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.maven.model.profile.activation;

import io.quarkus.launcher.shaded.javax.inject.Inject;
import io.quarkus.launcher.shaded.javax.inject.Named;
import io.quarkus.launcher.shaded.javax.inject.Singleton;
import io.quarkus.launcher.shaded.org.apache.maven.model.Activation;
import io.quarkus.launcher.shaded.org.apache.maven.model.ActivationFile;
import io.quarkus.launcher.shaded.org.apache.maven.model.Profile;
import io.quarkus.launcher.shaded.org.apache.maven.model.building.ModelProblem;
import io.quarkus.launcher.shaded.org.apache.maven.model.building.ModelProblemCollector;
import io.quarkus.launcher.shaded.org.apache.maven.model.building.ModelProblemCollectorRequest;
import io.quarkus.launcher.shaded.org.apache.maven.model.path.PathTranslator;
import io.quarkus.launcher.shaded.org.apache.maven.model.profile.ProfileActivationContext;
import io.quarkus.launcher.shaded.org.apache.maven.model.profile.activation.ProfileActivator;
import io.quarkus.launcher.shaded.org.codehaus.plexus.interpolation.AbstractValueSource;
import io.quarkus.launcher.shaded.org.codehaus.plexus.interpolation.MapBasedValueSource;
import io.quarkus.launcher.shaded.org.codehaus.plexus.interpolation.RegexBasedInterpolator;
import io.quarkus.launcher.shaded.org.codehaus.plexus.util.StringUtils;
import java.io.File;

@Named(value="io.quarkus.launcher.shaded.file")
@Singleton
public class FileProfileActivator
implements ProfileActivator {
    @Inject
    private PathTranslator pathTranslator;

    public FileProfileActivator setPathTranslator(PathTranslator pathTranslator) {
        this.pathTranslator = pathTranslator;
        return this;
    }

    @Override
    public boolean isActive(Profile profile, ProfileActivationContext context, ModelProblemCollector problems) {
        boolean missing;
        String path;
        Activation activation = profile.getActivation();
        if (activation == null) {
            return false;
        }
        ActivationFile file = activation.getFile();
        if (file == null) {
            return false;
        }
        if (StringUtils.isNotEmpty(file.getExists())) {
            path = file.getExists();
            missing = false;
        } else if (StringUtils.isNotEmpty(file.getMissing())) {
            path = file.getMissing();
            missing = true;
        } else {
            return false;
        }
        RegexBasedInterpolator interpolator = new RegexBasedInterpolator();
        final File basedir = context.getProjectDirectory();
        if (basedir != null) {
            interpolator.addValueSource(new AbstractValueSource(false){

                @Override
                public Object getValue(String expression) {
                    if ("io.quarkus.launcher.shaded.basedir".equals(expression)) {
                        return basedir.getAbsolutePath();
                    }
                    return null;
                }
            });
        } else if (path.contains("io.quarkus.launcher.shaded.${basedir}")) {
            return false;
        }
        interpolator.addValueSource(new MapBasedValueSource(context.getProjectProperties()));
        interpolator.addValueSource(new MapBasedValueSource(context.getUserProperties()));
        interpolator.addValueSource(new MapBasedValueSource(context.getSystemProperties()));
        try {
            path = interpolator.interpolate(path, "io.quarkus.launcher.shaded.");
        }
        catch (Exception e) {
            problems.add(new ModelProblemCollectorRequest(ModelProblem.Severity.ERROR, ModelProblem.Version.BASE).setMessage("io.quarkus.launcher.shaded.Failed to interpolate file location " + path + "io.quarkus.launcher.shaded. for profile " + profile.getId() + "io.quarkus.launcher.shaded.: " + e.getMessage()).setLocation(file.getLocation(missing ? "io.quarkus.launcher.shaded.missing" : "io.quarkus.launcher.shaded.exists")).setException(e));
            return false;
        }
        path = this.pathTranslator.alignToBaseDirectory(path, basedir);
        if (missing) {
            file.setMissing(path);
        } else {
            file.setExists(path);
        }
        File f = new File(path);
        if (!f.isAbsolute()) {
            return false;
        }
        boolean fileExists = f.exists();
        return missing ? !fileExists : fileExists;
    }

    @Override
    public boolean presentInConfig(Profile profile, ProfileActivationContext context, ModelProblemCollector problems) {
        Activation activation = profile.getActivation();
        if (activation == null) {
            return false;
        }
        ActivationFile file = activation.getFile();
        return file != null;
    }
}

