/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.maven.model.profile.activation;

import io.quarkus.launcher.shaded.javax.inject.Named;
import io.quarkus.launcher.shaded.javax.inject.Singleton;
import io.quarkus.launcher.shaded.org.apache.maven.model.Activation;
import io.quarkus.launcher.shaded.org.apache.maven.model.Profile;
import io.quarkus.launcher.shaded.org.apache.maven.model.building.ModelProblem;
import io.quarkus.launcher.shaded.org.apache.maven.model.building.ModelProblemCollector;
import io.quarkus.launcher.shaded.org.apache.maven.model.building.ModelProblemCollectorRequest;
import io.quarkus.launcher.shaded.org.apache.maven.model.profile.ProfileActivationContext;
import io.quarkus.launcher.shaded.org.apache.maven.model.profile.activation.ProfileActivator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@Named(value="io.quarkus.launcher.shaded.jdk-version")
@Singleton
public class JdkVersionProfileActivator
implements ProfileActivator {
    @Override
    public boolean isActive(Profile profile, ProfileActivationContext context, ModelProblemCollector problems) {
        Activation activation = profile.getActivation();
        if (activation == null) {
            return false;
        }
        String jdk = activation.getJdk();
        if (jdk == null) {
            return false;
        }
        String version = context.getSystemProperties().get("io/quarkus/launcher/shaded/java.version");
        if (version == null || version.length() <= 0) {
            problems.add(new ModelProblemCollectorRequest(ModelProblem.Severity.ERROR, ModelProblem.Version.BASE).setMessage("io.quarkus.launcher.shaded.Failed to determine Java version for profile " + profile.getId()).setLocation(activation.getLocation("io.quarkus.launcher.shaded.jdk")));
            return false;
        }
        if (jdk.startsWith("io.quarkus.launcher.shaded.!")) {
            return !version.startsWith(jdk.substring(1));
        }
        if (JdkVersionProfileActivator.isRange(jdk)) {
            return JdkVersionProfileActivator.isInRange(version, JdkVersionProfileActivator.getRange(jdk));
        }
        return version.startsWith(jdk);
    }

    @Override
    public boolean presentInConfig(Profile profile, ProfileActivationContext context, ModelProblemCollector problems) {
        Activation activation = profile.getActivation();
        if (activation == null) {
            return false;
        }
        String jdk = activation.getJdk();
        return jdk != null;
    }

    private static boolean isInRange(String value, List<RangeValue> range) {
        int leftRelation = JdkVersionProfileActivator.getRelationOrder(value, range.get(0), true);
        if (leftRelation == 0) {
            return true;
        }
        if (leftRelation < 0) {
            return false;
        }
        return JdkVersionProfileActivator.getRelationOrder(value, range.get(1), false) <= 0;
    }

    private static int getRelationOrder(String value, RangeValue rangeValue, boolean isLeft) {
        if (rangeValue.value.length() <= 0) {
            return isLeft ? 1 : -1;
        }
        value = value.replaceAll("io.quarkus.launcher.shaded.[^0-9\\.\\-\\_]", "io.quarkus.launcher.shaded.");
        ArrayList<String> valueTokens = new ArrayList<String>(Arrays.asList(value.split("io.quarkus.launcher.shaded.[\\.\\-\\_]")));
        ArrayList<String> rangeValueTokens = new ArrayList<String>(Arrays.asList(rangeValue.value.split("io.quarkus.launcher.shaded.\\.")));
        JdkVersionProfileActivator.addZeroTokens(valueTokens, 3);
        JdkVersionProfileActivator.addZeroTokens(rangeValueTokens, 3);
        for (int i = 0; i < 3; ++i) {
            int y;
            int x = Integer.parseInt((String)valueTokens.get(i));
            if (x < (y = Integer.parseInt((String)rangeValueTokens.get(i)))) {
                return -1;
            }
            if (x <= y) continue;
            return 1;
        }
        if (!rangeValue.closed) {
            return isLeft ? -1 : 1;
        }
        return 0;
    }

    private static void addZeroTokens(List<String> tokens, int max) {
        while (tokens.size() < max) {
            tokens.add("io.quarkus.launcher.shaded.0");
        }
    }

    private static boolean isRange(String value) {
        return value.startsWith("io.quarkus.launcher.shaded.[") || value.startsWith("io.quarkus.launcher.shaded.(");
    }

    private static List<RangeValue> getRange(String range) {
        ArrayList<RangeValue> ranges = new ArrayList<RangeValue>();
        for (String token : range.split("io.quarkus.launcher.shaded.,")) {
            if (token.startsWith("io.quarkus.launcher.shaded.[")) {
                ranges.add(new RangeValue(token.replace("io.quarkus.launcher.shaded.[", "io.quarkus.launcher.shaded."), true));
                continue;
            }
            if (token.startsWith("io.quarkus.launcher.shaded.(")) {
                ranges.add(new RangeValue(token.replace("io.quarkus.launcher.shaded.(", "io.quarkus.launcher.shaded."), false));
                continue;
            }
            if (token.endsWith("io.quarkus.launcher.shaded.]")) {
                ranges.add(new RangeValue(token.replace("io.quarkus.launcher.shaded.]", "io.quarkus.launcher.shaded."), true));
                continue;
            }
            if (token.endsWith("io.quarkus.launcher.shaded.)")) {
                ranges.add(new RangeValue(token.replace("io.quarkus.launcher.shaded.)", "io.quarkus.launcher.shaded."), false));
                continue;
            }
            if (token.length() > 0) continue;
            ranges.add(new RangeValue("io.quarkus.launcher.shaded.", false));
        }
        if (ranges.size() < 2) {
            ranges.add(new RangeValue("io.quarkus.launcher.shaded.99999999", false));
        }
        return ranges;
    }

    private static class RangeValue {
        private String value;
        private boolean closed;

        RangeValue(String value, boolean closed) {
            this.value = value.trim();
            this.closed = closed;
        }

        public String toString() {
            return this.value;
        }
    }
}

