/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.maven.model.profile.activation;

import io.quarkus.launcher.shaded.javax.inject.Named;
import io.quarkus.launcher.shaded.javax.inject.Singleton;
import io.quarkus.launcher.shaded.org.apache.maven.model.Activation;
import io.quarkus.launcher.shaded.org.apache.maven.model.ActivationProperty;
import io.quarkus.launcher.shaded.org.apache.maven.model.Profile;
import io.quarkus.launcher.shaded.org.apache.maven.model.building.ModelProblem;
import io.quarkus.launcher.shaded.org.apache.maven.model.building.ModelProblemCollector;
import io.quarkus.launcher.shaded.org.apache.maven.model.building.ModelProblemCollectorRequest;
import io.quarkus.launcher.shaded.org.apache.maven.model.profile.ProfileActivationContext;
import io.quarkus.launcher.shaded.org.apache.maven.model.profile.activation.ProfileActivator;
import io.quarkus.launcher.shaded.org.codehaus.plexus.util.StringUtils;

@Named(value="io.quarkus.launcher.shaded.property")
@Singleton
public class PropertyProfileActivator
implements ProfileActivator {
    @Override
    public boolean isActive(Profile profile, ProfileActivationContext context, ModelProblemCollector problems) {
        String propValue;
        Activation activation = profile.getActivation();
        if (activation == null) {
            return false;
        }
        ActivationProperty property = activation.getProperty();
        if (property == null) {
            return false;
        }
        String name = property.getName();
        boolean reverseName = false;
        if (name != null && name.startsWith("io.quarkus.launcher.shaded.!")) {
            reverseName = true;
            name = name.substring(1);
        }
        if (name == null || name.length() <= 0) {
            problems.add(new ModelProblemCollectorRequest(ModelProblem.Severity.ERROR, ModelProblem.Version.BASE).setMessage("io.quarkus.launcher.shaded.The property name is required to activate the profile " + profile.getId()).setLocation(property.getLocation("io.quarkus.launcher.shaded.")));
            return false;
        }
        String sysValue = context.getUserProperties().get(name);
        if (sysValue == null) {
            sysValue = context.getSystemProperties().get(name);
        }
        if (StringUtils.isNotEmpty(propValue = property.getValue())) {
            boolean reverseValue = false;
            if (propValue.startsWith("io.quarkus.launcher.shaded.!")) {
                reverseValue = true;
                propValue = propValue.substring(1);
            }
            boolean result = propValue.equals(sysValue);
            return reverseValue ? !result : result;
        }
        boolean result = StringUtils.isNotEmpty(sysValue);
        return reverseName ? !result : result;
    }

    @Override
    public boolean presentInConfig(Profile profile, ProfileActivationContext context, ModelProblemCollector problems) {
        Activation activation = profile.getActivation();
        if (activation == null) {
            return false;
        }
        ActivationProperty property = activation.getProperty();
        return property != null;
    }
}

