/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.maven.model.superpom;

import io.quarkus.launcher.shaded.javax.inject.Inject;
import io.quarkus.launcher.shaded.javax.inject.Named;
import io.quarkus.launcher.shaded.javax.inject.Singleton;
import io.quarkus.launcher.shaded.org.apache.maven.model.InputSource;
import io.quarkus.launcher.shaded.org.apache.maven.model.Model;
import io.quarkus.launcher.shaded.org.apache.maven.model.building.ModelProcessor;
import io.quarkus.launcher.shaded.org.apache.maven.model.superpom.SuperPomProvider;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;

@Named
@Singleton
public class DefaultSuperPomProvider
implements SuperPomProvider {
    private Model superModel;
    @Inject
    private ModelProcessor modelProcessor;

    public DefaultSuperPomProvider setModelProcessor(ModelProcessor modelProcessor) {
        this.modelProcessor = modelProcessor;
        return this;
    }

    @Override
    public Model getSuperModel(String version) {
        if (this.superModel == null) {
            String resource = "io/quarkus/launcher/shaded//org/apache/maven/model/pom-" + version + "io.quarkus.launcher.shaded..xml";
            InputStream is = this.getClass().getResourceAsStream(resource);
            if (is == null) {
                throw new IllegalStateException("io.quarkus.launcher.shaded.The super POM " + resource + "io.quarkus.launcher.shaded. was not found, please verify the integrity of your Maven installation");
            }
            try {
                HashMap<String, Object> options = new HashMap<String, Object>();
                options.put("io.quarkus.launcher.shaded.xml:4.0.0", "io.quarkus.launcher.shaded.xml:4.0.0");
                String modelId = "io.quarkus.launcher.shaded.org.apache.maven:maven-model-builder:" + this.getClass().getPackage().getImplementationVersion() + "io.quarkus.launcher.shaded.:super-pom";
                InputSource inputSource = new InputSource();
                inputSource.setModelId(modelId);
                inputSource.setLocation(this.getClass().getResource(resource).toExternalForm());
                options.put("io.quarkus.launcher.shaded.org.apache.maven.model.io.inputSource", inputSource);
                this.superModel = this.modelProcessor.read(is, options);
            }
            catch (IOException e) {
                throw new IllegalStateException("io.quarkus.launcher.shaded.The super POM " + resource + "io.quarkus.launcher.shaded. is damaged, please verify the integrity of your Maven installation", e);
            }
        }
        return this.superModel;
    }
}

