/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.maven.model.validation;

import io.quarkus.launcher.shaded.javax.inject.Named;
import io.quarkus.launcher.shaded.javax.inject.Singleton;
import io.quarkus.launcher.shaded.org.apache.maven.model.Activation;
import io.quarkus.launcher.shaded.org.apache.maven.model.ActivationFile;
import io.quarkus.launcher.shaded.org.apache.maven.model.Build;
import io.quarkus.launcher.shaded.org.apache.maven.model.BuildBase;
import io.quarkus.launcher.shaded.org.apache.maven.model.Dependency;
import io.quarkus.launcher.shaded.org.apache.maven.model.DependencyManagement;
import io.quarkus.launcher.shaded.org.apache.maven.model.DistributionManagement;
import io.quarkus.launcher.shaded.org.apache.maven.model.Exclusion;
import io.quarkus.launcher.shaded.org.apache.maven.model.InputLocation;
import io.quarkus.launcher.shaded.org.apache.maven.model.InputLocationTracker;
import io.quarkus.launcher.shaded.org.apache.maven.model.Model;
import io.quarkus.launcher.shaded.org.apache.maven.model.Parent;
import io.quarkus.launcher.shaded.org.apache.maven.model.Plugin;
import io.quarkus.launcher.shaded.org.apache.maven.model.PluginExecution;
import io.quarkus.launcher.shaded.org.apache.maven.model.PluginManagement;
import io.quarkus.launcher.shaded.org.apache.maven.model.Profile;
import io.quarkus.launcher.shaded.org.apache.maven.model.ReportPlugin;
import io.quarkus.launcher.shaded.org.apache.maven.model.Reporting;
import io.quarkus.launcher.shaded.org.apache.maven.model.Repository;
import io.quarkus.launcher.shaded.org.apache.maven.model.Resource;
import io.quarkus.launcher.shaded.org.apache.maven.model.building.ModelBuildingRequest;
import io.quarkus.launcher.shaded.org.apache.maven.model.building.ModelProblem;
import io.quarkus.launcher.shaded.org.apache.maven.model.building.ModelProblemCollector;
import io.quarkus.launcher.shaded.org.apache.maven.model.building.ModelProblemCollectorRequest;
import io.quarkus.launcher.shaded.org.apache.maven.model.validation.ModelValidator;
import io.quarkus.launcher.shaded.org.codehaus.plexus.util.StringUtils;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Named
@Singleton
public class DefaultModelValidator
implements ModelValidator {
    private static final Pattern CI_FRIENDLY_EXPRESSION = Pattern.compile("io.quarkus.launcher.shaded.\\$\\{(.+?)\\}");
    private static final List<String> CI_FRIENDLY_POSSIBLE_PROPERTY_NAMES = Arrays.asList("io.quarkus.launcher.shaded.revision", "io.quarkus.launcher.shaded.changelist", "io.quarkus.launcher.shaded.sha1");
    private static final String ILLEGAL_FS_CHARS = "io/quarkus/launcher/shaded/\\/:\"<>|?*";
    private static final String ILLEGAL_VERSION_CHARS = "io/quarkus/launcher/shaded/\\/:\"<>|?*";
    private static final String ILLEGAL_REPO_ID_CHARS = "io/quarkus/launcher/shaded/\\/:\"<>|?*";
    private static final String EMPTY = "io.quarkus.launcher.shaded.";
    private final Set<String> validIds = new HashSet<String>();

    @Override
    public void validateRawModel(Model m, ModelBuildingRequest request, ModelProblemCollector problems) {
        Parent parent = m.getParent();
        if (parent != null) {
            this.validateStringNotEmpty("io.quarkus.launcher.shaded.parent.groupId", problems, ModelProblem.Severity.FATAL, ModelProblem.Version.BASE, parent.getGroupId(), parent);
            this.validateStringNotEmpty("io.quarkus.launcher.shaded.parent.artifactId", problems, ModelProblem.Severity.FATAL, ModelProblem.Version.BASE, parent.getArtifactId(), parent);
            this.validateStringNotEmpty("io.quarkus.launcher.shaded.parent.version", problems, ModelProblem.Severity.FATAL, ModelProblem.Version.BASE, parent.getVersion(), parent);
            if (DefaultModelValidator.equals(parent.getGroupId(), m.getGroupId()) && DefaultModelValidator.equals(parent.getArtifactId(), m.getArtifactId())) {
                DefaultModelValidator.addViolation(problems, ModelProblem.Severity.FATAL, ModelProblem.Version.BASE, "io.quarkus.launcher.shaded.parent.artifactId", null, "io.quarkus.launcher.shaded.must be changed, the parent element cannot have the same groupId:artifactId as the project.", parent);
            }
            if (DefaultModelValidator.equals("io.quarkus.launcher.shaded.LATEST", parent.getVersion()) || DefaultModelValidator.equals("io.quarkus.launcher.shaded.RELEASE", parent.getVersion())) {
                DefaultModelValidator.addViolation(problems, ModelProblem.Severity.WARNING, ModelProblem.Version.BASE, "io.quarkus.launcher.shaded.parent.version", null, "io.quarkus.launcher.shaded.is either LATEST or RELEASE (both of them are being deprecated)", parent);
            }
        }
        if (request.getValidationLevel() >= 20) {
            ModelProblem.Severity errOn30 = DefaultModelValidator.getSeverity(request, 30);
            this.validateStringNotEmpty("io.quarkus.launcher.shaded.modelVersion", problems, ModelProblem.Severity.ERROR, ModelProblem.Version.V20, m.getModelVersion(), m);
            this.validateModelVersion(problems, m.getModelVersion(), m, "io.quarkus.launcher.shaded.4.0.0");
            this.validateStringNoExpression("io.quarkus.launcher.shaded.groupId", problems, ModelProblem.Severity.WARNING, ModelProblem.Version.V20, m.getGroupId(), m);
            if (parent == null) {
                this.validateStringNotEmpty("io.quarkus.launcher.shaded.groupId", problems, ModelProblem.Severity.FATAL, ModelProblem.Version.V20, m.getGroupId(), m);
            }
            this.validateStringNoExpression("io.quarkus.launcher.shaded.artifactId", problems, ModelProblem.Severity.WARNING, ModelProblem.Version.V20, m.getArtifactId(), m);
            this.validateStringNotEmpty("io.quarkus.launcher.shaded.artifactId", problems, ModelProblem.Severity.FATAL, ModelProblem.Version.V20, m.getArtifactId(), m);
            this.validateVersionNoExpression("io.quarkus.launcher.shaded.version", problems, ModelProblem.Severity.WARNING, ModelProblem.Version.V20, m.getVersion(), m);
            if (parent == null) {
                this.validateStringNotEmpty("io.quarkus.launcher.shaded.version", problems, ModelProblem.Severity.FATAL, ModelProblem.Version.V20, m.getVersion(), m);
            }
            this.validate20RawDependencies(problems, m.getDependencies(), "io.quarkus.launcher.shaded.dependencies.dependency.", EMPTY, request);
            this.validate20RawDependenciesSelfReferencing(problems, m, m.getDependencies(), "io.quarkus.launcher.shaded.dependencies.dependency", request);
            if (m.getDependencyManagement() != null) {
                this.validate20RawDependencies(problems, m.getDependencyManagement().getDependencies(), "io.quarkus.launcher.shaded.dependencyManagement.dependencies.dependency.", EMPTY, request);
            }
            this.validateRawRepositories(problems, m.getRepositories(), "io.quarkus.launcher.shaded.repositories.repository.", EMPTY, request);
            this.validateRawRepositories(problems, m.getPluginRepositories(), "io.quarkus.launcher.shaded.pluginRepositories.pluginRepository.", EMPTY, request);
            Build build = m.getBuild();
            if (build != null) {
                this.validate20RawPlugins(problems, build.getPlugins(), "io.quarkus.launcher.shaded.build.plugins.plugin.", EMPTY, request);
                PluginManagement mgmt = build.getPluginManagement();
                if (mgmt != null) {
                    this.validate20RawPlugins(problems, mgmt.getPlugins(), "io.quarkus.launcher.shaded.build.pluginManagement.plugins.plugin.", EMPTY, request);
                }
            }
            HashSet<String> profileIds = new HashSet<String>();
            for (Profile profile : m.getProfiles()) {
                String prefix = "io.quarkus.launcher.shaded.profiles.profile[" + profile.getId() + "io.quarkus.launcher.shaded.].";
                if (!profileIds.add(profile.getId())) {
                    DefaultModelValidator.addViolation(problems, errOn30, ModelProblem.Version.V20, "io.quarkus.launcher.shaded.profiles.profile.id", null, "io.quarkus.launcher.shaded.must be unique but found duplicate profile with id " + profile.getId(), profile);
                }
                this.validate30RawProfileActivation(problems, profile.getActivation(), profile.getId(), prefix, "io.quarkus.launcher.shaded.activation", request);
                this.validate20RawDependencies(problems, profile.getDependencies(), prefix, "io.quarkus.launcher.shaded.dependencies.dependency.", request);
                if (profile.getDependencyManagement() != null) {
                    this.validate20RawDependencies(problems, profile.getDependencyManagement().getDependencies(), prefix, "io.quarkus.launcher.shaded.dependencyManagement.dependencies.dependency.", request);
                }
                this.validateRawRepositories(problems, profile.getRepositories(), prefix, "io.quarkus.launcher.shaded.repositories.repository.", request);
                this.validateRawRepositories(problems, profile.getPluginRepositories(), prefix, "io.quarkus.launcher.shaded.pluginRepositories.pluginRepository.", request);
                BuildBase buildBase = profile.getBuild();
                if (buildBase == null) continue;
                this.validate20RawPlugins(problems, buildBase.getPlugins(), prefix, "io.quarkus.launcher.shaded.plugins.plugin.", request);
                PluginManagement mgmt = buildBase.getPluginManagement();
                if (mgmt == null) continue;
                this.validate20RawPlugins(problems, mgmt.getPlugins(), prefix, "io.quarkus.launcher.shaded.pluginManagement.plugins.plugin.", request);
            }
        }
    }

    private void validate30RawProfileActivation(ModelProblemCollector problems, Activation activation, String sourceHint, String prefix, String fieldName, ModelBuildingRequest request) {
        if (activation == null) {
            return;
        }
        ActivationFile file = activation.getFile();
        if (file != null) {
            boolean missing;
            String path;
            if (StringUtils.isNotEmpty(file.getExists())) {
                path = file.getExists();
                missing = false;
            } else if (StringUtils.isNotEmpty(file.getMissing())) {
                path = file.getMissing();
                missing = true;
            } else {
                return;
            }
            if (path.contains("io.quarkus.launcher.shaded.${project.basedir}")) {
                DefaultModelValidator.addViolation(problems, ModelProblem.Severity.WARNING, ModelProblem.Version.V30, prefix + fieldName + (missing ? "io.quarkus.launcher.shaded..file.missing" : "io.quarkus.launcher.shaded..file.exists"), null, "io.quarkus.launcher.shaded.Failed to interpolate file location " + path + "io.quarkus.launcher.shaded. for profile " + sourceHint + "io.quarkus.launcher.shaded.: ${project.basedir} expression not supported during profile activation, use ${basedir} instead", file.getLocation(missing ? "io.quarkus.launcher.shaded.missing" : "io.quarkus.launcher.shaded.exists"));
            } else if (this.hasProjectExpression(path)) {
                DefaultModelValidator.addViolation(problems, ModelProblem.Severity.WARNING, ModelProblem.Version.V30, prefix + fieldName + (missing ? "io.quarkus.launcher.shaded..file.missing" : "io.quarkus.launcher.shaded..file.exists"), null, "io.quarkus.launcher.shaded.Failed to interpolate file location " + path + "io.quarkus.launcher.shaded. for profile " + sourceHint + "io.quarkus.launcher.shaded.: ${project.*} expressions are not supported during profile activation", file.getLocation(missing ? "io.quarkus.launcher.shaded.missing" : "io.quarkus.launcher.shaded.exists"));
            }
        }
    }

    private void validate20RawPlugins(ModelProblemCollector problems, List<Plugin> plugins, String prefix, String prefix2, ModelBuildingRequest request) {
        ModelProblem.Severity errOn31 = DefaultModelValidator.getSeverity(request, 31);
        HashMap<String, Plugin> index = new HashMap<String, Plugin>();
        for (Plugin plugin : plugins) {
            String key;
            Plugin existing;
            if (plugin.getGroupId() == null || plugin.getGroupId() != null && plugin.getGroupId().trim().isEmpty()) {
                DefaultModelValidator.addViolation(problems, ModelProblem.Severity.FATAL, ModelProblem.Version.V20, prefix + prefix2 + "io.quarkus.launcher.shaded.(groupId:artifactId)", null, "io.quarkus.launcher.shaded.groupId of a plugin must be defined. ", plugin);
            }
            if (plugin.getArtifactId() == null || plugin.getArtifactId() != null && plugin.getArtifactId().trim().isEmpty()) {
                DefaultModelValidator.addViolation(problems, ModelProblem.Severity.FATAL, ModelProblem.Version.V20, prefix + prefix2 + "io.quarkus.launcher.shaded.(groupId:artifactId)", null, "io.quarkus.launcher.shaded.artifactId of a plugin must be defined. ", plugin);
            }
            if (plugin.getVersion() != null && plugin.getVersion().trim().isEmpty()) {
                DefaultModelValidator.addViolation(problems, ModelProblem.Severity.FATAL, ModelProblem.Version.V20, prefix + prefix2 + "io.quarkus.launcher.shaded.(groupId:artifactId)", null, "io.quarkus.launcher.shaded.version of a plugin must be defined. ", plugin);
            }
            if ((existing = (Plugin)index.get(key = plugin.getKey())) != null) {
                DefaultModelValidator.addViolation(problems, errOn31, ModelProblem.Version.V20, prefix + prefix2 + "io.quarkus.launcher.shaded.(groupId:artifactId)", null, "io.quarkus.launcher.shaded.must be unique but found duplicate declaration of plugin " + key, plugin);
            } else {
                index.put(key, plugin);
            }
            HashSet<String> executionIds = new HashSet<String>();
            for (PluginExecution exec : plugin.getExecutions()) {
                if (executionIds.add(exec.getId())) continue;
                DefaultModelValidator.addViolation(problems, ModelProblem.Severity.ERROR, ModelProblem.Version.V20, prefix + prefix2 + "io.quarkus.launcher.shaded.[" + plugin.getKey() + "io.quarkus.launcher.shaded.].executions.execution.id", null, "io.quarkus.launcher.shaded.must be unique but found duplicate execution with id " + exec.getId(), exec);
            }
        }
    }

    @Override
    public void validateEffectiveModel(Model m, ModelBuildingRequest request, ModelProblemCollector problems) {
        this.validateStringNotEmpty("io.quarkus.launcher.shaded.modelVersion", problems, ModelProblem.Severity.ERROR, ModelProblem.Version.BASE, m.getModelVersion(), m);
        this.validateId("io.quarkus.launcher.shaded.groupId", problems, m.getGroupId(), m);
        this.validateId("io.quarkus.launcher.shaded.artifactId", problems, m.getArtifactId(), m);
        this.validateStringNotEmpty("io.quarkus.launcher.shaded.packaging", problems, ModelProblem.Severity.ERROR, ModelProblem.Version.BASE, m.getPackaging(), m);
        if (!m.getModules().isEmpty()) {
            if (!"io.quarkus.launcher.shaded.pom".equals(m.getPackaging())) {
                DefaultModelValidator.addViolation(problems, ModelProblem.Severity.ERROR, ModelProblem.Version.BASE, "io.quarkus.launcher.shaded.packaging", null, "io.quarkus.launcher.shaded.with value '" + m.getPackaging() + "io.quarkus.launcher.shaded.' is invalid. Aggregator projects require 'pom' as packaging.", m);
            }
            int n = m.getModules().size();
            for (int i = 0; i < n; ++i) {
                String module = m.getModules().get(i);
                if (!StringUtils.isBlank(module)) continue;
                DefaultModelValidator.addViolation(problems, ModelProblem.Severity.ERROR, ModelProblem.Version.BASE, "io.quarkus.launcher.shaded.modules.module[" + i + "io.quarkus.launcher.shaded.]", null, "io.quarkus.launcher.shaded.has been specified without a path to the project directory.", m.getLocation("io.quarkus.launcher.shaded.modules"));
            }
        }
        this.validateStringNotEmpty("io.quarkus.launcher.shaded.version", problems, ModelProblem.Severity.ERROR, ModelProblem.Version.BASE, m.getVersion(), m);
        ModelProblem.Severity errOn30 = DefaultModelValidator.getSeverity(request, 30);
        this.validateEffectiveDependencies(problems, m, m.getDependencies(), false, request);
        DependencyManagement mgmt = m.getDependencyManagement();
        if (mgmt != null) {
            this.validateEffectiveDependencies(problems, m, mgmt.getDependencies(), true, request);
        }
        if (request.getValidationLevel() >= 20) {
            Reporting reporting;
            HashSet<String> modules = new HashSet<String>();
            int n = m.getModules().size();
            for (int i = 0; i < n; ++i) {
                String module = m.getModules().get(i);
                if (modules.add(module)) continue;
                DefaultModelValidator.addViolation(problems, ModelProblem.Severity.ERROR, ModelProblem.Version.V20, "io.quarkus.launcher.shaded.modules.module[" + i + "io.quarkus.launcher.shaded.]", null, "io.quarkus.launcher.shaded.specifies duplicate child module " + (String)module, m.getLocation("io.quarkus.launcher.shaded.modules"));
            }
            ModelProblem.Severity errOn31 = DefaultModelValidator.getSeverity(request, 31);
            this.validateBannedCharacters(EMPTY, "io.quarkus.launcher.shaded.version", problems, errOn31, ModelProblem.Version.V20, m.getVersion(), null, m, "io/quarkus/launcher/shaded/\\/:\"<>|?*");
            this.validate20ProperSnapshotVersion("io.quarkus.launcher.shaded.version", problems, errOn31, ModelProblem.Version.V20, m.getVersion(), null, m);
            Build build = m.getBuild();
            if (build != null) {
                for (Plugin plugin : build.getPlugins()) {
                    this.validateStringNotEmpty("io.quarkus.launcher.shaded.build.plugins.plugin.artifactId", problems, ModelProblem.Severity.ERROR, ModelProblem.Version.V20, plugin.getArtifactId(), plugin);
                    this.validateStringNotEmpty("io.quarkus.launcher.shaded.build.plugins.plugin.groupId", problems, ModelProblem.Severity.ERROR, ModelProblem.Version.V20, plugin.getGroupId(), plugin);
                    this.validate20PluginVersion("io.quarkus.launcher.shaded.build.plugins.plugin.version", problems, plugin.getVersion(), plugin.getKey(), plugin, request);
                    this.validateBoolean("io.quarkus.launcher.shaded.build.plugins.plugin.inherited", EMPTY, problems, errOn30, ModelProblem.Version.V20, plugin.getInherited(), plugin.getKey(), plugin);
                    this.validateBoolean("io.quarkus.launcher.shaded.build.plugins.plugin.extensions", EMPTY, problems, errOn30, ModelProblem.Version.V20, plugin.getExtensions(), plugin.getKey(), plugin);
                    this.validate20EffectivePluginDependencies(problems, plugin, request);
                }
                this.validate20RawResources(problems, build.getResources(), "io.quarkus.launcher.shaded.build.resources.resource.", request);
                this.validate20RawResources(problems, build.getTestResources(), "io.quarkus.launcher.shaded.build.testResources.testResource.", request);
            }
            if ((reporting = m.getReporting()) != null) {
                for (ReportPlugin p : reporting.getPlugins()) {
                    this.validateStringNotEmpty("io.quarkus.launcher.shaded.reporting.plugins.plugin.artifactId", problems, ModelProblem.Severity.ERROR, ModelProblem.Version.V20, p.getArtifactId(), p);
                    this.validateStringNotEmpty("io.quarkus.launcher.shaded.reporting.plugins.plugin.groupId", problems, ModelProblem.Severity.ERROR, ModelProblem.Version.V20, p.getGroupId(), p);
                }
            }
            for (Repository repository : m.getRepositories()) {
                this.validate20EffectiveRepository(problems, repository, "io.quarkus.launcher.shaded.repositories.repository.", request);
            }
            for (Repository repository : m.getPluginRepositories()) {
                this.validate20EffectiveRepository(problems, repository, "io.quarkus.launcher.shaded.pluginRepositories.pluginRepository.", request);
            }
            DistributionManagement distributionManagement = m.getDistributionManagement();
            if (distributionManagement != null) {
                if (distributionManagement.getStatus() != null) {
                    DefaultModelValidator.addViolation(problems, ModelProblem.Severity.ERROR, ModelProblem.Version.V20, "io.quarkus.launcher.shaded.distributionManagement.status", null, "io.quarkus.launcher.shaded.must not be specified.", distributionManagement);
                }
                this.validate20EffectiveRepository(problems, distributionManagement.getRepository(), "io.quarkus.launcher.shaded.distributionManagement.repository.", request);
                this.validate20EffectiveRepository(problems, distributionManagement.getSnapshotRepository(), "io.quarkus.launcher.shaded.distributionManagement.snapshotRepository.", request);
            }
        }
    }

    private void validate20RawDependencies(ModelProblemCollector problems, List<Dependency> dependencies, String prefix, String prefix2, ModelBuildingRequest request) {
        ModelProblem.Severity errOn30 = DefaultModelValidator.getSeverity(request, 30);
        ModelProblem.Severity errOn31 = DefaultModelValidator.getSeverity(request, 31);
        HashMap<String, Dependency> index = new HashMap<String, Dependency>();
        for (Dependency dependency : dependencies) {
            Dependency existing;
            String key = dependency.getManagementKey();
            if ("io.quarkus.launcher.shaded.import".equals(dependency.getScope())) {
                if (!"io.quarkus.launcher.shaded.pom".equals(dependency.getType())) {
                    DefaultModelValidator.addViolation(problems, ModelProblem.Severity.WARNING, ModelProblem.Version.V20, prefix + prefix2 + "io.quarkus.launcher.shaded.type", key, "io.quarkus.launcher.shaded.must be 'pom' to import the managed dependencies.", dependency);
                } else if (StringUtils.isNotEmpty(dependency.getClassifier())) {
                    DefaultModelValidator.addViolation(problems, errOn30, ModelProblem.Version.V20, prefix + prefix2 + "io.quarkus.launcher.shaded.classifier", key, "io.quarkus.launcher.shaded.must be empty, imported POM cannot have a classifier.", dependency);
                }
            } else if ("io.quarkus.launcher.shaded.system".equals(dependency.getScope())) {
                String sysPath;
                if (request.getValidationLevel() >= 31) {
                    DefaultModelValidator.addViolation(problems, ModelProblem.Severity.WARNING, ModelProblem.Version.V31, prefix + prefix2 + "io.quarkus.launcher.shaded.scope", key, "io.quarkus.launcher.shaded.declares usage of deprecated 'system' scope ", dependency);
                }
                if (StringUtils.isNotEmpty(sysPath = dependency.getSystemPath())) {
                    if (!this.hasExpression(sysPath)) {
                        DefaultModelValidator.addViolation(problems, ModelProblem.Severity.WARNING, ModelProblem.Version.V20, prefix + prefix2 + "io.quarkus.launcher.shaded.systemPath", key, "io.quarkus.launcher.shaded.should use a variable instead of a hard-coded path " + sysPath, dependency);
                    } else if (sysPath.contains("io.quarkus.launcher.shaded.${basedir}") || sysPath.contains("io.quarkus.launcher.shaded.${project.basedir}")) {
                        DefaultModelValidator.addViolation(problems, ModelProblem.Severity.WARNING, ModelProblem.Version.V20, prefix + prefix2 + "io.quarkus.launcher.shaded.systemPath", key, "io.quarkus.launcher.shaded.should not point at files within the project directory, " + sysPath + "io.quarkus.launcher.shaded. will be unresolvable by dependent projects", dependency);
                    }
                }
            }
            if (DefaultModelValidator.equals("io.quarkus.launcher.shaded.LATEST", dependency.getVersion()) || DefaultModelValidator.equals("io.quarkus.launcher.shaded.RELEASE", dependency.getVersion())) {
                DefaultModelValidator.addViolation(problems, ModelProblem.Severity.WARNING, ModelProblem.Version.BASE, prefix + prefix2 + "io.quarkus.launcher.shaded.version", key, "io.quarkus.launcher.shaded.is either LATEST or RELEASE (both of them are being deprecated)", dependency);
            }
            if ((existing = (Dependency)index.get(key)) != null) {
                String msg = DefaultModelValidator.equals(existing.getVersion(), dependency.getVersion()) ? "io.quarkus.launcher.shaded.duplicate declaration of version " + StringUtils.defaultString(dependency.getVersion(), "io.quarkus.launcher.shaded.(?)") : "io.quarkus.launcher.shaded.version " + StringUtils.defaultString(existing.getVersion(), "io.quarkus.launcher.shaded.(?)") + "io.quarkus.launcher.shaded. vs " + StringUtils.defaultString(dependency.getVersion(), "io.quarkus.launcher.shaded.(?)");
                DefaultModelValidator.addViolation(problems, errOn31, ModelProblem.Version.V20, prefix + prefix2 + "io.quarkus.launcher.shaded.(groupId:artifactId:type:classifier)", null, "io.quarkus.launcher.shaded.must be unique: " + key + "io.quarkus.launcher.shaded. -> " + msg, dependency);
                continue;
            }
            index.put(key, dependency);
        }
    }

    private void validate20RawDependenciesSelfReferencing(ModelProblemCollector problems, Model m, List<Dependency> dependencies, String prefix, ModelBuildingRequest request) {
        for (Dependency dependency : dependencies) {
            String mKey;
            String key = dependency.getGroupId() + "io.quarkus.launcher.shaded.:" + dependency.getArtifactId() + "io.quarkus.launcher.shaded.:" + dependency.getVersion() + (dependency.getClassifier() != null ? "io.quarkus.launcher.shaded.:" + dependency.getClassifier() : EMPTY);
            if (!key.equals(mKey = m.getGroupId() + "io.quarkus.launcher.shaded.:" + m.getArtifactId() + "io.quarkus.launcher.shaded.:" + m.getVersion())) continue;
            DefaultModelValidator.addViolation(problems, ModelProblem.Severity.FATAL, ModelProblem.Version.V31, prefix + "io.quarkus.launcher.shaded.[" + key + "io.quarkus.launcher.shaded.]", key, "io.quarkus.launcher.shaded.is referencing itself.", dependency);
        }
    }

    private void validateEffectiveDependencies(ModelProblemCollector problems, Model m, List<Dependency> dependencies, boolean management, ModelBuildingRequest request) {
        ModelProblem.Severity errOn30 = DefaultModelValidator.getSeverity(request, 30);
        String prefix = management ? "io.quarkus.launcher.shaded.dependencyManagement.dependencies.dependency." : "io.quarkus.launcher.shaded.dependencies.dependency.";
        for (Dependency d : dependencies) {
            this.validateEffectiveDependency(problems, d, management, prefix, request);
            if (request.getValidationLevel() < 20) continue;
            this.validateBoolean(prefix, "io.quarkus.launcher.shaded.optional", problems, errOn30, ModelProblem.Version.V20, d.getOptional(), d.getManagementKey(), d);
            if (!management) {
                this.validateVersion(prefix, "io.quarkus.launcher.shaded.version", problems, errOn30, ModelProblem.Version.V20, d.getVersion(), d.getManagementKey(), d);
                this.validateEnum(prefix, "io.quarkus.launcher.shaded.scope", problems, ModelProblem.Severity.WARNING, ModelProblem.Version.V20, d.getScope(), d.getManagementKey(), d, "io.quarkus.launcher.shaded.provided", "io.quarkus.launcher.shaded.compile", "io.quarkus.launcher.shaded.runtime", "io.quarkus.launcher.shaded.test", "io.quarkus.launcher.shaded.system");
                this.validateEffectiveModelAgainstDependency(prefix, problems, m, d, request);
                continue;
            }
            this.validateEnum(prefix, "io.quarkus.launcher.shaded.scope", problems, ModelProblem.Severity.WARNING, ModelProblem.Version.V20, d.getScope(), d.getManagementKey(), d, "io.quarkus.launcher.shaded.provided", "io.quarkus.launcher.shaded.compile", "io.quarkus.launcher.shaded.runtime", "io.quarkus.launcher.shaded.test", "io.quarkus.launcher.shaded.system", "io.quarkus.launcher.shaded.import");
        }
    }

    private void validateEffectiveModelAgainstDependency(String prefix, ModelProblemCollector problems, Model m, Dependency d, ModelBuildingRequest request) {
        String mKey;
        String key = d.getGroupId() + "io.quarkus.launcher.shaded.:" + d.getArtifactId() + "io.quarkus.launcher.shaded.:" + d.getVersion() + (d.getClassifier() != null ? "io.quarkus.launcher.shaded.:" + d.getClassifier() : EMPTY);
        if (key.equals(mKey = m.getGroupId() + "io.quarkus.launcher.shaded.:" + m.getArtifactId() + "io.quarkus.launcher.shaded.:" + m.getVersion())) {
            DefaultModelValidator.addViolation(problems, ModelProblem.Severity.FATAL, ModelProblem.Version.V31, prefix + "io.quarkus.launcher.shaded.[" + key + "io.quarkus.launcher.shaded.]", key, "io.quarkus.launcher.shaded.is referencing itself.", d);
        }
    }

    private void validate20EffectivePluginDependencies(ModelProblemCollector problems, Plugin plugin, ModelBuildingRequest request) {
        List<Dependency> dependencies = plugin.getDependencies();
        if (!dependencies.isEmpty()) {
            String prefix = "io.quarkus.launcher.shaded.build.plugins.plugin[" + plugin.getKey() + "io.quarkus.launcher.shaded.].dependencies.dependency.";
            ModelProblem.Severity errOn30 = DefaultModelValidator.getSeverity(request, 30);
            for (Dependency d : dependencies) {
                this.validateEffectiveDependency(problems, d, false, prefix, request);
                this.validateVersion(prefix, "io.quarkus.launcher.shaded.version", problems, errOn30, ModelProblem.Version.BASE, d.getVersion(), d.getManagementKey(), d);
                this.validateEnum(prefix, "io.quarkus.launcher.shaded.scope", problems, errOn30, ModelProblem.Version.BASE, d.getScope(), d.getManagementKey(), d, "io.quarkus.launcher.shaded.compile", "io.quarkus.launcher.shaded.runtime", "io.quarkus.launcher.shaded.system");
            }
        }
    }

    private void validateEffectiveDependency(ModelProblemCollector problems, Dependency d, boolean management, String prefix, ModelBuildingRequest request) {
        this.validateId(prefix, "io.quarkus.launcher.shaded.artifactId", problems, ModelProblem.Severity.ERROR, ModelProblem.Version.BASE, d.getArtifactId(), d.getManagementKey(), d);
        this.validateId(prefix, "io.quarkus.launcher.shaded.groupId", problems, ModelProblem.Severity.ERROR, ModelProblem.Version.BASE, d.getGroupId(), d.getManagementKey(), d);
        if (!management) {
            this.validateStringNotEmpty(prefix, "io.quarkus.launcher.shaded.type", problems, ModelProblem.Severity.ERROR, ModelProblem.Version.BASE, d.getType(), d.getManagementKey(), d);
            this.validateDependencyVersion(problems, d, prefix);
        }
        if ("io.quarkus.launcher.shaded.system".equals(d.getScope())) {
            String systemPath = d.getSystemPath();
            if (StringUtils.isEmpty(systemPath)) {
                DefaultModelValidator.addViolation(problems, ModelProblem.Severity.ERROR, ModelProblem.Version.BASE, prefix + "io.quarkus.launcher.shaded.systemPath", d.getManagementKey(), "io.quarkus.launcher.shaded.is missing.", d);
            } else {
                File sysFile = new File(systemPath);
                if (!sysFile.isAbsolute()) {
                    DefaultModelValidator.addViolation(problems, ModelProblem.Severity.ERROR, ModelProblem.Version.BASE, prefix + "io.quarkus.launcher.shaded.systemPath", d.getManagementKey(), "io.quarkus.launcher.shaded.must specify an absolute path but is " + systemPath, d);
                } else if (!sysFile.isFile()) {
                    String jdkHome;
                    String msg = "io.quarkus.launcher.shaded.refers to a non-existing file " + sysFile.getAbsolutePath();
                    if ((systemPath = systemPath.replace('/', File.separatorChar).replace('\\', File.separatorChar)).startsWith(jdkHome = request.getSystemProperties().getProperty("io/quarkus/launcher/shaded/java.home", EMPTY) + File.separator + "io.quarkus.launcher.shaded...")) {
                        msg = msg + "io.quarkus.launcher.shaded.. Please verify that you run Maven using a JDK and not just a JRE.";
                    }
                    DefaultModelValidator.addViolation(problems, ModelProblem.Severity.WARNING, ModelProblem.Version.BASE, prefix + "io.quarkus.launcher.shaded.systemPath", d.getManagementKey(), msg, d);
                }
            }
        } else if (StringUtils.isNotEmpty(d.getSystemPath())) {
            DefaultModelValidator.addViolation(problems, ModelProblem.Severity.ERROR, ModelProblem.Version.BASE, prefix + "io.quarkus.launcher.shaded.systemPath", d.getManagementKey(), "io.quarkus.launcher.shaded.must be omitted. This field may only be specified for a dependency with system scope.", d);
        }
        if (request.getValidationLevel() >= 20) {
            for (Exclusion exclusion : d.getExclusions()) {
                if (request.getValidationLevel() < 30) {
                    this.validateId(prefix, "io.quarkus.launcher.shaded.exclusions.exclusion.groupId", problems, ModelProblem.Severity.WARNING, ModelProblem.Version.V20, exclusion.getGroupId(), d.getManagementKey(), exclusion);
                    this.validateId(prefix, "io.quarkus.launcher.shaded.exclusions.exclusion.artifactId", problems, ModelProblem.Severity.WARNING, ModelProblem.Version.V20, exclusion.getArtifactId(), d.getManagementKey(), exclusion);
                    continue;
                }
                this.validateIdWithWildcards(prefix, "io.quarkus.launcher.shaded.exclusions.exclusion.groupId", problems, ModelProblem.Severity.WARNING, ModelProblem.Version.V30, exclusion.getGroupId(), d.getManagementKey(), exclusion);
                this.validateIdWithWildcards(prefix, "io.quarkus.launcher.shaded.exclusions.exclusion.artifactId", problems, ModelProblem.Severity.WARNING, ModelProblem.Version.V30, exclusion.getArtifactId(), d.getManagementKey(), exclusion);
            }
        }
    }

    protected void validateDependencyVersion(ModelProblemCollector problems, Dependency d, String prefix) {
        this.validateStringNotEmpty(prefix, "io.quarkus.launcher.shaded.version", problems, ModelProblem.Severity.ERROR, ModelProblem.Version.BASE, d.getVersion(), d.getManagementKey(), d);
    }

    private void validateRawRepositories(ModelProblemCollector problems, List<Repository> repositories, String prefix, String prefix2, ModelBuildingRequest request) {
        HashMap<String, Repository> index = new HashMap<String, Repository>();
        for (Repository repository : repositories) {
            this.validateStringNotEmpty(prefix, prefix2, "io.quarkus.launcher.shaded.id", problems, ModelProblem.Severity.ERROR, ModelProblem.Version.V20, repository.getId(), null, repository);
            this.validateStringNotEmpty(prefix, prefix2, "io.quarkus.launcher.shaded.[" + repository.getId() + "io.quarkus.launcher.shaded.].url", problems, ModelProblem.Severity.ERROR, ModelProblem.Version.V20, repository.getUrl(), null, repository);
            String key = repository.getId();
            Repository existing = (Repository)index.get(key);
            if (existing != null) {
                ModelProblem.Severity errOn30 = DefaultModelValidator.getSeverity(request, 30);
                DefaultModelValidator.addViolation(problems, errOn30, ModelProblem.Version.V20, prefix + prefix2 + "io.quarkus.launcher.shaded.id", null, "io.quarkus.launcher.shaded.must be unique: " + repository.getId() + "io.quarkus.launcher.shaded. -> " + existing.getUrl() + "io.quarkus.launcher.shaded. vs " + repository.getUrl(), repository);
                continue;
            }
            index.put(key, repository);
        }
    }

    private void validate20EffectiveRepository(ModelProblemCollector problems, Repository repository, String prefix, ModelBuildingRequest request) {
        if (repository != null) {
            ModelProblem.Severity errOn31 = DefaultModelValidator.getSeverity(request, 31);
            this.validateBannedCharacters(prefix, "io.quarkus.launcher.shaded.id", problems, errOn31, ModelProblem.Version.V20, repository.getId(), null, repository, "io/quarkus/launcher/shaded/\\/:\"<>|?*");
            if ("io.quarkus.launcher.shaded.local".equals(repository.getId())) {
                DefaultModelValidator.addViolation(problems, errOn31, ModelProblem.Version.V20, prefix + "io.quarkus.launcher.shaded.id", null, "io.quarkus.launcher.shaded.must not be 'local', this identifier is reserved for the local repository, using it for other repositories will corrupt your repository metadata.", repository);
            }
            if ("io.quarkus.launcher.shaded.legacy".equals(repository.getLayout())) {
                DefaultModelValidator.addViolation(problems, ModelProblem.Severity.WARNING, ModelProblem.Version.V20, prefix + "io.quarkus.launcher.shaded.layout", repository.getId(), "io.quarkus.launcher.shaded.uses the unsupported value 'legacy', artifact resolution might fail.", repository);
            }
        }
    }

    private void validate20RawResources(ModelProblemCollector problems, List<Resource> resources, String prefix, ModelBuildingRequest request) {
        ModelProblem.Severity errOn30 = DefaultModelValidator.getSeverity(request, 30);
        for (Resource resource : resources) {
            this.validateStringNotEmpty(prefix, "io.quarkus.launcher.shaded.directory", problems, ModelProblem.Severity.ERROR, ModelProblem.Version.V20, resource.getDirectory(), null, resource);
            this.validateBoolean(prefix, "io.quarkus.launcher.shaded.filtering", problems, errOn30, ModelProblem.Version.V20, resource.getFiltering(), resource.getDirectory(), resource);
        }
    }

    private boolean validateId(String fieldName, ModelProblemCollector problems, String id, InputLocationTracker tracker) {
        return this.validateId(EMPTY, fieldName, problems, ModelProblem.Severity.ERROR, ModelProblem.Version.BASE, id, null, tracker);
    }

    private boolean validateId(String prefix, String fieldName, ModelProblemCollector problems, ModelProblem.Severity severity, ModelProblem.Version version, String id, String sourceHint, InputLocationTracker tracker) {
        if (this.validIds.contains(id)) {
            return true;
        }
        if (!this.validateStringNotEmpty(prefix, fieldName, problems, severity, version, id, sourceHint, tracker)) {
            return false;
        }
        if (!this.isValidId(id)) {
            DefaultModelValidator.addViolation(problems, severity, version, prefix + fieldName, sourceHint, "io.quarkus.launcher.shaded.with value '" + id + "io.quarkus.launcher.shaded.' does not match a valid id pattern.", tracker);
            return false;
        }
        this.validIds.add(id);
        return true;
    }

    private boolean isValidId(String id) {
        for (int i = 0; i < id.length(); ++i) {
            char c = id.charAt(i);
            if (this.isValidIdCharacter(c)) continue;
            return false;
        }
        return true;
    }

    private boolean isValidIdCharacter(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '-' || c == '_' || c == '.';
    }

    private boolean validateIdWithWildcards(String prefix, String fieldName, ModelProblemCollector problems, ModelProblem.Severity severity, ModelProblem.Version version, String id, String sourceHint, InputLocationTracker tracker) {
        if (!this.validateStringNotEmpty(prefix, fieldName, problems, severity, version, id, sourceHint, tracker)) {
            return false;
        }
        if (!this.isValidIdWithWildCards(id)) {
            DefaultModelValidator.addViolation(problems, severity, version, prefix + fieldName, sourceHint, "io.quarkus.launcher.shaded.with value '" + id + "io.quarkus.launcher.shaded.' does not match a valid id pattern.", tracker);
            return false;
        }
        return true;
    }

    private boolean isValidIdWithWildCards(String id) {
        for (int i = 0; i < id.length(); ++i) {
            char c = id.charAt(i);
            if (this.isValidIdWithWildCardCharacter(c)) continue;
            return false;
        }
        return true;
    }

    private boolean isValidIdWithWildCardCharacter(char c) {
        return this.isValidIdCharacter(c) || c == '?' || c == '*';
    }

    private boolean validateStringNoExpression(String fieldName, ModelProblemCollector problems, ModelProblem.Severity severity, ModelProblem.Version version, String string, InputLocationTracker tracker) {
        if (!this.hasExpression(string)) {
            return true;
        }
        DefaultModelValidator.addViolation(problems, severity, version, fieldName, null, "io.quarkus.launcher.shaded.contains an expression but should be a constant.", tracker);
        return false;
    }

    private boolean validateVersionNoExpression(String fieldName, ModelProblemCollector problems, ModelProblem.Severity severity, ModelProblem.Version version, String string, InputLocationTracker tracker) {
        if (!this.hasExpression(string)) {
            return true;
        }
        Matcher m = CI_FRIENDLY_EXPRESSION.matcher(string.trim());
        while (m.find()) {
            if (CI_FRIENDLY_POSSIBLE_PROPERTY_NAMES.contains(m.group(1))) continue;
            DefaultModelValidator.addViolation(problems, severity, version, fieldName, null, "io.quarkus.launcher.shaded.contains an expression but should be a constant.", tracker);
            return false;
        }
        return true;
    }

    private boolean hasExpression(String value) {
        return value != null && value.contains("io.quarkus.launcher.shaded.${");
    }

    private boolean hasProjectExpression(String value) {
        return value != null && value.contains("io.quarkus.launcher.shaded.${project.");
    }

    private boolean validateStringNotEmpty(String fieldName, ModelProblemCollector problems, ModelProblem.Severity severity, ModelProblem.Version version, String string, InputLocationTracker tracker) {
        return this.validateStringNotEmpty(EMPTY, fieldName, problems, severity, version, string, null, tracker);
    }

    private boolean validateStringNotEmpty(String prefix, String prefix2, String fieldName, ModelProblemCollector problems, ModelProblem.Severity severity, ModelProblem.Version version, String string, String sourceHint, InputLocationTracker tracker) {
        if (!this.validateNotNull(prefix, prefix2, fieldName, problems, severity, version, string, sourceHint, tracker)) {
            return false;
        }
        if (!string.isEmpty()) {
            return true;
        }
        DefaultModelValidator.addViolation(problems, severity, version, prefix + prefix2 + fieldName, sourceHint, "io.quarkus.launcher.shaded.is missing.", tracker);
        return false;
    }

    private boolean validateStringNotEmpty(String prefix, String fieldName, ModelProblemCollector problems, ModelProblem.Severity severity, ModelProblem.Version version, String string, String sourceHint, InputLocationTracker tracker) {
        if (!this.validateNotNull(prefix, fieldName, problems, severity, version, string, sourceHint, tracker)) {
            return false;
        }
        if (string.length() > 0) {
            return true;
        }
        DefaultModelValidator.addViolation(problems, severity, version, prefix + fieldName, sourceHint, "io.quarkus.launcher.shaded.is missing.", tracker);
        return false;
    }

    private boolean validateNotNull(String prefix, String fieldName, ModelProblemCollector problems, ModelProblem.Severity severity, ModelProblem.Version version, Object object, String sourceHint, InputLocationTracker tracker) {
        if (object != null) {
            return true;
        }
        DefaultModelValidator.addViolation(problems, severity, version, prefix + fieldName, sourceHint, "io.quarkus.launcher.shaded.is missing.", tracker);
        return false;
    }

    private boolean validateNotNull(String prefix, String prefix2, String fieldName, ModelProblemCollector problems, ModelProblem.Severity severity, ModelProblem.Version version, Object object, String sourceHint, InputLocationTracker tracker) {
        if (object != null) {
            return true;
        }
        DefaultModelValidator.addViolation(problems, severity, version, prefix + prefix2 + fieldName, sourceHint, "io.quarkus.launcher.shaded.is missing.", tracker);
        return false;
    }

    private boolean validateBoolean(String prefix, String fieldName, ModelProblemCollector problems, ModelProblem.Severity severity, ModelProblem.Version version, String string, String sourceHint, InputLocationTracker tracker) {
        if (string == null || string.length() <= 0) {
            return true;
        }
        if ("io.quarkus.launcher.shaded.true".equalsIgnoreCase(string) || "io.quarkus.launcher.shaded.false".equalsIgnoreCase(string)) {
            return true;
        }
        DefaultModelValidator.addViolation(problems, severity, version, prefix + fieldName, sourceHint, "io.quarkus.launcher.shaded.must be 'true' or 'false' but is '" + string + "io.quarkus.launcher.shaded.'.", tracker);
        return false;
    }

    private boolean validateEnum(String prefix, String fieldName, ModelProblemCollector problems, ModelProblem.Severity severity, ModelProblem.Version version, String string, String sourceHint, InputLocationTracker tracker, String ... validValues) {
        if (string == null || string.length() <= 0) {
            return true;
        }
        List<String> values = Arrays.asList(validValues);
        if (values.contains(string)) {
            return true;
        }
        DefaultModelValidator.addViolation(problems, severity, version, prefix + fieldName, sourceHint, "io.quarkus.launcher.shaded.must be one of " + values + "io.quarkus.launcher.shaded. but is '" + string + "io.quarkus.launcher.shaded.'.", tracker);
        return false;
    }

    private boolean validateModelVersion(ModelProblemCollector problems, String string, InputLocationTracker tracker, String ... validVersions) {
        if (string == null || string.length() <= 0) {
            return true;
        }
        List<String> values = Arrays.asList(validVersions);
        if (values.contains(string)) {
            return true;
        }
        boolean newerThanAll = true;
        boolean olderThanAll = true;
        for (String validValue : validVersions) {
            int comparison = DefaultModelValidator.compareModelVersions(validValue, string);
            newerThanAll = newerThanAll && comparison < 0;
            olderThanAll = olderThanAll && comparison > 0;
        }
        if (newerThanAll) {
            DefaultModelValidator.addViolation(problems, ModelProblem.Severity.FATAL, ModelProblem.Version.V20, "io.quarkus.launcher.shaded.modelVersion", null, "io.quarkus.launcher.shaded.of '" + string + "io.quarkus.launcher.shaded.' is newer than the versions supported by this version of Maven: " + values + "io.quarkus.launcher.shaded.. Building this project requires a newer version of Maven.", tracker);
        } else if (olderThanAll) {
            DefaultModelValidator.addViolation(problems, ModelProblem.Severity.FATAL, ModelProblem.Version.V20, "io.quarkus.launcher.shaded.modelVersion", null, "io.quarkus.launcher.shaded.of '" + string + "io.quarkus.launcher.shaded.' is older than the versions supported by this version of Maven: " + values + "io.quarkus.launcher.shaded.. Building this project requires an older version of Maven.", tracker);
        } else {
            DefaultModelValidator.addViolation(problems, ModelProblem.Severity.ERROR, ModelProblem.Version.V20, "io.quarkus.launcher.shaded.modelVersion", null, "io.quarkus.launcher.shaded.must be one of " + values + "io.quarkus.launcher.shaded. but is '" + string + "io.quarkus.launcher.shaded.'.", tracker);
        }
        return false;
    }

    private static int compareModelVersions(String first, String second) {
        String[] firstSegments = StringUtils.split(first, "io.quarkus.launcher.shaded..");
        String[] secondSegments = StringUtils.split(second, "io.quarkus.launcher.shaded..");
        for (int i = 0; i < Math.min(firstSegments.length, secondSegments.length); ++i) {
            int result = Long.valueOf(firstSegments[i]).compareTo(Long.valueOf(secondSegments[i]));
            if (result == 0) continue;
            return result;
        }
        if (firstSegments.length == secondSegments.length) {
            return 0;
        }
        return firstSegments.length > secondSegments.length ? -1 : 1;
    }

    private boolean validateBannedCharacters(String prefix, String fieldName, ModelProblemCollector problems, ModelProblem.Severity severity, ModelProblem.Version version, String string, String sourceHint, InputLocationTracker tracker, String banned) {
        if (string != null) {
            for (int i = string.length() - 1; i >= 0; --i) {
                if (banned.indexOf(string.charAt(i)) < 0) continue;
                DefaultModelValidator.addViolation(problems, severity, version, prefix + fieldName, sourceHint, "io.quarkus.launcher.shaded.must not contain any of these characters " + banned + "io.quarkus.launcher.shaded. but found " + string.charAt(i), tracker);
                return false;
            }
        }
        return true;
    }

    private boolean validateVersion(String prefix, String fieldName, ModelProblemCollector problems, ModelProblem.Severity severity, ModelProblem.Version version, String string, String sourceHint, InputLocationTracker tracker) {
        if (string == null || string.length() <= 0) {
            return true;
        }
        if (this.hasExpression(string)) {
            DefaultModelValidator.addViolation(problems, severity, version, prefix + fieldName, sourceHint, "io.quarkus.launcher.shaded.must be a valid version but is '" + string + "io.quarkus.launcher.shaded.'.", tracker);
            return false;
        }
        return this.validateBannedCharacters(prefix, fieldName, problems, severity, version, string, sourceHint, tracker, "io/quarkus/launcher/shaded/\\/:\"<>|?*");
    }

    private boolean validate20ProperSnapshotVersion(String fieldName, ModelProblemCollector problems, ModelProblem.Severity severity, ModelProblem.Version version, String string, String sourceHint, InputLocationTracker tracker) {
        if (string == null || string.length() <= 0) {
            return true;
        }
        if (string.endsWith("io.quarkus.launcher.shaded.SNAPSHOT") && !string.endsWith("io.quarkus.launcher.shaded.-SNAPSHOT")) {
            DefaultModelValidator.addViolation(problems, severity, version, fieldName, sourceHint, "io.quarkus.launcher.shaded.uses an unsupported snapshot version format, should be '*-SNAPSHOT' instead.", tracker);
            return false;
        }
        return true;
    }

    private boolean validate20PluginVersion(String fieldName, ModelProblemCollector problems, String string, String sourceHint, InputLocationTracker tracker, ModelBuildingRequest request) {
        if (string == null) {
            return true;
        }
        ModelProblem.Severity errOn30 = DefaultModelValidator.getSeverity(request, 30);
        if (!this.validateVersion(EMPTY, fieldName, problems, errOn30, ModelProblem.Version.V20, string, sourceHint, tracker)) {
            return false;
        }
        if (string.length() <= 0 || "io.quarkus.launcher.shaded.RELEASE".equals(string) || "io.quarkus.launcher.shaded.LATEST".equals(string)) {
            DefaultModelValidator.addViolation(problems, errOn30, ModelProblem.Version.V20, fieldName, sourceHint, "io.quarkus.launcher.shaded.must be a valid version but is '" + string + "io.quarkus.launcher.shaded.'.", tracker);
            return false;
        }
        return true;
    }

    private static void addViolation(ModelProblemCollector problems, ModelProblem.Severity severity, ModelProblem.Version version, String fieldName, String sourceHint, String message, InputLocationTracker tracker) {
        StringBuilder buffer = new StringBuilder(256);
        buffer.append('\'').append(fieldName).append('\'');
        if (sourceHint != null) {
            buffer.append("io.quarkus.launcher.shaded. for ").append(sourceHint);
        }
        buffer.append(' ').append(message);
        problems.add(new ModelProblemCollectorRequest(severity, version).setMessage(buffer.toString()).setLocation(DefaultModelValidator.getLocation(fieldName, tracker)));
    }

    private static InputLocation getLocation(String fieldName, InputLocationTracker tracker) {
        InputLocation location = null;
        if (tracker != null) {
            if (fieldName != null) {
                Object key = fieldName;
                int idx = fieldName.lastIndexOf(46);
                if (idx >= 0) {
                    fieldName = fieldName.substring(idx + 1);
                    key = fieldName;
                }
                if (fieldName.endsWith("io.quarkus.launcher.shaded.]")) {
                    key = fieldName.substring(fieldName.lastIndexOf(91) + 1, fieldName.length() - 1);
                    try {
                        key = Integer.valueOf(key.toString());
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                location = tracker.getLocation(key);
            }
            if (location == null) {
                location = tracker.getLocation(EMPTY);
            }
        }
        return location;
    }

    private static boolean equals(String s1, String s2) {
        return StringUtils.clean(s1).equals(StringUtils.clean(s2));
    }

    private static ModelProblem.Severity getSeverity(ModelBuildingRequest request, int errorThreshold) {
        return DefaultModelValidator.getSeverity(request.getValidationLevel(), errorThreshold);
    }

    private static ModelProblem.Severity getSeverity(int validationLevel, int errorThreshold) {
        if (validationLevel < errorThreshold) {
            return ModelProblem.Severity.WARNING;
        }
        return ModelProblem.Severity.ERROR;
    }
}

