/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.maven.plugin;

import io.quarkus.launcher.shaded.org.apache.maven.plugin.descriptor.MojoDescriptor;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.descriptor.PluginDescriptor;
import java.util.Iterator;
import java.util.List;

public class MojoNotFoundException
extends Exception {
    private String goal;
    private PluginDescriptor pluginDescriptor;

    public MojoNotFoundException(String goal, PluginDescriptor pluginDescriptor) {
        super(MojoNotFoundException.toMessage(goal, pluginDescriptor));
        this.goal = goal;
        this.pluginDescriptor = pluginDescriptor;
    }

    public String getGoal() {
        return this.goal;
    }

    public PluginDescriptor getPluginDescriptor() {
        return this.pluginDescriptor;
    }

    private static String toMessage(String goal, PluginDescriptor pluginDescriptor) {
        StringBuilder buffer = new StringBuilder(256);
        buffer.append("io.quarkus.launcher.shaded.Could not find goal '").append(goal).append('\'');
        if (pluginDescriptor != null) {
            buffer.append("io.quarkus.launcher.shaded. in plugin ").append(pluginDescriptor.getId());
            buffer.append("io.quarkus.launcher.shaded. among available goals ");
            List<MojoDescriptor> mojos = pluginDescriptor.getMojos();
            if (mojos != null) {
                Iterator<MojoDescriptor> it = mojos.iterator();
                while (it.hasNext()) {
                    MojoDescriptor mojo = it.next();
                    if (mojo != null) {
                        buffer.append(mojo.getGoal());
                    }
                    if (!it.hasNext()) continue;
                    buffer.append("io.quarkus.launcher.shaded., ");
                }
            }
        }
        return buffer.toString();
    }
}

