/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.maven.plugin;

import io.quarkus.launcher.shaded.org.apache.maven.plugin.PluginConfigurationException;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.descriptor.MojoDescriptor;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.descriptor.Parameter;
import io.quarkus.launcher.shaded.org.codehaus.plexus.util.StringUtils;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class PluginParameterException
extends PluginConfigurationException {
    private final List<Parameter> parameters;
    private final MojoDescriptor mojo;

    public PluginParameterException(MojoDescriptor mojo, List<Parameter> parameters) {
        super(mojo.getPluginDescriptor(), "io.quarkus.launcher.shaded.The parameters " + PluginParameterException.format(parameters) + "io.quarkus.launcher.shaded. for goal " + mojo.getRoleHint() + "io.quarkus.launcher.shaded. are missing or invalid");
        this.mojo = mojo;
        this.parameters = parameters;
    }

    private static String format(List<Parameter> parameters) {
        StringBuilder buffer = new StringBuilder(128);
        if (parameters != null) {
            for (Parameter parameter : parameters) {
                if (buffer.length() > 0) {
                    buffer.append("io.quarkus.launcher.shaded., ");
                }
                buffer.append('\'').append(parameter.getName()).append('\'');
            }
        }
        return buffer.toString();
    }

    public MojoDescriptor getMojoDescriptor() {
        return this.mojo;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    private static void decomposeParameterIntoUserInstructions(MojoDescriptor mojo, Parameter param, StringBuilder messageBuffer) {
        String expression = param.getExpression();
        if (param.isEditable()) {
            boolean isArray = param.getType().endsWith("io.quarkus.launcher.shaded.[]");
            boolean isCollection = false;
            boolean isMap = false;
            boolean isProperties = false;
            if (!isArray) {
                try {
                    isCollection = Collection.class.isAssignableFrom(Class.forName(param.getType()));
                    isMap = Map.class.isAssignableFrom(Class.forName(param.getType()));
                    isProperties = Properties.class.isAssignableFrom(Class.forName(param.getType()));
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            messageBuffer.append("io.quarkus.launcher.shaded.Inside the definition for plugin '");
            messageBuffer.append(mojo.getPluginDescriptor().getArtifactId());
            messageBuffer.append("io.quarkus.launcher.shaded.', specify the following:\n\n<configuration>\n  ...\n");
            messageBuffer.append("io.quarkus.launcher.shaded.  <").append(param.getName()).append('>');
            if (isArray || isCollection) {
                messageBuffer.append('\n');
                messageBuffer.append("io.quarkus.launcher.shaded.    <item>");
            } else if (isProperties) {
                messageBuffer.append('\n');
                messageBuffer.append("io.quarkus.launcher.shaded.    <property>\n");
                messageBuffer.append("io/quarkus/launcher/shaded/      <name>KEY</name>\n");
                messageBuffer.append("io.quarkus.launcher.shaded.      <value>");
            } else if (isMap) {
                messageBuffer.append('\n');
                messageBuffer.append("io.quarkus.launcher.shaded.    <KEY>");
            }
            messageBuffer.append("io.quarkus.launcher.shaded.VALUE");
            if (isArray || isCollection) {
                messageBuffer.append("io/quarkus/launcher/shaded/</item>\n");
                messageBuffer.append("io.quarkus.launcher.shaded.  ");
            } else if (isProperties) {
                messageBuffer.append("io/quarkus/launcher/shaded/</value>\n");
                messageBuffer.append("io/quarkus/launcher/shaded/    </property>\n");
                messageBuffer.append("io.quarkus.launcher.shaded.  ");
            } else if (isMap) {
                messageBuffer.append("io/quarkus/launcher/shaded/</KEY>\n");
                messageBuffer.append("io.quarkus.launcher.shaded.  ");
            }
            messageBuffer.append("io/quarkus/launcher/shaded/</").append(param.getName()).append("io.quarkus.launcher.shaded.>\n");
            messageBuffer.append("io/quarkus/launcher/shaded/</configuration>");
            String alias = param.getAlias();
            if (StringUtils.isNotEmpty(alias) && !alias.equals(param.getName())) {
                messageBuffer.append("io.quarkus.launcher.shaded.\n\n-OR-\n\n<configuration>\n  ...\n  <").append(alias).append("io/quarkus/launcher/shaded/>VALUE</").append(alias).append("io/quarkus/launcher/shaded/>\n</configuration>\n");
            }
        }
        if (StringUtils.isEmpty(expression)) {
            messageBuffer.append('.');
        } else if (param.isEditable()) {
            messageBuffer.append("io.quarkus.launcher.shaded.\n\n-OR-\n\n");
        }
    }

    public String buildDiagnosticMessage() {
        StringBuilder messageBuffer = new StringBuilder(256);
        List<Parameter> params = this.getParameters();
        MojoDescriptor mojo = this.getMojoDescriptor();
        messageBuffer.append("io/quarkus/launcher/shaded/One or more required plugin parameters are invalid/missing for '").append(mojo.getPluginDescriptor().getGoalPrefix()).append(':').append(mojo.getGoal()).append("io.quarkus.launcher.shaded.'\n");
        int idx = 0;
        for (Parameter param : params) {
            messageBuffer.append("io.quarkus.launcher.shaded.\n[").append(idx).append("io.quarkus.launcher.shaded.] ");
            PluginParameterException.decomposeParameterIntoUserInstructions(mojo, param, messageBuffer);
            messageBuffer.append('\n');
            ++idx;
        }
        return messageBuffer.toString();
    }
}

