/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.maven.plugin;

import io.quarkus.launcher.shaded.org.apache.maven.execution.MavenSession;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.MojoExecution;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.descriptor.MojoDescriptor;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.descriptor.PluginDescriptor;
import io.quarkus.launcher.shaded.org.apache.maven.project.MavenProject;
import io.quarkus.launcher.shaded.org.apache.maven.project.path.PathTranslator;
import io.quarkus.launcher.shaded.org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import io.quarkus.launcher.shaded.org.codehaus.plexus.component.configurator.expression.TypeAwareExpressionEvaluator;
import io.quarkus.launcher.shaded.org.codehaus.plexus.logging.Logger;
import io.quarkus.launcher.shaded.org.codehaus.plexus.util.introspection.ReflectionValueExtractor;
import java.io.File;
import java.util.Map;
import java.util.Properties;

public class PluginParameterExpressionEvaluator
implements TypeAwareExpressionEvaluator {
    private MavenSession session;
    private MojoExecution mojoExecution;
    private MavenProject project;
    private String basedir;
    private Properties properties;

    @Deprecated
    public PluginParameterExpressionEvaluator(MavenSession session, MojoExecution mojoExecution, PathTranslator pathTranslator, Logger logger, MavenProject project, Properties properties) {
        this(session, mojoExecution);
    }

    public PluginParameterExpressionEvaluator(MavenSession session) {
        this(session, null);
    }

    public PluginParameterExpressionEvaluator(MavenSession session, MojoExecution mojoExecution) {
        File projectFile;
        this.session = session;
        this.mojoExecution = mojoExecution;
        this.properties = new Properties();
        this.project = session.getCurrentProject();
        this.properties.putAll((Map<?, ?>)session.getUserProperties());
        this.properties.putAll((Map<?, ?>)session.getSystemProperties());
        String basedir = null;
        if (this.project != null && (projectFile = this.project.getBasedir()) != null) {
            basedir = projectFile.getAbsolutePath();
        }
        if (basedir == null) {
            basedir = session.getExecutionRootDirectory();
        }
        if (basedir == null) {
            basedir = System.getProperty("io.quarkus.launcher.shaded.user.dir");
        }
        this.basedir = basedir;
    }

    @Override
    public Object evaluate(String expr) throws ExpressionEvaluationException {
        return this.evaluate(expr, null);
    }

    @Override
    public Object evaluate(String expr, Class<?> type) throws ExpressionEvaluationException {
        String val;
        int exprStartDelimiter;
        String pathExpression;
        int pathSeparator;
        Object value = null;
        if (expr == null) {
            return null;
        }
        String expression = this.stripTokens(expr);
        if (expression.equals(expr)) {
            int lastIndex;
            int index = expr.indexOf("io.quarkus.launcher.shaded.${");
            if (index >= 0 && (lastIndex = expr.indexOf(125, index)) >= 0) {
                Object subResult;
                String retVal = expr.substring(0, index);
                retVal = index > 0 && expr.charAt(index - 1) == '$' ? retVal + expr.substring(index + 1, lastIndex + 1) : ((subResult = this.evaluate(expr.substring(index, lastIndex + 1))) != null ? retVal + subResult : retVal + "io.quarkus.launcher.shaded.$" + expr.substring(index + 1, lastIndex + 1));
                retVal = retVal + this.evaluate(expr.substring(lastIndex + 1));
                return retVal;
            }
            if (expression.contains("io.quarkus.launcher.shaded.$$")) {
                return expression.replaceAll("io.quarkus.launcher.shaded.\\$\\$", "io.quarkus.launcher.shaded.\\$");
            }
            return expression;
        }
        MojoDescriptor mojoDescriptor = this.mojoExecution.getMojoDescriptor();
        if ("io.quarkus.launcher.shaded.localRepository".equals(expression)) {
            value = this.session.getLocalRepository();
        } else if ("io.quarkus.launcher.shaded.session".equals(expression)) {
            value = this.session;
        } else if (expression.startsWith("io.quarkus.launcher.shaded.session")) {
            try {
                pathSeparator = expression.indexOf(47);
                if (pathSeparator > 0) {
                    pathExpression = expression.substring(1, pathSeparator);
                    value = ReflectionValueExtractor.evaluate(pathExpression, this.session);
                    value = value + expression.substring(pathSeparator);
                }
                value = ReflectionValueExtractor.evaluate(expression.substring(1), this.session);
            }
            catch (Exception e) {
                throw new ExpressionEvaluationException("io.quarkus.launcher.shaded.Error evaluating plugin parameter expression: " + expression, e);
            }
        } else if ("io.quarkus.launcher.shaded.reactorProjects".equals(expression)) {
            value = this.session.getProjects();
        } else if ("io.quarkus.launcher.shaded.mojoExecution".equals(expression)) {
            value = this.mojoExecution;
        } else if ("io.quarkus.launcher.shaded.project".equals(expression)) {
            value = this.project;
        } else if ("io.quarkus.launcher.shaded.executedProject".equals(expression)) {
            value = this.project.getExecutionProject();
        } else if (expression.startsWith("io.quarkus.launcher.shaded.project") || expression.startsWith("io.quarkus.launcher.shaded.pom")) {
            try {
                pathSeparator = expression.indexOf(47);
                if (pathSeparator > 0) {
                    pathExpression = expression.substring(0, pathSeparator);
                    value = ReflectionValueExtractor.evaluate(pathExpression, this.project);
                    value = value + expression.substring(pathSeparator);
                }
                value = ReflectionValueExtractor.evaluate(expression.substring(1), this.project);
            }
            catch (Exception e) {
                throw new ExpressionEvaluationException("io.quarkus.launcher.shaded.Error evaluating plugin parameter expression: " + expression, e);
            }
        } else if (expression.equals("io.quarkus.launcher.shaded.repositorySystemSession")) {
            value = this.session.getRepositorySession();
        } else if (expression.equals("io.quarkus.launcher.shaded.mojo")) {
            value = this.mojoExecution;
        } else if (expression.startsWith("io.quarkus.launcher.shaded.mojo")) {
            try {
                pathSeparator = expression.indexOf(47);
                if (pathSeparator > 0) {
                    pathExpression = expression.substring(1, pathSeparator);
                    value = ReflectionValueExtractor.evaluate(pathExpression, this.mojoExecution);
                    value = value + expression.substring(pathSeparator);
                }
                value = ReflectionValueExtractor.evaluate(expression.substring(1), this.mojoExecution);
            }
            catch (Exception e) {
                throw new ExpressionEvaluationException("io.quarkus.launcher.shaded.Error evaluating plugin parameter expression: " + expression, e);
            }
        } else if (expression.equals("io.quarkus.launcher.shaded.plugin")) {
            value = mojoDescriptor.getPluginDescriptor();
        } else if (expression.startsWith("io.quarkus.launcher.shaded.plugin")) {
            try {
                pathSeparator = expression.indexOf(47);
                PluginDescriptor pluginDescriptor = mojoDescriptor.getPluginDescriptor();
                if (pathSeparator > 0) {
                    String pathExpression2 = expression.substring(1, pathSeparator);
                    value = ReflectionValueExtractor.evaluate(pathExpression2, pluginDescriptor);
                    value = value + expression.substring(pathSeparator);
                }
                value = ReflectionValueExtractor.evaluate(expression.substring(1), pluginDescriptor);
            }
            catch (Exception e) {
                throw new ExpressionEvaluationException("io.quarkus.launcher.shaded.Error evaluating plugin parameter expression: " + expression, e);
            }
        } else if ("io.quarkus.launcher.shaded.settings".equals(expression)) {
            value = this.session.getSettings();
        } else if (expression.startsWith("io.quarkus.launcher.shaded.settings")) {
            try {
                pathSeparator = expression.indexOf(47);
                if (pathSeparator > 0) {
                    pathExpression = expression.substring(1, pathSeparator);
                    value = ReflectionValueExtractor.evaluate(pathExpression, this.session.getSettings());
                    value = value + expression.substring(pathSeparator);
                }
                value = ReflectionValueExtractor.evaluate(expression.substring(1), this.session.getSettings());
            }
            catch (Exception e) {
                throw new ExpressionEvaluationException("io.quarkus.launcher.shaded.Error evaluating plugin parameter expression: " + expression, e);
            }
        } else if ("io.quarkus.launcher.shaded.basedir".equals(expression)) {
            value = this.basedir;
        } else if (expression.startsWith("io.quarkus.launcher.shaded.basedir") && (pathSeparator = expression.indexOf(47)) > 0) {
            value = this.basedir + expression.substring(pathSeparator);
        }
        if (value != null && type != null && !(value instanceof String) && !PluginParameterExpressionEvaluator.isTypeCompatible(type, value)) {
            value = null;
        }
        if (value == null) {
            if (this.properties != null) {
                value = this.properties.getProperty(expression);
            }
            if (value == null && this.project != null && this.project.getProperties() != null) {
                value = this.project.getProperties().getProperty(expression);
            }
        }
        if (value instanceof String && (exprStartDelimiter = (val = (String)value).indexOf("io.quarkus.launcher.shaded.${")) >= 0) {
            value = exprStartDelimiter > 0 ? val.substring(0, exprStartDelimiter) + this.evaluate(val.substring(exprStartDelimiter)) : this.evaluate(val.substring(exprStartDelimiter));
        }
        return value;
    }

    private static boolean isTypeCompatible(Class<?> type, Object value) {
        if (type.isInstance(value)) {
            return true;
        }
        return (type.isPrimitive() || type.getName().startsWith("io/quarkus/launcher/shaded/java.lang.")) && value.getClass().getName().startsWith("io/quarkus/launcher/shaded/java.lang.");
    }

    private String stripTokens(String expr) {
        if (expr.startsWith("io.quarkus.launcher.shaded.${") && expr.indexOf(125) == expr.length() - 1) {
            expr = expr.substring(2, expr.length() - 1);
        }
        return expr;
    }

    @Override
    public File alignToBaseDirectory(File file) {
        if (file != null && !file.isAbsolute()) {
            file = file.getPath().startsWith(File.separator) ? file.getAbsoluteFile() : new File(new File(this.basedir, file.getPath()).toURI().normalize()).getAbsoluteFile();
        }
        return file;
    }
}

