/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.maven.plugin.descriptor;

import io.quarkus.launcher.shaded.org.apache.maven.plugin.descriptor.MojoDescriptor;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.descriptor.Parameter;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.descriptor.PluginDescriptor;
import io.quarkus.launcher.shaded.org.codehaus.plexus.component.repository.ComponentDependency;
import io.quarkus.launcher.shaded.org.codehaus.plexus.component.repository.ComponentRequirement;
import io.quarkus.launcher.shaded.org.codehaus.plexus.configuration.PlexusConfiguration;
import io.quarkus.launcher.shaded.org.codehaus.plexus.configuration.PlexusConfigurationException;
import io.quarkus.launcher.shaded.org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;
import io.quarkus.launcher.shaded.org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import io.quarkus.launcher.shaded.org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;

public class PluginDescriptorBuilder {
    public PluginDescriptor build(Reader reader) throws PlexusConfigurationException {
        return this.build(reader, null);
    }

    public PluginDescriptor build(Reader reader, String source) throws PlexusConfigurationException {
        PlexusConfiguration[] mojoConfigurations;
        String inheritedByDefault;
        PlexusConfiguration c = this.buildConfiguration(reader);
        PluginDescriptor pluginDescriptor = new PluginDescriptor();
        pluginDescriptor.setSource(source);
        pluginDescriptor.setGroupId(c.getChild("io.quarkus.launcher.shaded.groupId").getValue());
        pluginDescriptor.setArtifactId(c.getChild("io.quarkus.launcher.shaded.artifactId").getValue());
        pluginDescriptor.setVersion(c.getChild("io.quarkus.launcher.shaded.version").getValue());
        pluginDescriptor.setGoalPrefix(c.getChild("io.quarkus.launcher.shaded.goalPrefix").getValue());
        pluginDescriptor.setName(c.getChild("io.quarkus.launcher.shaded.name").getValue());
        pluginDescriptor.setDescription(c.getChild("io.quarkus.launcher.shaded.description").getValue());
        String isolatedRealm = c.getChild("io.quarkus.launcher.shaded.isolatedRealm").getValue();
        if (isolatedRealm != null) {
            pluginDescriptor.setIsolatedRealm(Boolean.parseBoolean(isolatedRealm));
        }
        if ((inheritedByDefault = c.getChild("io.quarkus.launcher.shaded.inheritedByDefault").getValue()) != null) {
            pluginDescriptor.setInheritedByDefault(Boolean.parseBoolean(inheritedByDefault));
        }
        for (PlexusConfiguration component : mojoConfigurations = c.getChild("io.quarkus.launcher.shaded.mojos").getChildren("io.quarkus.launcher.shaded.mojo")) {
            MojoDescriptor mojoDescriptor = this.buildComponentDescriptor(component, pluginDescriptor);
            pluginDescriptor.addMojo(mojoDescriptor);
        }
        PlexusConfiguration[] dependencyConfigurations = c.getChild("io.quarkus.launcher.shaded.dependencies").getChildren("io.quarkus.launcher.shaded.dependency");
        ArrayList<ComponentDependency> dependencies = new ArrayList<ComponentDependency>();
        for (PlexusConfiguration d : dependencyConfigurations) {
            ComponentDependency cd = new ComponentDependency();
            cd.setArtifactId(d.getChild("io.quarkus.launcher.shaded.artifactId").getValue());
            cd.setGroupId(d.getChild("io.quarkus.launcher.shaded.groupId").getValue());
            cd.setType(d.getChild("io.quarkus.launcher.shaded.type").getValue());
            cd.setVersion(d.getChild("io.quarkus.launcher.shaded.version").getValue());
            dependencies.add(cd);
        }
        pluginDescriptor.setDependencies(dependencies);
        return pluginDescriptor;
    }

    public MojoDescriptor buildComponentDescriptor(PlexusConfiguration c, PluginDescriptor pluginDescriptor) throws PlexusConfigurationException {
        PlexusConfiguration[] requirements;
        String threadSafe;
        String inheritedByDefault;
        String requiresOnline;
        String aggregator;
        String requiresReports;
        String requiresProject;
        String directInvocationOnly;
        PlexusConfiguration dependencyCollection;
        String executeLifecycle;
        String executeMojo;
        String executePhase;
        String phase;
        PlexusConfiguration deprecated;
        String since;
        PlexusConfiguration composerConfig;
        PlexusConfiguration configuratorConfig;
        MojoDescriptor mojo = new MojoDescriptor();
        mojo.setPluginDescriptor(pluginDescriptor);
        mojo.setGoal(c.getChild("io.quarkus.launcher.shaded.goal").getValue());
        mojo.setImplementation(c.getChild("io.quarkus.launcher.shaded.implementation").getValue());
        PlexusConfiguration langConfig = c.getChild("io.quarkus.launcher.shaded.language");
        if (langConfig != null) {
            mojo.setLanguage(langConfig.getValue());
        }
        if ((configuratorConfig = c.getChild("io.quarkus.launcher.shaded.configurator")) != null) {
            mojo.setComponentConfigurator(configuratorConfig.getValue());
        }
        if ((composerConfig = c.getChild("io.quarkus.launcher.shaded.composer")) != null) {
            mojo.setComponentComposer(composerConfig.getValue());
        }
        if ((since = c.getChild("io.quarkus.launcher.shaded.since").getValue()) != null) {
            mojo.setSince(since);
        }
        if ((deprecated = c.getChild("io.quarkus.launcher.shaded.deprecated", false)) != null) {
            mojo.setDeprecated(deprecated.getValue());
        }
        if ((phase = c.getChild("io.quarkus.launcher.shaded.phase").getValue()) != null) {
            mojo.setPhase(phase);
        }
        if ((executePhase = c.getChild("io.quarkus.launcher.shaded.executePhase").getValue()) != null) {
            mojo.setExecutePhase(executePhase);
        }
        if ((executeMojo = c.getChild("io.quarkus.launcher.shaded.executeGoal").getValue()) != null) {
            mojo.setExecuteGoal(executeMojo);
        }
        if ((executeLifecycle = c.getChild("io.quarkus.launcher.shaded.executeLifecycle").getValue()) != null) {
            mojo.setExecuteLifecycle(executeLifecycle);
        }
        mojo.setInstantiationStrategy(c.getChild("io.quarkus.launcher.shaded.instantiationStrategy").getValue());
        mojo.setDescription(c.getChild("io.quarkus.launcher.shaded.description").getValue());
        PlexusConfiguration dependencyResolution = c.getChild("io.quarkus.launcher.shaded.requiresDependencyResolution", false);
        if (dependencyResolution != null) {
            mojo.setDependencyResolutionRequired(dependencyResolution.getValue());
        }
        if ((dependencyCollection = c.getChild("io.quarkus.launcher.shaded.requiresDependencyCollection", false)) != null) {
            mojo.setDependencyCollectionRequired(dependencyCollection.getValue());
        }
        if ((directInvocationOnly = c.getChild("io.quarkus.launcher.shaded.requiresDirectInvocation").getValue()) != null) {
            mojo.setDirectInvocationOnly(Boolean.parseBoolean(directInvocationOnly));
        }
        if ((requiresProject = c.getChild("io.quarkus.launcher.shaded.requiresProject").getValue()) != null) {
            mojo.setProjectRequired(Boolean.parseBoolean(requiresProject));
        }
        if ((requiresReports = c.getChild("io.quarkus.launcher.shaded.requiresReports").getValue()) != null) {
            mojo.setRequiresReports(Boolean.parseBoolean(requiresReports));
        }
        if ((aggregator = c.getChild("io.quarkus.launcher.shaded.aggregator").getValue()) != null) {
            mojo.setAggregator(Boolean.parseBoolean(aggregator));
        }
        if ((requiresOnline = c.getChild("io.quarkus.launcher.shaded.requiresOnline").getValue()) != null) {
            mojo.setOnlineRequired(Boolean.parseBoolean(requiresOnline));
        }
        if ((inheritedByDefault = c.getChild("io.quarkus.launcher.shaded.inheritedByDefault").getValue()) != null) {
            mojo.setInheritedByDefault(Boolean.parseBoolean(inheritedByDefault));
        }
        if ((threadSafe = c.getChild("io.quarkus.launcher.shaded.threadSafe").getValue()) != null) {
            mojo.setThreadSafe(Boolean.parseBoolean(threadSafe));
        }
        PlexusConfiguration mojoConfig = c.getChild("io.quarkus.launcher.shaded.configuration");
        mojo.setMojoConfiguration(mojoConfig);
        PlexusConfiguration[] parameterConfigurations = c.getChild("io.quarkus.launcher.shaded.parameters").getChildren("io.quarkus.launcher.shaded.parameter");
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        for (PlexusConfiguration d : parameterConfigurations) {
            Parameter parameter = new Parameter();
            parameter.setName(d.getChild("io.quarkus.launcher.shaded.name").getValue());
            parameter.setAlias(d.getChild("io.quarkus.launcher.shaded.alias").getValue());
            parameter.setType(d.getChild("io.quarkus.launcher.shaded.type").getValue());
            String required = d.getChild("io.quarkus.launcher.shaded.required").getValue();
            parameter.setRequired(Boolean.parseBoolean(required));
            PlexusConfiguration editableConfig = d.getChild("io.quarkus.launcher.shaded.editable");
            if (editableConfig != null) {
                String editable = d.getChild("io.quarkus.launcher.shaded.editable").getValue();
                parameter.setEditable(editable == null || Boolean.parseBoolean(editable));
            }
            parameter.setDescription(d.getChild("io.quarkus.launcher.shaded.description").getValue());
            parameter.setDeprecated(d.getChild("io.quarkus.launcher.shaded.deprecated").getValue());
            parameter.setImplementation(d.getChild("io.quarkus.launcher.shaded.implementation").getValue());
            parameter.setSince(d.getChild("io.quarkus.launcher.shaded.since").getValue());
            PlexusConfiguration paramConfig = mojoConfig.getChild(parameter.getName(), false);
            if (paramConfig != null) {
                parameter.setExpression(paramConfig.getValue(null));
                parameter.setDefaultValue(paramConfig.getAttribute("io.quarkus.launcher.shaded.default-value"));
            }
            parameters.add(parameter);
        }
        mojo.setParameters(parameters);
        for (PlexusConfiguration requirement : requirements = c.getChild("io.quarkus.launcher.shaded.requirements").getChildren("io.quarkus.launcher.shaded.requirement")) {
            ComponentRequirement cr = new ComponentRequirement();
            cr.setRole(requirement.getChild("io.quarkus.launcher.shaded.role").getValue());
            cr.setRoleHint(requirement.getChild("io.quarkus.launcher.shaded.role-hint").getValue());
            cr.setFieldName(requirement.getChild("io.quarkus.launcher.shaded.field-name").getValue());
            mojo.addRequirement(cr);
        }
        return mojo;
    }

    public PlexusConfiguration buildConfiguration(Reader configuration) throws PlexusConfigurationException {
        try {
            return new XmlPlexusConfiguration(Xpp3DomBuilder.build(configuration));
        }
        catch (XmlPullParserException | IOException e) {
            throw new PlexusConfigurationException(e.getMessage(), e);
        }
    }
}

