/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.maven.plugin.internal;

import io.quarkus.launcher.shaded.org.apache.maven.execution.MavenSession;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.LegacySupport;
import io.quarkus.launcher.shaded.org.codehaus.plexus.component.annotations.Component;
import io.quarkus.launcher.shaded.org.eclipse.aether.RepositorySystemSession;
import java.util.concurrent.atomic.AtomicReference;

@Component(role=LegacySupport.class)
public class DefaultLegacySupport
implements LegacySupport {
    private static final ThreadLocal<AtomicReference<MavenSession>> SESSION = new InheritableThreadLocal<AtomicReference<MavenSession>>();

    @Override
    public void setSession(MavenSession session) {
        AtomicReference<MavenSession> reference = SESSION.get();
        if (reference != null) {
            reference.set(null);
        }
        if (session == null && reference != null) {
            SESSION.remove();
        } else {
            SESSION.set(new AtomicReference<MavenSession>(session));
        }
    }

    @Override
    public MavenSession getSession() {
        AtomicReference<MavenSession> currentSession = SESSION.get();
        return currentSession != null ? currentSession.get() : null;
    }

    @Override
    public RepositorySystemSession getRepositorySession() {
        MavenSession session = this.getSession();
        return session != null ? session.getRepositorySession() : null;
    }
}

