/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.maven.plugin.internal;

import io.quarkus.launcher.shaded.org.apache.maven.RepositoryUtils;
import io.quarkus.launcher.shaded.org.apache.maven.artifact.Artifact;
import io.quarkus.launcher.shaded.org.apache.maven.classrealm.ClassRealmManager;
import io.quarkus.launcher.shaded.org.apache.maven.execution.MavenSession;
import io.quarkus.launcher.shaded.org.apache.maven.execution.scope.internal.MojoExecutionScopeModule;
import io.quarkus.launcher.shaded.org.apache.maven.model.Plugin;
import io.quarkus.launcher.shaded.org.apache.maven.monitor.logging.DefaultLog;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.ContextEnabled;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.DebugConfigurationListener;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.ExtensionRealmCache;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.InvalidPluginDescriptorException;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.MavenPluginManager;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.MavenPluginValidator;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.Mojo;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.MojoExecution;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.MojoNotFoundException;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.PluginArtifactsCache;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.PluginConfigurationException;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.PluginContainerException;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.PluginDescriptorCache;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.PluginDescriptorParsingException;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.PluginIncompatibleException;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.PluginManagerException;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.PluginParameterException;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.PluginParameterExpressionEvaluator;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.PluginRealmCache;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.PluginResolutionException;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.descriptor.MojoDescriptor;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.descriptor.Parameter;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.descriptor.PluginDescriptor;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.descriptor.PluginDescriptorBuilder;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.internal.PluginDependenciesResolver;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.internal.ValidatingConfigurationListener;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.version.DefaultPluginVersionRequest;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.version.PluginVersionResolutionException;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.version.PluginVersionResolver;
import io.quarkus.launcher.shaded.org.apache.maven.project.ExtensionDescriptor;
import io.quarkus.launcher.shaded.org.apache.maven.project.ExtensionDescriptorBuilder;
import io.quarkus.launcher.shaded.org.apache.maven.project.MavenProject;
import io.quarkus.launcher.shaded.org.apache.maven.rtinfo.RuntimeInformation;
import io.quarkus.launcher.shaded.org.apache.maven.session.scope.internal.SessionScopeModule;
import io.quarkus.launcher.shaded.org.codehaus.plexus.DefaultPlexusContainer;
import io.quarkus.launcher.shaded.org.codehaus.plexus.PlexusContainer;
import io.quarkus.launcher.shaded.org.codehaus.plexus.classworlds.realm.ClassRealm;
import io.quarkus.launcher.shaded.org.codehaus.plexus.component.annotations.Component;
import io.quarkus.launcher.shaded.org.codehaus.plexus.component.annotations.Requirement;
import io.quarkus.launcher.shaded.org.codehaus.plexus.component.composition.CycleDetectedInComponentGraphException;
import io.quarkus.launcher.shaded.org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import io.quarkus.launcher.shaded.org.codehaus.plexus.component.configurator.ComponentConfigurator;
import io.quarkus.launcher.shaded.org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import io.quarkus.launcher.shaded.org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import io.quarkus.launcher.shaded.org.codehaus.plexus.component.repository.ComponentDescriptor;
import io.quarkus.launcher.shaded.org.codehaus.plexus.component.repository.exception.ComponentLifecycleException;
import io.quarkus.launcher.shaded.org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import io.quarkus.launcher.shaded.org.codehaus.plexus.configuration.PlexusConfiguration;
import io.quarkus.launcher.shaded.org.codehaus.plexus.configuration.PlexusConfigurationException;
import io.quarkus.launcher.shaded.org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;
import io.quarkus.launcher.shaded.org.codehaus.plexus.logging.Logger;
import io.quarkus.launcher.shaded.org.codehaus.plexus.logging.LoggerManager;
import io.quarkus.launcher.shaded.org.codehaus.plexus.util.ReaderFactory;
import io.quarkus.launcher.shaded.org.codehaus.plexus.util.StringUtils;
import io.quarkus.launcher.shaded.org.codehaus.plexus.util.xml.XmlStreamReader;
import io.quarkus.launcher.shaded.org.codehaus.plexus.util.xml.Xpp3Dom;
import io.quarkus.launcher.shaded.org.eclipse.aether.RepositorySystemSession;
import io.quarkus.launcher.shaded.org.eclipse.aether.graph.DependencyFilter;
import io.quarkus.launcher.shaded.org.eclipse.aether.graph.DependencyNode;
import io.quarkus.launcher.shaded.org.eclipse.aether.repository.RemoteRepository;
import io.quarkus.launcher.shaded.org.eclipse.aether.util.filter.AndDependencyFilter;
import io.quarkus.launcher.shaded.org.eclipse.aether.util.graph.visitor.PreorderNodeListGenerator;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.jar.JarFile;

@Component(role=MavenPluginManager.class)
public class DefaultMavenPluginManager
implements MavenPluginManager {
    public static final String KEY_EXTENSIONS_REALMS = DefaultMavenPluginManager.class.getName() + "io/quarkus/launcher/shaded//extensionsRealms";
    @Requirement
    private Logger logger;
    @Requirement
    private LoggerManager loggerManager;
    @Requirement
    private PlexusContainer container;
    @Requirement
    private ClassRealmManager classRealmManager;
    @Requirement
    private PluginDescriptorCache pluginDescriptorCache;
    @Requirement
    private PluginRealmCache pluginRealmCache;
    @Requirement
    private PluginDependenciesResolver pluginDependenciesResolver;
    @Requirement
    private RuntimeInformation runtimeInformation;
    @Requirement
    private ExtensionRealmCache extensionRealmCache;
    @Requirement
    private PluginVersionResolver pluginVersionResolver;
    @Requirement
    private PluginArtifactsCache pluginArtifactsCache;
    private ExtensionDescriptorBuilder extensionDescriptorBuilder = new ExtensionDescriptorBuilder();
    private PluginDescriptorBuilder builder = new PluginDescriptorBuilder();

    @Override
    public synchronized PluginDescriptor getPluginDescriptor(Plugin plugin, List<RemoteRepository> repositories, RepositorySystemSession session) throws PluginResolutionException, PluginDescriptorParsingException, InvalidPluginDescriptorException {
        PluginDescriptorCache.Key cacheKey = this.pluginDescriptorCache.createKey(plugin, repositories, session);
        PluginDescriptor pluginDescriptor = this.pluginDescriptorCache.get(cacheKey);
        if (pluginDescriptor == null) {
            io.quarkus.launcher.shaded.org.eclipse.aether.artifact.Artifact artifact = this.pluginDependenciesResolver.resolve(plugin, repositories, session);
            Artifact pluginArtifact = RepositoryUtils.toArtifact(artifact);
            pluginDescriptor = this.extractPluginDescriptor(pluginArtifact, plugin);
            pluginDescriptor.setRequiredMavenVersion(artifact.getProperty("io.quarkus.launcher.shaded.requiredMavenVersion", null));
            this.pluginDescriptorCache.put(cacheKey, pluginDescriptor);
        }
        pluginDescriptor.setPlugin(plugin);
        return pluginDescriptor;
    }

    /*
     * Unable to fully structure code
     */
    private PluginDescriptor extractPluginDescriptor(Artifact pluginArtifact, Plugin plugin) throws PluginDescriptorParsingException, InvalidPluginDescriptorException {
        pluginDescriptor = null;
        pluginFile = pluginArtifact.getFile();
        try {
            if (pluginFile.isFile()) {
                pluginJar = new JarFile(pluginFile, false);
                var6_7 = null;
                try {
                    pluginDescriptorEntry = pluginJar.getEntry(this.getPluginDescriptorLocation());
                    if (pluginDescriptorEntry == null) ** GOTO lbl48
                    is = pluginJar.getInputStream(pluginDescriptorEntry);
                    pluginDescriptor = this.parsePluginDescriptor(is, plugin, pluginFile.getAbsolutePath());
                }
                catch (Throwable var7_11) {
                    var6_7 = var7_11;
                    throw var7_11;
                }
                finally {
                    if (pluginJar != null) {
                        if (var6_7 != null) {
                            try {
                                pluginJar.close();
                            }
                            catch (Throwable var7_10) {
                                var6_7.addSuppressed(var7_10);
                            }
                        } else {
                            pluginJar.close();
                        }
                    }
                }
            } else {
                pluginXml = new File(pluginFile, this.getPluginDescriptorLocation());
                if (pluginXml.isFile()) {
                    is = new BufferedInputStream(new FileInputStream(pluginXml));
                    var7_12 = null;
                    try {
                        pluginDescriptor = this.parsePluginDescriptor(is, plugin, pluginXml.getAbsolutePath());
                    }
                    catch (Throwable var8_15) {
                        var7_12 = var8_15;
                        throw var8_15;
                    }
                    finally {
                        if (is != null) {
                            if (var7_12 != null) {
                                try {
                                    is.close();
                                }
                                catch (Throwable var8_14) {
                                    var7_12.addSuppressed(var8_14);
                                }
                            } else {
                                is.close();
                            }
                        }
                    }
                }
            }
            if (pluginDescriptor == null) {
                throw new IOException("io.quarkus.launcher.shaded.No plugin descriptor found at " + this.getPluginDescriptorLocation());
            }
        }
        catch (IOException e) {
            throw new PluginDescriptorParsingException(plugin, pluginFile.getAbsolutePath(), e);
        }
        validator = new MavenPluginValidator(pluginArtifact);
        validator.validate(pluginDescriptor);
        if (validator.hasErrors()) {
            throw new InvalidPluginDescriptorException("io.quarkus.launcher.shaded.Invalid plugin descriptor for " + plugin.getId() + "io.quarkus.launcher.shaded. (" + pluginFile + "io.quarkus.launcher.shaded.)", validator.getErrors());
        }
        pluginDescriptor.setPluginArtifact(pluginArtifact);
        return pluginDescriptor;
    }

    private String getPluginDescriptorLocation() {
        return "META-INF/maven/plugin.xml";
    }

    private PluginDescriptor parsePluginDescriptor(InputStream is, Plugin plugin, String descriptorLocation) throws PluginDescriptorParsingException {
        try {
            XmlStreamReader reader = ReaderFactory.newXmlReader(is);
            PluginDescriptor pluginDescriptor = this.builder.build(reader, descriptorLocation);
            return pluginDescriptor;
        }
        catch (PlexusConfigurationException | IOException e) {
            throw new PluginDescriptorParsingException(plugin, descriptorLocation, e);
        }
    }

    @Override
    public MojoDescriptor getMojoDescriptor(Plugin plugin, String goal, List<RemoteRepository> repositories, RepositorySystemSession session) throws MojoNotFoundException, PluginResolutionException, PluginDescriptorParsingException, InvalidPluginDescriptorException {
        PluginDescriptor pluginDescriptor = this.getPluginDescriptor(plugin, repositories, session);
        MojoDescriptor mojoDescriptor = pluginDescriptor.getMojo(goal);
        if (mojoDescriptor == null) {
            throw new MojoNotFoundException(goal, pluginDescriptor);
        }
        return mojoDescriptor;
    }

    @Override
    public void checkRequiredMavenVersion(PluginDescriptor pluginDescriptor) throws PluginIncompatibleException {
        String requiredMavenVersion = pluginDescriptor.getRequiredMavenVersion();
        if (StringUtils.isNotBlank(requiredMavenVersion)) {
            try {
                if (!this.runtimeInformation.isMavenVersion(requiredMavenVersion)) {
                    throw new PluginIncompatibleException(pluginDescriptor.getPlugin(), "io.quarkus.launcher.shaded.The plugin " + pluginDescriptor.getId() + "io.quarkus.launcher.shaded. requires Maven version " + requiredMavenVersion);
                }
            }
            catch (RuntimeException e) {
                this.logger.warn("io.quarkus.launcher.shaded.Could not verify plugin's Maven prerequisite: " + e.getMessage());
            }
        }
    }

    @Override
    public synchronized void setupPluginRealm(PluginDescriptor pluginDescriptor, MavenSession session, ClassLoader parent, List<String> imports, DependencyFilter filter) throws PluginResolutionException, PluginContainerException {
        Plugin plugin = pluginDescriptor.getPlugin();
        MavenProject project = session.getCurrentProject();
        if (plugin.isExtensions()) {
            ExtensionRealmCache.CacheRecord extensionRecord;
            try {
                RepositorySystemSession repositorySession = session.getRepositorySession();
                extensionRecord = this.setupExtensionsRealm(project, plugin, repositorySession);
            }
            catch (PluginManagerException e) {
                throw new IllegalStateException(e);
            }
            ClassRealm pluginRealm = extensionRecord.getRealm();
            List<Artifact> pluginArtifacts = extensionRecord.getArtifacts();
            for (ComponentDescriptor<?> componentDescriptor : pluginDescriptor.getComponents()) {
                componentDescriptor.setRealm(pluginRealm);
            }
            pluginDescriptor.setClassRealm(pluginRealm);
            pluginDescriptor.setArtifacts(pluginArtifacts);
        } else {
            Map<String, ClassLoader> foreignImports = this.calcImports(project, parent, imports);
            PluginRealmCache.Key cacheKey = this.pluginRealmCache.createKey(plugin, parent, foreignImports, filter, project.getRemotePluginRepositories(), session.getRepositorySession());
            PluginRealmCache.CacheRecord cacheRecord = this.pluginRealmCache.get(cacheKey);
            if (cacheRecord != null) {
                pluginDescriptor.setClassRealm(cacheRecord.getRealm());
                pluginDescriptor.setArtifacts(new ArrayList<Artifact>(cacheRecord.getArtifacts()));
                for (ComponentDescriptor<?> componentDescriptor : pluginDescriptor.getComponents()) {
                    componentDescriptor.setRealm(cacheRecord.getRealm());
                }
            } else {
                this.createPluginRealm(pluginDescriptor, session, parent, foreignImports, filter);
                cacheRecord = this.pluginRealmCache.put(cacheKey, pluginDescriptor.getClassRealm(), pluginDescriptor.getArtifacts());
            }
            this.pluginRealmCache.register(project, cacheKey, cacheRecord);
        }
    }

    private void createPluginRealm(PluginDescriptor pluginDescriptor, MavenSession session, ClassLoader parent, Map<String, ClassLoader> foreignImports, DependencyFilter filter) throws PluginResolutionException, PluginContainerException {
        Plugin plugin = Objects.requireNonNull(pluginDescriptor.getPlugin(), "io.quarkus.launcher.shaded.pluginDescriptor.plugin cannot be null");
        Artifact pluginArtifact = Objects.requireNonNull(pluginDescriptor.getPluginArtifact(), "io.quarkus.launcher.shaded.pluginDescriptor.pluginArtifact cannot be null");
        MavenProject project = session.getCurrentProject();
        RepositorySystemSession repositorySession = session.getRepositorySession();
        DependencyFilter dependencyFilter = project.getExtensionDependencyFilter();
        dependencyFilter = AndDependencyFilter.newInstance(dependencyFilter, filter);
        DependencyNode root = this.pluginDependenciesResolver.resolve(plugin, RepositoryUtils.toArtifact(pluginArtifact), dependencyFilter, project.getRemotePluginRepositories(), repositorySession);
        PreorderNodeListGenerator nlg = new PreorderNodeListGenerator();
        root.accept(nlg);
        List<Artifact> pluginArtifacts = this.toMavenArtifacts(root, nlg);
        ClassRealm pluginRealm = this.classRealmManager.createPluginRealm(plugin, parent, null, foreignImports, this.toAetherArtifacts(pluginArtifacts));
        this.discoverPluginComponents(pluginRealm, plugin, pluginDescriptor);
        pluginDescriptor.setClassRealm(pluginRealm);
        pluginDescriptor.setArtifacts(pluginArtifacts);
    }

    private void discoverPluginComponents(ClassRealm pluginRealm, Plugin plugin, PluginDescriptor pluginDescriptor) throws PluginContainerException {
        try {
            if (pluginDescriptor != null) {
                for (ComponentDescriptor<?> componentDescriptor : pluginDescriptor.getComponents()) {
                    componentDescriptor.setRealm(pluginRealm);
                    this.container.addComponentDescriptor(componentDescriptor);
                }
            }
            ((DefaultPlexusContainer)this.container).discoverComponents(pluginRealm, new SessionScopeModule(this.container), new MojoExecutionScopeModule(this.container));
        }
        catch (CycleDetectedInComponentGraphException | ComponentLookupException e) {
            throw new PluginContainerException(plugin, pluginRealm, "io.quarkus.launcher.shaded.Error in component graph of plugin " + plugin.getId() + "io.quarkus.launcher.shaded.: " + e.getMessage(), (Throwable)e);
        }
    }

    private List<io.quarkus.launcher.shaded.org.eclipse.aether.artifact.Artifact> toAetherArtifacts(List<Artifact> pluginArtifacts) {
        return new ArrayList<io.quarkus.launcher.shaded.org.eclipse.aether.artifact.Artifact>(RepositoryUtils.toArtifacts(pluginArtifacts));
    }

    private List<Artifact> toMavenArtifacts(DependencyNode root, PreorderNodeListGenerator nlg) {
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>(nlg.getNodes().size());
        RepositoryUtils.toArtifacts(artifacts, Collections.singleton(root), Collections.emptyList(), null);
        Iterator it = artifacts.iterator();
        while (it.hasNext()) {
            Artifact artifact = (Artifact)it.next();
            if (artifact.getFile() != null) continue;
            it.remove();
        }
        return Collections.unmodifiableList(artifacts);
    }

    private Map<String, ClassLoader> calcImports(MavenProject project, ClassLoader parent, List<String> imports) {
        HashMap<String, ClassLoader> foreignImports = new HashMap<String, ClassLoader>();
        ClassRealm projectRealm = project.getClassRealm();
        if (projectRealm != null) {
            foreignImports.put("io.quarkus.launcher.shaded.", projectRealm);
        } else {
            foreignImports.put("io.quarkus.launcher.shaded.", this.classRealmManager.getMavenApiRealm());
        }
        if (parent != null && imports != null) {
            for (String parentImport : imports) {
                foreignImports.put(parentImport, parent);
            }
        }
        return foreignImports;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T getConfiguredMojo(Class<T> mojoInterface, MavenSession session, MojoExecution mojoExecution) throws PluginConfigurationException, PluginContainerException {
        MojoDescriptor mojoDescriptor = mojoExecution.getMojoDescriptor();
        PluginDescriptor pluginDescriptor = mojoDescriptor.getPluginDescriptor();
        ClassRealm pluginRealm = pluginDescriptor.getClassRealm();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("io.quarkus.launcher.shaded.Configuring mojo " + mojoDescriptor.getId() + "io.quarkus.launcher.shaded. from plugin realm " + pluginRealm);
        }
        ClassRealm oldLookupRealm = this.container.setLookupRealm(pluginRealm);
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(pluginRealm);
        try {
            Xpp3Dom dom;
            MavenProject project;
            Map<String, Object> pluginContext;
            T mojo;
            try {
                mojo = this.container.lookup(mojoInterface, mojoDescriptor.getRoleHint());
            }
            catch (ComponentLookupException e) {
                Throwable cause;
                for (cause = e.getCause(); cause != null && !(cause instanceof LinkageError) && !(cause instanceof ClassNotFoundException); cause = cause.getCause()) {
                }
                if (cause instanceof NoClassDefFoundError || cause instanceof ClassNotFoundException) {
                    ByteArrayOutputStream os = new ByteArrayOutputStream(1024);
                    PrintStream ps = new PrintStream(os);
                    ps.println("io.quarkus.launcher.shaded.Unable to load the mojo '" + mojoDescriptor.getGoal() + "io.quarkus.launcher.shaded.' in the plugin '" + pluginDescriptor.getId() + "io.quarkus.launcher.shaded.'. A required class is missing: " + cause.getMessage());
                    pluginRealm.display(ps);
                    throw new PluginContainerException(mojoDescriptor, pluginRealm, os.toString(), cause);
                }
                if (cause instanceof LinkageError) {
                    ByteArrayOutputStream os = new ByteArrayOutputStream(1024);
                    PrintStream ps = new PrintStream(os);
                    ps.println("io.quarkus.launcher.shaded.Unable to load the mojo '" + mojoDescriptor.getGoal() + "io.quarkus.launcher.shaded.' in the plugin '" + pluginDescriptor.getId() + "io.quarkus.launcher.shaded.' due to an API incompatibility: " + e.getClass().getName() + "io.quarkus.launcher.shaded.: " + cause.getMessage());
                    pluginRealm.display(ps);
                    throw new PluginContainerException(mojoDescriptor, pluginRealm, os.toString(), cause);
                }
                throw new PluginContainerException(mojoDescriptor, pluginRealm, "io.quarkus.launcher.shaded.Unable to load the mojo '" + mojoDescriptor.getGoal() + "io.quarkus.launcher.shaded.' (or one of its required components) from the plugin '" + pluginDescriptor.getId() + "io.quarkus.launcher.shaded.'", e);
            }
            if (mojo instanceof ContextEnabled && (pluginContext = session.getPluginContext(pluginDescriptor, project = session.getCurrentProject())) != null) {
                pluginContext.put("io.quarkus.launcher.shaded.project", project);
                pluginContext.put("io.quarkus.launcher.shaded.pluginDescriptor", pluginDescriptor);
                ((ContextEnabled)mojo).setPluginContext(pluginContext);
            }
            if (mojo instanceof Mojo) {
                Logger mojoLogger = this.loggerManager.getLoggerForComponent(mojoDescriptor.getImplementation());
                ((Mojo)mojo).setLog(new DefaultLog(mojoLogger));
            }
            XmlPlexusConfiguration pomConfiguration = (dom = mojoExecution.getConfiguration()) == null ? new XmlPlexusConfiguration("io.quarkus.launcher.shaded.configuration") : new XmlPlexusConfiguration(dom);
            PluginParameterExpressionEvaluator expressionEvaluator = new PluginParameterExpressionEvaluator(session, mojoExecution);
            this.populatePluginFields(mojo, mojoDescriptor, pluginRealm, pomConfiguration, expressionEvaluator);
            T t = mojo;
            return t;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
            this.container.setLookupRealm(oldLookupRealm);
        }
    }

    private void populatePluginFields(Object mojo, MojoDescriptor mojoDescriptor, ClassRealm pluginRealm, PlexusConfiguration configuration, ExpressionEvaluator expressionEvaluator) throws PluginConfigurationException {
        ComponentConfigurator configurator = null;
        String configuratorId = mojoDescriptor.getComponentConfigurator();
        if (StringUtils.isEmpty(configuratorId)) {
            configuratorId = "io.quarkus.launcher.shaded.basic";
        }
        try {
            configurator = this.container.lookup(ComponentConfigurator.class, configuratorId);
            DebugConfigurationListener listener = new DebugConfigurationListener(this.logger);
            ValidatingConfigurationListener validator = new ValidatingConfigurationListener(mojo, mojoDescriptor, listener);
            this.logger.debug("io.quarkus.launcher.shaded.Configuring mojo '" + mojoDescriptor.getId() + "io.quarkus.launcher.shaded.' with " + configuratorId + "io.quarkus.launcher.shaded. configurator -->");
            configurator.configureComponent(mojo, configuration, expressionEvaluator, pluginRealm, validator);
            this.logger.debug("io.quarkus.launcher.shaded.-- end configuration --");
            Collection<Parameter> missingParameters = validator.getMissingParameters();
            if (!missingParameters.isEmpty()) {
                if ("io.quarkus.launcher.shaded.basic".equals(configuratorId)) {
                    throw new PluginParameterException(mojoDescriptor, new ArrayList<Parameter>(missingParameters));
                }
                this.validateParameters(mojoDescriptor, configuration, expressionEvaluator);
            }
        }
        catch (ComponentConfigurationException e) {
            String message = "io.quarkus.launcher.shaded.Unable to parse configuration of mojo " + mojoDescriptor.getId();
            if (e.getFailedConfiguration() != null) {
                message = message + "io.quarkus.launcher.shaded. for parameter " + e.getFailedConfiguration().getName();
            }
            message = message + "io.quarkus.launcher.shaded.: " + e.getMessage();
            throw new PluginConfigurationException(mojoDescriptor.getPluginDescriptor(), message, e);
        }
        catch (ComponentLookupException e) {
            throw new PluginConfigurationException(mojoDescriptor.getPluginDescriptor(), "io.quarkus.launcher.shaded.Unable to retrieve component configurator " + configuratorId + "io.quarkus.launcher.shaded. for configuration of mojo " + mojoDescriptor.getId(), e);
        }
        catch (NoClassDefFoundError e) {
            ByteArrayOutputStream os = new ByteArrayOutputStream(1024);
            PrintStream ps = new PrintStream(os);
            ps.println("io.quarkus.launcher.shaded.A required class was missing during configuration of mojo " + mojoDescriptor.getId() + "io.quarkus.launcher.shaded.: " + e.getMessage());
            pluginRealm.display(ps);
            throw new PluginConfigurationException(mojoDescriptor.getPluginDescriptor(), os.toString(), e);
        }
        catch (LinkageError e) {
            ByteArrayOutputStream os = new ByteArrayOutputStream(1024);
            PrintStream ps = new PrintStream(os);
            ps.println("io.quarkus.launcher.shaded.An API incompatibility was encountered during configuration of mojo " + mojoDescriptor.getId() + "io.quarkus.launcher.shaded.: " + e.getClass().getName() + "io.quarkus.launcher.shaded.: " + e.getMessage());
            pluginRealm.display(ps);
            throw new PluginConfigurationException(mojoDescriptor.getPluginDescriptor(), os.toString(), e);
        }
        finally {
            if (configurator != null) {
                try {
                    this.container.release(configurator);
                }
                catch (ComponentLifecycleException e) {
                    this.logger.debug("io.quarkus.launcher.shaded.Failed to release mojo configurator - ignoring.");
                }
            }
        }
    }

    private void validateParameters(MojoDescriptor mojoDescriptor, PlexusConfiguration configuration, ExpressionEvaluator expressionEvaluator) throws ComponentConfigurationException, PluginParameterException {
        if (mojoDescriptor.getParameters() == null) {
            return;
        }
        ArrayList<Parameter> invalidParameters = new ArrayList<Parameter>();
        for (Parameter parameter : mojoDescriptor.getParameters()) {
            if (!parameter.isRequired()) continue;
            Object value = null;
            PlexusConfiguration config = configuration.getChild(parameter.getName(), false);
            if (config != null) {
                String expression = config.getValue(null);
                try {
                    value = expressionEvaluator.evaluate(expression);
                    if (value == null) {
                        value = config.getAttribute("io.quarkus.launcher.shaded.default-value", null);
                    }
                }
                catch (ExpressionEvaluationException e) {
                    String msg = "io.quarkus.launcher.shaded.Error evaluating the expression '" + expression + "io.quarkus.launcher.shaded.' for configuration value '" + configuration.getName() + "io.quarkus.launcher.shaded.'";
                    throw new ComponentConfigurationException(configuration, msg, e);
                }
            }
            if (value != null || config != null && config.getChildCount() > 0) continue;
            invalidParameters.add(parameter);
        }
        if (!invalidParameters.isEmpty()) {
            throw new PluginParameterException(mojoDescriptor, invalidParameters);
        }
    }

    @Override
    public void releaseMojo(Object mojo, MojoExecution mojoExecution) {
        if (mojo != null) {
            try {
                this.container.release(mojo);
            }
            catch (ComponentLifecycleException e) {
                String goalExecId = mojoExecution.getGoal();
                if (mojoExecution.getExecutionId() != null) {
                    goalExecId = goalExecId + "io.quarkus.launcher.shaded. {execution: " + mojoExecution.getExecutionId() + "io.quarkus.launcher.shaded.}";
                }
                this.logger.debug("io.quarkus.launcher.shaded.Error releasing mojo for " + goalExecId, e);
            }
        }
    }

    @Override
    public ExtensionRealmCache.CacheRecord setupExtensionsRealm(MavenProject project, Plugin plugin, RepositorySystemSession session) throws PluginManagerException {
        List<Artifact> artifacts;
        PluginArtifactsCache.CacheRecord recordArtifacts;
        String pluginKey;
        ExtensionRealmCache.CacheRecord extensionRecord;
        HashMap<String, ExtensionRealmCache.CacheRecord> pluginRealms = (HashMap<String, ExtensionRealmCache.CacheRecord>)project.getContextValue(KEY_EXTENSIONS_REALMS);
        if (pluginRealms == null) {
            pluginRealms = new HashMap<String, ExtensionRealmCache.CacheRecord>();
            project.setContextValue(KEY_EXTENSIONS_REALMS, pluginRealms);
        }
        if ((extensionRecord = (ExtensionRealmCache.CacheRecord)pluginRealms.get(pluginKey = plugin.getId())) != null) {
            return extensionRecord;
        }
        List<RemoteRepository> repositories = project.getRemotePluginRepositories();
        if (plugin.getVersion() == null) {
            DefaultPluginVersionRequest versionRequest = new DefaultPluginVersionRequest(plugin, session, repositories);
            try {
                plugin.setVersion(this.pluginVersionResolver.resolve(versionRequest).getVersion());
            }
            catch (PluginVersionResolutionException e) {
                throw new PluginManagerException(plugin, e.getMessage(), (Throwable)e);
            }
        }
        PluginArtifactsCache.Key cacheKey = this.pluginArtifactsCache.createKey(plugin, null, repositories, session);
        try {
            recordArtifacts = this.pluginArtifactsCache.get(cacheKey);
        }
        catch (PluginResolutionException e) {
            throw new PluginManagerException(plugin, e.getMessage(), (Throwable)e);
        }
        if (recordArtifacts != null) {
            artifacts = recordArtifacts.getArtifacts();
        } else {
            try {
                artifacts = this.resolveExtensionArtifacts(plugin, repositories, session);
                recordArtifacts = this.pluginArtifactsCache.put(cacheKey, artifacts);
            }
            catch (PluginResolutionException e) {
                this.pluginArtifactsCache.put(cacheKey, e);
                this.pluginArtifactsCache.register(project, cacheKey, recordArtifacts);
                throw new PluginManagerException(plugin, e.getMessage(), (Throwable)e);
            }
        }
        this.pluginArtifactsCache.register(project, cacheKey, recordArtifacts);
        ExtensionRealmCache.Key extensionKey = this.extensionRealmCache.createKey(artifacts);
        extensionRecord = this.extensionRealmCache.get(extensionKey);
        if (extensionRecord == null) {
            ClassRealm extensionRealm = this.classRealmManager.createExtensionRealm(plugin, this.toAetherArtifacts(artifacts));
            PluginDescriptor pluginDescriptor = null;
            if (plugin.isExtensions() && !artifacts.isEmpty()) {
                try {
                    pluginDescriptor = this.extractPluginDescriptor(artifacts.get(0), plugin);
                }
                catch (InvalidPluginDescriptorException | PluginDescriptorParsingException exception) {
                    // empty catch block
                }
            }
            this.discoverPluginComponents(extensionRealm, plugin, pluginDescriptor);
            ExtensionDescriptor extensionDescriptor = null;
            Artifact extensionArtifact = artifacts.get(0);
            try {
                extensionDescriptor = this.extensionDescriptorBuilder.build(extensionArtifact.getFile());
            }
            catch (IOException e) {
                String message = "io.quarkus.launcher.shaded.Invalid extension descriptor for " + plugin.getId() + "io.quarkus.launcher.shaded.: " + e.getMessage();
                if (this.logger.isDebugEnabled()) {
                    this.logger.error(message, e);
                }
                this.logger.error(message);
            }
            extensionRecord = this.extensionRealmCache.put(extensionKey, extensionRealm, extensionDescriptor, artifacts);
        }
        this.extensionRealmCache.register(project, extensionKey, extensionRecord);
        pluginRealms.put(pluginKey, extensionRecord);
        return extensionRecord;
    }

    private List<Artifact> resolveExtensionArtifacts(Plugin extensionPlugin, List<RemoteRepository> repositories, RepositorySystemSession session) throws PluginResolutionException {
        DependencyNode root = this.pluginDependenciesResolver.resolve(extensionPlugin, null, null, repositories, session);
        PreorderNodeListGenerator nlg = new PreorderNodeListGenerator();
        root.accept(nlg);
        return this.toMavenArtifacts(root, nlg);
    }
}

