/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.maven.plugin.internal;

import io.quarkus.launcher.shaded.org.apache.maven.RepositoryUtils;
import io.quarkus.launcher.shaded.org.apache.maven.model.Dependency;
import io.quarkus.launcher.shaded.org.apache.maven.model.Plugin;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.PluginResolutionException;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.internal.PlexusUtilsInjector;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.internal.PluginDependenciesResolver;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.internal.WagonExcluder;
import io.quarkus.launcher.shaded.org.codehaus.plexus.component.annotations.Component;
import io.quarkus.launcher.shaded.org.codehaus.plexus.component.annotations.Requirement;
import io.quarkus.launcher.shaded.org.codehaus.plexus.logging.Logger;
import io.quarkus.launcher.shaded.org.codehaus.plexus.util.StringUtils;
import io.quarkus.launcher.shaded.org.eclipse.aether.DefaultRepositorySystemSession;
import io.quarkus.launcher.shaded.org.eclipse.aether.RepositorySystem;
import io.quarkus.launcher.shaded.org.eclipse.aether.RepositorySystemSession;
import io.quarkus.launcher.shaded.org.eclipse.aether.RequestTrace;
import io.quarkus.launcher.shaded.org.eclipse.aether.artifact.Artifact;
import io.quarkus.launcher.shaded.org.eclipse.aether.artifact.DefaultArtifact;
import io.quarkus.launcher.shaded.org.eclipse.aether.collection.CollectRequest;
import io.quarkus.launcher.shaded.org.eclipse.aether.collection.DependencyCollectionException;
import io.quarkus.launcher.shaded.org.eclipse.aether.collection.DependencyGraphTransformer;
import io.quarkus.launcher.shaded.org.eclipse.aether.collection.DependencySelector;
import io.quarkus.launcher.shaded.org.eclipse.aether.graph.DependencyFilter;
import io.quarkus.launcher.shaded.org.eclipse.aether.graph.DependencyNode;
import io.quarkus.launcher.shaded.org.eclipse.aether.graph.DependencyVisitor;
import io.quarkus.launcher.shaded.org.eclipse.aether.graph.Exclusion;
import io.quarkus.launcher.shaded.org.eclipse.aether.repository.RemoteRepository;
import io.quarkus.launcher.shaded.org.eclipse.aether.resolution.ArtifactDescriptorException;
import io.quarkus.launcher.shaded.org.eclipse.aether.resolution.ArtifactDescriptorRequest;
import io.quarkus.launcher.shaded.org.eclipse.aether.resolution.ArtifactDescriptorResult;
import io.quarkus.launcher.shaded.org.eclipse.aether.resolution.ArtifactRequest;
import io.quarkus.launcher.shaded.org.eclipse.aether.resolution.ArtifactResolutionException;
import io.quarkus.launcher.shaded.org.eclipse.aether.resolution.DependencyRequest;
import io.quarkus.launcher.shaded.org.eclipse.aether.resolution.DependencyResolutionException;
import io.quarkus.launcher.shaded.org.eclipse.aether.util.filter.AndDependencyFilter;
import io.quarkus.launcher.shaded.org.eclipse.aether.util.filter.ScopeDependencyFilter;
import io.quarkus.launcher.shaded.org.eclipse.aether.util.graph.manager.DependencyManagerUtils;
import io.quarkus.launcher.shaded.org.eclipse.aether.util.graph.selector.AndDependencySelector;
import io.quarkus.launcher.shaded.org.eclipse.aether.util.graph.transformer.ChainedDependencyGraphTransformer;
import io.quarkus.launcher.shaded.org.eclipse.aether.util.repository.SimpleArtifactDescriptorPolicy;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@Component(role=PluginDependenciesResolver.class)
public class DefaultPluginDependenciesResolver
implements PluginDependenciesResolver {
    private static final String REPOSITORY_CONTEXT = "io.quarkus.launcher.shaded.plugin";
    @Requirement
    private Logger logger;
    @Requirement
    private RepositorySystem repoSystem;

    private Artifact toArtifact(Plugin plugin, RepositorySystemSession session) {
        return new DefaultArtifact(plugin.getGroupId(), plugin.getArtifactId(), null, "io.quarkus.launcher.shaded.jar", plugin.getVersion(), session.getArtifactTypeRegistry().get("io.quarkus.launcher.shaded.maven-plugin"));
    }

    @Override
    public Artifact resolve(Plugin plugin, List<RemoteRepository> repositories, RepositorySystemSession session) throws PluginResolutionException {
        RequestTrace trace = RequestTrace.newChild(null, plugin);
        Artifact pluginArtifact = this.toArtifact(plugin, session);
        try {
            DefaultRepositorySystemSession pluginSession = new DefaultRepositorySystemSession(session);
            pluginSession.setArtifactDescriptorPolicy(new SimpleArtifactDescriptorPolicy(true, false));
            ArtifactDescriptorRequest request = new ArtifactDescriptorRequest(pluginArtifact, repositories, REPOSITORY_CONTEXT);
            request.setTrace(trace);
            ArtifactDescriptorResult result = this.repoSystem.readArtifactDescriptor(pluginSession, request);
            pluginArtifact = result.getArtifact();
            String requiredMavenVersion = (String)result.getProperties().get("io.quarkus.launcher.shaded.prerequisites.maven");
            if (requiredMavenVersion != null) {
                LinkedHashMap<String, String> props = new LinkedHashMap<String, String>(pluginArtifact.getProperties());
                props.put("io.quarkus.launcher.shaded.requiredMavenVersion", requiredMavenVersion);
                pluginArtifact = pluginArtifact.setProperties(props);
            }
        }
        catch (ArtifactDescriptorException e) {
            throw new PluginResolutionException(plugin, (Throwable)e);
        }
        try {
            ArtifactRequest request = new ArtifactRequest(pluginArtifact, repositories, REPOSITORY_CONTEXT);
            request.setTrace(trace);
            pluginArtifact = this.repoSystem.resolveArtifact(session, request).getArtifact();
        }
        catch (ArtifactResolutionException e) {
            throw new PluginResolutionException(plugin, (Throwable)e);
        }
        return pluginArtifact;
    }

    public DependencyNode resolveCoreExtension(Plugin plugin, DependencyFilter dependencyFilter, List<RemoteRepository> repositories, RepositorySystemSession session) throws PluginResolutionException {
        return this.resolveInternal(plugin, null, dependencyFilter, null, repositories, session);
    }

    @Override
    public DependencyNode resolve(Plugin plugin, Artifact pluginArtifact, DependencyFilter dependencyFilter, List<RemoteRepository> repositories, RepositorySystemSession session) throws PluginResolutionException {
        return this.resolveInternal(plugin, pluginArtifact, dependencyFilter, new PlexusUtilsInjector(), repositories, session);
    }

    private DependencyNode resolveInternal(Plugin plugin, Artifact pluginArtifact, DependencyFilter dependencyFilter, DependencyGraphTransformer transformer, List<RemoteRepository> repositories, RepositorySystemSession session) throws PluginResolutionException {
        DependencyNode node;
        RequestTrace trace = RequestTrace.newChild(null, plugin);
        if (pluginArtifact == null) {
            pluginArtifact = this.toArtifact(plugin, session);
        }
        ScopeDependencyFilter collectionFilter = new ScopeDependencyFilter("io.quarkus.launcher.shaded.provided", "io.quarkus.launcher.shaded.test");
        DependencyFilter resolutionFilter = AndDependencyFilter.newInstance(collectionFilter, dependencyFilter);
        try {
            DependencySelector selector = AndDependencySelector.newInstance(session.getDependencySelector(), new WagonExcluder());
            transformer = ChainedDependencyGraphTransformer.newInstance(session.getDependencyGraphTransformer(), transformer);
            DefaultRepositorySystemSession pluginSession = new DefaultRepositorySystemSession(session);
            pluginSession.setDependencySelector(selector);
            pluginSession.setDependencyGraphTransformer(transformer);
            CollectRequest request = new CollectRequest();
            request.setRequestContext(REPOSITORY_CONTEXT);
            request.setRepositories(repositories);
            request.setRoot(new io.quarkus.launcher.shaded.org.eclipse.aether.graph.Dependency(pluginArtifact, null));
            for (Dependency dependency : plugin.getDependencies()) {
                io.quarkus.launcher.shaded.org.eclipse.aether.graph.Dependency pluginDep = RepositoryUtils.toDependency(dependency, session.getArtifactTypeRegistry());
                if (!"io.quarkus.launcher.shaded.system".equals(pluginDep.getScope())) {
                    pluginDep = pluginDep.setScope("io.quarkus.launcher.shaded.runtime");
                }
                request.addDependency(pluginDep);
            }
            DependencyRequest depRequest = new DependencyRequest(request, resolutionFilter);
            depRequest.setTrace(trace);
            request.setTrace(RequestTrace.newChild(trace, depRequest));
            node = this.repoSystem.collectDependencies(pluginSession, request).getRoot();
            if (this.logger.isDebugEnabled()) {
                node.accept(new GraphLogger());
            }
            depRequest.setRoot(node);
            this.repoSystem.resolveDependencies(session, depRequest);
        }
        catch (DependencyCollectionException e) {
            throw new PluginResolutionException(plugin, (Throwable)e);
        }
        catch (DependencyResolutionException e) {
            throw new PluginResolutionException(plugin, e.getCause());
        }
        return node;
    }

    class GraphLogger
    implements DependencyVisitor {
        private String indent = "io.quarkus.launcher.shaded.";

        GraphLogger() {
        }

        @Override
        public boolean visitEnter(DependencyNode node) {
            StringBuilder buffer = new StringBuilder(128);
            buffer.append(this.indent);
            io.quarkus.launcher.shaded.org.eclipse.aether.graph.Dependency dep = node.getDependency();
            if (dep != null) {
                Artifact art = dep.getArtifact();
                buffer.append(art);
                if (StringUtils.isNotEmpty(dep.getScope())) {
                    buffer.append(':').append(dep.getScope());
                }
                if (dep.isOptional()) {
                    buffer.append("io.quarkus.launcher.shaded. (optional)");
                }
                if ((node.getManagedBits() & 2) == 2) {
                    String premanagedScope = DependencyManagerUtils.getPremanagedScope(node);
                    buffer.append("io.quarkus.launcher.shaded. (scope managed from ");
                    buffer.append(StringUtils.defaultString(premanagedScope, "io.quarkus.launcher.shaded.default"));
                    buffer.append(')');
                }
                if ((node.getManagedBits() & 1) == 1) {
                    String premanagedVersion = DependencyManagerUtils.getPremanagedVersion(node);
                    buffer.append("io.quarkus.launcher.shaded. (version managed from ");
                    buffer.append(StringUtils.defaultString(premanagedVersion, "io.quarkus.launcher.shaded.default"));
                    buffer.append(')');
                }
                if ((node.getManagedBits() & 4) == 4) {
                    Boolean premanagedOptional = DependencyManagerUtils.getPremanagedOptional(node);
                    buffer.append("io.quarkus.launcher.shaded. (optionality managed from ");
                    buffer.append(StringUtils.defaultString(premanagedOptional, "io.quarkus.launcher.shaded.default"));
                    buffer.append(')');
                }
                if ((node.getManagedBits() & 0x10) == 16) {
                    Collection<Exclusion> premanagedExclusions = DependencyManagerUtils.getPremanagedExclusions(node);
                    buffer.append("io.quarkus.launcher.shaded. (exclusions managed from ");
                    buffer.append(StringUtils.defaultString(premanagedExclusions, "io.quarkus.launcher.shaded.default"));
                    buffer.append(')');
                }
                if ((node.getManagedBits() & 8) == 8) {
                    Map<String, String> premanagedProperties = DependencyManagerUtils.getPremanagedProperties(node);
                    buffer.append("io.quarkus.launcher.shaded. (properties managed from ");
                    buffer.append(StringUtils.defaultString(premanagedProperties, "io.quarkus.launcher.shaded.default"));
                    buffer.append(')');
                }
            }
            DefaultPluginDependenciesResolver.this.logger.debug(buffer.toString());
            this.indent = this.indent + "io.quarkus.launcher.shaded.   ";
            return true;
        }

        @Override
        public boolean visitLeave(DependencyNode node) {
            this.indent = this.indent.substring(0, this.indent.length() - 3);
            return true;
        }
    }
}

