/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.maven.plugin.internal;

import io.quarkus.launcher.shaded.org.apache.maven.artifact.repository.ArtifactRepository;
import io.quarkus.launcher.shaded.org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import io.quarkus.launcher.shaded.org.apache.maven.artifact.resolver.ArtifactResolutionException;
import io.quarkus.launcher.shaded.org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import io.quarkus.launcher.shaded.org.apache.maven.execution.MavenSession;
import io.quarkus.launcher.shaded.org.apache.maven.model.Plugin;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.InvalidPluginDescriptorException;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.InvalidPluginException;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.LegacySupport;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.MavenPluginManager;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.MojoExecution;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.MojoExecutionException;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.MojoFailureException;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.PluginConfigurationException;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.PluginDescriptorParsingException;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.PluginManager;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.PluginManagerException;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.PluginNotFoundException;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.PluginResolutionException;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.descriptor.PluginDescriptor;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.prefix.DefaultPluginPrefixRequest;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.prefix.NoPluginFoundForPrefixException;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.prefix.PluginPrefixResolver;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.prefix.PluginPrefixResult;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.version.DefaultPluginVersionRequest;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.version.PluginVersionNotFoundException;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.version.PluginVersionResolutionException;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.version.PluginVersionResolver;
import io.quarkus.launcher.shaded.org.apache.maven.project.MavenProject;
import io.quarkus.launcher.shaded.org.apache.maven.project.artifact.InvalidDependencyVersionException;
import io.quarkus.launcher.shaded.org.apache.maven.settings.Settings;
import io.quarkus.launcher.shaded.org.codehaus.plexus.PlexusContainer;
import io.quarkus.launcher.shaded.org.codehaus.plexus.component.annotations.Component;
import io.quarkus.launcher.shaded.org.codehaus.plexus.component.annotations.Requirement;
import io.quarkus.launcher.shaded.org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import java.util.Map;

@Component(role=PluginManager.class)
public class DefaultPluginManager
implements PluginManager {
    @Requirement
    private PlexusContainer container;
    @Requirement
    private MavenPluginManager pluginManager;
    @Requirement
    private PluginVersionResolver pluginVersionResolver;
    @Requirement
    private PluginPrefixResolver pluginPrefixResolver;
    @Requirement
    private LegacySupport legacySupport;

    @Override
    public void executeMojo(MavenProject project, MojoExecution execution, MavenSession session) throws MojoExecutionException, ArtifactResolutionException, MojoFailureException, ArtifactNotFoundException, InvalidDependencyVersionException, PluginManagerException, PluginConfigurationException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getPluginComponent(Plugin plugin, String role, String roleHint) throws PluginManagerException, ComponentLookupException {
        PluginDescriptor pluginDescriptor;
        MavenSession session = this.legacySupport.getSession();
        try {
            pluginDescriptor = this.pluginManager.getPluginDescriptor(plugin, session.getCurrentProject().getRemotePluginRepositories(), session.getRepositorySession());
            this.pluginManager.setupPluginRealm(pluginDescriptor, session, null, null, null);
        }
        catch (Exception e) {
            throw new PluginManagerException(plugin, e.getMessage(), (Throwable)e);
        }
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(pluginDescriptor.getClassRealm());
            Object object = this.container.lookup(role, roleHint);
            return object;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> getPluginComponents(Plugin plugin, String role) throws ComponentLookupException, PluginManagerException {
        PluginDescriptor pluginDescriptor;
        MavenSession session = this.legacySupport.getSession();
        try {
            pluginDescriptor = this.pluginManager.getPluginDescriptor(plugin, session.getCurrentProject().getRemotePluginRepositories(), session.getRepositorySession());
            this.pluginManager.setupPluginRealm(pluginDescriptor, session, null, null, null);
        }
        catch (Exception e) {
            throw new PluginManagerException(plugin, e.getMessage(), (Throwable)e);
        }
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(pluginDescriptor.getClassRealm());
            Map<String, Object> map = this.container.lookupMap(role);
            return map;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    @Override
    public Plugin getPluginDefinitionForPrefix(String prefix, MavenSession session, MavenProject project) {
        DefaultPluginPrefixRequest request = new DefaultPluginPrefixRequest(prefix, session);
        request.setPom(project.getModel());
        try {
            PluginPrefixResult result = this.pluginPrefixResolver.resolve(request);
            Plugin plugin = new Plugin();
            plugin.setGroupId(result.getGroupId());
            plugin.setArtifactId(result.getArtifactId());
            return plugin;
        }
        catch (NoPluginFoundForPrefixException e) {
            return null;
        }
    }

    @Override
    public PluginDescriptor getPluginDescriptorForPrefix(String prefix) {
        MavenSession session = this.legacySupport.getSession();
        DefaultPluginPrefixRequest request = new DefaultPluginPrefixRequest(prefix, session);
        try {
            PluginPrefixResult result = this.pluginPrefixResolver.resolve(request);
            Plugin plugin = new Plugin();
            plugin.setGroupId(result.getGroupId());
            plugin.setArtifactId(result.getArtifactId());
            return this.loadPluginDescriptor(plugin, session.getCurrentProject(), session);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public PluginDescriptor loadPluginDescriptor(Plugin plugin, MavenProject project, MavenSession session) throws ArtifactResolutionException, PluginVersionResolutionException, ArtifactNotFoundException, InvalidVersionSpecificationException, InvalidPluginException, PluginManagerException, PluginNotFoundException, PluginVersionNotFoundException {
        return this.verifyPlugin(plugin, project, session.getSettings(), session.getLocalRepository());
    }

    @Override
    public PluginDescriptor loadPluginFully(Plugin plugin, MavenProject project, MavenSession session) throws ArtifactResolutionException, PluginVersionResolutionException, ArtifactNotFoundException, InvalidVersionSpecificationException, InvalidPluginException, PluginManagerException, PluginNotFoundException, PluginVersionNotFoundException {
        PluginDescriptor pluginDescriptor = this.loadPluginDescriptor(plugin, project, session);
        try {
            this.pluginManager.setupPluginRealm(pluginDescriptor, session, null, null, null);
        }
        catch (PluginResolutionException e) {
            throw new PluginManagerException(plugin, e.getMessage(), (Throwable)e);
        }
        return pluginDescriptor;
    }

    @Override
    public PluginDescriptor verifyPlugin(Plugin plugin, MavenProject project, Settings settings, ArtifactRepository localRepository) throws ArtifactResolutionException, PluginVersionResolutionException, ArtifactNotFoundException, InvalidVersionSpecificationException, InvalidPluginException, PluginManagerException, PluginNotFoundException, PluginVersionNotFoundException {
        MavenSession session = this.legacySupport.getSession();
        if (plugin.getVersion() == null) {
            DefaultPluginVersionRequest versionRequest = new DefaultPluginVersionRequest(plugin, session.getRepositorySession(), project.getRemotePluginRepositories());
            plugin.setVersion(this.pluginVersionResolver.resolve(versionRequest).getVersion());
        }
        try {
            return this.pluginManager.getPluginDescriptor(plugin, project.getRemotePluginRepositories(), session.getRepositorySession());
        }
        catch (PluginResolutionException e) {
            throw new PluginNotFoundException(plugin, project.getPluginArtifactRepositories());
        }
        catch (InvalidPluginDescriptorException | PluginDescriptorParsingException e) {
            throw new PluginManagerException(plugin, e.getMessage(), (Throwable)e);
        }
    }
}

