/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.maven.plugin.internal;

import io.quarkus.launcher.shaded.org.eclipse.aether.RepositoryException;
import io.quarkus.launcher.shaded.org.eclipse.aether.artifact.Artifact;
import io.quarkus.launcher.shaded.org.eclipse.aether.artifact.DefaultArtifact;
import io.quarkus.launcher.shaded.org.eclipse.aether.collection.DependencyGraphTransformationContext;
import io.quarkus.launcher.shaded.org.eclipse.aether.collection.DependencyGraphTransformer;
import io.quarkus.launcher.shaded.org.eclipse.aether.graph.DefaultDependencyNode;
import io.quarkus.launcher.shaded.org.eclipse.aether.graph.Dependency;
import io.quarkus.launcher.shaded.org.eclipse.aether.graph.DependencyNode;

class PlexusUtilsInjector
implements DependencyGraphTransformer {
    private static final String GID = "io.quarkus.launcher.shaded.org.codehaus.plexus";
    private static final String AID = "io.quarkus.launcher.shaded.plexus-utils";
    private static final String VER = "io.quarkus.launcher.shaded.1.1";
    private static final String EXT = "io.quarkus.launcher.shaded.jar";

    PlexusUtilsInjector() {
    }

    @Override
    public DependencyNode transformGraph(DependencyNode node, DependencyGraphTransformationContext context) throws RepositoryException {
        if (this.findPlexusUtils(node) == null) {
            DefaultArtifact pu = new DefaultArtifact(GID, AID, null, EXT, VER);
            DefaultDependencyNode child = new DefaultDependencyNode(new Dependency(pu, "io.quarkus.launcher.shaded.runtime"));
            child.setRepositories(node.getRepositories());
            child.setRequestContext(node.getRequestContext());
            node.getChildren().add(child);
        }
        return node;
    }

    private DependencyNode findPlexusUtils(DependencyNode node) {
        Artifact artifact = node.getDependency().getArtifact();
        if (AID.equals(artifact.getArtifactId()) && GID.equals(artifact.getGroupId()) && EXT.equals(artifact.getExtension()) && "io.quarkus.launcher.shaded.".equals(artifact.getClassifier())) {
            return node;
        }
        for (DependencyNode child : node.getChildren()) {
            DependencyNode result = this.findPlexusUtils(child);
            if (result == null) continue;
            return result;
        }
        return null;
    }
}

