/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.maven.plugin.prefix;

import io.quarkus.launcher.shaded.org.eclipse.aether.repository.LocalRepository;
import io.quarkus.launcher.shaded.org.eclipse.aether.repository.RemoteRepository;
import java.util.List;

public class NoPluginFoundForPrefixException
extends Exception {
    public NoPluginFoundForPrefixException(String prefix, List<String> pluginGroups, LocalRepository localRepository, List<RemoteRepository> remoteRepositories) {
        super("io.quarkus.launcher.shaded.No plugin found for prefix '" + prefix + "io.quarkus.launcher.shaded.' in the current project and in the plugin groups " + pluginGroups + "io.quarkus.launcher.shaded. available from the repositories " + NoPluginFoundForPrefixException.format(localRepository, remoteRepositories));
    }

    private static String format(LocalRepository localRepository, List<RemoteRepository> remoteRepositories) {
        String repos = "io.quarkus.launcher.shaded.[";
        if (localRepository != null) {
            repos = repos + localRepository.getId() + "io.quarkus.launcher.shaded. (" + localRepository.getBasedir() + "io.quarkus.launcher.shaded.)";
        }
        if (remoteRepositories != null && !remoteRepositories.isEmpty()) {
            for (RemoteRepository repository : remoteRepositories) {
                repos = repos + "io.quarkus.launcher.shaded., ";
                if (repository == null) continue;
                repos = repos + repository.getId() + "io.quarkus.launcher.shaded. (" + repository.getUrl() + "io.quarkus.launcher.shaded.)";
            }
        }
        repos = repos + "io.quarkus.launcher.shaded.]";
        return repos;
    }
}

