/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.maven.plugin.prefix.internal;

import io.quarkus.launcher.shaded.org.apache.maven.artifact.repository.metadata.Metadata;
import io.quarkus.launcher.shaded.org.apache.maven.artifact.repository.metadata.io.MetadataReader;
import io.quarkus.launcher.shaded.org.apache.maven.model.Build;
import io.quarkus.launcher.shaded.org.apache.maven.model.Plugin;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.BuildPluginManager;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.descriptor.PluginDescriptor;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.prefix.NoPluginFoundForPrefixException;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.prefix.PluginPrefixRequest;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.prefix.PluginPrefixResolver;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.prefix.PluginPrefixResult;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.prefix.internal.DefaultPluginPrefixResult;
import io.quarkus.launcher.shaded.org.codehaus.plexus.component.annotations.Component;
import io.quarkus.launcher.shaded.org.codehaus.plexus.component.annotations.Requirement;
import io.quarkus.launcher.shaded.org.codehaus.plexus.logging.Logger;
import io.quarkus.launcher.shaded.org.eclipse.aether.DefaultRepositorySystemSession;
import io.quarkus.launcher.shaded.org.eclipse.aether.RepositoryEvent;
import io.quarkus.launcher.shaded.org.eclipse.aether.RepositoryListener;
import io.quarkus.launcher.shaded.org.eclipse.aether.RepositorySystem;
import io.quarkus.launcher.shaded.org.eclipse.aether.RepositorySystemSession;
import io.quarkus.launcher.shaded.org.eclipse.aether.RequestTrace;
import io.quarkus.launcher.shaded.org.eclipse.aether.metadata.DefaultMetadata;
import io.quarkus.launcher.shaded.org.eclipse.aether.metadata.Metadata;
import io.quarkus.launcher.shaded.org.eclipse.aether.repository.ArtifactRepository;
import io.quarkus.launcher.shaded.org.eclipse.aether.repository.RemoteRepository;
import io.quarkus.launcher.shaded.org.eclipse.aether.resolution.MetadataRequest;
import io.quarkus.launcher.shaded.org.eclipse.aether.resolution.MetadataResult;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

@Component(role=PluginPrefixResolver.class)
public class DefaultPluginPrefixResolver
implements PluginPrefixResolver {
    private static final String REPOSITORY_CONTEXT = "io.quarkus.launcher.shaded.plugin";
    @Requirement
    private Logger logger;
    @Requirement
    private BuildPluginManager pluginManager;
    @Requirement
    private RepositorySystem repositorySystem;
    @Requirement
    private MetadataReader metadataReader;

    @Override
    public PluginPrefixResult resolve(PluginPrefixRequest request) throws NoPluginFoundForPrefixException {
        this.logger.debug("io.quarkus.launcher.shaded.Resolving plugin prefix " + request.getPrefix() + "io.quarkus.launcher.shaded. from " + request.getPluginGroups());
        PluginPrefixResult result = this.resolveFromProject(request);
        if (result == null) {
            result = this.resolveFromRepository(request);
            if (result == null) {
                throw new NoPluginFoundForPrefixException(request.getPrefix(), request.getPluginGroups(), request.getRepositorySession().getLocalRepository(), request.getRepositories());
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("io.quarkus.launcher.shaded.Resolved plugin prefix " + request.getPrefix() + "io.quarkus.launcher.shaded. to " + result.getGroupId() + "io.quarkus.launcher.shaded.:" + result.getArtifactId() + "io.quarkus.launcher.shaded. from repository " + (result.getRepository() != null ? result.getRepository().getId() : "io.quarkus.launcher.shaded.null"));
            }
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug("io.quarkus.launcher.shaded.Resolved plugin prefix " + request.getPrefix() + "io.quarkus.launcher.shaded. to " + result.getGroupId() + "io.quarkus.launcher.shaded.:" + result.getArtifactId() + "io.quarkus.launcher.shaded. from POM " + request.getPom());
        }
        return result;
    }

    private PluginPrefixResult resolveFromProject(PluginPrefixRequest request) {
        Build build;
        PluginPrefixResult result = null;
        if (request.getPom() != null && request.getPom().getBuild() != null && (result = this.resolveFromProject(request, (build = request.getPom().getBuild()).getPlugins())) == null && build.getPluginManagement() != null) {
            result = this.resolveFromProject(request, build.getPluginManagement().getPlugins());
        }
        return result;
    }

    private PluginPrefixResult resolveFromProject(PluginPrefixRequest request, List<Plugin> plugins) {
        for (Plugin plugin : plugins) {
            try {
                PluginDescriptor pluginDescriptor = this.pluginManager.loadPlugin(plugin, request.getRepositories(), request.getRepositorySession());
                if (!request.getPrefix().equals(pluginDescriptor.getGoalPrefix())) continue;
                return new DefaultPluginPrefixResult(plugin);
            }
            catch (Exception e) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.warn("io.quarkus.launcher.shaded.Failed to retrieve plugin descriptor for " + plugin.getId() + "io.quarkus.launcher.shaded.: " + e.getMessage(), e);
                    continue;
                }
                this.logger.warn("io.quarkus.launcher.shaded.Failed to retrieve plugin descriptor for " + plugin.getId() + "io.quarkus.launcher.shaded.: " + e.getMessage());
            }
        }
        return null;
    }

    private PluginPrefixResult resolveFromRepository(PluginPrefixRequest request) {
        RequestTrace trace = RequestTrace.newChild(null, request);
        ArrayList<MetadataRequest> requests = new ArrayList<MetadataRequest>();
        for (String pluginGroup : request.getPluginGroups()) {
            DefaultMetadata metadata = new DefaultMetadata(pluginGroup, "io.quarkus.launcher.shaded.maven-metadata.xml", Metadata.Nature.RELEASE_OR_SNAPSHOT);
            requests.add(new MetadataRequest(metadata, null, REPOSITORY_CONTEXT).setTrace(trace));
            for (RemoteRepository repository : request.getRepositories()) {
                requests.add(new MetadataRequest(metadata, repository, REPOSITORY_CONTEXT).setTrace(trace));
            }
        }
        List<MetadataResult> results = this.repositorySystem.resolveMetadata(request.getRepositorySession(), requests);
        requests.clear();
        PluginPrefixResult result = this.processResults(request, trace, results, requests);
        if (result != null) {
            return result;
        }
        if (!request.getRepositorySession().isOffline() && !requests.isEmpty()) {
            DefaultRepositorySystemSession session = new DefaultRepositorySystemSession(request.getRepositorySession());
            session.setUpdatePolicy("io.quarkus.launcher.shaded.always");
            results = this.repositorySystem.resolveMetadata(session, requests);
            return this.processResults(request, trace, results, null);
        }
        return null;
    }

    private PluginPrefixResult processResults(PluginPrefixRequest request, RequestTrace trace, List<MetadataResult> results, List<MetadataRequest> requests) {
        for (MetadataResult res : results) {
            io.quarkus.launcher.shaded.org.eclipse.aether.metadata.Metadata metadata = res.getMetadata();
            if (metadata != null) {
                PluginPrefixResult result;
                ArtifactRepository repository = res.getRequest().getRepository();
                if (repository == null) {
                    repository = request.getRepositorySession().getLocalRepository();
                }
                if ((result = this.resolveFromRepository(request, trace, metadata.getGroupId(), metadata, repository)) != null) {
                    return result;
                }
            }
            if (requests == null || res.isUpdated()) continue;
            requests.add(res.getRequest());
        }
        return null;
    }

    private PluginPrefixResult resolveFromRepository(PluginPrefixRequest request, RequestTrace trace, String pluginGroup, io.quarkus.launcher.shaded.org.eclipse.aether.metadata.Metadata metadata, ArtifactRepository repository) {
        if (metadata != null && metadata.getFile() != null && metadata.getFile().isFile()) {
            try {
                Map<String, Boolean> options = Collections.singletonMap("io.quarkus.launcher.shaded.org.apache.maven.artifact.repository.metadata.io.isStrict", Boolean.FALSE);
                Metadata pluginGroupMetadata = this.metadataReader.read(metadata.getFile(), options);
                List<io.quarkus.launcher.shaded.org.apache.maven.artifact.repository.metadata.Plugin> plugins = pluginGroupMetadata.getPlugins();
                if (plugins != null) {
                    for (io.quarkus.launcher.shaded.org.apache.maven.artifact.repository.metadata.Plugin plugin : plugins) {
                        if (!request.getPrefix().equals(plugin.getPrefix())) continue;
                        return new DefaultPluginPrefixResult(pluginGroup, plugin.getArtifactId(), repository);
                    }
                }
            }
            catch (IOException e) {
                this.invalidMetadata(request.getRepositorySession(), trace, metadata, repository, e);
            }
        }
        return null;
    }

    private void invalidMetadata(RepositorySystemSession session, RequestTrace trace, io.quarkus.launcher.shaded.org.eclipse.aether.metadata.Metadata metadata, ArtifactRepository repository, Exception exception) {
        RepositoryListener listener = session.getRepositoryListener();
        if (listener != null) {
            RepositoryEvent.Builder event = new RepositoryEvent.Builder(session, RepositoryEvent.EventType.METADATA_INVALID);
            event.setTrace(trace);
            event.setMetadata(metadata);
            event.setException(exception);
            event.setRepository(repository);
            listener.metadataInvalid(event.build());
        }
    }
}

