/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.maven.plugin.version;

import io.quarkus.launcher.shaded.org.apache.maven.execution.MavenSession;
import io.quarkus.launcher.shaded.org.apache.maven.model.Model;
import io.quarkus.launcher.shaded.org.apache.maven.model.Plugin;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.version.PluginVersionRequest;
import io.quarkus.launcher.shaded.org.apache.maven.project.MavenProject;
import io.quarkus.launcher.shaded.org.eclipse.aether.RepositorySystemSession;
import io.quarkus.launcher.shaded.org.eclipse.aether.repository.RemoteRepository;
import java.util.Collections;
import java.util.List;

public class DefaultPluginVersionRequest
implements PluginVersionRequest {
    private String groupId;
    private String artifactId;
    private Model pom;
    private List<RemoteRepository> repositories = Collections.emptyList();
    private RepositorySystemSession session;

    public DefaultPluginVersionRequest() {
    }

    public DefaultPluginVersionRequest(Plugin plugin, MavenSession session) {
        this.setGroupId(plugin.getGroupId());
        this.setArtifactId(plugin.getArtifactId());
        this.setRepositorySession(session.getRepositorySession());
        MavenProject project = session.getCurrentProject();
        if (project != null) {
            this.setRepositories((List)project.getRemotePluginRepositories());
        }
    }

    public DefaultPluginVersionRequest(Plugin plugin, RepositorySystemSession session, List<RemoteRepository> repositories) {
        this.setGroupId(plugin.getGroupId());
        this.setArtifactId(plugin.getArtifactId());
        this.setRepositorySession(session);
        this.setRepositories((List)repositories);
    }

    @Override
    public String getGroupId() {
        return this.groupId;
    }

    @Override
    public DefaultPluginVersionRequest setGroupId(String groupId) {
        this.groupId = groupId;
        return this;
    }

    @Override
    public String getArtifactId() {
        return this.artifactId;
    }

    @Override
    public DefaultPluginVersionRequest setArtifactId(String artifactId) {
        this.artifactId = artifactId;
        return this;
    }

    @Override
    public Model getPom() {
        return this.pom;
    }

    @Override
    public DefaultPluginVersionRequest setPom(Model pom) {
        this.pom = pom;
        return this;
    }

    @Override
    public List<RemoteRepository> getRepositories() {
        return this.repositories;
    }

    @Override
    public DefaultPluginVersionRequest setRepositories(List<RemoteRepository> repositories) {
        this.repositories = repositories != null ? Collections.unmodifiableList(repositories) : Collections.emptyList();
        return this;
    }

    @Override
    public RepositorySystemSession getRepositorySession() {
        return this.session;
    }

    @Override
    public DefaultPluginVersionRequest setRepositorySession(RepositorySystemSession session) {
        this.session = session;
        return this;
    }
}

