/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.maven.plugin.version;

import io.quarkus.launcher.shaded.org.eclipse.aether.repository.LocalRepository;
import io.quarkus.launcher.shaded.org.eclipse.aether.repository.RemoteRepository;
import java.util.List;

public class PluginVersionResolutionException
extends Exception {
    private final String groupId;
    private final String artifactId;
    private final String baseMessage;

    public PluginVersionResolutionException(String groupId, String artifactId, String baseMessage, Throwable cause) {
        super("io.quarkus.launcher.shaded.Error resolving version for plugin '" + groupId + "io.quarkus.launcher.shaded.:" + artifactId + "io.quarkus.launcher.shaded.': " + baseMessage, cause);
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.baseMessage = baseMessage;
    }

    public PluginVersionResolutionException(String groupId, String artifactId, String baseMessage) {
        super("io.quarkus.launcher.shaded.Error resolving version for plugin '" + groupId + "io.quarkus.launcher.shaded.:" + artifactId + "io.quarkus.launcher.shaded.': " + baseMessage);
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.baseMessage = baseMessage;
    }

    public PluginVersionResolutionException(String groupId, String artifactId, LocalRepository localRepository, List<RemoteRepository> remoteRepositories, String baseMessage) {
        super("io.quarkus.launcher.shaded.Error resolving version for plugin '" + groupId + "io.quarkus.launcher.shaded.:" + artifactId + "io.quarkus.launcher.shaded.' from the repositories " + PluginVersionResolutionException.format(localRepository, remoteRepositories) + "io.quarkus.launcher.shaded.: " + baseMessage);
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.baseMessage = baseMessage;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getBaseMessage() {
        return this.baseMessage;
    }

    private static String format(LocalRepository localRepository, List<RemoteRepository> remoteRepositories) {
        String repos = "io.quarkus.launcher.shaded.[";
        if (localRepository != null) {
            repos = repos + localRepository.getId() + "io.quarkus.launcher.shaded. (" + localRepository.getBasedir() + "io.quarkus.launcher.shaded.)";
        }
        if (remoteRepositories != null && !remoteRepositories.isEmpty()) {
            for (RemoteRepository repository : remoteRepositories) {
                repos = repos + "io.quarkus.launcher.shaded., ";
                if (repository == null) continue;
                repos = repos + repository.getId() + "io.quarkus.launcher.shaded. (" + repository.getUrl() + "io.quarkus.launcher.shaded.)";
            }
        }
        repos = repos + "io.quarkus.launcher.shaded.]";
        return repos;
    }
}

