/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.maven.project;

import io.quarkus.launcher.shaded.org.apache.maven.artifact.Artifact;
import io.quarkus.launcher.shaded.org.apache.maven.artifact.handler.ArtifactHandler;
import io.quarkus.launcher.shaded.org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import io.quarkus.launcher.shaded.org.apache.maven.model.Resource;
import io.quarkus.launcher.shaded.org.apache.maven.project.MavenProject;
import io.quarkus.launcher.shaded.org.apache.maven.project.MavenProjectHelper;
import io.quarkus.launcher.shaded.org.apache.maven.project.artifact.AttachedArtifact;
import io.quarkus.launcher.shaded.org.codehaus.plexus.component.annotations.Component;
import io.quarkus.launcher.shaded.org.codehaus.plexus.component.annotations.Requirement;
import io.quarkus.launcher.shaded.org.codehaus.plexus.logging.AbstractLogEnabled;
import java.io.File;
import java.util.List;

@Component(role=MavenProjectHelper.class)
public class DefaultMavenProjectHelper
extends AbstractLogEnabled
implements MavenProjectHelper {
    @Requirement
    private ArtifactHandlerManager artifactHandlerManager;

    @Override
    public void attachArtifact(MavenProject project, String artifactType, String artifactClassifier, File artifactFile) {
        String type = artifactType;
        ArtifactHandler handler = null;
        if (type != null) {
            handler = this.artifactHandlerManager.getArtifactHandler(artifactType);
        }
        if (handler == null) {
            handler = this.artifactHandlerManager.getArtifactHandler("io.quarkus.launcher.shaded.jar");
        }
        AttachedArtifact artifact = new AttachedArtifact(project.getArtifact(), artifactType, artifactClassifier, handler);
        artifact.setFile(artifactFile);
        artifact.setResolved(true);
        this.attachArtifact(project, artifact);
    }

    @Override
    public void attachArtifact(MavenProject project, String artifactType, File artifactFile) {
        ArtifactHandler handler = this.artifactHandlerManager.getArtifactHandler(artifactType);
        AttachedArtifact artifact = new AttachedArtifact(project.getArtifact(), artifactType, handler);
        artifact.setFile(artifactFile);
        artifact.setResolved(true);
        this.attachArtifact(project, artifact);
    }

    @Override
    public void attachArtifact(MavenProject project, File artifactFile, String artifactClassifier) {
        Artifact projectArtifact = project.getArtifact();
        AttachedArtifact artifact = new AttachedArtifact(projectArtifact, projectArtifact.getType(), artifactClassifier, projectArtifact.getArtifactHandler());
        artifact.setFile(artifactFile);
        artifact.setResolved(true);
        this.attachArtifact(project, artifact);
    }

    public void attachArtifact(MavenProject project, Artifact artifact) {
        project.addAttachedArtifact(artifact);
    }

    @Override
    public void addResource(MavenProject project, String resourceDirectory, List<String> includes, List<String> excludes) {
        Resource resource = new Resource();
        resource.setDirectory(resourceDirectory);
        resource.setIncludes(includes);
        resource.setExcludes(excludes);
        project.addResource(resource);
    }

    @Override
    public void addTestResource(MavenProject project, String resourceDirectory, List<String> includes, List<String> excludes) {
        Resource resource = new Resource();
        resource.setDirectory(resourceDirectory);
        resource.setIncludes(includes);
        resource.setExcludes(excludes);
        project.addTestResource(resource);
    }
}

