/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.maven.project;

import io.quarkus.launcher.shaded.org.apache.maven.artifact.repository.ArtifactRepository;
import io.quarkus.launcher.shaded.org.apache.maven.model.Model;
import io.quarkus.launcher.shaded.org.apache.maven.model.building.AbstractModelBuildingListener;
import io.quarkus.launcher.shaded.org.apache.maven.model.building.ModelBuildingEvent;
import io.quarkus.launcher.shaded.org.apache.maven.model.building.ModelProblem;
import io.quarkus.launcher.shaded.org.apache.maven.model.building.ModelProblemCollectorRequest;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.PluginManagerException;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.PluginResolutionException;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.version.PluginVersionResolutionException;
import io.quarkus.launcher.shaded.org.apache.maven.project.MavenProject;
import io.quarkus.launcher.shaded.org.apache.maven.project.ProjectBuildingHelper;
import io.quarkus.launcher.shaded.org.apache.maven.project.ProjectBuildingRequest;
import io.quarkus.launcher.shaded.org.apache.maven.project.ProjectRealmCache;
import java.util.List;
import java.util.Objects;

public class DefaultModelBuildingListener
extends AbstractModelBuildingListener {
    private MavenProject project;
    private ProjectBuildingHelper projectBuildingHelper;
    private ProjectBuildingRequest projectBuildingRequest;
    private List<ArtifactRepository> remoteRepositories;
    private List<ArtifactRepository> pluginRepositories;

    public DefaultModelBuildingListener(MavenProject project, ProjectBuildingHelper projectBuildingHelper, ProjectBuildingRequest projectBuildingRequest) {
        this.project = Objects.requireNonNull(project, "io.quarkus.launcher.shaded.project cannot be null");
        this.projectBuildingHelper = Objects.requireNonNull(projectBuildingHelper, "io.quarkus.launcher.shaded.projectBuildingHelper cannot be null");
        this.projectBuildingRequest = Objects.requireNonNull(projectBuildingRequest, "io.quarkus.launcher.shaded.projectBuildingRequest cannot be null");
        this.remoteRepositories = projectBuildingRequest.getRemoteRepositories();
        this.pluginRepositories = projectBuildingRequest.getPluginArtifactRepositories();
    }

    public MavenProject getProject() {
        return this.project;
    }

    @Override
    public void buildExtensionsAssembled(ModelBuildingEvent event) {
        Model model = event.getModel();
        try {
            this.pluginRepositories = this.projectBuildingHelper.createArtifactRepositories(model.getPluginRepositories(), this.pluginRepositories, this.projectBuildingRequest);
        }
        catch (Exception e) {
            event.getProblems().add(new ModelProblemCollectorRequest(ModelProblem.Severity.ERROR, ModelProblem.Version.BASE).setMessage("io.quarkus.launcher.shaded.Invalid plugin repository: " + e.getMessage()).setException(e));
        }
        this.project.setPluginArtifactRepositories(this.pluginRepositories);
        if (event.getRequest().isProcessPlugins()) {
            try {
                ProjectRealmCache.CacheRecord record = this.projectBuildingHelper.createProjectRealm(this.project, model, this.projectBuildingRequest);
                this.project.setClassRealm(record.getRealm());
                this.project.setExtensionDependencyFilter(record.getExtensionArtifactFilter());
            }
            catch (PluginManagerException | PluginResolutionException | PluginVersionResolutionException e) {
                event.getProblems().add(new ModelProblemCollectorRequest(ModelProblem.Severity.ERROR, ModelProblem.Version.BASE).setMessage("io.quarkus.launcher.shaded.Unresolveable build extension: " + e.getMessage()).setException(e));
            }
            this.projectBuildingHelper.selectProjectRealm(this.project);
        }
        try {
            this.remoteRepositories = this.projectBuildingHelper.createArtifactRepositories(model.getRepositories(), this.remoteRepositories, this.projectBuildingRequest);
        }
        catch (Exception e) {
            event.getProblems().add(new ModelProblemCollectorRequest(ModelProblem.Severity.ERROR, ModelProblem.Version.BASE).setMessage("io.quarkus.launcher.shaded.Invalid artifact repository: " + e.getMessage()).setException(e));
        }
        this.project.setRemoteArtifactRepositories(this.remoteRepositories);
    }
}

