/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.maven.project;

import io.quarkus.launcher.shaded.org.apache.maven.RepositoryUtils;
import io.quarkus.launcher.shaded.org.apache.maven.artifact.Artifact;
import io.quarkus.launcher.shaded.org.apache.maven.artifact.InvalidRepositoryException;
import io.quarkus.launcher.shaded.org.apache.maven.artifact.repository.ArtifactRepository;
import io.quarkus.launcher.shaded.org.apache.maven.classrealm.ClassRealmManager;
import io.quarkus.launcher.shaded.org.apache.maven.model.Build;
import io.quarkus.launcher.shaded.org.apache.maven.model.Extension;
import io.quarkus.launcher.shaded.org.apache.maven.model.Model;
import io.quarkus.launcher.shaded.org.apache.maven.model.Plugin;
import io.quarkus.launcher.shaded.org.apache.maven.model.Repository;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.ExtensionRealmCache;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.MavenPluginManager;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.PluginManagerException;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.PluginResolutionException;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.version.PluginVersionResolutionException;
import io.quarkus.launcher.shaded.org.apache.maven.project.ExtensionDescriptor;
import io.quarkus.launcher.shaded.org.apache.maven.project.MavenProject;
import io.quarkus.launcher.shaded.org.apache.maven.project.ProjectBuildingHelper;
import io.quarkus.launcher.shaded.org.apache.maven.project.ProjectBuildingRequest;
import io.quarkus.launcher.shaded.org.apache.maven.project.ProjectRealmCache;
import io.quarkus.launcher.shaded.org.apache.maven.repository.RepositorySystem;
import io.quarkus.launcher.shaded.org.codehaus.plexus.PlexusContainer;
import io.quarkus.launcher.shaded.org.codehaus.plexus.classworlds.realm.ClassRealm;
import io.quarkus.launcher.shaded.org.codehaus.plexus.component.annotations.Component;
import io.quarkus.launcher.shaded.org.codehaus.plexus.component.annotations.Requirement;
import io.quarkus.launcher.shaded.org.codehaus.plexus.logging.Logger;
import io.quarkus.launcher.shaded.org.eclipse.aether.util.filter.ExclusionsDependencyFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;

@Component(role=ProjectBuildingHelper.class)
public class DefaultProjectBuildingHelper
implements ProjectBuildingHelper {
    @Requirement
    private Logger logger;
    @Requirement
    private PlexusContainer container;
    @Requirement
    private ClassRealmManager classRealmManager;
    @Requirement
    private ProjectRealmCache projectRealmCache;
    @Requirement
    private RepositorySystem repositorySystem;
    @Requirement
    private MavenPluginManager pluginManager;

    @Override
    public List<ArtifactRepository> createArtifactRepositories(List<Repository> pomRepositories, List<ArtifactRepository> externalRepositories, ProjectBuildingRequest request) throws InvalidRepositoryException {
        List<ArtifactRepository> recessiveRepositories;
        List<ArtifactRepository> dominantRepositories;
        ArrayList<ArtifactRepository> internalRepositories = new ArrayList<ArtifactRepository>();
        for (Repository repository : pomRepositories) {
            internalRepositories.add(this.repositorySystem.buildArtifactRepository(repository));
        }
        this.repositorySystem.injectMirror(request.getRepositorySession(), internalRepositories);
        this.repositorySystem.injectProxy(request.getRepositorySession(), internalRepositories);
        this.repositorySystem.injectAuthentication(request.getRepositorySession(), internalRepositories);
        if (ProjectBuildingRequest.RepositoryMerging.REQUEST_DOMINANT.equals((Object)request.getRepositoryMerging())) {
            dominantRepositories = externalRepositories;
            recessiveRepositories = internalRepositories;
        } else {
            dominantRepositories = internalRepositories;
            recessiveRepositories = externalRepositories;
        }
        List<ArtifactRepository> artifactRepositories = new ArrayList<ArtifactRepository>();
        HashSet<String> repoIds = new HashSet<String>();
        if (dominantRepositories != null) {
            for (ArtifactRepository repository : dominantRepositories) {
                repoIds.add(repository.getId());
                artifactRepositories.add(repository);
            }
        }
        if (recessiveRepositories != null) {
            for (ArtifactRepository repository : recessiveRepositories) {
                if (!repoIds.add(repository.getId())) continue;
                artifactRepositories.add(repository);
            }
        }
        artifactRepositories = this.repositorySystem.getEffectiveRepositories(artifactRepositories);
        return artifactRepositories;
    }

    @Override
    public synchronized ProjectRealmCache.CacheRecord createProjectRealm(MavenProject project, Model model, ProjectBuildingRequest request) throws PluginResolutionException, PluginVersionResolutionException, PluginManagerException {
        ProjectRealmCache.Key projectRealmKey;
        ProjectRealmCache.CacheRecord record;
        ArrayList<Plugin> extensionPlugins = new ArrayList<Plugin>();
        Build build = model.getBuild();
        if (build != null) {
            for (Extension extension : build.getExtensions()) {
                Plugin plugin = new Plugin();
                plugin.setGroupId(extension.getGroupId());
                plugin.setArtifactId(extension.getArtifactId());
                plugin.setVersion(extension.getVersion());
                extensionPlugins.add(plugin);
            }
            for (Plugin plugin : build.getPlugins()) {
                if (!plugin.isExtensions()) continue;
                extensionPlugins.add(plugin);
            }
        }
        if (extensionPlugins.isEmpty()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("io.quarkus.launcher.shaded.Extension realms for project " + model.getId() + "io.quarkus.launcher.shaded.: (none)");
            }
            return new ProjectRealmCache.CacheRecord(null, null);
        }
        ArrayList<ClassRealm> extensionRealms = new ArrayList<ClassRealm>();
        HashMap<ClassRealm, List<String>> exportedPackages = new HashMap<ClassRealm, List<String>>();
        HashMap<Object, List<String>> exportedArtifacts = new HashMap<Object, List<String>>();
        ArrayList<Artifact> publicArtifacts = new ArrayList<Artifact>();
        for (Plugin plugin : extensionPlugins) {
            ExtensionRealmCache.CacheRecord recordRealm = this.pluginManager.setupExtensionsRealm(project, plugin, request.getRepositorySession());
            ClassRealm extensionRealm = recordRealm.getRealm();
            ExtensionDescriptor extensionDescriptor = recordRealm.getDescriptor();
            List<Artifact> artifacts = recordRealm.getArtifacts();
            extensionRealms.add(extensionRealm);
            if (extensionDescriptor != null) {
                exportedPackages.put(extensionRealm, extensionDescriptor.getExportedPackages());
                exportedArtifacts.put(extensionRealm, extensionDescriptor.getExportedArtifacts());
            }
            if (plugin.isExtensions() || artifacts.size() != 2 || artifacts.get(0).getFile() == null || !"io.quarkus.launcher.shaded.plexus-utils".equals(artifacts.get(1).getArtifactId())) continue;
            publicArtifacts.add(artifacts.get(0));
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("io.quarkus.launcher.shaded.Extension realms for project " + model.getId() + "io.quarkus.launcher.shaded.: " + extensionRealms);
        }
        if ((record = this.projectRealmCache.get(projectRealmKey = this.projectRealmCache.createKey(extensionRealms))) == null) {
            ClassRealm projectRealm = this.classRealmManager.createProjectRealm(model, this.toAetherArtifacts(publicArtifacts));
            LinkedHashSet<String> exclusions = new LinkedHashSet<String>();
            for (ClassRealm extensionRealm : extensionRealms) {
                List<String> exports;
                List excludes = (List)exportedArtifacts.get(extensionRealm);
                if (excludes != null) {
                    exclusions.addAll(excludes);
                }
                if ((exports = (List<String>)exportedPackages.get(extensionRealm)) == null || exports.isEmpty()) {
                    exports = Arrays.asList(extensionRealm.getId());
                }
                for (String export : exports) {
                    projectRealm.importFrom(extensionRealm, export);
                }
            }
            ExclusionsDependencyFilter extensionArtifactFilter = null;
            if (!exclusions.isEmpty()) {
                extensionArtifactFilter = new ExclusionsDependencyFilter(exclusions);
            }
            record = this.projectRealmCache.put(projectRealmKey, projectRealm, extensionArtifactFilter);
        }
        this.projectRealmCache.register(project, projectRealmKey, record);
        return record;
    }

    @Override
    public void selectProjectRealm(MavenProject project) {
        ClassRealm projectRealm = project.getClassRealm();
        if (projectRealm == null) {
            projectRealm = this.classRealmManager.getCoreRealm();
        }
        Thread.currentThread().setContextClassLoader(projectRealm);
    }

    private List<io.quarkus.launcher.shaded.org.eclipse.aether.artifact.Artifact> toAetherArtifacts(List<Artifact> pluginArtifacts) {
        return new ArrayList<io.quarkus.launcher.shaded.org.eclipse.aether.artifact.Artifact>(RepositoryUtils.toArtifacts(pluginArtifacts));
    }
}

