/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.maven.project;

import io.quarkus.launcher.shaded.org.apache.maven.model.building.ModelProblem;
import io.quarkus.launcher.shaded.org.apache.maven.project.DependencyResolutionResult;
import io.quarkus.launcher.shaded.org.apache.maven.project.MavenProject;
import io.quarkus.launcher.shaded.org.apache.maven.project.ProjectBuildingResult;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

class DefaultProjectBuildingResult
implements ProjectBuildingResult {
    private String projectId;
    private File pomFile;
    private MavenProject project;
    private List<ModelProblem> problems;
    private DependencyResolutionResult dependencyResolutionResult;

    DefaultProjectBuildingResult(MavenProject project, List<ModelProblem> problems, DependencyResolutionResult dependencyResolutionResult) {
        this.projectId = project != null ? project.getGroupId() + ':' + project.getArtifactId() + ':' + project.getVersion() : "io.quarkus.launcher.shaded.";
        this.pomFile = project != null ? project.getFile() : null;
        this.project = project;
        this.problems = problems;
        this.dependencyResolutionResult = dependencyResolutionResult;
    }

    DefaultProjectBuildingResult(String projectId, File pomFile, List<ModelProblem> problems) {
        this.projectId = projectId != null ? projectId : "io.quarkus.launcher.shaded.";
        this.pomFile = pomFile;
        this.problems = problems;
    }

    @Override
    public String getProjectId() {
        return this.projectId;
    }

    @Override
    public File getPomFile() {
        return this.pomFile;
    }

    @Override
    public MavenProject getProject() {
        return this.project;
    }

    @Override
    public List<ModelProblem> getProblems() {
        if (this.problems == null) {
            this.problems = new ArrayList<ModelProblem>();
        }
        return this.problems;
    }

    @Override
    public DependencyResolutionResult getDependencyResolutionResult() {
        return this.dependencyResolutionResult;
    }
}

