/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.maven.project;

import io.quarkus.launcher.shaded.org.apache.maven.project.ExtensionDescriptor;
import io.quarkus.launcher.shaded.org.codehaus.plexus.util.ReaderFactory;
import io.quarkus.launcher.shaded.org.codehaus.plexus.util.xml.Xpp3Dom;
import io.quarkus.launcher.shaded.org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import io.quarkus.launcher.shaded.org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public class ExtensionDescriptorBuilder {
    public String getExtensionDescriptorLocation() {
        return "META-INF/maven/extension.xml";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ExtensionDescriptor build(File extensionJar) throws IOException {
        ExtensionDescriptor extensionDescriptor = null;
        if (extensionJar.isFile()) {
            try (JarFile pluginJar = new JarFile(extensionJar, false);){
                ZipEntry pluginDescriptorEntry = pluginJar.getEntry(this.getExtensionDescriptorLocation());
                if (pluginDescriptorEntry == null) return extensionDescriptor;
                try (InputStream is = pluginJar.getInputStream(pluginDescriptorEntry);){
                    extensionDescriptor = this.build(is);
                    return extensionDescriptor;
                }
            }
        }
        File pluginXml = new File(extensionJar, this.getExtensionDescriptorLocation());
        if (!pluginXml.canRead()) return extensionDescriptor;
        try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(pluginXml));){
            extensionDescriptor = this.build(is);
            return extensionDescriptor;
        }
    }

    public ExtensionDescriptor build(InputStream is) throws IOException {
        Xpp3Dom dom;
        ExtensionDescriptor extensionDescriptor = new ExtensionDescriptor();
        try {
            dom = Xpp3DomBuilder.build(ReaderFactory.newXmlReader(is));
        }
        catch (XmlPullParserException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
        if (!"io.quarkus.launcher.shaded.extension".equals(dom.getName())) {
            throw new IOException("io.quarkus.launcher.shaded.Unexpected root element \"" + dom.getName() + "io.quarkus.launcher.shaded.\", expected \"extension\"");
        }
        extensionDescriptor.setExportedPackages(this.parseStrings(dom.getChild("io.quarkus.launcher.shaded.exportedPackages")));
        extensionDescriptor.setExportedArtifacts(this.parseStrings(dom.getChild("io.quarkus.launcher.shaded.exportedArtifacts")));
        return extensionDescriptor;
    }

    private List<String> parseStrings(Xpp3Dom dom) {
        ArrayList<String> strings = null;
        if (dom != null) {
            strings = new ArrayList<String>();
            for (Xpp3Dom child : dom.getChildren()) {
                String string = child.getValue();
                if (string == null || (string = string.trim()).length() <= 0) continue;
                strings.add(string);
            }
        }
        return strings;
    }
}

