/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.maven.project;

import io.quarkus.launcher.shaded.org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import io.quarkus.launcher.shaded.org.apache.maven.project.ProjectBuildingException;
import java.io.File;

public class InvalidProjectVersionException
extends ProjectBuildingException {
    private final String locationInPom;
    private final String offendingVersion;

    public InvalidProjectVersionException(String projectId, String locationInPom, String offendingVersion, File pomFile, InvalidVersionSpecificationException cause) {
        super(projectId, InvalidProjectVersionException.formatMessage(projectId, locationInPom, offendingVersion, cause), pomFile, cause);
        this.locationInPom = locationInPom;
        this.offendingVersion = offendingVersion;
    }

    private static String formatMessage(String projectId, String locationInPom, String offendingVersion, InvalidVersionSpecificationException cause) {
        return "io.quarkus.launcher.shaded.Invalid version: " + offendingVersion + "io.quarkus.launcher.shaded. found for: " + locationInPom + "io.quarkus.launcher.shaded. in project: " + projectId + "io.quarkus.launcher.shaded.. Reason: " + cause.getMessage();
    }

    public String getOffendingVersion() {
        return this.offendingVersion;
    }

    public String getLocationInPom() {
        return this.locationInPom;
    }
}

