/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.maven.project;

import io.quarkus.launcher.shaded.org.apache.maven.model.building.ModelProblem;
import io.quarkus.launcher.shaded.org.apache.maven.model.building.ModelProblemUtils;
import io.quarkus.launcher.shaded.org.apache.maven.project.ProjectBuildingResult;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;

public class ProjectBuildingException
extends Exception {
    private final String projectId;
    private File pomFile;
    private List<ProjectBuildingResult> results;

    public ProjectBuildingException(String projectId, String message, Throwable cause) {
        super(ProjectBuildingException.createMessage(message, projectId, null), cause);
        this.projectId = projectId;
    }

    public ProjectBuildingException(String projectId, String message, File pomFile) {
        super(ProjectBuildingException.createMessage(message, projectId, pomFile));
        this.projectId = projectId;
        this.pomFile = pomFile;
    }

    protected ProjectBuildingException(String projectId, String message, File pomFile, Throwable cause) {
        super(ProjectBuildingException.createMessage(message, projectId, pomFile), cause);
        this.projectId = projectId;
        this.pomFile = pomFile;
    }

    public ProjectBuildingException(List<ProjectBuildingResult> results) {
        super(ProjectBuildingException.createMessage(results));
        this.projectId = "io.quarkus.launcher.shaded.";
        this.results = results;
    }

    public File getPomFile() {
        return this.pomFile;
    }

    public String getPomLocation() {
        if (this.getPomFile() != null) {
            return this.getPomFile().getAbsolutePath();
        }
        return "io.quarkus.launcher.shaded.null";
    }

    public String getProjectId() {
        return this.projectId;
    }

    public List<ProjectBuildingResult> getResults() {
        return this.results;
    }

    private static String createMessage(String message, String projectId, File pomFile) {
        StringBuilder buffer = new StringBuilder(256);
        buffer.append(message);
        buffer.append("io.quarkus.launcher.shaded. for project ").append(projectId);
        if (pomFile != null) {
            buffer.append("io.quarkus.launcher.shaded. at ").append(pomFile.getAbsolutePath());
        }
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String createMessage(List<ProjectBuildingResult> results) {
        StringWriter buffer = new StringWriter(1024);
        writer.println("io.quarkus.launcher.shaded.Some problems were encountered while processing the POMs:");
        try (PrintWriter writer = new PrintWriter(buffer);){
            for (ProjectBuildingResult result : results) {
                for (ModelProblem problem : result.getProblems()) {
                    writer.print("io.quarkus.launcher.shaded.[");
                    writer.print((Object)problem.getSeverity());
                    writer.print("io.quarkus.launcher.shaded.] ");
                    writer.print(problem.getMessage());
                    writer.print("io.quarkus.launcher.shaded. @ ");
                    writer.println(ModelProblemUtils.formatLocation(problem, result.getProjectId()));
                }
            }
        }
        return buffer.toString();
    }
}

