/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.maven.project;

import io.quarkus.launcher.shaded.org.apache.maven.model.Dependency;
import io.quarkus.launcher.shaded.org.apache.maven.model.Parent;
import io.quarkus.launcher.shaded.org.apache.maven.model.Repository;
import io.quarkus.launcher.shaded.org.apache.maven.model.building.FileModelSource;
import io.quarkus.launcher.shaded.org.apache.maven.model.building.ModelSource;
import io.quarkus.launcher.shaded.org.apache.maven.model.resolution.InvalidRepositoryException;
import io.quarkus.launcher.shaded.org.apache.maven.model.resolution.ModelResolver;
import io.quarkus.launcher.shaded.org.apache.maven.model.resolution.UnresolvableModelException;
import io.quarkus.launcher.shaded.org.apache.maven.project.ProjectBuildingRequest;
import io.quarkus.launcher.shaded.org.apache.maven.project.ReactorModelPool;
import io.quarkus.launcher.shaded.org.apache.maven.repository.internal.ArtifactDescriptorUtils;
import io.quarkus.launcher.shaded.org.eclipse.aether.RepositorySystem;
import io.quarkus.launcher.shaded.org.eclipse.aether.RepositorySystemSession;
import io.quarkus.launcher.shaded.org.eclipse.aether.RequestTrace;
import io.quarkus.launcher.shaded.org.eclipse.aether.artifact.Artifact;
import io.quarkus.launcher.shaded.org.eclipse.aether.artifact.DefaultArtifact;
import io.quarkus.launcher.shaded.org.eclipse.aether.impl.RemoteRepositoryManager;
import io.quarkus.launcher.shaded.org.eclipse.aether.repository.RemoteRepository;
import io.quarkus.launcher.shaded.org.eclipse.aether.resolution.ArtifactRequest;
import io.quarkus.launcher.shaded.org.eclipse.aether.resolution.ArtifactResolutionException;
import io.quarkus.launcher.shaded.org.eclipse.aether.resolution.VersionRangeRequest;
import io.quarkus.launcher.shaded.org.eclipse.aether.resolution.VersionRangeResolutionException;
import io.quarkus.launcher.shaded.org.eclipse.aether.resolution.VersionRangeResult;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class ProjectModelResolver
implements ModelResolver {
    private final RepositorySystemSession session;
    private final RequestTrace trace;
    private final String context = "io.quarkus.launcher.shaded.project";
    private List<RemoteRepository> repositories;
    private List<RemoteRepository> pomRepositories;
    private final List<RemoteRepository> externalRepositories;
    private final RepositorySystem resolver;
    private final RemoteRepositoryManager remoteRepositoryManager;
    private final Set<String> repositoryIds;
    private final ReactorModelPool modelPool;
    private final ProjectBuildingRequest.RepositoryMerging repositoryMerging;

    public ProjectModelResolver(RepositorySystemSession session, RequestTrace trace, RepositorySystem resolver, RemoteRepositoryManager remoteRepositoryManager, List<RemoteRepository> repositories, ProjectBuildingRequest.RepositoryMerging repositoryMerging, ReactorModelPool modelPool) {
        this.session = session;
        this.trace = trace;
        this.resolver = resolver;
        this.remoteRepositoryManager = remoteRepositoryManager;
        this.pomRepositories = new ArrayList<RemoteRepository>();
        this.externalRepositories = Collections.unmodifiableList(new ArrayList<RemoteRepository>(repositories));
        this.repositories = new ArrayList<RemoteRepository>();
        this.repositories.addAll(this.externalRepositories);
        this.repositoryMerging = repositoryMerging;
        this.repositoryIds = new HashSet<String>();
        this.modelPool = modelPool;
    }

    private ProjectModelResolver(ProjectModelResolver original) {
        this.session = original.session;
        this.trace = original.trace;
        this.resolver = original.resolver;
        this.remoteRepositoryManager = original.remoteRepositoryManager;
        this.pomRepositories = new ArrayList<RemoteRepository>(original.pomRepositories);
        this.externalRepositories = original.externalRepositories;
        this.repositories = new ArrayList<RemoteRepository>(original.repositories);
        this.repositoryMerging = original.repositoryMerging;
        this.repositoryIds = new HashSet<String>(original.repositoryIds);
        this.modelPool = original.modelPool;
    }

    @Override
    public void addRepository(Repository repository) throws InvalidRepositoryException {
        this.addRepository(repository, false);
    }

    @Override
    public void addRepository(Repository repository, boolean replace) throws InvalidRepositoryException {
        if (!this.repositoryIds.add(repository.getId())) {
            if (!replace) {
                return;
            }
            ProjectModelResolver.removeMatchingRepository(this.repositories, repository.getId());
            ProjectModelResolver.removeMatchingRepository(this.pomRepositories, repository.getId());
        }
        List<RemoteRepository> newRepositories = Collections.singletonList(ArtifactDescriptorUtils.toRemoteRepository(repository));
        if (ProjectBuildingRequest.RepositoryMerging.REQUEST_DOMINANT.equals((Object)this.repositoryMerging)) {
            this.repositories = this.remoteRepositoryManager.aggregateRepositories(this.session, this.repositories, newRepositories, true);
        } else {
            this.pomRepositories = this.remoteRepositoryManager.aggregateRepositories(this.session, this.pomRepositories, newRepositories, true);
            this.repositories = this.remoteRepositoryManager.aggregateRepositories(this.session, this.pomRepositories, this.externalRepositories, false);
        }
    }

    private static void removeMatchingRepository(Iterable<RemoteRepository> repositories, String id) {
        Iterator<RemoteRepository> iterator = repositories.iterator();
        while (iterator.hasNext()) {
            RemoteRepository next = iterator.next();
            if (!next.getId().equals(id)) continue;
            iterator.remove();
        }
    }

    @Override
    public ModelResolver newCopy() {
        return new ProjectModelResolver(this);
    }

    @Override
    public ModelSource resolveModel(String groupId, String artifactId, String version) throws UnresolvableModelException {
        File pomFile = null;
        if (this.modelPool != null) {
            pomFile = this.modelPool.get(groupId, artifactId, version);
        }
        if (pomFile == null) {
            Artifact pomArtifact = new DefaultArtifact(groupId, artifactId, "io.quarkus.launcher.shaded.", "io.quarkus.launcher.shaded.pom", version);
            try {
                ArtifactRequest request = new ArtifactRequest(pomArtifact, this.repositories, "io.quarkus.launcher.shaded.project");
                request.setTrace(this.trace);
                pomArtifact = this.resolver.resolveArtifact(this.session, request).getArtifact();
            }
            catch (ArtifactResolutionException e) {
                throw new UnresolvableModelException(e.getMessage(), groupId, artifactId, version, e);
            }
            pomFile = pomArtifact.getFile();
        }
        return new FileModelSource(pomFile);
    }

    @Override
    public ModelSource resolveModel(Parent parent) throws UnresolvableModelException {
        try {
            DefaultArtifact artifact = new DefaultArtifact(parent.getGroupId(), parent.getArtifactId(), "io.quarkus.launcher.shaded.", "io.quarkus.launcher.shaded.pom", parent.getVersion());
            VersionRangeRequest versionRangeRequest = new VersionRangeRequest(artifact, this.repositories, "io.quarkus.launcher.shaded.project");
            versionRangeRequest.setTrace(this.trace);
            VersionRangeResult versionRangeResult = this.resolver.resolveVersionRange(this.session, versionRangeRequest);
            if (versionRangeResult.getHighestVersion() == null) {
                throw new UnresolvableModelException(String.format("io.quarkus.launcher.shaded.No versions matched the requested parent version range '%s'", parent.getVersion()), parent.getGroupId(), parent.getArtifactId(), parent.getVersion());
            }
            if (versionRangeResult.getVersionConstraint() != null && versionRangeResult.getVersionConstraint().getRange() != null && versionRangeResult.getVersionConstraint().getRange().getUpperBound() == null) {
                throw new UnresolvableModelException(String.format("io.quarkus.launcher.shaded.The requested parent version range '%s' does not specify an upper bound", parent.getVersion()), parent.getGroupId(), parent.getArtifactId(), parent.getVersion());
            }
            parent.setVersion(versionRangeResult.getHighestVersion().toString());
            return this.resolveModel(parent.getGroupId(), parent.getArtifactId(), parent.getVersion());
        }
        catch (VersionRangeResolutionException e) {
            throw new UnresolvableModelException(e.getMessage(), parent.getGroupId(), parent.getArtifactId(), parent.getVersion(), e);
        }
    }

    @Override
    public ModelSource resolveModel(Dependency dependency) throws UnresolvableModelException {
        try {
            DefaultArtifact artifact = new DefaultArtifact(dependency.getGroupId(), dependency.getArtifactId(), "io.quarkus.launcher.shaded.", "io.quarkus.launcher.shaded.pom", dependency.getVersion());
            VersionRangeRequest versionRangeRequest = new VersionRangeRequest(artifact, this.repositories, "io.quarkus.launcher.shaded.project");
            versionRangeRequest.setTrace(this.trace);
            VersionRangeResult versionRangeResult = this.resolver.resolveVersionRange(this.session, versionRangeRequest);
            if (versionRangeResult.getHighestVersion() == null) {
                throw new UnresolvableModelException(String.format("io.quarkus.launcher.shaded.No versions matched the requested dependency version range '%s'", dependency.getVersion()), dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion());
            }
            if (versionRangeResult.getVersionConstraint() != null && versionRangeResult.getVersionConstraint().getRange() != null && versionRangeResult.getVersionConstraint().getRange().getUpperBound() == null) {
                throw new UnresolvableModelException(String.format("io.quarkus.launcher.shaded.The requested dependency version range '%s' does not specify an upper bound", dependency.getVersion()), dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion());
            }
            dependency.setVersion(versionRangeResult.getHighestVersion().toString());
            return this.resolveModel(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion());
        }
        catch (VersionRangeResolutionException e) {
            throw new UnresolvableModelException(e.getMessage(), dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), e);
        }
    }
}

