/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.maven.project;

import io.quarkus.launcher.shaded.org.apache.maven.model.building.ModelCache;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

class ReactorModelCache
implements ModelCache {
    private final Map<CacheKey, Object> models = new ConcurrentHashMap<CacheKey, Object>(256);

    ReactorModelCache() {
    }

    @Override
    public Object get(String groupId, String artifactId, String version, String tag) {
        return this.models.get(new CacheKey(groupId, artifactId, version, tag));
    }

    @Override
    public void put(String groupId, String artifactId, String version, String tag, Object data) {
        this.models.put(new CacheKey(groupId, artifactId, version, tag), data);
    }

    private static final class CacheKey {
        private final String groupId;
        private final String artifactId;
        private final String version;
        private final String tag;
        private final int hashCode;

        CacheKey(String groupId, String artifactId, String version, String tag) {
            this.groupId = groupId != null ? groupId : "io.quarkus.launcher.shaded.";
            this.artifactId = artifactId != null ? artifactId : "io.quarkus.launcher.shaded.";
            this.version = version != null ? version : "io.quarkus.launcher.shaded.";
            this.tag = tag != null ? tag : "io.quarkus.launcher.shaded.";
            int hash = 17;
            hash = hash * 31 + this.groupId.hashCode();
            hash = hash * 31 + this.artifactId.hashCode();
            hash = hash * 31 + this.version.hashCode();
            this.hashCode = hash = hash * 31 + this.tag.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof CacheKey)) {
                return false;
            }
            CacheKey that = (CacheKey)obj;
            return this.artifactId.equals(that.artifactId) && this.groupId.equals(that.groupId) && this.version.equals(that.version) && this.tag.equals(that.tag);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

