/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.maven.project.artifact;

import io.quarkus.launcher.shaded.org.apache.maven.RepositoryUtils;
import io.quarkus.launcher.shaded.org.apache.maven.artifact.Artifact;
import io.quarkus.launcher.shaded.org.apache.maven.lifecycle.LifecycleExecutionException;
import io.quarkus.launcher.shaded.org.apache.maven.project.MavenProject;
import io.quarkus.launcher.shaded.org.apache.maven.project.artifact.ProjectArtifactsCache;
import io.quarkus.launcher.shaded.org.codehaus.plexus.component.annotations.Component;
import io.quarkus.launcher.shaded.org.eclipse.aether.RepositorySystemSession;
import io.quarkus.launcher.shaded.org.eclipse.aether.repository.LocalRepository;
import io.quarkus.launcher.shaded.org.eclipse.aether.repository.RemoteRepository;
import io.quarkus.launcher.shaded.org.eclipse.aether.repository.WorkspaceRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

@Component(role=ProjectArtifactsCache.class)
public class DefaultProjectArtifactsCache
implements ProjectArtifactsCache {
    protected final Map<ProjectArtifactsCache.Key, ProjectArtifactsCache.CacheRecord> cache = new ConcurrentHashMap<ProjectArtifactsCache.Key, ProjectArtifactsCache.CacheRecord>();

    @Override
    public ProjectArtifactsCache.Key createKey(MavenProject project, Collection<String> scopesToCollect, Collection<String> scopesToResolve, boolean aggregating, RepositorySystemSession session) {
        return new CacheKey(project, project.getRemoteProjectRepositories(), scopesToCollect, scopesToResolve, aggregating, session);
    }

    @Override
    public ProjectArtifactsCache.CacheRecord get(ProjectArtifactsCache.Key key) throws LifecycleExecutionException {
        ProjectArtifactsCache.CacheRecord cacheRecord = this.cache.get(key);
        if (cacheRecord != null && cacheRecord.getException() != null) {
            throw cacheRecord.getException();
        }
        return cacheRecord;
    }

    @Override
    public ProjectArtifactsCache.CacheRecord put(ProjectArtifactsCache.Key key, Set<Artifact> projectArtifacts) {
        Objects.requireNonNull(projectArtifacts, "io.quarkus.launcher.shaded.projectArtifacts cannot be null");
        this.assertUniqueKey(key);
        ProjectArtifactsCache.CacheRecord record = new ProjectArtifactsCache.CacheRecord(Collections.unmodifiableSet(new LinkedHashSet<Artifact>(projectArtifacts)));
        this.cache.put(key, record);
        return record;
    }

    protected void assertUniqueKey(ProjectArtifactsCache.Key key) {
        if (this.cache.containsKey(key)) {
            throw new IllegalStateException("io.quarkus.launcher.shaded.Duplicate artifact resolution result for project " + key);
        }
    }

    @Override
    public ProjectArtifactsCache.CacheRecord put(ProjectArtifactsCache.Key key, LifecycleExecutionException exception) {
        Objects.requireNonNull(exception, "io.quarkus.launcher.shaded.exception cannot be null");
        this.assertUniqueKey(key);
        ProjectArtifactsCache.CacheRecord record = new ProjectArtifactsCache.CacheRecord(exception);
        this.cache.put(key, record);
        return record;
    }

    @Override
    public void flush() {
        this.cache.clear();
    }

    @Override
    public void register(MavenProject project, ProjectArtifactsCache.Key cacheKey, ProjectArtifactsCache.CacheRecord record) {
    }

    protected static class CacheKey
    implements ProjectArtifactsCache.Key {
        private final String groupId;
        private final String artifactId;
        private final String version;
        private final Set<String> dependencyArtifacts;
        private final WorkspaceRepository workspace;
        private final LocalRepository localRepo;
        private final List<RemoteRepository> repositories;
        private final Set<String> collect;
        private final Set<String> resolve;
        private boolean aggregating;
        private final int hashCode;

        public CacheKey(MavenProject project, List<RemoteRepository> repositories, Collection<String> scopesToCollect, Collection<String> scopesToResolve, boolean aggregating, RepositorySystemSession session) {
            this.groupId = project.getGroupId();
            this.artifactId = project.getArtifactId();
            this.version = project.getVersion();
            LinkedHashSet<String> deps = new LinkedHashSet<String>();
            if (project.getDependencyArtifacts() != null) {
                for (Artifact dep : project.getDependencyArtifacts()) {
                    deps.add(dep.toString());
                }
            }
            this.dependencyArtifacts = Collections.unmodifiableSet(deps);
            this.workspace = RepositoryUtils.getWorkspace(session);
            this.localRepo = session.getLocalRepository();
            this.repositories = new ArrayList<RemoteRepository>(repositories.size());
            for (RemoteRepository repository : repositories) {
                if (repository.isRepositoryManager()) {
                    this.repositories.addAll(repository.getMirroredRepositories());
                    continue;
                }
                this.repositories.add(repository);
            }
            this.collect = scopesToCollect == null ? Collections.emptySet() : Collections.unmodifiableSet(new HashSet<String>(scopesToCollect));
            this.resolve = scopesToResolve == null ? Collections.emptySet() : Collections.unmodifiableSet(new HashSet<String>(scopesToResolve));
            this.aggregating = aggregating;
            int hash = 17;
            hash = hash * 31 + Objects.hashCode(this.groupId);
            hash = hash * 31 + Objects.hashCode(this.artifactId);
            hash = hash * 31 + Objects.hashCode(this.version);
            hash = hash * 31 + Objects.hashCode(this.dependencyArtifacts);
            hash = hash * 31 + Objects.hashCode(this.workspace);
            hash = hash * 31 + Objects.hashCode(this.localRepo);
            hash = hash * 31 + RepositoryUtils.repositoriesHashCode(repositories);
            hash = hash * 31 + Objects.hashCode(this.collect);
            hash = hash * 31 + Objects.hashCode(this.resolve);
            this.hashCode = hash = hash * 31 + Objects.hashCode(aggregating);
        }

        public String toString() {
            return this.groupId + "io.quarkus.launcher.shaded.:" + this.artifactId + "io.quarkus.launcher.shaded.:" + this.version;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey that = (CacheKey)o;
            return Objects.equals(this.groupId, that.groupId) && Objects.equals(this.artifactId, that.artifactId) && Objects.equals(this.version, that.version) && Objects.equals(this.dependencyArtifacts, that.dependencyArtifacts) && Objects.equals(this.workspace, that.workspace) && Objects.equals(this.localRepo, that.localRepo) && RepositoryUtils.repositoriesEquals(this.repositories, that.repositories) && Objects.equals(this.collect, that.collect) && Objects.equals(this.resolve, that.resolve) && this.aggregating == that.aggregating;
        }
    }
}

