/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.maven.project.artifact;

import io.quarkus.launcher.shaded.org.apache.maven.RepositoryUtils;
import io.quarkus.launcher.shaded.org.apache.maven.artifact.Artifact;
import io.quarkus.launcher.shaded.org.apache.maven.artifact.ArtifactUtils;
import io.quarkus.launcher.shaded.org.apache.maven.artifact.factory.ArtifactFactory;
import io.quarkus.launcher.shaded.org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import io.quarkus.launcher.shaded.org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import io.quarkus.launcher.shaded.org.apache.maven.artifact.metadata.ResolutionGroup;
import io.quarkus.launcher.shaded.org.apache.maven.artifact.repository.ArtifactRepository;
import io.quarkus.launcher.shaded.org.apache.maven.artifact.repository.metadata.ArtifactRepositoryMetadata;
import io.quarkus.launcher.shaded.org.apache.maven.artifact.repository.metadata.Metadata;
import io.quarkus.launcher.shaded.org.apache.maven.artifact.repository.metadata.RepositoryMetadataManager;
import io.quarkus.launcher.shaded.org.apache.maven.artifact.repository.metadata.RepositoryMetadataResolutionException;
import io.quarkus.launcher.shaded.org.apache.maven.artifact.resolver.ArtifactResolutionException;
import io.quarkus.launcher.shaded.org.apache.maven.artifact.resolver.MultipleArtifactsNotFoundException;
import io.quarkus.launcher.shaded.org.apache.maven.artifact.resolver.filter.AndArtifactFilter;
import io.quarkus.launcher.shaded.org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import io.quarkus.launcher.shaded.org.apache.maven.artifact.resolver.filter.ExclusionArtifactFilter;
import io.quarkus.launcher.shaded.org.apache.maven.artifact.versioning.ArtifactVersion;
import io.quarkus.launcher.shaded.org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import io.quarkus.launcher.shaded.org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import io.quarkus.launcher.shaded.org.apache.maven.artifact.versioning.VersionRange;
import io.quarkus.launcher.shaded.org.apache.maven.execution.MavenSession;
import io.quarkus.launcher.shaded.org.apache.maven.model.Dependency;
import io.quarkus.launcher.shaded.org.apache.maven.model.DependencyManagement;
import io.quarkus.launcher.shaded.org.apache.maven.model.DistributionManagement;
import io.quarkus.launcher.shaded.org.apache.maven.model.Model;
import io.quarkus.launcher.shaded.org.apache.maven.model.Relocation;
import io.quarkus.launcher.shaded.org.apache.maven.model.building.ModelBuildingException;
import io.quarkus.launcher.shaded.org.apache.maven.model.building.ModelProblem;
import io.quarkus.launcher.shaded.org.apache.maven.model.resolution.UnresolvableModelException;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.LegacySupport;
import io.quarkus.launcher.shaded.org.apache.maven.project.DefaultProjectBuildingRequest;
import io.quarkus.launcher.shaded.org.apache.maven.project.MavenProject;
import io.quarkus.launcher.shaded.org.apache.maven.project.ProjectBuilder;
import io.quarkus.launcher.shaded.org.apache.maven.project.ProjectBuildingException;
import io.quarkus.launcher.shaded.org.apache.maven.project.ProjectBuildingRequest;
import io.quarkus.launcher.shaded.org.apache.maven.project.artifact.ArtifactWithDependencies;
import io.quarkus.launcher.shaded.org.apache.maven.project.artifact.InvalidDependencyVersionException;
import io.quarkus.launcher.shaded.org.apache.maven.project.artifact.MavenMetadataCache;
import io.quarkus.launcher.shaded.org.apache.maven.properties.internal.EnvironmentUtils;
import io.quarkus.launcher.shaded.org.apache.maven.properties.internal.SystemProperties;
import io.quarkus.launcher.shaded.org.apache.maven.repository.internal.MavenWorkspaceReader;
import io.quarkus.launcher.shaded.org.apache.maven.repository.legacy.metadata.DefaultMetadataResolutionRequest;
import io.quarkus.launcher.shaded.org.apache.maven.repository.legacy.metadata.MetadataResolutionRequest;
import io.quarkus.launcher.shaded.org.codehaus.plexus.PlexusContainer;
import io.quarkus.launcher.shaded.org.codehaus.plexus.component.annotations.Component;
import io.quarkus.launcher.shaded.org.codehaus.plexus.component.annotations.Requirement;
import io.quarkus.launcher.shaded.org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import io.quarkus.launcher.shaded.org.codehaus.plexus.logging.Logger;
import io.quarkus.launcher.shaded.org.eclipse.aether.RepositorySystemSession;
import io.quarkus.launcher.shaded.org.eclipse.aether.repository.WorkspaceReader;
import io.quarkus.launcher.shaded.org.eclipse.aether.transfer.ArtifactNotFoundException;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;

@Component(role=ArtifactMetadataSource.class, hint="io.quarkus.launcher.shaded.maven")
public class MavenMetadataSource
implements ArtifactMetadataSource {
    @Requirement
    private RepositoryMetadataManager repositoryMetadataManager;
    @Requirement
    private ArtifactFactory repositorySystem;
    private ProjectBuilder projectBuilder;
    @Requirement
    private PlexusContainer container;
    @Requirement
    private Logger logger;
    @Requirement
    private MavenMetadataCache cache;
    @Requirement
    private LegacySupport legacySupport;

    private void injectSession(MetadataResolutionRequest request) {
        RepositorySystemSession session = this.legacySupport.getRepositorySession();
        if (session != null) {
            request.setOffline(session.isOffline());
            request.setForceUpdate("io.quarkus.launcher.shaded.always".equals(session.getUpdatePolicy()));
        }
    }

    @Override
    public ResolutionGroup retrieve(Artifact artifact, ArtifactRepository localRepository, List<ArtifactRepository> remoteRepositories) throws ArtifactMetadataRetrievalException {
        return this.retrieve(artifact, localRepository, remoteRepositories, false);
    }

    public ResolutionGroup retrieve(Artifact artifact, ArtifactRepository localRepository, List<ArtifactRepository> remoteRepositories, boolean resolveManagedVersions) throws ArtifactMetadataRetrievalException {
        DefaultMetadataResolutionRequest request = new DefaultMetadataResolutionRequest();
        this.injectSession(request);
        request.setArtifact(artifact);
        request.setLocalRepository(localRepository);
        request.setRemoteRepositories(remoteRepositories);
        request.setResolveManagedVersions(resolveManagedVersions);
        return this.retrieve(request);
    }

    @Override
    public ResolutionGroup retrieve(MetadataResolutionRequest request) throws ArtifactMetadataRetrievalException {
        List<Dependency> dependencies;
        Artifact pomArtifact;
        Artifact artifact = request.getArtifact();
        if (artifact.getScope() != null && artifact.getScope().equals("io.quarkus.launcher.shaded.system")) {
            return new ResolutionGroup(null, null, null);
        }
        ResolutionGroup cached = this.cache.get(artifact, request.isResolveManagedVersions(), request.getLocalRepository(), request.getRemoteRepositories());
        if (cached != null && (!request.isForceUpdate() || this.hasFile(cached.getPomArtifact()))) {
            return cached;
        }
        List<Dependency> managedDependencies = null;
        List<ArtifactRepository> pomRepositories = null;
        Artifact relocatedArtifact = null;
        WorkspaceReader workspace = this.legacySupport.getRepositorySession().getWorkspaceReader();
        Model model = null;
        if (workspace instanceof MavenWorkspaceReader) {
            model = ((MavenWorkspaceReader)workspace).findModel(RepositoryUtils.toArtifact(artifact));
        }
        if (model != null) {
            pomArtifact = artifact;
            dependencies = model.getDependencies();
            DependencyManagement dependencyManagement = model.getDependencyManagement();
            managedDependencies = dependencyManagement == null ? null : dependencyManagement.getDependencies();
            MavenSession session = this.legacySupport.getSession();
            MavenProject mavenProject = session.getProjectMap().get(ArtifactUtils.key(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion()));
            pomRepositories = mavenProject.getRemoteArtifactRepositories();
        } else if (artifact instanceof ArtifactWithDependencies) {
            pomArtifact = artifact;
            dependencies = ((ArtifactWithDependencies)((Object)artifact)).getDependencies();
            managedDependencies = ((ArtifactWithDependencies)((Object)artifact)).getManagedDependencies();
        } else {
            ProjectRelocation rel = this.retrieveRelocatedProject(artifact, request);
            if (rel == null) {
                return null;
            }
            pomArtifact = rel.pomArtifact;
            relocatedArtifact = rel.relocatedArtifact;
            if (rel.project == null) {
                dependencies = Collections.emptyList();
            } else {
                dependencies = rel.project.getDependencies();
                DependencyManagement depMgmt = rel.project.getDependencyManagement();
                managedDependencies = depMgmt != null ? depMgmt.getDependencies() : null;
                pomRepositories = rel.project.getRemoteArtifactRepositories();
            }
        }
        Set<Artifact> artifacts = Collections.emptySet();
        if (!artifact.getArtifactHandler().isIncludesDependencies()) {
            artifacts = new LinkedHashSet();
            for (Dependency dependency : dependencies) {
                Artifact dependencyArtifact = this.createDependencyArtifact(dependency, artifact, pomArtifact);
                if (dependencyArtifact == null) continue;
                artifacts.add(dependencyArtifact);
            }
        }
        HashMap<String, Artifact> managedVersions = null;
        if (managedDependencies != null && request.isResolveManagedVersions()) {
            managedVersions = new HashMap<String, Artifact>();
            for (Dependency managedDependency : managedDependencies) {
                Artifact managedArtifact = this.createDependencyArtifact(managedDependency, null, pomArtifact);
                managedVersions.put(managedDependency.getManagementKey(), managedArtifact);
            }
        }
        List<ArtifactRepository> list = this.aggregateRepositories(request.getRemoteRepositories(), pomRepositories);
        ResolutionGroup result = new ResolutionGroup(pomArtifact, relocatedArtifact, artifacts, managedVersions, list);
        this.cache.put(artifact, request.isResolveManagedVersions(), request.getLocalRepository(), request.getRemoteRepositories(), result);
        return result;
    }

    private boolean hasFile(Artifact artifact) {
        return artifact != null && artifact.getFile() != null && artifact.getFile().exists();
    }

    private List<ArtifactRepository> aggregateRepositories(List<ArtifactRepository> requestRepositories, List<ArtifactRepository> pomRepositories) {
        List<ArtifactRepository> repositories = requestRepositories;
        if (pomRepositories != null && !pomRepositories.isEmpty()) {
            LinkedHashMap<String, ArtifactRepository> repos = new LinkedHashMap<String, ArtifactRepository>();
            for (ArtifactRepository repo : requestRepositories) {
                if (repos.containsKey(repo.getId())) continue;
                repos.put(repo.getId(), repo);
            }
            for (ArtifactRepository repo : pomRepositories) {
                if (repos.containsKey(repo.getId())) continue;
                repos.put(repo.getId(), repo);
            }
            repositories = new ArrayList(repos.values());
        }
        return repositories;
    }

    private Artifact createDependencyArtifact(Dependency dependency, Artifact owner, Artifact pom) throws ArtifactMetadataRetrievalException {
        try {
            String inheritedScope = owner != null ? owner.getScope() : null;
            ArtifactFilter inheritedFilter = owner != null ? owner.getDependencyFilter() : null;
            return MavenMetadataSource.createDependencyArtifact(this.repositorySystem, dependency, inheritedScope, inheritedFilter);
        }
        catch (InvalidVersionSpecificationException e) {
            throw new ArtifactMetadataRetrievalException("io.quarkus.launcher.shaded.Invalid version for dependency " + dependency.getManagementKey() + "io.quarkus.launcher.shaded.: " + e.getMessage(), e, pom);
        }
    }

    private static Artifact createDependencyArtifact(ArtifactFactory factory, Dependency dependency, String inheritedScope, ArtifactFilter inheritedFilter) throws InvalidVersionSpecificationException {
        String effectiveScope = MavenMetadataSource.getEffectiveScope(dependency.getScope(), inheritedScope);
        if (effectiveScope == null) {
            return null;
        }
        VersionRange versionRange = VersionRange.createFromVersionSpec(dependency.getVersion());
        Artifact dependencyArtifact = factory.createDependencyArtifact(dependency.getGroupId(), dependency.getArtifactId(), versionRange, dependency.getType(), dependency.getClassifier(), effectiveScope, dependency.isOptional());
        ArtifactFilter dependencyFilter = inheritedFilter;
        if (dependencyFilter != null && !dependencyFilter.include(dependencyArtifact)) {
            return null;
        }
        if ("io.quarkus.launcher.shaded.system".equals(effectiveScope)) {
            dependencyArtifact.setFile(new File(dependency.getSystemPath()));
        }
        dependencyArtifact.setDependencyFilter(MavenMetadataSource.createDependencyFilter(dependency, dependencyFilter));
        return dependencyArtifact;
    }

    private static String getEffectiveScope(String originalScope, String inheritedScope) {
        String effectiveScope = "io.quarkus.launcher.shaded.runtime";
        if (originalScope == null) {
            originalScope = "io.quarkus.launcher.shaded.compile";
        }
        if (inheritedScope == null) {
            effectiveScope = originalScope;
        } else if ("io.quarkus.launcher.shaded.test".equals(originalScope) || "io.quarkus.launcher.shaded.provided".equals(originalScope)) {
            effectiveScope = null;
        } else if ("io.quarkus.launcher.shaded.system".equals(originalScope)) {
            effectiveScope = "io.quarkus.launcher.shaded.system";
        } else if ("io.quarkus.launcher.shaded.compile".equals(originalScope) && "io.quarkus.launcher.shaded.compile".equals(inheritedScope)) {
            effectiveScope = "io.quarkus.launcher.shaded.compile";
        } else if ("io.quarkus.launcher.shaded.test".equals(inheritedScope)) {
            effectiveScope = "io.quarkus.launcher.shaded.test";
        } else if ("io.quarkus.launcher.shaded.provided".equals(inheritedScope)) {
            effectiveScope = "io.quarkus.launcher.shaded.provided";
        }
        return effectiveScope;
    }

    private static ArtifactFilter createDependencyFilter(Dependency dependency, ArtifactFilter inheritedFilter) {
        ArtifactFilter effectiveFilter = inheritedFilter;
        if (!dependency.getExclusions().isEmpty()) {
            effectiveFilter = new ExclusionArtifactFilter(dependency.getExclusions());
            if (inheritedFilter != null) {
                effectiveFilter = new AndArtifactFilter(Arrays.asList(inheritedFilter, effectiveFilter));
            }
        }
        return effectiveFilter;
    }

    @Override
    public List<ArtifactVersion> retrieveAvailableVersions(Artifact artifact, ArtifactRepository localRepository, List<ArtifactRepository> remoteRepositories) throws ArtifactMetadataRetrievalException {
        DefaultMetadataResolutionRequest request = new DefaultMetadataResolutionRequest();
        this.injectSession(request);
        request.setArtifact(artifact);
        request.setLocalRepository(localRepository);
        request.setRemoteRepositories(remoteRepositories);
        return this.retrieveAvailableVersions(request);
    }

    @Override
    public List<ArtifactVersion> retrieveAvailableVersions(MetadataResolutionRequest request) throws ArtifactMetadataRetrievalException {
        ArtifactRepositoryMetadata metadata = new ArtifactRepositoryMetadata(request.getArtifact());
        try {
            this.repositoryMetadataManager.resolve(metadata, request);
        }
        catch (RepositoryMetadataResolutionException e) {
            throw new ArtifactMetadataRetrievalException(e.getMessage(), e, request.getArtifact());
        }
        List<String> availableVersions = request.getLocalRepository().findVersions(request.getArtifact());
        return this.retrieveAvailableVersionsFromMetadata(metadata.getMetadata(), availableVersions);
    }

    @Override
    public List<ArtifactVersion> retrieveAvailableVersionsFromDeploymentRepository(Artifact artifact, ArtifactRepository localRepository, ArtifactRepository deploymentRepository) throws ArtifactMetadataRetrievalException {
        ArtifactRepositoryMetadata metadata = new ArtifactRepositoryMetadata(artifact);
        try {
            this.repositoryMetadataManager.resolveAlways(metadata, localRepository, deploymentRepository);
        }
        catch (RepositoryMetadataResolutionException e) {
            throw new ArtifactMetadataRetrievalException(e.getMessage(), e, artifact);
        }
        List<String> availableVersions = localRepository.findVersions(artifact);
        return this.retrieveAvailableVersionsFromMetadata(metadata.getMetadata(), availableVersions);
    }

    private List<ArtifactVersion> retrieveAvailableVersionsFromMetadata(Metadata repoMetadata, List<String> availableVersions) {
        LinkedHashSet<String> versions = new LinkedHashSet<String>();
        if (repoMetadata != null && repoMetadata.getVersioning() != null) {
            versions.addAll(repoMetadata.getVersioning().getVersions());
        }
        versions.addAll(availableVersions);
        ArrayList<ArtifactVersion> artifactVersions = new ArrayList<ArtifactVersion>(versions.size());
        for (String version : versions) {
            artifactVersions.add(new DefaultArtifactVersion(version));
        }
        return artifactVersions;
    }

    @Deprecated
    public static Set<Artifact> createArtifacts(ArtifactFactory artifactFactory, List<Dependency> dependencies, String inheritedScope, ArtifactFilter dependencyFilter, MavenProject project) throws InvalidDependencyVersionException {
        LinkedHashSet<Artifact> artifacts = new LinkedHashSet<Artifact>();
        for (Dependency d : dependencies) {
            Artifact dependencyArtifact;
            try {
                dependencyArtifact = MavenMetadataSource.createDependencyArtifact(artifactFactory, d, inheritedScope, dependencyFilter);
            }
            catch (InvalidVersionSpecificationException e) {
                throw new InvalidDependencyVersionException(project.getId(), d, project.getFile(), e);
            }
            if (dependencyArtifact == null) continue;
            artifacts.add(dependencyArtifact);
        }
        return artifacts;
    }

    private ProjectBuilder getProjectBuilder() {
        if (this.projectBuilder != null) {
            return this.projectBuilder;
        }
        try {
            this.projectBuilder = this.container.lookup(ProjectBuilder.class);
        }
        catch (ComponentLookupException componentLookupException) {
            // empty catch block
        }
        return this.projectBuilder;
    }

    private ProjectRelocation retrieveRelocatedProject(Artifact artifact, MetadataResolutionRequest repositoryRequest) throws ArtifactMetadataRetrievalException {
        Artifact pomArtifact;
        MavenProject project;
        Artifact relocatedArtifact = null;
        boolean done = false;
        do {
            project = null;
            pomArtifact = this.repositorySystem.createProjectArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getScope());
            if ("io.quarkus.launcher.shaded.pom".equals(artifact.getType())) {
                pomArtifact.setFile(artifact.getFile());
            }
            if ("io.quarkus.launcher.shaded.system".equals(artifact.getScope())) {
                done = true;
                continue;
            }
            try {
                DefaultProjectBuildingRequest configuration = new DefaultProjectBuildingRequest();
                configuration.setLocalRepository(repositoryRequest.getLocalRepository());
                configuration.setRemoteRepositories(repositoryRequest.getRemoteRepositories());
                configuration.setValidationLevel(0);
                configuration.setProcessPlugins(false);
                configuration.setRepositoryMerging(ProjectBuildingRequest.RepositoryMerging.REQUEST_DOMINANT);
                configuration.setSystemProperties(this.getSystemProperties());
                configuration.setRepositorySession(this.legacySupport.getRepositorySession());
                project = this.getProjectBuilder().build(pomArtifact, (ProjectBuildingRequest)configuration).getProject();
            }
            catch (ProjectBuildingException e) {
                String message;
                ModelProblem missingParentPom = this.hasMissingParentPom(e);
                if (missingParentPom != null) {
                    throw new ArtifactMetadataRetrievalException("io.quarkus.launcher.shaded.Failed to process POM for " + artifact.getId() + "io.quarkus.launcher.shaded.: " + missingParentPom.getMessage(), missingParentPom.getException(), artifact);
                }
                if (this.isMissingPom(e)) {
                    message = "io.quarkus.launcher.shaded.Missing POM for " + artifact.getId();
                } else {
                    if (this.isNonTransferrablePom(e)) {
                        throw new ArtifactMetadataRetrievalException("io.quarkus.launcher.shaded.Failed to retrieve POM for " + artifact.getId() + "io.quarkus.launcher.shaded.: " + e.getCause().getMessage(), e.getCause(), artifact);
                    }
                    message = "io.quarkus.launcher.shaded.Invalid POM for " + artifact.getId() + "io.quarkus.launcher.shaded., transitive dependencies (if any) will not be available, enable debug logging for more details";
                }
                if (this.logger.isDebugEnabled()) {
                    message = message + "io.quarkus.launcher.shaded.: " + e.getMessage();
                }
                this.logger.warn(message);
            }
            if (project != null) {
                Relocation relocation = null;
                DistributionManagement distMgmt = project.getDistributionManagement();
                if (distMgmt != null) {
                    relocation = distMgmt.getRelocation();
                    artifact.setDownloadUrl(distMgmt.getDownloadUrl());
                    pomArtifact.setDownloadUrl(distMgmt.getDownloadUrl());
                }
                if (relocation != null) {
                    if (relocation.getGroupId() != null) {
                        artifact.setGroupId(relocation.getGroupId());
                        relocatedArtifact = artifact;
                        project.setGroupId(relocation.getGroupId());
                    }
                    if (relocation.getArtifactId() != null) {
                        artifact.setArtifactId(relocation.getArtifactId());
                        relocatedArtifact = artifact;
                        project.setArtifactId(relocation.getArtifactId());
                    }
                    if (relocation.getVersion() != null) {
                        artifact.setVersionRange(VersionRange.createFromVersion(relocation.getVersion()));
                        relocatedArtifact = artifact;
                        project.setVersion(relocation.getVersion());
                    }
                    if (artifact.getDependencyFilter() != null && !artifact.getDependencyFilter().include(artifact)) {
                        return null;
                    }
                    List<ArtifactVersion> available = artifact.getAvailableVersions();
                    if (available != null && !available.isEmpty()) {
                        DefaultMetadataResolutionRequest metadataRequest = new DefaultMetadataResolutionRequest(repositoryRequest);
                        metadataRequest.setArtifact(artifact);
                        available = this.retrieveAvailableVersions(metadataRequest);
                        artifact.setAvailableVersions(available);
                    }
                    String message = "io.quarkus.launcher.shaded.\n  This artifact has been relocated to " + artifact.getGroupId() + "io.quarkus.launcher.shaded.:" + artifact.getArtifactId() + "io.quarkus.launcher.shaded.:" + artifact.getVersion() + "io.quarkus.launcher.shaded..\n";
                    if (relocation.getMessage() != null) {
                        message = message + "io.quarkus.launcher.shaded.  " + relocation.getMessage() + "io.quarkus.launcher.shaded.\n";
                    }
                    if (artifact.getDependencyTrail() != null && artifact.getDependencyTrail().size() == 1) {
                        this.logger.warn("io.quarkus.launcher.shaded.While downloading " + pomArtifact.getGroupId() + "io.quarkus.launcher.shaded.:" + pomArtifact.getArtifactId() + "io.quarkus.launcher.shaded.:" + pomArtifact.getVersion() + message + "io.quarkus.launcher.shaded.\n");
                        continue;
                    }
                    this.logger.debug("io.quarkus.launcher.shaded.While downloading " + pomArtifact.getGroupId() + "io.quarkus.launcher.shaded.:" + pomArtifact.getArtifactId() + "io.quarkus.launcher.shaded.:" + pomArtifact.getVersion() + message + "io.quarkus.launcher.shaded.\n");
                    continue;
                }
                done = true;
                continue;
            }
            done = true;
        } while (!done);
        ProjectRelocation rel = new ProjectRelocation();
        rel.project = project;
        rel.pomArtifact = pomArtifact;
        rel.relocatedArtifact = relocatedArtifact;
        return rel;
    }

    private ModelProblem hasMissingParentPom(ProjectBuildingException e) {
        if (e.getCause() instanceof ModelBuildingException) {
            ModelBuildingException mbe = (ModelBuildingException)e.getCause();
            for (ModelProblem problem : mbe.getProblems()) {
                if (!(problem.getException() instanceof UnresolvableModelException)) continue;
                return problem;
            }
        }
        return null;
    }

    private boolean isMissingPom(Exception e) {
        if (e.getCause() instanceof MultipleArtifactsNotFoundException) {
            return true;
        }
        return e.getCause() instanceof io.quarkus.launcher.shaded.org.eclipse.aether.resolution.ArtifactResolutionException && e.getCause().getCause() instanceof ArtifactNotFoundException;
    }

    private boolean isNonTransferrablePom(Exception e) {
        if (e.getCause() instanceof ArtifactResolutionException) {
            return true;
        }
        return e.getCause() instanceof io.quarkus.launcher.shaded.org.eclipse.aether.resolution.ArtifactResolutionException && !(e.getCause().getCause() instanceof ArtifactNotFoundException);
    }

    private Properties getSystemProperties() {
        Properties props = new Properties();
        EnvironmentUtils.addEnvVars(props);
        SystemProperties.addSystemProperties(props);
        return props;
    }

    private static final class ProjectRelocation {
        private MavenProject project;
        private Artifact pomArtifact;
        private Artifact relocatedArtifact;

        private ProjectRelocation() {
        }
    }
}

