/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.maven.project.artifact;

import io.quarkus.launcher.shaded.org.apache.maven.artifact.DefaultArtifact;
import io.quarkus.launcher.shaded.org.apache.maven.artifact.handler.ArtifactHandler;
import io.quarkus.launcher.shaded.org.apache.maven.model.Dependency;
import io.quarkus.launcher.shaded.org.apache.maven.model.DependencyManagement;
import io.quarkus.launcher.shaded.org.apache.maven.project.MavenProject;
import io.quarkus.launcher.shaded.org.apache.maven.project.artifact.ArtifactWithDependencies;
import java.util.Collections;
import java.util.List;

public class ProjectArtifact
extends DefaultArtifact
implements ArtifactWithDependencies {
    private MavenProject project;

    public ProjectArtifact(MavenProject project) {
        super(project.getGroupId(), project.getArtifactId(), project.getVersion(), null, "io.quarkus.launcher.shaded.pom", null, (ArtifactHandler)new PomArtifactHandler());
        this.project = project;
        this.setFile(project.getFile());
        this.setResolved(true);
    }

    public MavenProject getProject() {
        return this.project;
    }

    @Override
    public List<Dependency> getDependencies() {
        return this.project.getDependencies();
    }

    @Override
    public List<Dependency> getManagedDependencies() {
        DependencyManagement depMngt = this.project.getDependencyManagement();
        return depMngt != null ? Collections.unmodifiableList(depMngt.getDependencies()) : Collections.emptyList();
    }

    static class PomArtifactHandler
    implements ArtifactHandler {
        PomArtifactHandler() {
        }

        @Override
        public String getClassifier() {
            return null;
        }

        @Override
        public String getDirectory() {
            return null;
        }

        @Override
        public String getExtension() {
            return "io.quarkus.launcher.shaded.pom";
        }

        @Override
        public String getLanguage() {
            return "io.quarkus.launcher.shaded.none";
        }

        @Override
        public String getPackaging() {
            return "io.quarkus.launcher.shaded.pom";
        }

        @Override
        public boolean isAddedToClasspath() {
            return false;
        }

        @Override
        public boolean isIncludesDependencies() {
            return false;
        }
    }
}

