/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.maven.project.artifact;

import io.quarkus.launcher.shaded.org.apache.maven.artifact.Artifact;
import io.quarkus.launcher.shaded.org.apache.maven.artifact.metadata.AbstractArtifactMetadata;
import io.quarkus.launcher.shaded.org.apache.maven.artifact.metadata.ArtifactMetadata;
import io.quarkus.launcher.shaded.org.apache.maven.artifact.repository.ArtifactRepository;
import io.quarkus.launcher.shaded.org.apache.maven.artifact.repository.metadata.RepositoryMetadataStoreException;
import io.quarkus.launcher.shaded.org.codehaus.plexus.util.FileUtils;
import java.io.File;
import java.io.IOException;

public class ProjectArtifactMetadata
extends AbstractArtifactMetadata {
    private final File file;

    public ProjectArtifactMetadata(Artifact artifact) {
        this(artifact, null);
    }

    public ProjectArtifactMetadata(Artifact artifact, File file) {
        super(artifact);
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public String getRemoteFilename() {
        return this.getFilename();
    }

    @Override
    public String getLocalFilename(ArtifactRepository repository) {
        return this.getFilename();
    }

    private String getFilename() {
        return this.getArtifactId() + "io.quarkus.launcher.shaded.-" + this.artifact.getVersion() + "io.quarkus.launcher.shaded..pom";
    }

    @Override
    public void storeInLocalRepository(ArtifactRepository localRepository, ArtifactRepository remoteRepository) throws RepositoryMetadataStoreException {
        File destination = new File(localRepository.getBasedir(), localRepository.pathOfLocalRepositoryMetadata(this, remoteRepository));
        try {
            FileUtils.copyFile(this.file, destination);
        }
        catch (IOException e) {
            throw new RepositoryMetadataStoreException("io.quarkus.launcher.shaded.Error copying POM to the local repository.", e);
        }
    }

    public String toString() {
        return "io.quarkus.launcher.shaded.project information for " + this.artifact.getArtifactId() + "io.quarkus.launcher.shaded. " + this.artifact.getVersion();
    }

    @Override
    public boolean storedInArtifactVersionDirectory() {
        return true;
    }

    @Override
    public String getBaseVersion() {
        return this.artifact.getBaseVersion();
    }

    @Override
    public Object getKey() {
        return "io.quarkus.launcher.shaded.project " + this.artifact.getGroupId() + "io.quarkus.launcher.shaded.:" + this.artifact.getArtifactId();
    }

    @Override
    public void merge(ArtifactMetadata metadata) {
        ProjectArtifactMetadata m = (ProjectArtifactMetadata)metadata;
        if (!m.file.equals(this.file)) {
            throw new IllegalStateException("io.quarkus.launcher.shaded.Cannot add two different pieces of metadata for: " + this.getKey());
        }
    }

    @Override
    public void merge(io.quarkus.launcher.shaded.org.apache.maven.repository.legacy.metadata.ArtifactMetadata metadata) {
        this.merge((ArtifactMetadata)metadata);
    }
}

