/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.maven.repository;

import io.quarkus.launcher.shaded.org.apache.maven.repository.ArtifactTransferResource;
import java.io.File;
import java.util.EventObject;

public class ArtifactTransferEvent
extends EventObject {
    public static final int TRANSFER_INITIATED = 0;
    public static final int TRANSFER_STARTED = 1;
    public static final int TRANSFER_COMPLETED = 2;
    public static final int TRANSFER_PROGRESS = 3;
    public static final int TRANSFER_ERROR = 4;
    public static final int REQUEST_GET = 5;
    public static final int REQUEST_PUT = 6;
    private int eventType;
    private int requestType;
    private Exception exception;
    private File localFile;
    private ArtifactTransferResource artifact;
    private long transferredBytes;
    private byte[] dataBuffer;
    private int dataOffset;
    private int dataLength;

    public ArtifactTransferEvent(String wagon, int eventType, int requestType, ArtifactTransferResource artifact) {
        super(wagon);
        this.setEventType(eventType);
        this.setRequestType(requestType);
        this.artifact = artifact;
    }

    public ArtifactTransferEvent(String wagon, Exception exception, int requestType, ArtifactTransferResource artifact) {
        this(wagon, 4, requestType, artifact);
        this.exception = exception;
    }

    public ArtifactTransferResource getResource() {
        return this.artifact;
    }

    public Exception getException() {
        return this.exception;
    }

    public int getRequestType() {
        return this.requestType;
    }

    public void setRequestType(int requestType) {
        switch (requestType) {
            case 6: {
                break;
            }
            case 5: {
                break;
            }
            default: {
                throw new IllegalArgumentException("io.quarkus.launcher.shaded.Illegal request type: " + requestType);
            }
        }
        this.requestType = requestType;
    }

    public int getEventType() {
        return this.eventType;
    }

    public void setEventType(int eventType) {
        switch (eventType) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            default: {
                throw new IllegalArgumentException("io.quarkus.launcher.shaded.Illegal event type: " + eventType);
            }
        }
        this.eventType = eventType;
    }

    public File getLocalFile() {
        return this.localFile;
    }

    public void setLocalFile(File localFile) {
        this.localFile = localFile;
    }

    public long getTransferredBytes() {
        return this.transferredBytes;
    }

    public void setTransferredBytes(long transferredBytes) {
        this.transferredBytes = transferredBytes;
    }

    public byte[] getDataBuffer() {
        return this.dataBuffer;
    }

    public void setDataBuffer(byte[] dataBuffer) {
        this.dataBuffer = dataBuffer;
    }

    public int getDataOffset() {
        return this.dataOffset;
    }

    public void setDataOffset(int dataOffset) {
        this.dataOffset = dataOffset;
    }

    public int getDataLength() {
        return this.dataLength;
    }

    public void setDataLength(int dataLength) {
        this.dataLength = dataLength;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append("io.quarkus.launcher.shaded.TransferEvent[");
        switch (this.getRequestType()) {
            case 5: {
                sb.append("io.quarkus.launcher.shaded.GET");
                break;
            }
            case 6: {
                sb.append("io.quarkus.launcher.shaded.PUT");
                break;
            }
            default: {
                sb.append(this.getRequestType());
            }
        }
        sb.append('|');
        switch (this.getEventType()) {
            case 2: {
                sb.append("io.quarkus.launcher.shaded.COMPLETED");
                break;
            }
            case 4: {
                sb.append("io.quarkus.launcher.shaded.ERROR");
                break;
            }
            case 0: {
                sb.append("io.quarkus.launcher.shaded.INITIATED");
                break;
            }
            case 3: {
                sb.append("io.quarkus.launcher.shaded.PROGRESS");
                break;
            }
            case 1: {
                sb.append("io.quarkus.launcher.shaded.STARTED");
                break;
            }
            default: {
                sb.append(this.getEventType());
            }
        }
        sb.append('|');
        sb.append(this.getLocalFile()).append('|');
        sb.append(']');
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.eventType;
        result = 31 * result + (this.exception == null ? 0 : this.exception.hashCode());
        result = 31 * result + (this.localFile == null ? 0 : this.localFile.hashCode());
        result = 31 * result + this.requestType;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ArtifactTransferEvent other = (ArtifactTransferEvent)obj;
        if (this.eventType != other.eventType) {
            return false;
        }
        if (this.exception == null ? other.exception != null : !this.exception.getClass().equals(other.exception.getClass())) {
            return false;
        }
        if (this.requestType != other.requestType) {
            return false;
        }
        return this.source.equals(other.source);
    }
}

