/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.maven.repository.internal;

import io.quarkus.launcher.shaded.org.apache.maven.repository.internal.LocalSnapshotMetadata;
import io.quarkus.launcher.shaded.org.eclipse.aether.RepositorySystemSession;
import io.quarkus.launcher.shaded.org.eclipse.aether.artifact.Artifact;
import io.quarkus.launcher.shaded.org.eclipse.aether.impl.MetadataGenerator;
import io.quarkus.launcher.shaded.org.eclipse.aether.installation.InstallRequest;
import io.quarkus.launcher.shaded.org.eclipse.aether.metadata.Metadata;
import io.quarkus.launcher.shaded.org.eclipse.aether.util.ConfigUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

class LocalSnapshotMetadataGenerator
implements MetadataGenerator {
    private Map<Object, LocalSnapshotMetadata> snapshots;
    private final boolean legacyFormat;

    LocalSnapshotMetadataGenerator(RepositorySystemSession session, InstallRequest request) {
        this.legacyFormat = ConfigUtils.getBoolean(session.getConfigProperties(), false, "io.quarkus.launcher.shaded.maven.metadata.legacy");
        this.snapshots = new LinkedHashMap<Object, LocalSnapshotMetadata>();
    }

    @Override
    public Collection<? extends Metadata> prepare(Collection<? extends Artifact> artifacts) {
        for (Artifact artifact : artifacts) {
            if (!artifact.isSnapshot()) continue;
            Object key = LocalSnapshotMetadata.getKey(artifact);
            LocalSnapshotMetadata snapshotMetadata = this.snapshots.get(key);
            if (snapshotMetadata == null) {
                snapshotMetadata = new LocalSnapshotMetadata(artifact, this.legacyFormat);
                this.snapshots.put(key, snapshotMetadata);
            }
            snapshotMetadata.bind(artifact);
        }
        return Collections.emptyList();
    }

    @Override
    public Artifact transformArtifact(Artifact artifact) {
        return artifact;
    }

    @Override
    public Collection<? extends Metadata> finish(Collection<? extends Artifact> artifacts) {
        return this.snapshots.values();
    }
}

