/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.maven.repository.internal;

import io.quarkus.launcher.shaded.org.apache.maven.artifact.repository.metadata.Metadata;
import io.quarkus.launcher.shaded.org.apache.maven.artifact.repository.metadata.io.xpp3.MetadataXpp3Reader;
import io.quarkus.launcher.shaded.org.apache.maven.artifact.repository.metadata.io.xpp3.MetadataXpp3Writer;
import io.quarkus.launcher.shaded.org.codehaus.plexus.util.ReaderFactory;
import io.quarkus.launcher.shaded.org.codehaus.plexus.util.WriterFactory;
import io.quarkus.launcher.shaded.org.codehaus.plexus.util.xml.XmlStreamReader;
import io.quarkus.launcher.shaded.org.codehaus.plexus.util.xml.XmlStreamWriter;
import io.quarkus.launcher.shaded.org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import io.quarkus.launcher.shaded.org.eclipse.aether.RepositoryException;
import io.quarkus.launcher.shaded.org.eclipse.aether.metadata.AbstractMetadata;
import io.quarkus.launcher.shaded.org.eclipse.aether.metadata.MergeableMetadata;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;

abstract class MavenMetadata
extends AbstractMetadata
implements MergeableMetadata {
    static final String MAVEN_METADATA_XML = "io.quarkus.launcher.shaded.maven-metadata.xml";
    private final File file;
    protected Metadata metadata;
    private boolean merged;

    protected MavenMetadata(Metadata metadata, File file) {
        this.metadata = metadata;
        this.file = file;
    }

    @Override
    public String getType() {
        return MAVEN_METADATA_XML;
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public void merge(File existing, File result) throws RepositoryException {
        Metadata recessive = MavenMetadata.read(existing);
        this.merge(recessive);
        this.write(result, this.metadata);
        this.merged = true;
    }

    @Override
    public boolean isMerged() {
        return this.merged;
    }

    protected abstract void merge(Metadata var1);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Metadata read(File metadataFile) throws RepositoryException {
        if (metadataFile.length() <= 0L) {
            return new Metadata();
        }
        try (XmlStreamReader reader = ReaderFactory.newXmlReader(metadataFile);){
            Metadata metadata = new MetadataXpp3Reader().read(reader, false);
            return metadata;
        }
        catch (IOException e) {
            throw new RepositoryException("io.quarkus.launcher.shaded.Could not read metadata " + metadataFile + "io.quarkus.launcher.shaded.: " + e.getMessage(), e);
        }
        catch (XmlPullParserException e) {
            throw new RepositoryException("io.quarkus.launcher.shaded.Could not parse metadata " + metadataFile + "io.quarkus.launcher.shaded.: " + e.getMessage(), e);
        }
    }

    private void write(File metadataFile, Metadata metadata) throws RepositoryException {
        metadataFile.getParentFile().mkdirs();
        try (XmlStreamWriter writer = WriterFactory.newXmlWriter(metadataFile);){
            new MetadataXpp3Writer().write(writer, metadata);
        }
        catch (IOException e) {
            throw new RepositoryException("io.quarkus.launcher.shaded.Could not write metadata " + metadataFile + "io.quarkus.launcher.shaded.: " + e.getMessage(), e);
        }
    }

    @Override
    public Map<String, String> getProperties() {
        return Collections.emptyMap();
    }

    @Override
    public io.quarkus.launcher.shaded.org.eclipse.aether.metadata.Metadata setProperties(Map<String, String> properties) {
        return this;
    }
}

