/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.maven.rtinfo.internal;

import io.quarkus.launcher.shaded.org.apache.commons.lang3.StringUtils;
import io.quarkus.launcher.shaded.org.apache.commons.lang3.Validate;
import io.quarkus.launcher.shaded.org.apache.maven.rtinfo.RuntimeInformation;
import io.quarkus.launcher.shaded.org.codehaus.plexus.component.annotations.Component;
import io.quarkus.launcher.shaded.org.codehaus.plexus.component.annotations.Requirement;
import io.quarkus.launcher.shaded.org.codehaus.plexus.logging.Logger;
import io.quarkus.launcher.shaded.org.eclipse.aether.util.version.GenericVersionScheme;
import io.quarkus.launcher.shaded.org.eclipse.aether.version.InvalidVersionSpecificationException;
import io.quarkus.launcher.shaded.org.eclipse.aether.version.Version;
import io.quarkus.launcher.shaded.org.eclipse.aether.version.VersionConstraint;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

@Component(role=RuntimeInformation.class)
public class DefaultRuntimeInformation
implements RuntimeInformation {
    @Requirement
    private Logger logger;
    private String mavenVersion;

    @Override
    public String getMavenVersion() {
        if (this.mavenVersion == null) {
            Properties props = new Properties();
            String resource = "META-INF/maven/org.apache.maven/maven-core/pom.properties";
            try (InputStream is = DefaultRuntimeInformation.class.getResourceAsStream("io/quarkus/launcher/shaded//" + resource);){
                if (is != null) {
                    props.load(is);
                } else {
                    this.logger.warn("io.quarkus.launcher.shaded.Could not locate " + resource + "io.quarkus.launcher.shaded. on classpath, Maven runtime information not available");
                }
            }
            catch (IOException e) {
                String msg = "io.quarkus.launcher.shaded.Could not parse " + resource + "io.quarkus.launcher.shaded., Maven runtime information not available";
                if (this.logger.isDebugEnabled()) {
                    this.logger.warn(msg, e);
                }
                this.logger.warn(msg);
            }
            String version = props.getProperty("io.quarkus.launcher.shaded.version", "io.quarkus.launcher.shaded.").trim();
            this.mavenVersion = !version.startsWith("io.quarkus.launcher.shaded.${") ? version : "io.quarkus.launcher.shaded.";
        }
        return this.mavenVersion;
    }

    @Override
    public boolean isMavenVersion(String versionRange) {
        Version current;
        VersionConstraint constraint;
        GenericVersionScheme versionScheme = new GenericVersionScheme();
        Validate.notBlank(versionRange, "io.quarkus.launcher.shaded.versionRange can neither be null, empty nor blank", new Object[0]);
        try {
            constraint = versionScheme.parseVersionConstraint(versionRange);
        }
        catch (InvalidVersionSpecificationException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        try {
            String mavenVersion = this.getMavenVersion();
            Validate.validState(StringUtils.isNotEmpty(mavenVersion), "io.quarkus.launcher.shaded.Could not determine current Maven version", new Object[0]);
            current = versionScheme.parseVersion(mavenVersion);
        }
        catch (InvalidVersionSpecificationException e) {
            throw new IllegalStateException("io.quarkus.launcher.shaded.Could not parse current Maven version: " + e.getMessage(), e);
        }
        if (constraint.getRange() == null) {
            return constraint.getVersion().compareTo(current) <= 0;
        }
        return constraint.containsVersion(current);
    }
}

