/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.maven.settings;

import io.quarkus.launcher.shaded.org.apache.maven.execution.MavenExecutionRequest;
import io.quarkus.launcher.shaded.org.apache.maven.properties.internal.SystemProperties;
import io.quarkus.launcher.shaded.org.apache.maven.settings.MavenSettingsBuilder;
import io.quarkus.launcher.shaded.org.apache.maven.settings.Settings;
import io.quarkus.launcher.shaded.org.apache.maven.settings.building.DefaultSettingsBuildingRequest;
import io.quarkus.launcher.shaded.org.apache.maven.settings.building.SettingsBuilder;
import io.quarkus.launcher.shaded.org.apache.maven.settings.building.SettingsBuildingException;
import io.quarkus.launcher.shaded.org.apache.maven.settings.building.SettingsBuildingRequest;
import io.quarkus.launcher.shaded.org.codehaus.plexus.component.annotations.Component;
import io.quarkus.launcher.shaded.org.codehaus.plexus.component.annotations.Requirement;
import io.quarkus.launcher.shaded.org.codehaus.plexus.logging.AbstractLogEnabled;
import io.quarkus.launcher.shaded.org.codehaus.plexus.util.StringUtils;
import io.quarkus.launcher.shaded.org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import java.io.File;
import java.io.IOException;

@Component(role=MavenSettingsBuilder.class)
public class DefaultMavenSettingsBuilder
extends AbstractLogEnabled
implements MavenSettingsBuilder {
    @Requirement
    private SettingsBuilder settingsBuilder;

    @Override
    public Settings buildSettings() throws IOException, XmlPullParserException {
        File userSettingsFile = this.getFile("io/quarkus/launcher/shaded/${user.home}/.m2/settings.xml", "io.quarkus.launcher.shaded.user.home", "io.quarkus.launcher.shaded.org.apache.maven.user-settings");
        return this.buildSettings(userSettingsFile);
    }

    @Override
    public Settings buildSettings(boolean useCachedSettings) throws IOException, XmlPullParserException {
        return this.buildSettings();
    }

    @Override
    public Settings buildSettings(File userSettingsFile) throws IOException, XmlPullParserException {
        File globalSettingsFile = this.getFile("io/quarkus/launcher/shaded/${maven.conf}/settings.xml", "io.quarkus.launcher.shaded.maven.conf", "io.quarkus.launcher.shaded.org.apache.maven.global-settings");
        DefaultSettingsBuildingRequest request = new DefaultSettingsBuildingRequest();
        request.setUserSettingsFile(userSettingsFile);
        request.setGlobalSettingsFile(globalSettingsFile);
        request.setSystemProperties(SystemProperties.getSystemProperties());
        return this.build(request);
    }

    @Override
    public Settings buildSettings(File userSettingsFile, boolean useCachedSettings) throws IOException, XmlPullParserException {
        return this.buildSettings(userSettingsFile);
    }

    private Settings build(SettingsBuildingRequest request) throws IOException, XmlPullParserException {
        try {
            return this.settingsBuilder.build(request).getEffectiveSettings();
        }
        catch (SettingsBuildingException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
    }

    @Override
    public Settings buildSettings(MavenExecutionRequest request) throws IOException, XmlPullParserException {
        DefaultSettingsBuildingRequest settingsRequest = new DefaultSettingsBuildingRequest();
        settingsRequest.setUserSettingsFile(request.getUserSettingsFile());
        settingsRequest.setGlobalSettingsFile(request.getGlobalSettingsFile());
        settingsRequest.setUserProperties(request.getUserProperties());
        settingsRequest.setSystemProperties(request.getSystemProperties());
        return this.build(settingsRequest);
    }

    private File getFile(String pathPattern, String basedirSysProp, String altLocationSysProp) {
        String path = System.getProperty(altLocationSysProp);
        if (StringUtils.isEmpty(path)) {
            String basedir = System.getProperty(basedirSysProp);
            if (basedir == null) {
                basedir = System.getProperty("io.quarkus.launcher.shaded.user.dir");
            }
            basedir = basedir.replaceAll("io.quarkus.launcher.shaded.\\\\", "io/quarkus/launcher/shaded//");
            basedir = basedir.replaceAll("io.quarkus.launcher.shaded.\\$", "io.quarkus.launcher.shaded.\\\\\\$");
            path = pathPattern.replaceAll("io.quarkus.launcher.shaded.\\$\\{" + basedirSysProp + "io.quarkus.launcher.shaded.\\}", basedir);
            path = path.replaceAll("io.quarkus.launcher.shaded.\\\\", "io/quarkus/launcher/shaded//");
            return new File(path).getAbsoluteFile();
        }
        return new File(path).getAbsoluteFile();
    }
}

